/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaMoveMembersProperties;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveMembersRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class MoveMembersTransformer
extends RefactoringVisitor {
    private static final int NOPOS = -2;
    private static final Set<Modifier> ALL_ACCESS_MODIFIERS = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private Problem problem;
    private Collection<? extends TreePathHandle> allElements;
    private final JavaMoveMembersProperties.Visibility visibility;
    private final HashMap<TreePathHandle, Boolean> usageOutsideOfPackage;
    private final HashMap<TreePathHandle, Boolean> usageOutsideOfType;
    private final TreePathHandle targetHandle;
    private final boolean delegate;
    private final boolean deprecate;
    private final boolean updateJavadoc;

    public MoveMembersTransformer(MoveRefactoring refactoring) {
        this.allElements = refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
        JavaMoveMembersProperties properties = (JavaMoveMembersProperties)refactoring.getContext().lookup(JavaMoveMembersProperties.class);
        properties = properties == null ? new JavaMoveMembersProperties(this.allElements.toArray(new TreePathHandle[this.allElements.size()])) : properties;
        this.visibility = properties.getVisibility();
        this.usageOutsideOfPackage = new HashMap();
        this.usageOutsideOfType = new HashMap();
        for (TreePathHandle treePathHandle : this.allElements) {
            this.usageOutsideOfPackage.put(treePathHandle, Boolean.FALSE);
        }
        this.targetHandle = (TreePathHandle)refactoring.getTarget().lookup(TreePathHandle.class);
        this.delegate = properties.isDelegate();
        this.deprecate = properties.isAddDeprecated();
        this.updateJavadoc = properties.isUpdateJavaDoc();
    }

    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element target) {
        if (this.changeIfMatch(this.getCurrentPath(), node, target)) {
            return node;
        }
        return (Tree)super.visitMemberSelect(node, target);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element target) {
        if (this.changeIfMatch(this.getCurrentPath(), node, target)) {
            return node;
        }
        return (Tree)super.visitIdentifier(node, target);
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, Element target) {
        if (this.changeIfMatch(this.getCurrentPath(), node, target)) {
            return node;
        }
        return (Tree)super.visitMethodInvocation(node, target);
    }

    private boolean changeIfMatch(TreePath currentPath, Tree node, Element target) throws IllegalArgumentException {
        Element el = this.workingCopy.getTrees().getElement(currentPath);
        if (el == null) {
            return false;
        }
        TreePathHandle elementBeingMoved = this.isElementBeingMoved(el);
        if (elementBeingMoved != null) {
            FileObject folder = this.targetHandle.getFileObject().getParent();
            CompilationUnitTree compilationUnit = currentPath.getCompilationUnit();
            this.checkForUsagesOutsideOfPackage(folder, compilationUnit, elementBeingMoved);
            this.checkForUsagesOutsideOfType(target, currentPath, elementBeingMoved);
            if (node instanceof MethodInvocationTree) {
                if (!this.delegate) {
                    this.changeMethodInvocation((ExecutableElement)el, (MethodInvocationTree)node, currentPath, target);
                }
            } else if (node instanceof IdentifierTree) {
                this.changeIdentifier(el, (IdentifierTree)node, currentPath, target);
            } else if (node instanceof MemberSelectTree) {
                this.changeMemberSelect(el, (MemberSelectTree)node, currentPath, target);
            }
            return true;
        }
        return false;
    }

    @Override
    public Tree visitClass(ClassTree node, Element target) {
        this.insertIfMatch(this.getCurrentPath(), node, target);
        return (Tree)super.visitClass(node, target);
    }

    @Override
    public Tree visitVariable(VariableTree node, Element target) {
        if (this.removeIfMatch(this.getCurrentPath(), target)) {
            return node;
        }
        return (Tree)super.visitVariable(node, target);
    }

    @Override
    public Tree visitMethod(MethodTree node, Element target) {
        if (this.removeIfMatch(this.getCurrentPath(), target)) {
            return node;
        }
        return (Tree)super.visitMethod(node, target);
    }

    private void changeMemberSelect(Element el, MemberSelectTree node, TreePath currentPath, final Element target) {
        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
            ExpressionTree expression = node.getExpression();
            TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, currentPath, true, true, true, true, true);
            Element enclosingElement = this.workingCopy.getTrees().getElement(enclosingClassPath);
            if (target.equals(enclosingElement)) {
                IdentifierTree newIdt = this.make.Identifier((CharSequence)node.getIdentifier());
                this.rewrite(node, newIdt);
            } else {
                ExpressionTree newIdent = this.make.QualIdent(target);
                this.rewrite(expression, newIdent);
            }
        } else {
            TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, currentPath, true, true, true, true, false);
            Scope scope = this.workingCopy.getTrees().getScope(currentPath);
            Element enclosingElement = this.workingCopy.getTrees().getElement(enclosingClassPath);
            if (target.equals(enclosingElement) && node.getKind() == Tree.Kind.MEMBER_SELECT && !scope.getEnclosingMethod().getModifiers().contains((Object)Modifier.STATIC)) {
                IdentifierTree newIdt = this.make.Identifier((CharSequence)node.getIdentifier());
                this.rewrite(node, newIdt);
            } else {
                Iterable vars = this.workingCopy.getElementUtilities().getLocalMembersAndVars(scope, new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        return MoveMembersTransformer.this.workingCopy.getTypes().isSameType(e.asType(), target.asType()) && MoveMembersTransformer.this.isElementBeingMoved(e) == null;
                    }
                });
                if (!vars.iterator().hasNext()) {
                    SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                    long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                    long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                    String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"WRN_NoAccessor", (Object)source)));
                } else {
                    Element localVar = (Element)vars.iterator().next();
                    MemberSelectTree selectTree = node;
                    ExpressionTree it = selectTree.getExpression();
                    IdentifierTree newIt = this.make.Identifier(localVar);
                    if (it != null && newIt != null) {
                        this.rewrite(it, newIt);
                    }
                }
            }
        }
    }

    private void changeIdentifier(Element el, IdentifierTree node, TreePath currentPath, final Element target) {
        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
            IdentifierTree it = node;
            TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, currentPath, true, true, true, true, true);
            Element enclosingElement = this.workingCopy.getTrees().getElement(enclosingClassPath);
            if (enclosingElement == null || !enclosingElement.equals(target)) {
                ExpressionTree qualIdent = this.make.QualIdent(target);
                MemberSelectTree memberSelect = this.make.MemberSelect(qualIdent, (CharSequence)it.getName().toString());
                this.rewrite(it, memberSelect);
            }
        } else {
            Scope scope = this.workingCopy.getTrees().getScope(currentPath);
            Iterable vars = this.workingCopy.getElementUtilities().getLocalMembersAndVars(scope, new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror type) {
                    return MoveMembersTransformer.this.workingCopy.getTypes().isSameType(e.asType(), target.asType());
                }
            });
            if (!vars.iterator().hasNext()) {
                SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_NoAccessor", (Object)source)));
            } else {
                Element localVar = (Element)vars.iterator().next();
                IdentifierTree variableTree = node;
                IdentifierTree it = node;
                Tree newIt = this.make.setLabel((Tree)node, (CharSequence)(localVar.getSimpleName().toString() + "." + variableTree.getName().toString()));
                if (it != null && newIt != null) {
                    this.rewrite(it, newIt);
                }
            }
        }
    }

    private void changeMethodInvocation(ExecutableElement el, MethodInvocationTree node, TreePath currentPath, Element target) {
        this.rewrite(node, this.createMethodInvocationTree(el, node, currentPath, target, false));
    }

    /*
     * WARNING - void declaration
     */
    private MethodInvocationTree createMethodInvocationTree(ExecutableElement el, MethodInvocationTree node, final TreePath currentPath, final Element target, boolean delegate) {
        TypeParameterElement typeParameterElement;
        ExpressionTree newMethodSelect;
        TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, currentPath, true, true, true, true, true);
        Element enclosingElement = this.workingCopy.getTrees().getElement(enclosingClassPath);
        LinkedList<? extends ExpressionTree> arguments = new LinkedList<ExpressionTree>(node.getArguments());
        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
            newMethodSelect = node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT ? (enclosingElement != null && enclosingElement.equals(target) ? this.make.Identifier((CharSequence)((MemberSelectTree)node.getMethodSelect()).getIdentifier()) : this.make.MemberSelect(this.make.QualIdent(target), (CharSequence)((MemberSelectTree)node.getMethodSelect()).getIdentifier().toString())) : (enclosingElement == null || !enclosingElement.equals(target) ? this.make.MemberSelect(this.make.QualIdent(target), (Element)el) : node.getMethodSelect());
        } else {
            ExpressionTree selectExpression;
            int removedIndex = -1;
            List<? extends VariableElement> parameters = el.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement variableElement = parameters.get(i);
                if (!this.workingCopy.getTypes().isSameType(variableElement.asType(), target.asType())) continue;
                removedIndex = i;
                break;
            }
            if (removedIndex != -1) {
                selectExpression = node.getArguments().get(removedIndex);
            } else {
                Scope scope = this.workingCopy.getTrees().getScope(currentPath);
                Iterable vars = this.workingCopy.getElementUtilities().getLocalMembersAndVars(scope, new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        return MoveMembersTransformer.this.workingCopy.getTypes().isSameType(e.asType(), target.asType());
                    }
                });
                if (!vars.iterator().hasNext()) {
                    if (delegate) {
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_NoAccessor", (Object)NbBundle.getMessage(MoveMembersTransformer.class, (String)"TXT_DelegatingMethod"))));
                    } else {
                        SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                        long l = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                        long l2 = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(l);
                        String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + l2;
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_NoAccessor", (Object)source)));
                    }
                    selectExpression = null;
                } else {
                    Element localVar = (Element)vars.iterator().next();
                    selectExpression = this.make.Identifier(localVar);
                }
            }
            if (selectExpression == null) {
                newMethodSelect = node.getMethodSelect();
            } else if (node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree selectTree = (MemberSelectTree)node.getMethodSelect();
                boolean inStatic = false;
                for (TreePath blockPath = currentPath; blockPath != null; blockPath = blockPath.getParentPath()) {
                    if (blockPath.getLeaf().getKind() != Tree.Kind.BLOCK) continue;
                    TreePath treePath = blockPath.getParentPath();
                    if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
                        MethodTree enclosingMethod = (MethodTree)treePath.getLeaf();
                        if (!enclosingMethod.getModifiers().getFlags().contains((Object)Modifier.STATIC)) continue;
                        inStatic = true;
                        continue;
                    }
                    if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.CLASS) continue;
                    inStatic = true;
                }
                if (enclosingElement.equals(target)) {
                    if (inStatic) {
                        SourcePositions sourcePositions = this.workingCopy.getTrees().getSourcePositions();
                        long startPosition = sourcePositions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                        long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                        String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_NoAccessor", (Object)source)));
                        newMethodSelect = node.getMethodSelect();
                    } else {
                        newMethodSelect = this.make.Identifier((CharSequence)((MemberSelectTree)node.getMethodSelect()).getIdentifier());
                    }
                } else {
                    newMethodSelect = this.make.MemberSelect(selectExpression, (CharSequence)selectTree.getIdentifier());
                }
            } else {
                IdentifierTree variableTree = (IdentifierTree)node.getMethodSelect();
                newMethodSelect = this.make.MemberSelect(selectExpression, (CharSequence)variableTree.getName().toString());
            }
            if (removedIndex != -1) {
                arguments.remove(removedIndex);
            }
            TypeMirror sourceType = this.workingCopy.getTrees().getTypeMirror(enclosingClassPath);
            TreeScanner<Boolean, TypeMirror> needsArgumentScanner = new TreeScanner<Boolean, TypeMirror>(){

                @Override
                public Boolean visitMemberSelect(MemberSelectTree node, TypeMirror source) {
                    String isThis = node.getExpression().toString();
                    if (isThis.equals("this") || isThis.endsWith(".this")) {
                        TreePath thisPath = new TreePath(currentPath, node);
                        Element el = MoveMembersTransformer.this.workingCopy.getTrees().getElement(thisPath);
                        if (el != null && MoveMembersTransformer.this.isElementBeingMoved(el) != null) {
                            return false;
                        }
                    }
                    return (Boolean)super.visitMemberSelect(node, source);
                }

                @Override
                public Boolean visitIdentifier(IdentifierTree node, TypeMirror source) {
                    TypeElement elType;
                    String isThis;
                    TreePath thisPath = new TreePath(currentPath, node);
                    Element el = MoveMembersTransformer.this.workingCopy.getTrees().getElement(thisPath);
                    if (el != null && MoveMembersTransformer.this.isElementBeingMoved(el) == null && ((isThis = node.toString()).equals("this") || isThis.endsWith(".this") ? !el.getModifiers().contains((Object)Modifier.STATIC) : (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.FIELD || el.getKind() == ElementKind.ENUM) && (elType = MoveMembersTransformer.this.workingCopy.getElementUtilities().enclosingTypeElement(el)) != null && MoveMembersTransformer.this.workingCopy.getTypes().isSubtype(source, elType.asType()) && !el.getModifiers().contains((Object)Modifier.STATIC))) {
                        return true;
                    }
                    return (Boolean)super.visitIdentifier(node, source);
                }

                @Override
                public Boolean reduce(Boolean r1, Boolean r2) {
                    return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
                }
            };
            Boolean needsArgument = (Boolean)needsArgumentScanner.scan(this.workingCopy.getTrees().getTree(el).getBody(), sourceType);
            if (needsArgument == Boolean.TRUE) {
                void var16_28;
                if (enclosingElement.equals(target) && node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                    ExpressionTree expressionTree = ((MemberSelectTree)node.getMethodSelect()).getExpression();
                } else {
                    ExpressionTree expressionTree = this.workingCopy.getTreeUtilities().parseExpression("this", new SourcePositions[1]);
                }
                if (el.isVarArgs()) {
                    arguments.add(arguments.size() - 1, (ExpressionTree)var16_28);
                } else {
                    arguments.add((ExpressionTree)var16_28);
                }
            }
        }
        LinkedList<? extends Tree> typeArguments = new LinkedList<Tree>(node.getTypeArguments());
        Element returnType = this.workingCopy.getTypes().asElement(el.getReturnType());
        if (returnType != null && returnType.getKind() == ElementKind.TYPE_PARAMETER && (typeParameterElement = (TypeParameterElement)returnType).getGenericElement().getKind() != ElementKind.METHOD) {
            ExpressionTree methodSelect = node.getMethodSelect();
            if (methodSelect.getKind() == Tree.Kind.MEMBER_SELECT) {
                TypeMirror asType;
                VariableElement element = (VariableElement)this.workingCopy.getTrees().getElement(new TreePath(currentPath, ((MemberSelectTree)methodSelect).getExpression()));
                if (element != null && (asType = element.asType()).getKind() == TypeKind.DECLARED) {
                    List<? extends TypeMirror> list = ((DeclaredType)asType).getTypeArguments();
                    for (TypeMirror typeMirror : list) {
                        typeArguments.add((ExpressionTree)this.make.Type(typeMirror));
                    }
                }
            } else {
                ClassTree classTree = this.workingCopy.getTrees().getTree((TypeElement)enclosingElement);
                for (TypeParameterTree typeParameterTree : classTree.getTypeParameters()) {
                    if (!typeParameterTree.getName().contentEquals(el.getReturnType().toString())) continue;
                    typeArguments.add((ExpressionTree)this.make.Type(typeParameterTree.getName().toString()));
                }
            }
        }
        if (!typeArguments.isEmpty() && newMethodSelect.getKind() == Tree.Kind.IDENTIFIER) {
            newMethodSelect = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"this"), (CharSequence)((IdentifierTree)newMethodSelect).getName());
        }
        return this.make.MethodInvocation(typeArguments, newMethodSelect, arguments);
    }

    private void checkForUsagesOutsideOfPackage(FileObject folder, CompilationUnitTree compilationUnit, TreePathHandle elementBeingMoved) {
        if (!RefactoringUtils.getPackageName(folder).equals(RefactoringUtils.getPackageName(compilationUnit))) {
            this.usageOutsideOfPackage.put(elementBeingMoved, Boolean.TRUE);
        }
    }

    private void checkForUsagesOutsideOfType(Element target, TreePath currentPath, TreePathHandle elementBeingMoved) {
        Types types = this.workingCopy.getTypes();
        TypeMirror targetType = target.asType();
        TreePath enclosingPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, currentPath, true, true, true, true, false);
        Element enclosingEl = null;
        if (enclosingPath != null) {
            enclosingEl = this.workingCopy.getTrees().getElement(enclosingPath);
        }
        if (enclosingEl != null) {
            TypeMirror enclosingType = enclosingEl.asType();
            if (!(this.enclosedBy(targetType, enclosingType) || this.enclosedBy(enclosingType, targetType) || types.isSameType(enclosingType, targetType))) {
                this.usageOutsideOfType.put(elementBeingMoved, Boolean.TRUE);
            }
        } else {
            this.usageOutsideOfType.put(elementBeingMoved, Boolean.TRUE);
        }
    }

    private void insertIfMatch(TreePath currentPath, ClassTree node, final Element target) throws IllegalArgumentException {
        Element el = this.workingCopy.getTrees().getElement(currentPath);
        if (el == null) {
            return;
        }
        if (el.equals(target)) {
            ClassTree newClassTree = node;
            for (TreePathHandle treePathHandle : this.allElements) {
                final TreePath resolvedPath = treePathHandle.resolve((CompilationInfo)this.workingCopy);
                if (resolvedPath == null) continue;
                Tree member = resolvedPath.getLeaf();
                Tree newMember = null;
                Element resolvedElement = this.workingCopy.getTrees().getElement(resolvedPath);
                if (resolvedElement == null) continue;
                GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
                genUtils.importComments(member, resolvedPath.getCompilationUnit());
                if (member.getKind() == Tree.Kind.METHOD) {
                    TreePath returnPath;
                    Element returnTypeEl;
                    Tree returnType;
                    TypeParameterElement typeParameterElement;
                    Element element;
                    boolean addParameter;
                    MethodTree methodTree = (MethodTree)member;
                    ExecutableElement method = (ExecutableElement)resolvedElement;
                    ModifiersTree modifiers = this.changeModifiers((ModifiersTree)genUtils.importFQNs((Tree)methodTree.getModifiers()), this.usageOutsideOfPackage.get(treePathHandle) == Boolean.TRUE, this.usageOutsideOfType.get(treePathHandle) == Boolean.TRUE);
                    List<? extends VariableTree> parameters = methodTree.getParameters();
                    VariableTree removedParameter = null;
                    boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
                    LinkedList<Tree> newParameters = new LinkedList<Tree>();
                    for (int i = 0; i < parameters.size(); ++i) {
                        VariableTree variableTree = parameters.get(i);
                        TypeMirror type = this.workingCopy.getTrees().getTypeMirror(TreePath.getPath(resolvedPath, (Tree)variableTree));
                        if (!isStatic && removedParameter == null && type != null && this.workingCopy.getTypes().isSameType(type, target.asType())) {
                            removedParameter = variableTree;
                            continue;
                        }
                        newParameters.add(genUtils.importFQNs((Tree)variableTree));
                    }
                    BlockTree body = methodTree.getBody();
                    final TreePath bodyPath = new TreePath(resolvedPath, body);
                    final Trees trees = this.workingCopy.getTrees();
                    final HashMap fqns = new HashMap();
                    TreeScanner<Void, Void> fqnScan = new TreeScanner<Void, Void>(){

                        @Override
                        public Void visitIdentifier(IdentifierTree node, Void p) {
                            Element el;
                            TreePath treePath = trees.getPath(bodyPath.getCompilationUnit(), node);
                            if (!MoveMembersTransformer.this.workingCopy.getTreeUtilities().isSynthetic(treePath) && (el = trees.getElement(treePath)) != null) {
                                fqns.put(node, MoveMembersTransformer.this.make.Identifier(el));
                            }
                            return (Void)super.visitIdentifier(node, p);
                        }
                    };
                    fqnScan.scan(body, null);
                    body = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)body, fqns);
                    final HashMap original2Translated = new HashMap();
                    TreePath sourceClass = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, resolvedPath, true, true, true, true, true);
                    TypeMirror sourceType = this.workingCopy.getTrees().getTypeMirror(sourceClass);
                    final String parameterName = MoveMembersTransformer.getParameterName(sourceType, this.workingCopy.getTrees().getScope(bodyPath), (CompilationController)this.workingCopy);
                    TreeScanner<Boolean, TypeMirror> idScan = new TreeScanner<Boolean, TypeMirror>(){

                        @Override
                        public Boolean visitMemberSelect(MemberSelectTree node, TypeMirror source) {
                            String isThis = node.getExpression().toString();
                            if (isThis.equals("this") || isThis.endsWith(".this")) {
                                TreePath currentPath = new TreePath(resolvedPath, node);
                                Element el = trees.getElement(currentPath);
                                if (el != null && MoveMembersTransformer.this.isElementBeingMoved(el) != null) {
                                    return false;
                                }
                            } else {
                                TreePath currentPath = new TreePath(resolvedPath, node);
                                Element el = trees.getElement(currentPath);
                                if (el != null && MoveMembersTransformer.this.isElementBeingMoved(el) != null && el.getKind() != ElementKind.PACKAGE && el.getModifiers().contains((Object)Modifier.STATIC)) {
                                    IdentifierTree ident = MoveMembersTransformer.this.make.Identifier(target);
                                    MemberSelectTree memberSelect = MoveMembersTransformer.this.make.MemberSelect((ExpressionTree)ident, el);
                                    original2Translated.put(node, memberSelect);
                                }
                            }
                            return (Boolean)super.visitMemberSelect(node, source);
                        }

                        @Override
                        public Boolean visitIdentifier(IdentifierTree node, TypeMirror source) {
                            TreePath currentPath = new TreePath(resolvedPath, node);
                            Element el = trees.getElement(currentPath);
                            boolean result = false;
                            if (el != null && MoveMembersTransformer.this.isElementBeingMoved(el) == null && el.getKind() != ElementKind.PACKAGE) {
                                TypeElement elType = MoveMembersTransformer.this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                                String isThis = node.toString();
                                if (isThis.equals("this") || isThis.endsWith(".this")) {
                                    if (!el.getModifiers().contains((Object)Modifier.STATIC)) {
                                        ExpressionTree newLabel = (ExpressionTree)MoveMembersTransformer.this.make.setLabel((Tree)node, (CharSequence)parameterName);
                                        original2Translated.put(node, newLabel);
                                        result = true;
                                    } else {
                                        IdentifierTree ident = MoveMembersTransformer.this.make.Identifier((Element)elType);
                                        original2Translated.put(node, ident);
                                    }
                                } else if ((el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.FIELD || el.getKind() == ElementKind.ENUM) && elType != null && MoveMembersTransformer.this.workingCopy.getTypes().isSubtype(source, elType.asType())) {
                                    if (!el.getModifiers().contains((Object)Modifier.STATIC)) {
                                        MemberSelectTree memberSelect = MoveMembersTransformer.this.make.MemberSelect(MoveMembersTransformer.this.workingCopy.getTreeUtilities().parseExpression(parameterName, new SourcePositions[1]), el);
                                        original2Translated.put(node, memberSelect);
                                        result = true;
                                    } else {
                                        IdentifierTree ident = MoveMembersTransformer.this.make.Identifier((Element)elType);
                                        MemberSelectTree memberSelect = MoveMembersTransformer.this.make.MemberSelect((ExpressionTree)ident, el);
                                        original2Translated.put(node, memberSelect);
                                    }
                                }
                            }
                            return super.visitIdentifier(node, source) == Boolean.TRUE || result;
                        }

                        @Override
                        public Boolean reduce(Boolean r1, Boolean r2) {
                            return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
                        }
                    };
                    boolean bl = addParameter = idScan.scan(body, sourceType) == Boolean.TRUE;
                    if (removedParameter != null) {
                        TreeScanner<Void, Pair<Element, ExpressionTree>> idScan2 = new TreeScanner<Void, Pair<Element, ExpressionTree>>(){

                            @Override
                            public Void visitIdentifier(IdentifierTree node, Pair<Element, ExpressionTree> p) {
                                TreePath currentPath = new TreePath(resolvedPath, node);
                                Element el = trees.getElement(currentPath);
                                if (((Element)p.first()).equals(el)) {
                                    original2Translated.put(node, p.second());
                                }
                                return (Void)super.visitIdentifier(node, p);
                            }
                        };
                        TreePath path = new TreePath(resolvedPath, removedParameter);
                        Element element2 = trees.getElement(path);
                        if (element2 != null) {
                            Pair pair = Pair.of((Object)element2, (Object)this.workingCopy.getTreeUtilities().parseExpression("this", new SourcePositions[1]));
                            idScan2.scan(body, pair);
                        }
                    }
                    body = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)body, original2Translated);
                    if (addParameter) {
                        VariableTree vt = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)parameterName, (Tree)this.make.QualIdent(sourceType.toString()), null);
                        if (method.isVarArgs()) {
                            newParameters.add(newParameters.size() - 1, vt);
                        } else {
                            newParameters.add(vt);
                        }
                    }
                    body = (BlockTree)genUtils.importFQNs((Tree)body);
                    LinkedList<? extends TypeParameterTree> typeParameters = new LinkedList<TypeParameterTree>(methodTree.getTypeParameters());
                    if (method.getReturnType().getKind() == TypeKind.TYPEVAR && (element = this.workingCopy.getTypes().asElement(method.getReturnType())).getKind() == ElementKind.TYPE_PARAMETER && (typeParameterElement = (TypeParameterElement)element).getGenericElement().getKind() != ElementKind.METHOD) {
                        LinkedList<ExpressionTree> bounds = new LinkedList<ExpressionTree>();
                        for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                            if (typeMirror.toString().equals("java.lang.Object")) continue;
                            bounds.add((ExpressionTree)this.make.Type(typeMirror));
                        }
                        typeParameters.add(this.make.TypeParameter((CharSequence)typeParameterElement.getSimpleName(), bounds));
                    }
                    if ((returnType = methodTree.getReturnType()) != null && (returnTypeEl = trees.getElement(returnPath = new TreePath(resolvedPath, returnType))) != null && returnTypeEl.getKind() != ElementKind.TYPE_PARAMETER && this.isElementBeingMoved(returnTypeEl) == null) {
                        returnType = genUtils.importFQNs(returnType);
                    }
                    newMember = this.make.Method(modifiers, (CharSequence)methodTree.getName(), returnType, typeParameters, newParameters, methodTree.getThrows(), body, (ExpressionTree)methodTree.getDefaultValue());
                } else if (member.getKind() == Tree.Kind.VARIABLE) {
                    VariableTree field = (VariableTree)member;
                    ModifiersTree modifiers = this.changeModifiers((ModifiersTree)genUtils.importFQNs((Tree)field.getModifiers()), this.usageOutsideOfPackage.get(treePathHandle) == Boolean.TRUE, this.usageOutsideOfType.get(treePathHandle) == Boolean.TRUE);
                    ExpressionTree initializer = field.getInitializer();
                    initializer = this.fixReferences(initializer, target, resolvedPath);
                    VariableTree importFQNs = (VariableTree)genUtils.importFQNs((Tree)field);
                    newMember = this.make.Variable(modifiers, (CharSequence)field.getName(), importFQNs.getType(), initializer);
                }
                if (newMember == null) continue;
                genUtils.copyComments(member, newMember, true);
                genUtils.copyComments(member, newMember, false);
                if (newMember.getKind() == Tree.Kind.METHOD && this.updateJavadoc) {
                    Comment comment;
                    MethodTree method = (MethodTree)newMember;
                    List comments = this.workingCopy.getTreeUtilities().getComments((Tree)method, true);
                    if (comments.isEmpty()) {
                        comment = this.generateJavadoc(method, target, false);
                    } else if (((Comment)comments.get(0)).isDocComment()) {
                        this.make.removeComment((Tree)method, 0, true);
                        comment = this.updateJavadoc(resolvedElement, target, false);
                    } else {
                        comment = this.generateJavadoc(method, target, false);
                    }
                    this.make.addComment(newMember, comment, true);
                }
                newClassTree = genUtils.insertClassMember(newClassTree, newMember);
            }
            this.rewrite(node, newClassTree);
        }
    }

    private boolean removeIfMatch(TreePath currentPath, Element target) throws IllegalArgumentException {
        Element el = this.workingCopy.getTrees().getElement(currentPath);
        if (el == null) {
            return false;
        }
        if (this.isElementBeingMoved(el) != null) {
            ClassTree classTree;
            TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, currentPath, true, true, true, true, true);
            ClassTree newClassTree = classTree = (ClassTree)enclosingClassPath.getLeaf();
            for (TreePathHandle treePathHandle : this.allElements) {
                TreePath resolvedPath = treePathHandle.resolve((CompilationInfo)this.workingCopy);
                if (resolvedPath == null) continue;
                Tree member = resolvedPath.getLeaf();
                if (this.delegate && member.getKind() == Tree.Kind.METHOD) {
                    MethodTree methodTree = (MethodTree)member;
                    int index = newClassTree.getMembers().indexOf(methodTree);
                    newClassTree = this.make.removeClassMember(newClassTree, (Tree)methodTree);
                    ExecutableElement element = (ExecutableElement)this.workingCopy.getTrees().getElement(resolvedPath);
                    if (element == null) continue;
                    ArrayList<IdentifierTree> paramList = new ArrayList<IdentifierTree>();
                    for (VariableElement variableElement : element.getParameters()) {
                        IdentifierTree vt = this.make.Identifier((CharSequence)variableElement.getSimpleName().toString());
                        paramList.add(vt);
                    }
                    MethodInvocationTree methodInvocation = this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.Identifier((Element)element), paramList);
                    methodInvocation = this.createMethodInvocationTree(element, methodInvocation, currentPath, target, true);
                    TypeMirror typeMirror = element.getReturnType();
                    Types types = this.workingCopy.getTypes();
                    StatementTree statement = !types.isSameType(typeMirror, types.getNoType(TypeKind.VOID)) ? this.make.Return((ExpressionTree)methodInvocation) : this.make.ExpressionStatement((ExpressionTree)methodInvocation);
                    ModifiersTree modifiers = methodTree.getModifiers();
                    if (this.deprecate) {
                        AnnotationTree annotation = this.make.Annotation((Tree)this.make.Identifier((CharSequence)"Deprecated"), Collections.EMPTY_LIST);
                        modifiers = this.make.addModifiersAnnotation(modifiers, annotation);
                    }
                    MethodTree method = this.make.Method(modifiers, (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), this.make.Block(Collections.singletonList(statement), false), (ExpressionTree)methodTree.getDefaultValue());
                    GeneratorUtilities.get((WorkingCopy)this.workingCopy).importComments(member, resolvedPath.getCompilationUnit());
                    GeneratorUtilities.get((WorkingCopy)this.workingCopy).copyComments(member, (Tree)method, true);
                    GeneratorUtilities.get((WorkingCopy)this.workingCopy).copyComments(member, (Tree)method, false);
                    if (this.updateJavadoc) {
                        Comment comment;
                        List comments = this.workingCopy.getTreeUtilities().getComments((Tree)method, true);
                        if (comments.isEmpty()) {
                            comment = this.generateJavadoc(method, target, this.deprecate);
                        } else if (((Comment)comments.get(0)).isDocComment()) {
                            this.make.removeComment((Tree)method, 0, true);
                            comment = this.updateJavadoc(element, target, this.deprecate);
                        } else {
                            comment = this.generateJavadoc(method, target, this.deprecate);
                        }
                        this.make.addComment((Tree)method, comment, true);
                    }
                    newClassTree = this.make.insertClassMember(newClassTree, index, (Tree)method);
                    continue;
                }
                newClassTree = this.make.removeClassMember(newClassTree, member);
            }
            this.rewrite(classTree, newClassTree);
            return true;
        }
        return false;
    }

    private Comment updateJavadoc(Element method, Element targetElement, boolean addDeprecated) {
        Doc javadoc = this.workingCopy.getElementUtilities().javaDocFor(method);
        LinkedList<Tag> otherTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags()));
        LinkedList<Tag> returnTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags("@return")));
        LinkedList<Tag> throwsTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags("@throws")));
        LinkedList<Tag> paramTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags("@param")));
        otherTags.removeAll(returnTags);
        otherTags.removeAll(throwsTags);
        otherTags.removeAll(paramTags);
        StringBuilder text = new StringBuilder(javadoc.commentText()).append("\n\n");
        text.append(this.tagsToString(paramTags));
        text.append(this.tagsToString(returnTags));
        text.append(this.tagsToString(throwsTags));
        text.append(this.tagsToString(otherTags));
        if (addDeprecated) {
            String target = targetElement.asType().toString() + "#" + method.getSimpleName();
            text.append(NbBundle.getMessage(MoveMembersTransformer.class, (String)"TAG_Deprecated", (Object)target));
        }
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)text.toString());
        return comment;
    }

    private String tagsToString(List<Tag> tags) {
        StringBuilder sb = new StringBuilder();
        for (Tag tag : tags) {
            sb.append(tag.name()).append(" ").append(tag.text()).append("\n");
        }
        return sb.toString();
    }

    private Comment generateJavadoc(MethodTree current, Element targetElement, boolean addDeprecated) {
        Tree returnType = current.getReturnType();
        StringBuilder builder = new StringBuilder("\n");
        for (VariableTree variableTree : current.getParameters()) {
            builder.append(String.format("@param %s the value of %s", variableTree.getName(), variableTree.getName()));
            builder.append("\n");
        }
        boolean hasReturn = false;
        if (returnType != null && returnType.getKind().equals((Object)Tree.Kind.PRIMITIVE_TYPE) && !((PrimitiveTypeTree)returnType).getPrimitiveTypeKind().equals((Object)TypeKind.VOID)) {
            hasReturn = true;
        }
        if (hasReturn) {
            builder.append("@return the ").append(returnType).append("\n");
        }
        for (ExpressionTree expressionTree : current.getThrows()) {
            builder.append("@throws ").append(expressionTree).append("\n");
        }
        if (addDeprecated) {
            String string = targetElement.asType().toString() + "#" + current.getName();
            builder.append(NbBundle.getMessage(MoveMembersTransformer.class, (String)"TAG_Deprecated", (Object)string));
        }
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)builder.toString());
        return comment;
    }

    private TreePathHandle isElementBeingMoved(Element el) {
        for (TreePathHandle treePathHandle : this.allElements) {
            Element element = treePathHandle.resolveElement((CompilationInfo)this.workingCopy);
            if (element == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").log(Level.INFO, "MoveMembersTransformer cannot resolve {0}", treePathHandle);
                continue;
            }
            if (!element.equals(el)) continue;
            return treePathHandle;
        }
        return null;
    }

    private ModifiersTree changeModifiers(ModifiersTree modifiersTree, boolean usageOutsideOfPackage, boolean usageOutsideOfType) {
        Set<Modifier> flags = modifiersTree.getFlags();
        EnumSet<Modifier> newModifiers = flags.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(flags);
        switch (this.visibility) {
            case ESCALATE: {
                if (usageOutsideOfPackage) {
                    if (flags.contains((Object)Modifier.PUBLIC)) break;
                    newModifiers.removeAll(ALL_ACCESS_MODIFIERS);
                    newModifiers.add(Modifier.PUBLIC);
                    break;
                }
                if (!usageOutsideOfType || !flags.contains((Object)Modifier.PRIVATE)) break;
                newModifiers.removeAll(ALL_ACCESS_MODIFIERS);
                break;
            }
            default: {
                break;
            }
            case PUBLIC: {
                newModifiers.removeAll(ALL_ACCESS_MODIFIERS);
                newModifiers.add(Modifier.PUBLIC);
                break;
            }
            case PROTECTED: {
                newModifiers.removeAll(ALL_ACCESS_MODIFIERS);
                newModifiers.add(Modifier.PROTECTED);
                break;
            }
            case DEFAULT: {
                newModifiers.removeAll(ALL_ACCESS_MODIFIERS);
                break;
            }
            case PRIVATE: {
                newModifiers.removeAll(ALL_ACCESS_MODIFIERS);
                newModifiers.add(Modifier.PRIVATE);
            }
        }
        ModifiersTree modifiers = this.make.Modifiers(newModifiers, modifiersTree.getAnnotations());
        return modifiers;
    }

    private <T extends Tree> T fixReferences(T body, Element target, final TreePath resolvedPath) {
        TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, resolvedPath, true, true, true, true, true);
        TypeElement enclosingClass = (TypeElement)this.workingCopy.getTrees().getElement(enclosingClassPath);
        final HashMap original2Translated = new HashMap();
        TreeScanner<Void, Void> idScan = new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                TreePath currentPath = new TreePath(resolvedPath, node);
                if (currentPath.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
                    return (Void)super.visitIdentifier(node, p);
                }
                Element element = MoveMembersTransformer.this.workingCopy.getTrees().getElement(currentPath);
                if (element != null && MoveMembersTransformer.this.isElementBeingMoved(element) == null && element.getModifiers().contains((Object)Modifier.STATIC)) {
                    ExpressionTree newTree = MoveMembersTransformer.this.make.QualIdent(element);
                    original2Translated.put(node, newTree);
                }
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                TreePath currentPath = new TreePath(resolvedPath, node);
                if (currentPath.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
                    return (Void)super.visitMethodInvocation(node, p);
                }
                Element element = MoveMembersTransformer.this.workingCopy.getTrees().getElement(currentPath);
                ExpressionTree methodSelect = node.getMethodSelect();
                if (element != null && MoveMembersTransformer.this.isElementBeingMoved(element) == null) {
                    if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                        ExpressionTree newTree = MoveMembersTransformer.this.make.QualIdent(element);
                        original2Translated.put(methodSelect, newTree);
                    } else {
                        MoveMembersTransformer.this.problem = JavaPluginUtils.chainProblems(MoveMembersTransformer.this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_InitNoAccess")));
                    }
                }
                return (Void)super.visitMethodInvocation(node, p);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void p) {
                Element element = MoveMembersTransformer.this.workingCopy.getTrees().getElement(new TreePath(resolvedPath, node));
                if (element != null && MoveMembersTransformer.this.isElementBeingMoved(element) == null && element.getModifiers().contains((Object)Modifier.STATIC)) {
                    ExpressionTree newTree = MoveMembersTransformer.this.make.QualIdent(element);
                    original2Translated.put(node, newTree);
                }
                return (Void)super.visitMemberSelect(node, p);
            }
        };
        idScan.scan(body, null);
        return (T)this.workingCopy.getTreeUtilities().translate(body, original2Translated);
    }

    private static String getParameterName(TypeMirror type, Scope scope, CompilationController info) {
        String name = JavaPluginUtils.getName(type);
        if (name == null) {
            name = "par";
        }
        return JavaPluginUtils.makeNameUnique((CompilationInfo)info, scope, name);
    }

    private boolean enclosedBy(TypeMirror t1, TypeMirror t2) {
        if (t1.getKind() == TypeKind.DECLARED) {
            if (this.workingCopy.getTypes().isSameType(t1, t2)) {
                return true;
            }
            DeclaredType dt = (DeclaredType)t1;
            TypeMirror enclosingType = dt.getEnclosingType();
            if (enclosingType.getKind() == TypeKind.NONE) {
                return false;
            }
            return this.enclosedBy(enclosingType, t2);
        }
        return false;
    }
}

