/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.executable;

import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.PhpOptions;
import org.netbeans.modules.php.api.executable.Bundle;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.openide.util.Lookup;

public final class PhpInterpreter {
    public static final Pattern[] LINE_PATTERNS = new Pattern[]{Pattern.compile(".+\\s+in\\s+(.+)\\s+on\\s+line\\s+(\\d+)"), Pattern.compile(".+\\(\\)\\s+(.+):(\\d+)")};
    private final PhpExecutable executable;

    PhpInterpreter(String command) {
        this.executable = new PhpExecutable(command);
    }

    public static PhpInterpreter getDefault() throws InvalidPhpExecutableException {
        return PhpInterpreter.getCustom(((PhpOptions)Lookup.getDefault().lookup(PhpOptions.class)).getPhpInterpreter());
    }

    public static PhpInterpreter getCustom(String command) throws InvalidPhpExecutableException {
        String error = PhpExecutableValidator.validateCommand(command, Bundle.PhpInterpreter_name());
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new PhpInterpreter(command);
    }

    public String getInterpreter() {
        return this.executable.getExecutable();
    }

    public List<String> getParameters() {
        return this.executable.getParameters();
    }
}

