/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class DriverNodeProvider
extends NodeProvider {
    private static final Comparator<Node> driverComparator = new Comparator<Node>(){

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareToIgnoreCase(model2.getDisplayName());
        }
    };

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private DriverNodeProvider(Lookup lookup) {
        super(lookup, driverComparator);
        JDBCDriverManager mgr = JDBCDriverManager.getDefault();
        mgr.addDriverListener(new JDBCDriverListener(){

            @Override
            public void driversChanged() {
                DriverNodeProvider.this.initialize();
            }
        });
    }

    @Override
    protected synchronized void initialize() {
        JDBCDriver[] drivers;
        ArrayList<Node> newList = new ArrayList<Node>();
        for (JDBCDriver driver : drivers = JDBCDriverManager.getDefault().getDrivers()) {
            Collection<Node> matches = this.getNodes(driver);
            if (matches.size() > 0) {
                newList.addAll(matches);
                continue;
            }
            NodeDataLookup lookup = new NodeDataLookup();
            lookup.add(driver);
            newList.add((Node)DriverNode.create(lookup, this));
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public DriverNodeProvider createInstance(Lookup lookup) {
                return new DriverNodeProvider(lookup);
            }
        };

        private FactoryHolder() {
        }
    }
}

