/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.indexer.NexusRepositoryIndexerImpl;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexQueryProvider;
import org.netbeans.modules.maven.indexer.spi.impl.RepositoryIndexerImplementation;
import org.openide.util.Lookup;

public final class RepositoryIndexer {
    public static void indexRepo(RepositoryInfo repo) {
        assert (repo != null);
        RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(repo);
        if (impl != null) {
            impl.indexRepo(repo);
        } else {
            repo.fireIndexChange();
        }
    }

    public static void updateIndexWithArtifacts(RepositoryInfo repo, Collection<Artifact> artifacts) {
        assert (repo != null);
        if (artifacts == null || artifacts.isEmpty()) {
            return;
        }
        RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(repo);
        if (impl != null) {
            impl.updateIndexWithArtifacts(repo, artifacts);
        }
    }

    public static void deleteArtifactFromIndex(RepositoryInfo repo, Artifact artifact) {
        assert (repo != null);
        if (artifact == null) {
            return;
        }
        RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(repo);
        if (impl != null) {
            impl.deleteArtifactFromIndex(repo, artifact);
        }
    }

    static RepositoryIndexerImplementation findImplementation(RepositoryInfo repo) {
        Lookup l = Lookup.getDefault();
        Collection queryProviders = l.lookupAll(RepositoryIndexQueryProvider.class);
        for (RepositoryIndexQueryProvider queryProvider : queryProviders) {
            if (queryProvider instanceof NexusRepositoryIndexerImpl || !queryProvider.handlesRepository(repo)) continue;
            return null;
        }
        return (RepositoryIndexerImplementation)l.lookup(RepositoryIndexerImplementation.class);
    }
}

