/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.support.impl.FoldingSetStatics;

public abstract class FoldingSetImpl
implements Destructors.ClassWithDestructor {
    protected type.ptr<Object> Buckets;
    protected int NumBuckets;
    protected int NumNodes;

    protected void anchor() {
    }

    protected FoldingSetImpl() {
        this(6);
    }

    protected FoldingSetImpl(int Log2InitSize) {
        assert (Unsigned.$less_uint((int)5, (int)Log2InitSize) && Unsigned.$less_uint((int)Log2InitSize, (int)32)) : "Initial hash table size out of range";
        this.NumBuckets = 1 << Log2InitSize;
        this.Buckets = (type.ptr)Native.$tryConstClone(FoldingSetStatics.AllocateBuckets(this.NumBuckets));
        this.NumNodes = 0;
    }

    protected FoldingSetImpl(JavaDifferentiators.JD.Move _dparam, FoldingSetImpl Arg) {
        this.Buckets = (type.ptr)Native.$tryConstClone(Arg.Buckets);
        this.NumBuckets = Arg.NumBuckets;
        this.NumNodes = Arg.NumNodes;
        Arg.Buckets = null;
        Arg.NumBuckets = 0;
        Arg.NumNodes = 0;
    }

    protected FoldingSetImpl $assignMove(FoldingSetImpl RHS) {
        std.free(this.Buckets);
        this.Buckets = (type.ptr)Native.$tryConstClone(RHS.Buckets);
        this.NumBuckets = RHS.NumBuckets;
        this.NumNodes = RHS.NumNodes;
        RHS.Buckets = null;
        RHS.NumBuckets = 0;
        RHS.NumNodes = 0;
        return this;
    }

    public void $destroy() {
        std.free(this.Buckets);
    }

    public void clear() {
        std.memset(this.Buckets, (Object)0, (int)(this.NumBuckets * NativeType.sizeof(Object.class)));
        this.Buckets.$set(this.NumBuckets, (Object)FoldingSetStatics.EMPTY_NODE);
        this.NumNodes = 0;
    }

    public boolean RemoveNode(Node N) {
        type.ptr Bucket2;
        Object Ptr = N.getNextInBucket();
        if (Ptr == null) {
            return false;
        }
        --this.NumNodes;
        N.SetNextInBucket(null);
        Object NodeNextPtr = Ptr;
        while (true) {
            Node NodeInBucket;
            if ((NodeInBucket = FoldingSetStatics.GetNextPtr(Ptr)) != null) {
                Ptr = NodeInBucket.getNextInBucket();
                if (!Native.$eq_ptr((Object)Ptr, (Object)N)) continue;
                NodeInBucket.SetNextInBucket(NodeNextPtr);
                return true;
            }
            Bucket2 = (type.ptr)Native.$tryClone(FoldingSetStatics.GetBucketPtr(Ptr));
            if (Native.$eq_ptr((Object)(Ptr = Bucket2.$star()), (Object)N)) break;
        }
        Bucket2.$set(NodeNextPtr);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node GetOrInsertNode(Node N) {
        FoldingSetNodeID ID = null;
        try {
            ID = new FoldingSetNodeID();
            this.GetNodeProfile(N, ID);
            type.ref IP = NativePointer.create_type$ref(null);
            Node E = this.FindNodeOrInsertPos(ID, (type.ref<Object>)IP);
            if (E != null) {
                Node node2 = E;
                return node2;
            }
            this.InsertNode(N, IP.$deref());
            Node node3 = N;
            return node3;
        }
        finally {
            if (ID != null) {
                ID.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node FindNodeOrInsertPos(FoldingSetNodeID ID, type.ref<Object> InsertPos) {
        FoldingSetNodeID TempID = null;
        try {
            Node NodeInBucket;
            int IDHash = ID.ComputeHash();
            type.ptr Bucket2 = (type.ptr)Native.$tryClone(FoldingSetStatics.GetBucketFor(IDHash, this.Buckets, this.NumBuckets));
            Object Probe = Bucket2.$star();
            InsertPos.$set(null);
            TempID = new FoldingSetNodeID();
            while ((NodeInBucket = FoldingSetStatics.GetNextPtr(Probe)) != null) {
                if (this.NodeEquals(NodeInBucket, ID, IDHash, TempID)) {
                    Node node2 = NodeInBucket;
                    return node2;
                }
                TempID.clear();
                Probe = NodeInBucket.getNextInBucket();
            }
            InsertPos.$set((Object)Bucket2);
            Node node3 = null;
            return node3;
        }
        finally {
            if (TempID != null) {
                TempID.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void InsertNode(Node N, Object InsertPos) {
        assert (N.getNextInBucket() == null);
        if (Unsigned.$greater_uint((int)(this.NumNodes + 1), (int)(this.NumBuckets * 2))) {
            FoldingSetNodeID TempID = null;
            try {
                this.GrowHashTable();
                TempID = new FoldingSetNodeID();
                InsertPos = Native.$tryClone(FoldingSetStatics.GetBucketFor(this.ComputeNodeHash(N, TempID), this.Buckets, this.NumBuckets));
            }
            finally {
                if (TempID != null) {
                    TempID.$destroy();
                }
            }
        }
        ++this.NumNodes;
        type.ptr Bucket2 = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)InsertPos));
        Object Next = Bucket2.$star();
        if (Next == null) {
            Next = Bucket2;
        }
        N.SetNextInBucket(Next);
        Bucket2.$set((Object)N);
    }

    public void InsertNode(Node N) {
        Node Inserted = this.GetOrInsertNode(N);
        assert (Inserted == N) : "Node already inserted!";
    }

    public int size() {
        return this.NumNodes;
    }

    public boolean empty() {
        return this.NumNodes == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void GrowHashTable() {
        FoldingSetNodeID TempID = null;
        try {
            type.ptr OldBuckets = (type.ptr)Native.$tryClone(this.Buckets);
            int OldNumBuckets = this.NumBuckets;
            this.NumBuckets <<= 1;
            this.Buckets = (type.ptr)Native.$tryConstClone(FoldingSetStatics.AllocateBuckets(this.NumBuckets));
            this.NumNodes = 0;
            TempID = new FoldingSetNodeID();
            for (int i = 0; i != OldNumBuckets; ++i) {
                Node NodeInBucket;
                Object Probe = OldBuckets.$at(i);
                if (Probe == null) continue;
                while ((NodeInBucket = FoldingSetStatics.GetNextPtr(Probe)) != null) {
                    Probe = NodeInBucket.getNextInBucket();
                    NodeInBucket.SetNextInBucket(null);
                    this.InsertNode(NodeInBucket, FoldingSetStatics.GetBucketFor(this.ComputeNodeHash(NodeInBucket, TempID), this.Buckets, this.NumBuckets));
                    TempID.clear();
                }
            }
            std.free((Object)OldBuckets);
        }
        finally {
            if (TempID != null) {
                TempID.$destroy();
            }
        }
    }

    protected abstract void GetNodeProfile(Node var1, FoldingSetNodeID var2);

    protected abstract boolean NodeEquals(Node var1, FoldingSetNodeID var2, int var3, FoldingSetNodeID var4);

    protected abstract int ComputeNodeHash(Node var1, FoldingSetNodeID var2);

    public String toString() {
        return "Buckets=" + this.Buckets + ", NumBuckets=" + this.NumBuckets + ", NumNodes=" + this.NumNodes;
    }

    public static class NodeImpl
    implements Node {
        private Object NextInFoldingSetBucket;

        public NodeImpl() {
            this.NextInFoldingSetBucket = null;
        }

        @Override
        public Object getNextInBucket() {
            return this.NextInFoldingSetBucket;
        }

        @Override
        public void SetNextInBucket(Object N) {
            this.NextInFoldingSetBucket = N;
        }

        @Override
        public void Profile(FoldingSetNodeID ID) {
            throw new UnsupportedOperationException("Please, implement Profile or use another FoldingSetTrait!");
        }

        public NodeImpl(Node $Prm0) {
            this.NextInFoldingSetBucket = $Prm0.getNextInBucket();
        }

        public String toString() {
            return "";
        }
    }

    public static interface Node {
        public Object getNextInBucket();

        public void SetNextInBucket(Object var1);

        public void Profile(FoldingSetNodeID var1);
    }
}

