/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.jsr172.wizard;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.jsr172.wizard.WebServiceClientWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class WebServiceClientWizardIterator
implements TemplateWizard.Iterator {
    public static final String WSDL_SOURCE = "wsdlSource";
    public static final String WSDL_FILE_PATH = "wsdlFilePath";
    public static final String WSDL_DOWNLOAD_URL = "wsdlDownloadUrl";
    public static final String WSDL_DOWNLOAD_FILE = "wsdlDownloadedPath";
    public static final String WSDL_PACKAGE_NAME = "wsdlPackageName";
    public static final String JSR172_CLIENT_NAME = "clientName";
    public static final String PROP_DATABINDING = "DataBinding";
    private int index = 0;
    private WizardDescriptor.Panel[] panels;
    private Project project;
    private static WebServiceClientWizardIterator instance;

    public static synchronized WebServiceClientWizardIterator singleton() {
        if (instance == null) {
            instance = new WebServiceClientWizardIterator();
        }
        return instance;
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new WebServiceClientWizardDescriptor()};
    }

    public void initialize(TemplateWizard wiz) {
        this.project = Templates.getProject((WizardDescriptor)wiz);
        this.index = 0;
        this.panels = this.createPanels();
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = WebServiceClientWizardIterator.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            assert (c instanceof JComponent);
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        wiz.putProperty(WSDL_DOWNLOAD_URL, null);
        wiz.putProperty(WSDL_DOWNLOAD_FILE, null);
        wiz.putProperty(WSDL_FILE_PATH, null);
        wiz.putProperty(WSDL_PACKAGE_NAME, null);
        wiz = null;
        this.panels = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setServiceType("jsr-172");
        this.project = Templates.getProject((WizardDescriptor)wiz);
        String packageName = (String)wiz.getProperty(WSDL_PACKAGE_NAME);
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        SourceGroup sg = sources.getSourceGroups("java")[0];
        FileObject targetFolder = sg.getRootFolder().getFileObject(packageName.replace('.', '/'));
        if (targetFolder == null) {
            targetFolder = FileUtil.createFolder((FileObject)sg.getRootFolder(), (String)packageName.replace('.', '/'));
        }
        String clientName = (String)wiz.getProperty(JSR172_CLIENT_NAME);
        FileObject tempFO = Templates.getTemplate((WizardDescriptor)wiz);
        DataObject template = DataObject.find((FileObject)tempFO);
        E2EDataObject e2eDO = (E2EDataObject)template.createFromTemplate((DataFolder)DataObject.find((FileObject)targetFolder), clientName);
        String filePath = null;
        WSDLService service = new WSDLService();
        if (wiz.getProperty(WSDL_DOWNLOAD_URL) != null) {
            filePath = (String)wiz.getProperty(WSDL_FILE_PATH);
            FileObject fo = null;
            fo = targetFolder.getFileObject(filePath);
            if (fo != null) {
                fo.delete();
            }
            fo = targetFolder.createData(filePath);
            FileLock fclk = null;
            try {
                fclk = fo.lock();
                BufferedOutputStream bos = new BufferedOutputStream(fo.getOutputStream(fclk));
                bos.write((byte[])wiz.getProperty(WSDL_DOWNLOAD_FILE));
                bos.close();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            finally {
                if (fclk != null) {
                    fclk.releaseLock();
                }
            }
            service.setUrl((String)wiz.getProperty(WSDL_DOWNLOAD_URL));
            service.setFile(filePath);
        } else {
            filePath = (String)wiz.getProperty(WSDL_FILE_PATH);
            File file = new File(filePath);
            FileObject foFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            String name = foFile.getName();
            if (!foFile.getURL().toString().equals(targetFolder.getURL().toString() + foFile.getNameExt())) {
                foFile = FileUtil.copyFile((FileObject)foFile, (FileObject)targetFolder, (String)name);
            }
            service.setUrl((filePath.startsWith("/") ? "file:" : "file:/") + filePath);
            service.setFile(foFile.getNameExt());
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setProjectName(ProjectUtils.getInformation((Project)this.project).getName());
        Properties prop = new Properties();
        prop.put("cldc11", "true");
        Boolean propDataBinding = (Boolean)wiz.getProperty(PROP_DATABINDING);
        prop.put(PROP_DATABINDING, propDataBinding != null && propDataBinding != false ? "true" : "false");
        clientConfiguration.setProperties(prop);
        ClassDescriptor classDescriptor = new ClassDescriptor(packageName + "." + clientName, sg.getName());
        clientConfiguration.setClassDescriptor(classDescriptor);
        configuration.setClientConfiguration(clientConfiguration);
        service.setName(clientName);
        ArrayList<WSDLService> list = new ArrayList<WSDLService>();
        list.add(service);
        configuration.setServices(list);
        e2eDO.setConfiguration(configuration);
        e2eDO.generate();
        HashSet<DataObject> result = new HashSet<DataObject>();
        result.add((DataObject)e2eDO);
        return result;
    }

    public String name() {
        return NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"LBL_WebServiceClient");
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }
}

