/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanNodeProp;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class PlatformSpecificProp
extends BooleanNodeProp
implements PropertyChangeListener {
    private PropertyEditor editor;
    private final BooleanConfiguration value;
    private String platform;
    private final MakeConfiguration makeConfiguration;

    public PlatformSpecificProp(MakeConfiguration makeConfiguration, BooleanConfiguration value, boolean canWrite, String id, String name, String hint) {
        super(value, canWrite, id, name, hint);
        this.value = value;
        this.makeConfiguration = makeConfiguration;
        makeConfiguration.getDevelopmentHost().addPropertyChangeListener((PropertyChangeListener)this);
        this.platform = Platforms.getPlatform((int)makeConfiguration.getDevelopmentHost().getBuildPlatform()).getDisplayName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof DevelopmentHostConfiguration) {
            this.platform = Platforms.getPlatform((int)this.makeConfiguration.getDevelopmentHost().getBuildPlatform()).getDisplayName();
            PropertyEditor ed = this.getPropertyEditor();
            if (ed instanceof PropertyEditorSupport) {
                ((PropertyEditorSupport)ed).firePropertyChange();
            }
        }
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new PropertyEditorImpl();
        }
        return this.editor;
    }

    private class PropertyEditorImpl
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private final JCheckBox checkBox = new JCheckBox();
        private PropertyEnv propenv;

        @Override
        public void setValue(Object obj) {
            if (obj instanceof Boolean) {
                Boolean v = (Boolean)obj;
                this.checkBox.setSelected(v);
            }
        }

        @Override
        public Object getValue() {
            return this.checkBox.isSelected();
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        @Override
        public void firePropertyChange() {
            super.firePropertyChange();
        }

        @Override
        public void paintValue(Graphics g, Rectangle box) {
            this.checkBox.setSize(box.width, box.height);
            this.checkBox.doLayout();
            this.checkBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            if (this.checkBox.isSelected()) {
                this.checkBox.setText(this.getTags()[1]);
            } else {
                this.checkBox.setText(this.getTags()[0]);
            }
            Graphics gr = g.create(box.x, box.y, box.width, box.height);
            this.checkBox.setOpaque(false);
            this.checkBox.paint(gr);
            gr.dispose();
        }

        @Override
        public String getAsText() {
            if (this.checkBox.isSelected()) {
                return this.getTags()[1];
            }
            return this.getTags()[0];
        }

        @Override
        public String[] getTags() {
            String[] out = new String[]{NbBundle.getMessage(PlatformSpecificProp.class, (String)"PlatformSpecificFalse"), NbBundle.getMessage(PlatformSpecificProp.class, (String)"PlatformSpecificTrue", (Object)PlatformSpecificProp.this.platform)};
            return out;
        }

        @Override
        public Component getCustomEditor() {
            throw new IllegalStateException();
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public void attachEnv(PropertyEnv env) {
            this.propenv = env;
        }
    }
}

