/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.makeproject.api.configurations.CodeAssistanceConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringListNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.utils.TokenizerFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CodeAssistanceCustomizerNode
extends CustomizerNode {
    public CodeAssistanceCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        switch (this.getContext().getKind()) {
            case Project: {
                Sheet generalSheet = this.getGeneralSheet((MakeConfiguration)configuration, ((MakeConfiguration)configuration).getCodeAssistanceConfiguration());
                return new Sheet[]{generalSheet};
            }
        }
        return null;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsParser");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CodeAssistanceCustomizerNode.class, (String)s);
    }

    private Sheet getGeneralSheet(MakeConfiguration conf, CodeAssistanceConfiguration ca) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("CodeAssistance");
        set.setDisplayName(CodeAssistanceCustomizerNode.getString("CodeAssistanceTxt"));
        set.setShortDescription(CodeAssistanceCustomizerNode.getString("CodeAssistanceHint"));
        set.put((Node.Property)new BooleanNodeProp(ca.getBuildAnalyzer(), true, "BuildAnalyzer", CodeAssistanceCustomizerNode.getString("BuildAnalyzerTxt"), CodeAssistanceCustomizerNode.getString("BuildAnalyzerHint")));
        if (System.getProperty("cnd.buildtrace.tools") != null) {
            set.put((Node.Property)new StringNodeProp(ca.getTools(), "gcc:c++:g++:clang:clang++:icc:icpc:ifort:gfortran:g77:g90:g95:cc:CC:ffortran:f77:f90:f95:ar:ld", "Tools", CodeAssistanceCustomizerNode.getString("ToolsTxt2"), CodeAssistanceCustomizerNode.getString("ToolsHint2")));
        }
        set.put((Node.Property)new StringListNodeProp(ca.getTransientMacros(), null, new String[]{"transient-macros", CodeAssistanceCustomizerNode.getString("TransientMacrosTxt"), CodeAssistanceCustomizerNode.getString("TransientMacrosHint"), CodeAssistanceCustomizerNode.getString("TransientMacrosLbl"), null}, true, new HelpCtx("transient-macros")){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
            }
        });
        set.put((Node.Property)new StringListNodeProp(ca.getEnvironmentVariables(), null, new String[]{"environment-variables", CodeAssistanceCustomizerNode.getString("EnvironmentVariablesTxt"), CodeAssistanceCustomizerNode.getString("EnvironmentVariablesHint"), CodeAssistanceCustomizerNode.getString("EnvironmentVariablesLbl"), null}, true, new HelpCtx("environment-variables")){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
            }
        });
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("IncludeInCodeAssistance");
        set.setDisplayName(CodeAssistanceCustomizerNode.getString("IncludeInCodeAssistanceTxt"));
        set.setShortDescription(CodeAssistanceCustomizerNode.getString("IncludeInCodeAssistanceHint"));
        set.put((Node.Property)new BooleanNodeProp(ca.getIncludeInCA(), true, "IncludeFlag", CodeAssistanceCustomizerNode.getString("IncludeFlagTxt"), CodeAssistanceCustomizerNode.getString("IncludeFlagHint")));
        set.put((Node.Property)new PatternNodeProp(ca.getExcludeInCA(), "", "ExcludePattern", CodeAssistanceCustomizerNode.getString("ExcludePatternTxt"), CodeAssistanceCustomizerNode.getString("ExcludePatternHint")));
        set.put((Node.Property)new BooleanNodeProp(ca.getResolveSymbolicLinks(), false, "ResolveSymbolicLinks", CodeAssistanceCustomizerNode.getString("ResolveSymbolicLinksTxt"), CodeAssistanceCustomizerNode.getString("ResolveSymbolicLinksHint")));
        sheet.put(set);
        return sheet;
    }

    private static class PatternNodeProp
    extends StringNodeProp {
        public PatternNodeProp(StringConfiguration stringConfiguration, String def, String txt1, String txt2, String txt3) {
            super(stringConfiguration, def, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            try {
                Pattern.compile(v);
            }
            catch (Throwable ex) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeAssistanceCustomizerNode.getString("InvalidPattern"), 0));
            }
            super.setValue(v);
        }
    }
}

