/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.runprofiles;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.ui.runprofiles.RerunArguments;
import org.netbeans.modules.cnd.makeproject.uiapi.EventsProcessorActions;
import org.netbeans.modules.dlight.api.terminal.TerminalSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class EventsProcessorActionsImpl
extends EventsProcessorActions {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private final AtomicReference<ProjectActionHandler> activeHandlerRef = new AtomicReference<Object>(null);
    private final StopAction stopAction = new StopAction(this.activeHandlerRef);
    private final RerunAction rerunAction;
    private final RerunModAction rerunModAction;
    private final TermAction ta;
    private List<BuildActionsProvider.BuildAction> additional;
    private final BuildActionsProvider.EventsProcessor ep;

    public EventsProcessorActionsImpl(BuildActionsProvider.EventsProcessor ep) {
        this.ep = ep;
        this.rerunAction = new RerunAction(ep);
        this.rerunModAction = new RerunModAction(ep);
        this.ta = new TermAction(ep);
    }

    public Action[] getActions(String name) {
        ArrayList<AbstractAction> list = new ArrayList<AbstractAction>();
        list.add(this.stopAction);
        list.add(this.rerunAction);
        for (int i = 0; i < this.ep.getProjectActionEvents().length; ++i) {
            if (this.ep.getProjectActionEvents()[i].getType() != ProjectActionEvent.PredefinedType.RUN) continue;
            list.add(this.rerunModAction);
            break;
        }
        list.add(this.ta);
        if (this.additional == null) {
            this.additional = BuildActionsProvider.getDefault().getActions(name, this.ep.getProjectActionEvents());
        }
        list.addAll(this.additional);
        return list.toArray(new Action[list.size()]);
    }

    public void setEnableRerunAction(boolean enable) {
        this.rerunAction.setEnabled(enable);
    }

    public void setEnableRerunModAction(boolean enable) {
        this.rerunModAction.setEnabled(enable);
    }

    public void setEnableStopAction(boolean enable) {
        this.stopAction.setEnabled(enable);
    }

    public void stopAction() {
        this.stopAction.actionPerformed(null);
    }

    public ProjectActionHandler getActiveHandler() {
        return this.activeHandlerRef.get();
    }

    public void setActiveHandler(ProjectActionHandler handler) {
        this.activeHandlerRef.set(handler);
    }

    public List<BuildActionsProvider.BuildAction> getAdditional() {
        return this.additional;
    }

    public void setAdditional(String name) {
        this.additional = BuildActionsProvider.getDefault().getActions(name, this.ep.getProjectActionEvents());
    }

    private static String getString(String s) {
        return NbBundle.getMessage(EventsProcessorActionsImpl.class, (String)s);
    }

    private static String getString(String s, String ... arg) {
        return NbBundle.getMessage(EventsProcessorActionsImpl.class, (String)s, (Object[])arg);
    }

    private static final class TermAction
    extends AbstractAction {
        private final BuildActionsProvider.EventsProcessor handleEvents;

        public TermAction(BuildActionsProvider.EventsProcessor handleEvents) {
            this.handleEvents = handleEvents;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dlight/terminal/ui/term.png", (boolean)false));
            this.putValue("ShortDescription", EventsProcessorActionsImpl.getString("TargetExecutor.TermAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block4: {
                ProjectActionEvent pae;
                int i = this.handleEvents.getProjectActionEvents().length - 1;
                if (i < 0 || !this.handleEvents.checkProject(pae = this.handleEvents.getProjectActionEvents()[i])) break block4;
                String projectName = ProjectUtils.getInformation((Project)pae.getProject()).getDisplayName();
                String dir = pae.getProfile().getRunDirectory();
                ExecutionEnvironment env = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
                if (env.isRemote() && RemoteFileUtil.getProjectSourceExecutionEnvironment((Project)pae.getProject()).isLocal()) {
                    PathMap pathMap = RemoteSyncSupport.getPathMap((Lookup.Provider)pae.getProject());
                    if (pathMap != null) {
                        String aDir = pathMap.getRemotePath(dir);
                        if (aDir != null) {
                            dir = aDir;
                        }
                    } else {
                        LOGGER.log(Level.SEVERE, "Path Mapper not found for project {0} - using local path {1}", new Object[]{pae.getProject(), dir});
                    }
                }
                TerminalSupport.openTerminal((String)EventsProcessorActionsImpl.getString("TargetExecutor.TermAction.tabTitle", new String[]{projectName, env.getDisplayName()}), (ExecutionEnvironment)env, (String)dir);
            }
        }
    }

    private static final class RerunModAction
    extends AbstractAction {
        private final BuildActionsProvider.EventsProcessor eventsProcessor;

        public RerunModAction(BuildActionsProvider.EventsProcessor eventsProcessor) {
            this.eventsProcessor = eventsProcessor;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/rerun-mod.png", (boolean)false));
            this.putValue("ShortDescription", EventsProcessorActionsImpl.getString("TargetExecutor.RerunAction.rerun-mod"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            if (new RerunArguments(this.eventsProcessor.getProjectActionEvents()).showMe()) {
                this.eventsProcessor.submitTask();
            } else {
                this.setEnabled(true);
            }
        }
    }

    private static final class RerunAction
    extends AbstractAction {
        private final BuildActionsProvider.EventsProcessor eventsProcessor;

        public RerunAction(BuildActionsProvider.EventsProcessor eventsProcessor) {
            this.eventsProcessor = eventsProcessor;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/rerun.png", (boolean)false));
            this.putValue("ShortDescription", EventsProcessorActionsImpl.getString("TargetExecutor.RerunAction.rerun"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            this.eventsProcessor.submitTask();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        private final AtomicReference<ProjectActionHandler> activeHandlerRef;

        public StopAction(AtomicReference<ProjectActionHandler> activeHandlerRef) {
            this.activeHandlerRef = activeHandlerRef;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/stop.png", (boolean)false));
            this.putValue("ShortDescription", EventsProcessorActionsImpl.getString("TargetExecutor.StopAction.stop"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            ProjectActionHandler handler = this.activeHandlerRef.getAndSet(null);
            if (handler != null) {
                handler.cancel();
            }
        }
    }

    public static final class EventsProcessorActionsFactoryImpl
    implements EventsProcessorActions.EventsProcessorActionsFactory {
        public EventsProcessorActions getEventsProcessorActions(BuildActionsProvider.EventsProcessor ep) {
            return new EventsProcessorActionsImpl(ep);
        }
    }
}

