/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.JavaIteratorBool;
import org.clank.support.aliases.bool$iterator;
import org.clank.support.aliases.bool$ptr;
import org.clank.support.aliases.bool$ref;

public abstract class StdVectorBool
implements Native.assignable<std.vectorBool>,
NativeCloneable<std.vectorBool>,
Native.NativeComparable<std.vectorBool>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Boolean>,
Destructors.ClassWithDestructor {
    protected final boolean defaultValue;
    protected boolean[] array;
    private static final boolean[] EMPTY = NativePointer.new$bool(0);
    protected int end;

    protected StdVectorBool(boolean defaultValue) {
        this.array = EMPTY;
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected StdVectorBool(int initialSize, boolean defaultValue) {
        this(defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected StdVectorBool(boolean[] array2, int length, boolean defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected StdVectorBool(bool$iterator<?> iter, int length, boolean defaultValue) {
        this(iter, (bool$iterator)iter.$add(length), defaultValue);
    }

    protected StdVectorBool(bool$iterator<?> begin, bool$iterator<?> end, boolean defaultValue) {
        this(defaultValue);
        this.append(begin, end);
    }

    protected StdVectorBool(std.vectorBool other) {
        this(other.defaultValue);
        this.append(other.begin(), other.end());
    }

    protected StdVectorBool(JavaDifferentiators.JD.Move _dparam, std.vectorBool other) {
        this(false);
        this.$assignMove(other);
    }

    @Override
    public std.vectorBool $assign(std.vectorBool other) {
        this.array = other.array;
        this.end = other.end;
        return (std.vectorBool)this;
    }

    public std.vectorBool $assignMove(std.vectorBool other) {
        boolean[] tmpArray = this.array;
        int tmpEnd = this.end;
        this.array = other.array;
        this.end = other.end;
        other.array = tmpArray;
        other.end = tmpEnd;
        return (std.vectorBool)this;
    }

    public void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void resize(int newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(int newSize, boolean defaultValue) {
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
    }

    public void reserve(int N) {
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public void assign(int NumElts, boolean Elt) {
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public void assign(bool$iterator<?> __first, bool$iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public void swap(StdVectorBool RHS) {
        boolean[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(boolean elem) {
        return this.find(elem, 0);
    }

    public final int find(boolean elem, int from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], elem, isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(boolean elem) {
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(boolean elem) {
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy(this.array, index + 1, this.end - index, this.array, index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy(I.$add(1), this.end(), I);
        this.pop_back();
        return N;
    }

    public iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = std.copy(E, this.end(), S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public iterator insert(iterator I, boolean Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public iterator insert(iterator I, int NumToInsert, boolean Elt) {
        assert (NumToInsert >= 0);
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.fill_n(I, NumToInsert, Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        std.fill_n(I, NumOverwritten, Elt);
        std.fill_n(OldEnd, NumToInsert - NumOverwritten, Elt);
        return I;
    }

    public iterator insert(iterator I, bool$iterator<?> From, bool$iterator<?> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.copy(From, To, I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        From = Native.$tryClone(From);
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, OldEnd);
        return I;
    }

    public void append(bool$iterator<?> in_start, bool$iterator<?> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        bool$iterator iter = (bool$iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public void append(int NumInputs, boolean Elt) {
        assert (NumInputs >= 0);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    @Override
    public boolean $eq(std.vectorBool RHS) {
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), RHS.begin());
    }

    @Override
    public boolean $noteq(std.vectorBool RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $less(Object obj) {
        return std.lexicographical_compare(this.begin(), this.end(), ((StdVectorBool)obj).begin(), ((StdVectorBool)obj).end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((std.vectorBool)obj);
    }

    public bool$ref ref$at(int idx) {
        return NativePointer.create_bool$ref(this.array, idx);
    }

    public boolean $at(int idx) {
        return this.array[idx];
    }

    public boolean $set(int idx, boolean value) {
        this.array[idx] = value;
        return value;
    }

    public boolean empty() {
        return this.size() == 0;
    }

    @Override
    public void $destroy() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void push_back(boolean val) {
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public void emplace_back() {
        this.push_back(this.defaultValue);
    }

    public void emplace_back(boolean value) {
        this.push_back(value);
    }

    public void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public boolean pop_back_val() {
        boolean val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public std.reverse_iteratorBool rbegin() {
        return new std.reverse_iteratorBool(NativePointer.create_bool$ptr(this.array, this.end));
    }

    public std.reverse_iteratorBool rend() {
        return new std.reverse_iteratorBool(NativePointer.create_bool$ptr(this.array));
    }

    public bool$ptr data() {
        return NativePointer.create_bool$ptr(this.array);
    }

    public boolean front() {
        return this.array[0];
    }

    public boolean back() {
        return this.array[this.end - 1];
    }

    public bool$ref ref$front() {
        return new bool$ref(){
            private final boolean stored;
            private final int index = 0;
            {
                this.stored = StdVectorBool.this.array[0];
                this.index = 0;
            }

            @Override
            public boolean $deref() {
                return this.stored;
            }

            @Override
            public boolean $set(boolean value) {
                StdVectorBool.this.array[0] = value;
                return value;
            }

            @Override
            public bool$ptr deref$ptr() {
                return (bool$ptr)StdVectorBool.this.data().$add(0);
            }
        };
    }

    public bool$ref ref$back() {
        return new bool$ref(){
            private final boolean stored;
            private final int index;
            {
                this.stored = StdVectorBool.this.array[StdVectorBool.this.end - 1];
                this.index = StdVectorBool.this.end - 1;
            }

            @Override
            public boolean $deref() {
                return this.stored;
            }

            @Override
            public boolean $set(boolean value) {
                StdVectorBool.this.array[this.index] = value;
                return value;
            }

            @Override
            public bool$ptr deref$ptr() {
                return (bool$ptr)StdVectorBool.this.data().$add(this.index);
            }
        };
    }

    public int size() {
        return this.end;
    }

    public int max_size() {
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        return this.array.length;
    }

    @Override
    public int $sizeof() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (boolean elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.capacity() * oneElemSize;
    }

    public bool$ptr ptr$at(int idx) {
        return NativePointer.create_bool$ptr(this.array, idx);
    }

    @Override
    public std.vectorBool clone() {
        return new std.vectorBool((std.vectorBool)this);
    }

    public void set_size(int N) {
        assert (N >= 0);
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int newSize) {
        this.array = NativePointer.copyOf$bool(this.array, newSize);
    }

    private void grow() {
        this.grow(this.capacity() > 0 ? this.capacity() * 2 : 1);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new JavaIteratorBool(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\n").append(this.getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            boolean element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}").append(this.getClass().getSimpleName()).append("}\n");
        return out.toString();
    }

    public static final class iterator
    implements bool$iterator<iterator>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final StdVectorBool delegate;
        private int index;

        public iterator(StdVectorBool delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator(iterator other) {
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator other) {
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        @Override
        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public boolean $arrow() {
            return this.$at(0);
        }

        @Override
        public boolean $star() {
            return this.$at(0);
        }

        @Override
        public bool$ref star$ref() {
            return this.ref$at(0);
        }

        @Override
        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        @Override
        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        @Override
        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        @Override
        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        @Override
        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        @Override
        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        @Override
        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        @Override
        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        @Override
        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        @Override
        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        @Override
        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        @Override
        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        @Override
        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        @Override
        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        @Override
        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public boolean $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public bool$ref ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public bool$ptr toPointer() {
            return NativePointer.create_bool$ptr(this.delegate.array, this.index);
        }

        public int $index() {
            return this.index;
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

