/**
 * DOMLocator is an interface that describes a location (e.g. where an error occurred).
 */
var DOMLocator = {
}
/**
 * The byte offset into the input source this locator is pointing to or -1 if there is no byte offset available.
 * @syntax dOMLocator.byteOffset
 * @returns {Number} 
 */
DOMLocator.prototype.byteOffset = new Number();

/**
 * The line number this locator is pointing to, or -1 if there is no column number available.
 * @syntax dOMLocator.lineNumber
 * @returns {Number} 
 */
DOMLocator.prototype.lineNumber = new Number();

/**
 * The node this locator is pointing to, or null if no node is available.
 * @syntax dOMLocator.relatedNode
 * @returns {Node} 
 */
DOMLocator.prototype.relatedNode = new Node();

/**
 * The UTF-16, as defined in [Unicode] and Amendment 1 of [ISO/IEC 10646], offset into the input source this locator is pointing to or -1 if there is no UTF-16 offset available.
 * @syntax dOMLocator.utf16Offset
 * @returns {Number} 
 */
DOMLocator.prototype.utf16Offset = new Number();

/**
 * The URI this locator is pointing to, or null if no URI is available.
 * @syntax dOMLocator.uri
 * @returns {String} 
 */
DOMLocator.prototype.uri = new String();

/**
 * The column number this locator is pointing to, or -1 if there is no column number available.
 * @syntax dOMLocator.columnNumber
 * @returns {Number} 
 */
DOMLocator.prototype.columnNumber = new Number();

/**
 * Represents the DOMLocator prototype object.
 * @syntax DOMLocator.prototype
 * @static
 */
DOMLocator.prototype;

