/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoReorder;

public class UndoSewSegments
extends UndoReorder {
    private boolean[] _segmentStartFlags = null;

    public UndoSewSegments(Track track) {
        super(track, "undo.sewsegments");
        int n = track.getNumPoints();
        this._segmentStartFlags = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this._segmentStartFlags[n2] = track.getPoint(n2).getSegmentStart();
            ++n2;
        }
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        super.performUndo(trackInfo);
        int n = 0;
        while (n < this._segmentStartFlags.length) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                dataPoint.setSegmentStart(this._segmentStartFlags[n]);
            }
            ++n;
        }
    }
}

