/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;

public class Permute
extends Transform {
    private final MethodType source;
    private final int[] reorder;

    public Permute(MethodType source2, int ... reorder) {
        this.source = source2;
        this.reorder = reorder;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return MethodHandles.permuteArguments(target, this.source, this.reorder);
    }

    @Override
    public MethodType down(MethodType type2) {
        Class[] types = new Class[this.reorder.length];
        for (int i2 = 0; i2 < this.reorder.length; ++i2) {
            int typeIndex = this.reorder[i2];
            if (typeIndex < 0 || typeIndex >= type2.parameterCount()) {
                throw new InvalidTransformException("one or more permute indices (" + Arrays.toString(this.reorder) + ") out of bounds for " + this.source);
            }
            types[i2] = type2.parameterType(this.reorder[i2]);
        }
        return MethodType.methodType(type2.returnType(), types);
    }

    @Override
    public String toString() {
        return "permute " + this.source + " with " + Arrays.toString(this.reorder);
    }
}

