/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.OwnershipListener;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSelectionClearEvent;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;

final class XSelection {
    private static final Hashtable<XAtom, XSelection> table = new Hashtable();
    private static final Object lock = new Object();
    private static final XAtom selectionPropertyAtom = XAtom.get("XAWT_SELECTION");
    public static final long MAX_LENGTH = 1000000L;
    public static final int MAX_PROPERTY_SIZE;
    private static final XEventDispatcher incrementalTransferHandler;
    private static WindowPropertyGetter propertyGetter;
    private final XAtom selectionAtom;
    private Transferable contents = null;
    private Map formatMap = null;
    private long[] formats = null;
    private AppContext appContext = null;
    private static long lastRequestServerTime;
    private long ownershipTime = 0L;
    private boolean isOwner;
    private OwnershipListener ownershipListener = null;
    private final Object stateLock = new Object();

    static XSelection getSelection(XAtom xAtom) {
        return table.get(xAtom);
    }

    XSelection(XAtom xAtom) {
        if (xAtom == null) {
            throw new NullPointerException("Null atom");
        }
        this.selectionAtom = xAtom;
        table.put(this.selectionAtom, this);
    }

    public XAtom getSelectionAtom() {
        return this.selectionAtom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean setOwner(Transferable transferable, Map map, long[] lArray, long l) {
        long l2 = XWindow.getXAWTRootWindow().getWindow();
        long l3 = this.selectionAtom.getAtom();
        if (l == 0L) {
            l = XToolkit.getCurrentServerTime();
        }
        this.contents = transferable;
        this.formatMap = map;
        this.formats = lArray;
        this.appContext = AppContext.getAppContext();
        this.ownershipTime = l;
        XToolkit.awtLock();
        try {
            XlibWrapper.XSetSelectionOwner(XToolkit.getDisplay(), l3, l2, l);
            if (XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), l3) != l2) {
                this.reset();
                boolean bl = false;
                return bl;
            }
            this.setOwnerProp(true);
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private static void waitForSelectionNotify(WindowPropertyGetter windowPropertyGetter) throws InterruptedException {
        long l = System.currentTimeMillis();
        XToolkit.awtLock();
        try {
            do {
                DataTransferer.getInstance().processDataConversionRequests();
                XToolkit.awtLockWait(250L);
            } while (propertyGetter == windowPropertyGetter && System.currentTimeMillis() < l + (long)UNIXToolkit.getDatatransferTimeout());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long[] getTargets(long l) {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        long[] lArray = null;
        Object object = lock;
        synchronized (object) {
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, true, 0L);
            try {
                XToolkit.awtLock();
                try {
                    propertyGetter = windowPropertyGetter;
                    lastRequestServerTime = l;
                    XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l);
                    try {
                        XSelection.waitForSelectionNotify(windowPropertyGetter);
                        propertyGetter = null;
                    }
                    catch (InterruptedException interruptedException) {
                        long[] lArray2;
                        try {
                            lArray2 = new long[]{};
                            propertyGetter = null;
                        }
                        catch (Throwable throwable) {
                            propertyGetter = null;
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        windowPropertyGetter.dispose();
                        return lArray2;
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
    }

    static long[] getFormats(WindowPropertyGetter windowPropertyGetter) {
        int n;
        long[] lArray = null;
        if (windowPropertyGetter.isExecuted() && !windowPropertyGetter.isDisposed() && (windowPropertyGetter.getActualType() == 4L || windowPropertyGetter.getActualType() == XDataTransferer.TARGETS_ATOM.getAtom()) && windowPropertyGetter.getActualFormat() == 32 && (n = windowPropertyGetter.getNumberOfItems()) > 0) {
            long l = windowPropertyGetter.getData();
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = Native.getLong(l + (long)(i * XAtom.getAtomSize()));
            }
        }
        return lArray != null ? lArray : new long[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] getData(long l, long l2) throws IOException {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        byte[] byArray = null;
        Object object = lock;
        synchronized (object) {
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, false, 0L);
            try {
                XToolkit.awtLock();
                try {
                    propertyGetter = windowPropertyGetter;
                    lastRequestServerTime = l2;
                    XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), l, selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l2);
                    try {
                        XSelection.waitForSelectionNotify(windowPropertyGetter);
                        propertyGetter = null;
                    }
                    catch (InterruptedException interruptedException) {
                        byte[] byArray2;
                        try {
                            byArray2 = new byte[]{};
                            propertyGetter = null;
                        }
                        catch (Throwable throwable) {
                            propertyGetter = null;
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        windowPropertyGetter.dispose();
                        return byArray2;
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
    }

    private void validateDataGetter(WindowPropertyGetter windowPropertyGetter) throws IOException {
        if (windowPropertyGetter.isDisposed()) {
            throw new IOException("Owner failed to convert data");
        }
        if (!windowPropertyGetter.isExecuted()) {
            throw new IOException("Owner timed out");
        }
    }

    boolean isOwner() {
        return this.isOwner;
    }

    private void setOwnerProp(boolean bl) {
        this.isOwner = bl;
        this.fireOwnershipChanges(this.isOwner);
    }

    private void lostOwnership() {
        this.setOwnerProp(false);
    }

    public synchronized void reset() {
        this.contents = null;
        this.formatMap = null;
        this.formats = null;
        this.appContext = null;
        this.ownershipTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertAndStore(long l, long l2, long l3) {
        int n = 8;
        byte[] byArray = null;
        long l4 = 0L;
        int n2 = 0;
        try {
            SunToolkit.insertTargetMapping(this, this.appContext);
            byArray = DataTransferer.getInstance().convertData(this, this.contents, l2, this.formatMap, XToolkit.isToolkitThread());
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        n2 = byArray.length;
        try {
            if (n2 > 0) {
                if (n2 <= MAX_PROPERTY_SIZE) {
                    l4 = Native.toData(byArray);
                } else {
                    new IncrementalDataProvider(l, l3, l2, 8, byArray);
                    l4 = XlibWrapper.unsafe.allocateMemory(XAtom.getAtomSize());
                    Native.putLong(l4, n2);
                    l2 = XDataTransferer.INCR_ATOM.getAtom();
                    n = 32;
                    n2 = 1;
                }
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, l3, l2, n, 0, l4, n2);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            if (l4 != 0L) {
                XlibWrapper.unsafe.freeMemory(l4);
                l4 = 0L;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelectionRequest(XSelectionRequestEvent xSelectionRequestEvent) {
        long l = xSelectionRequestEvent.get_property();
        long l2 = xSelectionRequestEvent.get_requestor();
        long l3 = xSelectionRequestEvent.get_time();
        long l4 = xSelectionRequestEvent.get_target();
        boolean bl = false;
        if (this.ownershipTime != 0L && (l3 == 0L || l3 >= this.ownershipTime)) {
            if (l4 == XDataTransferer.MULTIPLE_ATOM.getAtom()) {
                bl = this.handleMultipleRequest(l2, l);
            } else {
                if (l == 0L) {
                    l = l4;
                }
                bl = l4 == XDataTransferer.TARGETS_ATOM.getAtom() ? this.handleTargetsRequest(l, l2) : this.convertAndStore(l2, l4, l);
            }
        }
        if (!bl) {
            l = 0L;
        }
        XSelectionEvent xSelectionEvent = new XSelectionEvent();
        try {
            xSelectionEvent.set_type(31);
            xSelectionEvent.set_send_event(true);
            xSelectionEvent.set_requestor(l2);
            xSelectionEvent.set_selection(this.selectionAtom.getAtom());
            xSelectionEvent.set_target(l4);
            xSelectionEvent.set_property(l);
            xSelectionEvent.set_time(l3);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), l2, false, 0L, xSelectionEvent.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            xSelectionEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMultipleRequest(long l, long l2) {
        boolean bl;
        block10: {
            if (0L == l2) {
                return false;
            }
            bl = false;
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XAtom.get(l2), 0L, 1000000L, false, 0L);
            try {
                windowPropertyGetter.execute();
                if (windowPropertyGetter.getActualFormat() != 32 || windowPropertyGetter.getNumberOfItems() % 2 != 0) break block10;
                long l3 = windowPropertyGetter.getNumberOfItems() / 2;
                long l4 = windowPropertyGetter.getData();
                boolean bl2 = false;
                int n = 0;
                while ((long)n < l3) {
                    long l5;
                    long l6 = Native.getLong(l4, 2 * n);
                    if (!this.convertAndStore(l, l6, l5 = Native.getLong(l4, 2 * n + 1))) {
                        Native.putLong(l4, 2 * n, 0L);
                        bl2 = true;
                    }
                    ++n;
                }
                if (bl2) {
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, l2, windowPropertyGetter.getActualType(), windowPropertyGetter.getActualFormat(), 0, windowPropertyGetter.getData(), windowPropertyGetter.getNumberOfItems());
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
                bl = true;
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleTargetsRequest(long l, long l2) throws IllegalStateException {
        boolean bl = false;
        long[] lArray = this.formats;
        if (lArray == null) {
            throw new IllegalStateException("Not an owner.");
        }
        long l3 = 0L;
        try {
            int n = lArray.length;
            if (n > 0) {
                l3 = Native.allocateLongArray(n);
                Native.put(l3, lArray);
            }
            bl = true;
            XToolkit.awtLock();
            try {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, l, 4L, 32, 0, l3, n);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            if (l3 != 0L) {
                XlibWrapper.unsafe.freeMemory(l3);
                l3 = 0L;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOwnershipChanges(boolean bl) {
        OwnershipListener ownershipListener = null;
        Object object = this.stateLock;
        synchronized (object) {
            ownershipListener = this.ownershipListener;
        }
        if (null != ownershipListener) {
            ownershipListener.ownershipChanged(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOwershipListener(OwnershipListener ownershipListener) {
        Object object = this.stateLock;
        synchronized (object) {
            this.ownershipListener = ownershipListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOwnershipListener() {
        Object object = this.stateLock;
        synchronized (object) {
            this.ownershipListener = null;
        }
    }

    static {
        XToolkit.awtLock();
        try {
            MAX_PROPERTY_SIZE = (int)(XlibWrapper.XMaxRequestSize(XToolkit.getDisplay()) * 4L - 100L);
        }
        finally {
            XToolkit.awtUnlock();
        }
        incrementalTransferHandler = new IncrementalTransferHandler();
        propertyGetter = null;
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionEventHandler());
    }

    private static class IncrementalTransferHandler
    implements XEventDispatcher {
        private IncrementalTransferHandler() {
        }

        @Override
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                    if (xPropertyEvent.get_state() != 0 || xPropertyEvent.get_atom() != selectionPropertyAtom.getAtom()) break;
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null) {
                            propertyGetter.execute();
                            propertyGetter = null;
                        }
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
            }
        }
    }

    private static class IncrementalDataProvider
    implements XEventDispatcher {
        private final long requestor;
        private final long property;
        private final long target;
        private final int format;
        private final byte[] data;
        private int offset = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IncrementalDataProvider(long l, long l2, long l3, int n, byte[] byArray) {
            if (n != 8) {
                throw new IllegalArgumentException("Unsupported format: " + n);
            }
            this.requestor = l;
            this.property = l2;
            this.target = l3;
            this.format = n;
            this.data = byArray;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                XToolkit.awtLock();
                try {
                    XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                    XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, xWindowAttributes.get_your_event_mask() | 0x400000L);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                xWindowAttributes.dispose();
            }
            XToolkit.addEventDispatcher(l, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                    if (xPropertyEvent.get_window() != this.requestor || xPropertyEvent.get_state() != 1 || xPropertyEvent.get_atom() != this.property) break;
                    int n = this.data.length - this.offset;
                    long l = 0L;
                    if (n > MAX_PROPERTY_SIZE) {
                        n = MAX_PROPERTY_SIZE;
                    }
                    if (n > 0) {
                        l = XlibWrapper.unsafe.allocateMemory(n);
                        for (int i = 0; i < n; ++i) {
                            Native.putByte(l + (long)i, this.data[this.offset + i]);
                        }
                    } else {
                        assert (n == 0);
                        XToolkit.removeEventDispatcher(this.requestor, this);
                    }
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), this.requestor, this.property, this.target, this.format, 0, l, n);
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                    if (l != 0L) {
                        XlibWrapper.unsafe.freeMemory(l);
                        l = 0L;
                    }
                    this.offset += n;
                }
            }
        }
    }

    private static class SelectionEventHandler
    implements XEventDispatcher {
        private SelectionEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 31: {
                    XToolkit.awtLock();
                    try {
                        XSelectionEvent xSelectionEvent = xEvent.get_xselection();
                        if (propertyGetter != null && xSelectionEvent.get_time() == lastRequestServerTime) {
                            if (xSelectionEvent.get_property() == selectionPropertyAtom.getAtom()) {
                                propertyGetter.execute();
                                propertyGetter = null;
                            } else if (xSelectionEvent.get_property() == 0L) {
                                propertyGetter.dispose();
                                propertyGetter = null;
                            }
                        }
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
                case 30: {
                    XSelectionRequestEvent xSelectionRequestEvent = xEvent.get_xselectionrequest();
                    long l = xSelectionRequestEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l));
                    if (xSelection == null) break;
                    xSelection.handleSelectionRequest(xSelectionRequestEvent);
                    break;
                }
                case 29: {
                    XSelectionClearEvent xSelectionClearEvent = xEvent.get_xselectionclear();
                    long l = xSelectionClearEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l));
                    if (xSelection != null) {
                        xSelection.lostOwnership();
                    }
                    XToolkit.awtLock();
                    try {
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
            }
        }
    }
}

