/* liblightdm-gobject-1.vapi generated by vapigen-0.38, do not modify. */

[CCode (cprefix = "LightDM", gir_namespace = "LightDM", gir_version = "1", lower_case_cprefix = "lightdm_")]
namespace LightDM {
	[CCode (cheader_filename = "lightdm.h", type_id = "lightdm_greeter_get_type ()")]
	public class Greeter : GLib.Object {
		[CCode (has_construct_function = false)]
		public Greeter ();
		public bool authenticate (string? username = null) throws GLib.Error;
		public bool authenticate_as_guest () throws GLib.Error;
		public bool authenticate_autologin () throws GLib.Error;
		public bool authenticate_remote (string session, string? username) throws GLib.Error;
		public bool cancel_authentication () throws GLib.Error;
		public void cancel_autologin ();
		[Version (deprecated = true, deprecated_since = "1.11.1", replacement = "LightDM.Greeter.connect_to_daemon_sync")]
		public bool connect_sync () throws GLib.Error;
		public async bool connect_to_daemon (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_to_daemon_sync () throws GLib.Error;
		public async string ensure_shared_data_dir (string username, GLib.Cancellable? cancellable) throws GLib.Error;
		public string ensure_shared_data_dir_sync (string username) throws GLib.Error;
		public unowned string? get_authentication_user ();
		public bool get_autologin_guest_hint ();
		public unowned string? get_autologin_session_hint ();
		public int get_autologin_timeout_hint ();
		public unowned string? get_autologin_user_hint ();
		public unowned string get_default_session_hint ();
		public bool get_has_guest_account_hint ();
		public bool get_hide_users_hint ();
		public unowned string? get_hint (string name);
		public bool get_in_authentication ();
		public bool get_is_authenticated ();
		public bool get_lock_hint ();
		public bool get_select_guest_hint ();
		public unowned string? get_select_user_hint ();
		public bool get_show_manual_login_hint ();
		public bool get_show_remote_login_hint ();
		public bool respond (string response) throws GLib.Error;
		public bool set_language (string language) throws GLib.Error;
		public void set_resettable (bool resettable);
		public async bool start_session (string? session = null, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool start_session_sync (string? session = null) throws GLib.Error;
		public string? authentication_user { get; }
		public bool autologin_guest_hint { get; }
		public string autologin_session_hint { get; }
		public int autologin_timeout_hint { get; }
		public string? autologin_user_hint { get; }
		public string default_session_hint { get; }
		public bool has_guest_account_hint { get; }
		public bool hide_users_hint { get; }
		public bool in_authentication { get; }
		public bool is_authenticated { get; }
		public bool lock_hint { get; }
		public bool select_guest_hint { get; }
		public string? select_user_hint { get; }
		public bool show_manual_login_hint { get; }
		public bool show_remote_login_hint { get; }
		public virtual signal void authentication_complete ();
		public virtual signal void autologin_timer_expired ();
		public virtual signal void idle ();
		public virtual signal void reset ();
		public virtual signal void show_message (string text, LightDM.MessageType type);
		public virtual signal void show_prompt (string text, LightDM.PromptType type);
	}
	[CCode (cheader_filename = "lightdm.h", type_id = "lightdm_language_get_type ()")]
	public class Language : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Language ();
		public unowned string get_code ();
		public unowned string get_name ();
		public unowned string get_territory ();
		public bool matches (string code);
		public string code { get; construct; }
		public string name { get; }
		public string territory { get; }
	}
	[CCode (cheader_filename = "lightdm.h", type_id = "lightdm_layout_get_type ()")]
	public class Layout : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Layout ();
		public unowned string get_description ();
		public unowned string get_name ();
		public unowned string get_short_description ();
		public string description { get; construct; }
		public string name { get; construct; }
		public string short_description { get; construct; }
	}
	[CCode (cheader_filename = "lightdm.h", type_id = "lightdm_session_get_type ()")]
	public class Session : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Session ();
		public unowned string get_comment ();
		public unowned string get_key ();
		public unowned string get_name ();
		public unowned string get_session_type ();
		public string comment { get; }
		public string key { get; }
		public string name { get; }
	}
	[CCode (cheader_filename = "lightdm.h", type_id = "lightdm_user_get_type ()")]
	public class User : GLib.Object {
		[CCode (has_construct_function = false)]
		protected User ();
		public unowned string? get_background ();
		public unowned string get_display_name ();
		public bool get_has_messages ();
		public unowned string get_home_directory ();
		public unowned string? get_image ();
		public unowned string? get_language ();
		public unowned string? get_layout ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_layouts ();
		public bool get_logged_in ();
		public unowned string get_name ();
		public unowned string get_real_name ();
		public unowned string? get_session ();
		public Posix.uid_t get_uid ();
		public string background { get; }
		public string display_name { get; }
		public bool has_messages { get; }
		public string home_directory { get; }
		public string image { get; }
		public string language { get; }
		public string layout { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] layouts { get; }
		public bool logged_in { get; }
		public string name { get; }
		public string real_name { get; }
		public string session { get; }
		public Posix.uid_t uid { get; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "lightdm.h", type_id = "lightdm_user_list_get_type ()")]
	public class UserList : GLib.Object {
		[CCode (has_construct_function = false)]
		protected UserList ();
		public static unowned LightDM.UserList get_instance ();
		public int get_length ();
		public unowned LightDM.User get_user_by_name (string username);
		public unowned GLib.List<LightDM.User> get_users ();
		public int length { get; }
		[NoAccessorMethod]
		public int num_users { get; }
		public GLib.List<LightDM.User> users { get; }
		public virtual signal void user_added (LightDM.User user);
		public virtual signal void user_changed (LightDM.User user);
		public virtual signal void user_removed (LightDM.User user);
	}
	[CCode (cheader_filename = "lightdm.h", cprefix = "LIGHTDM_MESSAGE_TYPE_", type_id = "lightdm_message_type_get_type ()")]
	public enum MessageType {
		INFO,
		ERROR
	}
	[CCode (cheader_filename = "lightdm.h", cprefix = "LIGHTDM_PROMPT_TYPE_", type_id = "lightdm_prompt_type_get_type ()")]
	public enum PromptType {
		QUESTION,
		SECRET
	}
	[CCode (cheader_filename = "lightdm.h", cprefix = "LIGHTDM_GREETER_ERROR_")]
	public errordomain GreeterError {
		COMMUNICATION_ERROR,
		CONNECTION_FAILED,
		SESSION_FAILED,
		NO_AUTOLOGIN,
		INVALID_USER;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_GREETER_SIGNAL_AUTHENTICATION_COMPLETE")]
	public const string GREETER_SIGNAL_AUTHENTICATION_COMPLETE;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_GREETER_SIGNAL_AUTOLOGIN_TIMER_EXPIRED")]
	public const string GREETER_SIGNAL_AUTOLOGIN_TIMER_EXPIRED;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_GREETER_SIGNAL_IDLE")]
	public const string GREETER_SIGNAL_IDLE;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_GREETER_SIGNAL_RESET")]
	public const string GREETER_SIGNAL_RESET;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_GREETER_SIGNAL_SHOW_MESSAGE")]
	public const string GREETER_SIGNAL_SHOW_MESSAGE;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_GREETER_SIGNAL_SHOW_PROMPT")]
	public const string GREETER_SIGNAL_SHOW_PROMPT;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_SIGNAL_USER_CHANGED")]
	public const string SIGNAL_USER_CHANGED;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_USER_LIST_SIGNAL_USER_ADDED")]
	public const string USER_LIST_SIGNAL_USER_ADDED;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_USER_LIST_SIGNAL_USER_CHANGED")]
	public const string USER_LIST_SIGNAL_USER_CHANGED;
	[CCode (cheader_filename = "lightdm.h", cname = "LIGHTDM_USER_LIST_SIGNAL_USER_REMOVED")]
	public const string USER_LIST_SIGNAL_USER_REMOVED;
	[CCode (cheader_filename = "lightdm.h")]
	public static bool get_can_hibernate ();
	[CCode (cheader_filename = "lightdm.h")]
	public static bool get_can_restart ();
	[CCode (cheader_filename = "lightdm.h")]
	public static bool get_can_shutdown ();
	[CCode (cheader_filename = "lightdm.h")]
	public static bool get_can_suspend ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned string get_hostname ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned LightDM.Language get_language ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned GLib.List<LightDM.Language> get_languages ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned LightDM.Layout get_layout ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned GLib.List<LightDM.Layout> get_layouts ();
	[CCode (cheader_filename = "lightdm.h")]
	public static string? get_motd ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned string? get_os_id ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned string? get_os_name ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned string? get_os_pretty_name ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned string? get_os_version ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned string? get_os_version_id ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned GLib.List<LightDM.Session> get_remote_sessions ();
	[CCode (cheader_filename = "lightdm.h")]
	public static unowned GLib.List<LightDM.Session> get_sessions ();
	[CCode (cheader_filename = "lightdm.h")]
	public static bool hibernate () throws GLib.Error;
	[CCode (cheader_filename = "lightdm.h")]
	public static bool restart () throws GLib.Error;
	[CCode (cheader_filename = "lightdm.h")]
	public static void set_layout (LightDM.Layout layout);
	[CCode (cheader_filename = "lightdm.h")]
	public static bool shutdown () throws GLib.Error;
	[CCode (cheader_filename = "lightdm.h")]
	public static bool suspend () throws GLib.Error;
}
