/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_be extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BRL", "BRL" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYR", "\u0440." },
            { "BZD", "BZD" },
            { "CAD", "CAD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\u00a5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "NZD", "NZD" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "\u20bd" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0434\u044b\u0440\u0445\u0435\u043c \u0410\u0410\u042d" },
            { "afn", "\u0430\u0444\u0433\u0430\u043d\u0441\u043a\u0456 \u0430\u0444\u0433\u0430\u043d\u0456" },
            { "all", "\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0456 \u043b\u0435\u043a" },
            { "amd", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0456 \u0434\u0440\u0430\u043c" },
            { "ang", "\u043d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0456 \u0430\u043d\u0442\u044b\u043b\u044c\u0441\u043a\u0456 \u0433\u0443\u043b\u044c\u0434\u044d\u043d" },
            { "aoa", "\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u043d\u0437\u0430" },
            { "ars", "\u0430\u0440\u0433\u0435\u043d\u0446\u0456\u043d\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "aud", "\u0430\u045e\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "awg", "\u0430\u0440\u0443\u0431\u0430\u043d\u0441\u043a\u0456 \u0444\u043b\u0430\u0440\u044b\u043d" },
            { "azn", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0456 \u043c\u0430\u043d\u0430\u0442" },
            { "bam", "\u043a\u0430\u043d\u0432\u0435\u0440\u0441\u043e\u045e\u043d\u0430\u044f \u043c\u0430\u0440\u043a\u0430" },
            { "bbd", "\u0431\u0430\u0440\u0431\u0430\u0434\u043e\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "bdt", "\u0431\u0430\u043d\u0433\u043b\u0430\u0434\u044d\u0448\u0441\u043a\u0430\u044f \u0442\u0430\u043a\u0430" },
            { "bgn", "\u0431\u0430\u043b\u0433\u0430\u0440\u0441\u043a\u0456 \u043b\u0435\u045e" },
            { "bhd", "\u0431\u0430\u0445\u0440\u044d\u0439\u043d\u0441\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "bif", "\u0431\u0443\u0440\u0443\u043d\u0434\u0437\u0456\u0439\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "bmd", "\u0431\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "bnd", "\u0431\u0440\u0443\u043d\u0435\u0439\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "bob", "\u0431\u0430\u043b\u0456\u0432\u0456\u044f\u043d\u0430" },
            { "brl", "\u0431\u0440\u0430\u0437\u0456\u043b\u044c\u0441\u043a\u0456 \u0440\u044d\u0430\u043b" },
            { "bsd", "\u0431\u0430\u0433\u0430\u043c\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "btn", "\u0431\u0443\u0442\u0430\u043d\u0441\u043a\u0456 \u043d\u0433\u0443\u043b\u0442\u0440\u0443\u043c" },
            { "bwp", "\u0431\u0430\u0442\u0441\u0432\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0443\u043b\u0430" },
            { "byr", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0456 \u0440\u0443\u0431\u0435\u043b\u044c" },
            { "bzd", "\u0431\u0435\u043b\u0456\u0437\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "cad", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "cdf", "\u043a\u0430\u043d\u0433\u0430\u043b\u0435\u0437\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "chf", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "clp", "\u0447\u044b\u043b\u0456\u0439\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "cny", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0456 \u044e\u0430\u043d\u044c" },
            { "cop", "\u043a\u0430\u043b\u0443\u043c\u0431\u0456\u0439\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "crc", "\u043a\u043e\u0441\u0442\u0430-\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456 \u043a\u0430\u043b\u043e\u043d" },
            { "cuc", "\u043a\u0443\u0431\u0456\u043d\u0441\u043a\u0430\u0435 \u043a\u0430\u043d\u0432\u0435\u0440\u0441\u043e\u045e\u043d\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "cup", "\u043a\u0443\u0431\u0456\u043d\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "cve", "\u044d\u0441\u043a\u0443\u0434\u0430 \u041a\u0430\u0431\u0430-\u0412\u0435\u0440\u0434\u044d" },
            { "czk", "\u0447\u044d\u0448\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "djf", "\u0434\u0436\u044b\u0431\u0443\u0446\u0456\u0439\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "dkk", "\u0434\u0430\u0446\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "dop", "\u0434\u0430\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "dzd", "\u0430\u043b\u0436\u044b\u0440\u0441\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "egp", "\u0435\u0433\u0456\u043f\u0435\u0446\u043a\u0456 \u0444\u0443\u043d\u0442" },
            { "ern", "\u044d\u0440\u044b\u0442\u0440\u044d\u0439\u0441\u043a\u0430\u044f \u043d\u0430\u043a\u0444\u0430" },
            { "etb", "\u044d\u0444\u0456\u043e\u043f\u0441\u043a\u0456 \u0431\u044b\u0440" },
            { "eur", "\u0435\u045e\u0440\u0430" },
            { "fjd", "\u0444\u0456\u0434\u0436\u044b\u0439\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "fkp", "\u0444\u0443\u043d\u0442 \u0424\u0430\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0456\u0445 \u0430\u0441\u0442\u0440\u0430\u0432\u043e\u045e" },
            { "gbp", "\u0431\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0456 \u0444\u0443\u043d\u0442 \u0441\u0442\u044d\u0440\u043b\u0456\u043d\u0433\u0430\u045e" },
            { "gel", "\u0433\u0440\u0443\u0437\u0456\u043d\u0441\u043a\u0456 \u043b\u0430\u0440\u044b" },
            { "ghs", "\u0433\u0430\u043d\u0441\u043a\u0456 \u0441\u0435\u0434\u0437\u0456" },
            { "gip", "\u0433\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440\u0441\u043a\u0456 \u0444\u0443\u043d\u0442" },
            { "gmd", "\u0433\u0430\u043c\u0431\u0456\u0439\u0441\u043a\u0456 \u0434\u0430\u043b\u0430\u0441\u0456" },
            { "gnf", "\u0433\u0432\u0456\u043d\u0435\u0439\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "gtq", "\u0433\u0432\u0430\u0442\u044d\u043c\u0430\u043b\u044c\u0441\u043a\u0456 \u043a\u0435\u0442\u0441\u0430\u043b\u044c" },
            { "gyd", "\u0433\u0430\u044f\u043d\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "hkd", "\u0433\u0430\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "hnl", "\u0433\u0430\u043d\u0434\u0443\u0440\u0430\u0441\u043a\u0430\u044f \u043b\u0435\u043c\u043f\u0456\u0440\u0430" },
            { "hrk", "\u0445\u0430\u0440\u0432\u0430\u0446\u043a\u0430\u044f \u043a\u0443\u043d\u0430" },
            { "htg", "\u0433\u0430\u0456\u0446\u044f\u043d\u0441\u043a\u0456 \u0433\u0443\u0440\u0434" },
            { "huf", "\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0456 \u0444\u043e\u0440\u044b\u043d\u0442" },
            { "idr", "\u0456\u043d\u0434\u0430\u043d\u0435\u0437\u0456\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0456\u044f" },
            { "ils", "\u043d\u043e\u0432\u044b \u0456\u0437\u0440\u0430\u0456\u043b\u044c\u0441\u043a\u0456 \u0448\u044d\u043a\u0435\u043b\u044c" },
            { "inr", "\u0456\u043d\u0434\u044b\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0456\u044f" },
            { "iqd", "\u0456\u0440\u0430\u043a\u0441\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "irr", "\u0456\u0440\u0430\u043d\u0441\u043a\u0456 \u0440\u044b\u0430\u043b" },
            { "isk", "\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "jmd", "\u044f\u043c\u0430\u0439\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "jod", "\u0456\u0430\u0440\u0434\u0430\u043d\u0441\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "jpy", "\u044f\u043f\u043e\u043d\u0441\u043a\u0430\u044f \u0456\u0435\u043d\u0430" },
            { "kes", "\u043a\u0435\u043d\u0456\u0439\u0441\u043a\u0456 \u0448\u044b\u043b\u0456\u043d\u0433" },
            { "kgs", "\u043a\u0456\u0440\u0433\u0456\u0437\u0441\u043a\u0456 \u0441\u043e\u043c" },
            { "khr", "\u043a\u0430\u043c\u0431\u0430\u0434\u0436\u044b\u0439\u0441\u043a\u0456 \u0440\u044b\u044d\u043b\u044c" },
            { "kmf", "\u043a\u0430\u043c\u043e\u0440\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "kpw", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u043a\u0430\u0440\u044d\u0439\u0441\u043a\u0430\u044f \u0432\u043e\u043d\u0430" },
            { "krw", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u043a\u0430\u0440\u044d\u0439\u0441\u043a\u0430\u044f \u0432\u043e\u043d\u0430" },
            { "kwd", "\u043a\u0443\u0432\u0435\u0439\u0446\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "kyd", "\u0434\u043e\u043b\u0430\u0440 \u041a\u0430\u0439\u043c\u0430\u043d\u0430\u0432\u044b\u0445 \u0430\u0441\u0442\u0440\u0430\u0432\u043e\u045e" },
            { "kzt", "\u043a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0441\u043a\u0456 \u0442\u044d\u043d\u0433\u044d" },
            { "lak", "\u043b\u0430\u043e\u0441\u043a\u0456 \u043a\u0456\u043f" },
            { "lbp", "\u043b\u0456\u0432\u0430\u043d\u0441\u043a\u0456 \u0444\u0443\u043d\u0442" },
            { "lkr", "\u0448\u0440\u044b-\u043b\u0430\u043d\u043a\u0456\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0456\u044f" },
            { "lrd", "\u043b\u0456\u0431\u0435\u0440\u044b\u0439\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "lyd", "\u043b\u0456\u0432\u0456\u0439\u0441\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "mad", "\u043c\u0430\u0440\u0430\u043a\u0430\u043d\u0441\u043a\u0456 \u0434\u044b\u0440\u0445\u0430\u043c" },
            { "mdl", "\u043c\u0430\u043b\u0434\u0430\u045e\u0441\u043a\u0456 \u043b\u0435\u0439" },
            { "mga", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0456\u0439\u0441\u043a\u0456 \u0430\u0440\u044b\u044f\u0440\u044b" },
            { "mkd", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0456 \u0434\u044d\u043d\u0430\u0440" },
            { "mmk", "\u043c\u2019\u044f\u043d\u043c\u0430\u043d\u0441\u043a\u0456 \u043a\u2019\u044f\u0442" },
            { "mnt", "\u043c\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0456 \u0442\u0443\u0433\u0440\u044b\u043a" },
            { "mop", "\u043f\u0430\u0442\u0430\u043a\u0430 \u041c\u0430\u043a\u0430\u0430" },
            { "mro", "\u043c\u0430\u045e\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u045e\u0433\u0456\u044f" },
            { "mur", "\u043c\u0430\u045e\u0440\u044b\u043a\u0456\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0456\u044f" },
            { "mvr", "\u043c\u0430\u043b\u044c\u0434\u044b\u045e\u0441\u043a\u0430\u044f \u0440\u0443\u0444\u0456\u044f" },
            { "mwk", "\u043c\u0430\u043b\u0430\u0432\u0456\u0439\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u0447\u0430" },
            { "mxn", "\u043c\u0435\u043a\u0441\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "myr", "\u043c\u0430\u043b\u0430\u0439\u0437\u0456\u0439\u0441\u043a\u0456 \u0440\u044b\u043d\u0433\u0456\u0442" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043c\u0431\u0456\u043a\u0441\u043a\u0456 \u043c\u0435\u0442\u044b\u043a\u0430\u043b" },
            { "nad", "\u043d\u0430\u043c\u0456\u0431\u0456\u0439\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "ngn", "\u043d\u0456\u0433\u0435\u0440\u044b\u0439\u0441\u043a\u0430\u044f \u043d\u0430\u0439\u0440\u0430" },
            { "nio", "\u043d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u043a\u0430\u044f \u043a\u043e\u0440\u0434\u0430\u0431\u0430" },
            { "nok", "\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "npr", "\u043d\u0435\u043f\u0430\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0456\u044f" },
            { "nzd", "\u043d\u043e\u0432\u0430\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "omr", "\u0430\u043c\u0430\u043d\u0441\u043a\u0456 \u0440\u044b\u0430\u043b" },
            { "pab", "\u043f\u0430\u043d\u0430\u043c\u0441\u043a\u0430\u0435 \u0431\u0430\u043b\u044c\u0431\u043e\u0430" },
            { "pen", "\u043f\u0435\u0440\u0443\u0430\u043d\u0441\u043a\u0456 \u043d\u043e\u0432\u044b \u0441\u043e\u043b\u044c" },
            { "pgk", "\u043a\u0456\u043d\u0430" },
            { "php", "\u0444\u0456\u043b\u0456\u043f\u0456\u043d\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "pkr", "\u043f\u0430\u043a\u0456\u0441\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0456\u044f" },
            { "pln", "\u043f\u043e\u043b\u044c\u0441\u043a\u0456 \u0437\u043b\u043e\u0442\u044b" },
            { "pyg", "\u043f\u0430\u0440\u0430\u0433\u0432\u0430\u0439\u0441\u043a\u0456 \u0433\u0443\u0430\u0440\u0430\u043d\u0456" },
            { "qar", "\u043a\u0430\u0442\u0430\u0440\u0441\u043a\u0456 \u0440\u044b\u0430\u043b" },
            { "ron", "\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0456 \u043b\u0435\u0439" },
            { "rsd", "\u0441\u0435\u0440\u0431\u0441\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "rub", "\u0440\u0430\u0441\u0456\u0439\u0441\u043a\u0456 \u0440\u0443\u0431\u0435\u043b\u044c" },
            { "rwf", "\u0440\u0443\u0430\u043d\u0434\u044b\u0439\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "sar", "\u0441\u0430\u0443\u0434\u0430\u045e\u0441\u043a\u0456 \u0440\u044b\u044f\u043b" },
            { "sbd", "\u0434\u043e\u043b\u0430\u0440 \u0421\u0430\u043b\u0430\u043c\u043e\u043d\u0430\u0432\u044b\u0445 \u0410\u0441\u0442\u0440\u0430\u0432\u043e\u045e" },
            { "scr", "\u0441\u0435\u0439\u0448\u044d\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0456\u044f" },
            { "sdg", "\u0441\u0443\u0434\u0430\u043d\u0441\u043a\u0456 \u0444\u0443\u043d\u0442" },
            { "sek", "\u0448\u0432\u0435\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "sgd", "\u0441\u0456\u043d\u0433\u0430\u043f\u0443\u0440\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "shp", "\u0444\u0443\u043d\u0442 \u0421\u0432\u044f\u0442\u043e\u0439 \u0410\u043b\u0435\u043d\u044b" },
            { "sll", "\u043b\u0435\u043e\u043d\u044d" },
            { "sos", "\u0441\u0430\u043c\u0430\u043b\u0456\u0439\u0441\u043a\u0456 \u0448\u044b\u043b\u0456\u043d\u0433" },
            { "srd", "\u0441\u0443\u0440\u044b\u043d\u0430\u043c\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "ssp", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u0441\u0443\u0434\u0430\u043d\u0441\u043a\u0456 \u0444\u0443\u043d\u0442" },
            { "std", "\u0434\u043e\u0431\u0440\u0430 \u0421\u0430\u043d-\u0422\u0430\u043c\u044d \u0456 \u041f\u0440\u044b\u043d\u0441\u0456\u043f\u0456" },
            { "syp", "\u0441\u0456\u0440\u044b\u0439\u0441\u043a\u0456 \u0444\u0443\u043d\u0442" },
            { "szl", "\u0441\u0432\u0430\u0437\u0456\u043b\u0435\u043d\u0434\u0441\u043a\u0456 \u043b\u0456\u043b\u0430\u043d\u0433\u0435\u043d\u0456" },
            { "thb", "\u0442\u0430\u0439\u0441\u043a\u0456 \u0431\u0430\u0442" },
            { "tjs", "\u0442\u0430\u0434\u0436\u044b\u043a\u0441\u043a\u0456 \u0441\u0430\u043c\u0430\u043d\u0456" },
            { "tmt", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0456 \u043c\u0430\u043d\u0430\u0442" },
            { "tnd", "\u0442\u0443\u043d\u0456\u0441\u043a\u0456 \u0434\u044b\u043d\u0430\u0440" },
            { "top", "\u0442\u0430\u043d\u0433\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0430\u0430\u043d\u0433\u0430" },
            { "try", "\u0442\u0443\u0440\u044d\u0446\u043a\u0430\u044f \u043b\u0456\u0440\u0430" },
            { "ttd", "\u0434\u043e\u043b\u0430\u0440 \u0422\u0440\u044b\u043d\u0456\u0434\u0430\u0434\u0430 \u0456 \u0422\u0430\u0431\u0430\u0433\u0430" },
            { "twd", "\u043d\u043e\u0432\u044b \u0442\u0430\u0439\u0432\u0430\u043d\u044c\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "tzs", "\u0442\u0430\u043d\u0437\u0430\u043d\u0456\u0439\u0441\u043a\u0456 \u0448\u044b\u043b\u0456\u043d\u0433" },
            { "uah", "\u0443\u043a\u0440\u0430\u0456\u043d\u0441\u043a\u0430\u044f \u0433\u0440\u044b\u045e\u043d\u0430" },
            { "ugx", "\u0443\u0433\u0430\u043d\u0434\u044b\u0439\u0441\u043a\u0456 \u0448\u044b\u043b\u0456\u043d\u0433" },
            { "usd", "\u0434\u043e\u043b\u0430\u0440 \u0417\u0428\u0410" },
            { "uyu", "\u0443\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u0430\u0435 \u043f\u0435\u0441\u0430" },
            { "uzs", "\u0443\u0437\u0431\u0435\u043a\u0441\u043a\u0456 \u0441\u0443\u043c" },
            { "vef", "\u0432\u0435\u043d\u0435\u0441\u0443\u0430\u043b\u044c\u0441\u043a\u0456 \u0431\u0430\u043b\u0456\u0432\u0430\u0440" },
            { "vnd", "\u0432\u2019\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0456 \u0434\u043e\u043d\u0433" },
            { "vuv", "\u0432\u0430\u0442\u0443" },
            { "wst", "\u0441\u0430\u043c\u0430\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u0430\u043b\u0430" },
            { "xaf", "\u0446\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u0430\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a \u041a\u0424\u0410" },
            { "xcd", "\u0443\u0441\u0445\u043e\u0434\u043d\u0435\u043a\u0430\u0440\u044b\u0431\u0441\u043a\u0456 \u0434\u043e\u043b\u0430\u0440" },
            { "xof", "\u0437\u0430\u0445\u043e\u0434\u043d\u0435\u0430\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a \u041a\u0424\u0410" },
            { "xpf", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0456 \u0446\u0456\u0445\u0430\u0430\u043a\u0456\u044f\u043d\u0441\u043a\u0456 \u0444\u0440\u0430\u043d\u043a" },
            { "xxx", "\u043d\u0435\u0432\u044f\u0434\u043e\u043c\u0430\u044f \u0432\u0430\u043b\u044e\u0442\u0430" },
            { "yer", "\u0435\u043c\u0435\u043d\u0441\u043a\u0456 \u0440\u044b\u0430\u043b" },
            { "zar", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u0430\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456 \u0440\u0430\u043d\u0434" },
            { "zmw", "\u0437\u0430\u043c\u0431\u0456\u0439\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u0447\u0430" },
        };
        return data;
    }
}
