/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malajalam";
        final String metaValue_or = "orija";
        final String metaValue_te = "telugu";
        final String metaValue_chr = "czirokeski";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_phn = "fenicki";
        final String metaValue_syr = "syryjski";
        final Object[][] data = new Object[][] {
            { "ksh", "gwara kolo\u0144ska" },
            { "Ogam", "ogham" },
            { "mwl", "mirandese" },
            { "Zsym", "symbole" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "egl", "emilijski" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "dialekt Gniva/Njiva" },
            { "xmf", "megrelski" },
            { "egy", "staro\u017cytny egipski" },
            { "raj", "rad\u017aasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "ateso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Wyspa Wniebowst\u0105pienia" },
            { "rar", "rarotonga" },
            { "tet", "tetum" },
            { "AD", "Andora" },
            { "AE", "Zjednoczone Emiraty Arabskie" },
            { "nl_BE", "flamandzki" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "glk", "gilia\u0144ski" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktyka" },
            { "AR", "Argentyna" },
            { "Prti", "partyjski inskrypcyjny" },
            { "AS", "Samoa Ameryka\u0144skie" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "ameryka\u0144ski angielski" },
            { "AX", "Wyspy Alandzkie" },
            { "mye", "myene" },
            { "AZ", "Azerbejd\u017can" },
            { "%%AREVELA", "ormia\u0144ski wchodni" },
            { "BA", "Bo\u015bnia i Hercegowina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesz" },
            { "kum", "kumycki" },
            { "BE", "Belgia" },
            { "gmh", "\u015brednio-wysoko-niemiecki" },
            { "BF", "Burkina Faso" },
            { "BG", "Bu\u0142garia" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermudy" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brunei Darussalam" },
            { "BO", "Boliwia" },
            { "BQ", "Niderlandy Karaibskie" },
            { "BR", "Brazylia" },
            { "BS", "Bahamy" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Wyspa Bouveta" },
            { "BW", "Botswana" },
            { "BY", "Bia\u0142oru\u015b" },
            { "BZ", "Belize" },
            { "Visp", "Visible Speech" },
            { "CA", "Kanada" },
            { "CC", "Wyspy Kokosowe" },
            { "mzn", "mazandera\u0144ski" },
            { "CD", "Demokratyczna Republika Konga" },
            { "CF", "Republika \u015arodkowoafryka\u0144ska" },
            { "CG", "Kongo" },
            { "CH", "Szwajcaria" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Wyspy Cooka" },
            { "CL", "Chile" },
            { "Kthi", "kaithi" },
            { "CM", "Kamerun" },
            { "CN", "Chiny" },
            { "CO", "Kolumbia" },
            { "CP", "Clipperton" },
            { "CR", "Kostaryka" },
            { "CU", "Kuba" },
            { "CV", "Republika Zielonego Przyl\u0105dka" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Wyspa Bo\u017cego Narodzenia" },
            { "CY", "Cypr" },
            { "CZ", "Czechy" },
            { "eka", "ekajuk" },
            { "vls", "zachodnioflamandzki" },
            { "DE", "Niemcy" },
            { "goh", "staro-wysoko-niemiecki" },
            { "ace", "aceh" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "konkani (Goa)" },
            { "DJ", "D\u017cibuti" },
            { "DK", "Dania" },
            { "ach", "aczoli" },
            { "gon", "gondi" },
            { "Brai", "Braille\u2019a" },
            { "Brah", "brahmi" },
            { "DM", "Dominika" },
            { "DO", "Dominikana" },
            { "gor", "gorontalo" },
            { "got", "gocki" },
            { "vmf", "me\u0144ski franko\u0144ski" },
            { "Mtei", "meitei mayek" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "DZ", "Algieria" },
            { "pag", "pangasino" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta i Melilla" },
            { "chb", "czibcza" },
            { "pam", "pampango" },
            { "EC", "Ekwador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "tiv", "tiw" },
            { "EG", "Egipt" },
            { "EH", "Sahara Zachodnia" },
            { "chg", "czagatajski" },
            { "pau", "palau" },
            { "chk", "truk" },
            { "chn", "\u017cargon Chinook" },
            { "chm", "maryjski" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Erytrea" },
            { "ES", "Hiszpania" },
            { "ET", "Etiopia" },
            { "EU", "Unia Europejska" },
            { "elx", "elamicki" },
            { "chy", "j\u0119zyk Czejen\u00f3w" },
            { "Inds", "indus" },
            { "ady", "adygejski" },
            { "aeb", "tunezyjski arabski" },
            { "FI", "Finlandia" },
            { "FJ", "Fid\u017ci" },
            { "FK", "Falklandy" },
            { "FM", "Mikronezja" },
            { "FO", "Wyspy Owcze" },
            { "Taml", "tamilskie" },
            { "FR", "Francja" },
            { "pcd", "pikardyjski" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "j\u0119zyk rdzenny" },
            { "rgn", "romagnol" },
            { "grc", "starogrecki" },
            { "GA", "Gabon" },
            { "tkr", "cachurski" },
            { "vot", "wotiacki" },
            { "GB", "Wielka Brytania" },
            { "GD", "Grenada" },
            { "GE", "Gruzja" },
            { "GF", "Gujana Francuska" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Grenlandia" },
            { "enm", "\u015brednioangielski" },
            { "GM", "Gambia" },
            { "GN", "Gwinea" },
            { "GP", "Gwadelupa" },
            { "GQ", "Gwinea R\u00f3wnikowa" },
            { "GR", "Grecja" },
            { "GS", "Georgia Po\u0142udniowa i Sandwich Po\u0142udniowy" },
            { "GT", "Gwatemala" },
            { "GU", "Guam" },
            { "pdc", "pensylwa\u0144ski" },
            { "GW", "Gwinea Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingo\u0144ski" },
            { "Talu", "nowy tai lue" },
            { "GY", "Gujana" },
            { "ckb", "sorani" },
            { "zxx", "brak tre\u015bci o charakterze j\u0119zykowym" },
            { "tly", "ta\u0142yski" },
            { "pdt", "plautdietsch" },
            { "de_AT", "austriacki niemiecki" },
            { "HK", "SRA Hongkong (Chiny)" },
            { "Vaii", "vai" },
            { "HM", "Wyspy Heard i McDonalda" },
            { "HN", "Honduras" },
            { "HR", "Chorwacja" },
            { "agq", "aghem" },
            { "gsw", "szwajcarski niemiecki" },
            { "HT", "Haiti" },
            { "HU", "W\u0119gry" },
            { "rif", "tarifit" },
            { "tmh", "tamaszek" },
            { "IC", "Wyspy Kanaryjskie" },
            { "nan", "minna\u0144ski" },
            { "ID", "Indonezja" },
            { "peo", "staroperski" },
            { "IE", "Irlandia" },
            { "nap", "neapolita\u0144ski" },
            { "naq", "nama" },
            { "zza", "zazaki" },
            { "IL", "Izrael" },
            { "IM", "Wyspa Man" },
            { "IN", "Indie" },
            { "IO", "Brytyjskie Terytorium Oceanu Indyjskiego" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "W\u0142ochy" },
            { "Zmth", "notacja matematyczna" },
            { "vro", "v\u00f5ro" },
            { "guc", "way\u00fau" },
            { "%%POSIX", "komputerowy" },
            { "pfl", "palatynacki" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "Beng", "bengalskie" },
            { "JO", "Jordania" },
            { "gur", "frafra" },
            { "JP", "Japonia" },
            { "%%1606NICT", "szesnastowieczny francuski" },
            { "ain", "ajnu" },
            { "guz", "gusii" },
            { "tog", "tonga (Niasa)" },
            { "Kali", "kayah li" },
            { "de_CH", "wysokoniemiecki (Szwajcaria)" },
            { "izh", "ingryjski" },
            { "KE", "Kenia" },
            { "419", "Ameryka \u0141aci\u0144ska" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ca" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts i Nevis" },
            { "Zinh", "dziedziczone" },
            { "fr_CA", "kanadyjski francuski" },
            { "KP", "Korea P\u00f3\u0142nocna" },
            { "KR", "Korea Po\u0142udniowa" },
            { "Plrd", "fonetyczny Pollard\u2019a" },
            { "fr_CH", "szwajcarski francuski" },
            { "KW", "Kuwejt" },
            { "tpi", "tok pisin" },
            { "KY", "Kajmany" },
            { "KZ", "Kazachstan" },
            { "Cyrl", "cyrylica" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "cyrylica staro-cerkiewno-s\u0142owia\u0144ska" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "dolnoniemiecki" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akadyjski" },
            { "cop", "koptyjski" },
            { "LR", "Liberia" },
            { "esu", "yupik \u015brodkowosyberyjski" },
            { "LS", "Lesotho" },
            { "Phlv", "pahlawi ksi\u0105\u017ckowy" },
            { "LT", "Litwa" },
            { "LU", "Luksemburg" },
            { "LV", "\u0141otwa" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "lady\u0144ski" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Mo\u0142dawia" },
            { "ME", "Czarnog\u00f3ra" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Wyspy Marshalla" },
            { "ale", "aleucki" },
            { "Thai", "tajskie" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Mjanma (Birma)" },
            { "MN", "Mongolia" },
            { "new", "newarski" },
            { "MO", "SRA Makau (Chiny)" },
            { "aln", "alba\u0144ski gegijski" },
            { "MP", "Mariany P\u00f3\u0142nocne" },
            { "MQ", "Martynika" },
            { "MR", "Mauretania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "capiznon" },
            { "MU", "Mauritius" },
            { "alt", "po\u0142udniowoa\u0142tajski" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Meksyk" },
            { "MY", "Malezja" },
            { "MZ", "Mozambik" },
            { "Phli", "inskrypcyjne pahlawi" },
            { "NA", "Namibia" },
            { "NC", "Nowa Kaledonia" },
            { "%%WADEGILE", "latynizacja Wade\u2019a i Gilesa" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "zreformowana ortografia ujednolicona" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "pahlawi psa\u0142terzowy" },
            { "NI", "Nikaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Holandia" },
            { "NO", "Norwegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "cako\u0144ski" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nowa Zelandia" },
            { "rom", "cyga\u0144ski" },
            { "Mero", "meroickie" },
            { "crh", "krymski turecki" },
            { "ang", "staroangielski" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "Xpeo", "staroperskie" },
            { "PA", "Panama" },
            { "csb", "kaszubski" },
            { "en_GB", "brytyjski angielski" },
            { "PE", "Peru" },
            { "ttt", "tacki" },
            { "PF", "Polinezja Francuska" },
            { "PG", "Papua-Nowa Gwinea" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "Polska" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre i Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Portoryko" },
            { "PS", "Terytoria Palesty\u0144skie" },
            { "Bali", "balijskie" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paragwaj" },
            { "tum", "tumbuka" },
            { "Hebr", "hebrajskie" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "standardowy szkocki angielski" },
            { "jam", "jamajski" },
            { "pms", "piemoncki" },
            { "niu", "niue" },
            { "QO", "Oceania inne" },
            { "ext", "estremadurski" },
            { "lez", "lezgijski" },
            { "%%FONUPA", "fonetyczny" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "001", "\u015bwiat" },
            { "002", "Afryka" },
            { "njo", "ao" },
            { "003", "Ameryka P\u00f3\u0142nocna" },
            { "RE", "Reunion" },
            { "005", "Ameryka Po\u0142udniowa" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "lojban" },
            { "pnt", "pontyjski" },
            { "Rjng", "rejang" },
            { "009", "Oceania" },
            { "RO", "Rumunia" },
            { "RS", "Serbia" },
            { "RU", "Rosja" },
            { "RW", "Rwanda" },
            { "Mani", "manichejskie" },
            { "Ugar", "ugaryckie" },
            { "Khar", "charosti" },
            { "SA", "Arabia Saudyjska" },
            { "pon", "ponpejski" },
            { "Mand", "mandejskie" },
            { "SB", "Wyspy Salomona" },
            { "twq", "tasawaq" },
            { "011", "Afryka Zachodnia" },
            { "SC", "Seszele" },
            { "SD", "Sudan" },
            { "013", "Ameryka \u015arodkowa" },
            { "SE", "Szwecja" },
            { "014", "Afryka Wschodnia" },
            { "arc", "aramejski" },
            { "015", "Afryka P\u00f3\u0142nocna" },
            { "SG", "Singapur" },
            { "SH", "Wyspa \u015awi\u0119tej Heleny" },
            { "017", "Afryka \u015arodkowa" },
            { "SI", "S\u0142owenia" },
            { "018", "Afryka Po\u0142udniowa" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "019", "Ameryka" },
            { "SK", "S\u0142owacja" },
            { "Bamu", "bamun" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "arauka\u0144ski" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "SS", "Sudan Po\u0142udniowy" },
            { "ST", "Wyspy \u015awi\u0119tego Tomasza i Ksi\u0105\u017c\u0119ca" },
            { "arq", "algierski arabski" },
            { "SV", "Salwador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "yao" },
            { "SZ", "Suazi" },
            { "arw", "arawak" },
            { "arz", "egipski arabski" },
            { "ary", "maroka\u0144ski arabski" },
            { "yap", "japski" },
            { "rtm", "rotuma\u0144ski" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "Ameryka P\u00f3\u0142nocna (USA, Kanada)" },
            { "TC", "Turks i Caicos" },
            { "yav", "yangben" },
            { "TD", "Czad" },
            { "TF", "Francuskie Terytoria Po\u0142udniowe i Antarktyczne" },
            { "ase", "ameryka\u0144ski j\u0119zyk migowy" },
            { "TG", "Togo" },
            { "TH", "Tajlandia" },
            { "TJ", "Tad\u017cykistan" },
            { "029", "Karaiby" },
            { "TK", "Tokelau" },
            { "TL", "Timor Wschodni" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "dialekt Boontling" },
            { "TN", "Tunezja" },
            { "TO", "Tonga" },
            { "TR", "Turcja" },
            { "TT", "Trynidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajwan" },
            { "ast", "asturyjski" },
            { "rue", "rusi\u0144ski" },
            { "rug", "roviana" },
            { "Orkh", "orcho\u0144skie" },
            { "TZ", "Tanzania" },
            { "nmg", "ngumba" },
            { "Zzzz", "nieznane lub niepoprawne" },
            { "UA", "Ukraina" },
            { "lij", "liguryjski" },
            { "rup", "arumu\u0144ski" },
            { "030", "Azja Wschodnia" },
            { "tyv", "tuwi\u0144ski" },
            { "sw_CD", "kongijski suahili" },
            { "034", "Azja Po\u0142udniowa" },
            { "hai", "haida" },
            { "035", "Azja Po\u0142udniowo-Wschodnia" },
            { "UG", "Uganda" },
            { "hak", "hakka" },
            { "039", "Europa Po\u0142udniowa" },
            { "Sinh", "syngaleskie" },
            { "UM", "Dalekie Wyspy Mniejsze Stan\u00f3w Zjednoczonych" },
            { "liv", "liwski" },
            { "US", "Stany Zjednoczone" },
            { "haw", "hawajski" },
            { "UY", "Urugwaj" },
            { "prg", "pruski" },
            { "UZ", "Uzbekistan" },
            { "tzm", "centralnomaroka\u0144ski tamazight" },
            { "nnh", "ngiemboon" },
            { "VA", "Watykan" },
            { "pro", "staroprowansalski" },
            { "VC", "Saint Vincent i Grenadyny" },
            { "VE", "Wenezuela" },
            { "VG", "Brytyjskie Wyspy Dziewicze" },
            { "VI", "Wyspy Dziewicze Stan\u00f3w Zjednoczonych" },
            { "VN", "Wietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogajski" },
            { "rwk", "rwa" },
            { "non", "staronordyjski" },
            { "053", "Australazja" },
            { "%%AREVMDA", "ormia\u0144ski zachodni" },
            { "054", "Melanezja" },
            { "WF", "Wallis i Futuna" },
            { "057", "Region Mikronezji" },
            { "jgo", "ngombe" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "avk", "kotava" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waraj" },
            { "awa", "awadhi" },
            { "061", "Polinezja" },
            { "XK", "Kosowo" },
            { "Gujr", "gud\u017aarackie" },
            { "Zxxx", "j\u0119zyk bez systemu pisma" },
            { "Olck", "ol chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "batak" },
            { "Blis", "symbole Blissa" },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "lmo", "lombardzki" },
            { "fan", "fang" },
            { "%%ROZAJ", "dialekt regionu Resia" },
            { "fat", "fanti" },
            { "Sgnw", "pismo znakowe" },
            { "YT", "Majotta" },
            { "ZA", "Republika Po\u0142udniowej Afryki" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Nieznany region" },
            { "Runr", "runiczne" },
            { "lol", "mongo" },
            { "nso", "sotho p\u00f3\u0142nocny" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "hif", "hindi fid\u017cyjskie" },
            { "hil", "hiligajnon" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "hetycki" },
            { "dar", "dargwijski" },
            { "dav", "taita" },
            { "Maya", "hieroglify Maj\u00f3w" },
            { "lrc", "luryjski p\u00f3\u0142nocny" },
            { "Copt", "koptyjskie" },
            { "nwc", "newarski klasyczny" },
            { "udm", "udmurcki" },
            { "Khmr", "khmerskie" },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "sah", "jakucki" },
            { "ltg", "\u0142atgalski" },
            { "sam", "samaryta\u0144ski aramejski" },
            { "%%SCOUSE", "dialekt Scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh (berberski)" },
            { "jpr", "judeoperski" },
            { "saz", "saurasztryjski" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "niamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmongijski" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "belud\u017ci" },
            { "den", "slave" },
            { "ban", "balijski" },
            { "uga", "ugarycki" },
            { "fit", "me\u00e4nkieli" },
            { "luy", "luhya" },
            { "bar", "bawarski" },
            { "bas", "basa" },
            { "bax", "bamum" },
            { "jrb", "judeoarabski" },
            { "es_ES", "europejski hiszpa\u0144ski" },
            { "nzi", "nzema" },
            { "sco", "szkocki" },
            { "scn", "sycylijski" },
            { "aa", "afar" },
            { "ab", "abchaski" },
            { "bbc", "batak toba" },
            { "ae", "awestyjski" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amharski" },
            { "an", "arago\u0144ski" },
            { "Arab", "arabskie" },
            { "%%SOLBA", "dialekt Stolvizza/Solbica" },
            { "Jpan", "japo\u0144skie" },
            { "ar", "arabski" },
            { "Hrkt", "katakana lub hiragana" },
            { "as", "asamski" },
            { "sdc", "sassarski" },
            { "Lina", "linearne A" },
            { "av", "awarski" },
            { "Linb", "linearne B" },
            { "sdh", "po\u0142udniowokurdyjski" },
            { "ay", "ajmara" },
            { "az", "azerski" },
            { "%%OSOJS", "dialekt Oseacco/Osojane" },
            { "ba", "baszkirski" },
            { "be", "bia\u0142oruski" },
            { "bg", "bu\u0142garski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tybeta\u0144ski" },
            { "dgr", "dogrib" },
            { "br", "breto\u0144ski" },
            { "bs", "bo\u015bniacki" },
            { "see", "seneka" },
            { "Mymr", "birma\u0144skie" },
            { "sei", "seri" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkupski" },
            { "ca", "katalo\u0144ski" },
            { "ses", "koyraboro senni" },
            { "ce", "czecze\u0144ski" },
            { "ch", "chamorro" },
            { "%%REVISED", "ortografia zreformowana" },
            { "co", "korsyka\u0144ski" },
            { "Orya", metaValue_or },
            { "cr", "kri" },
            { "cs", "czeski" },
            { "cu", "staro-cerkiewno-s\u0142owia\u0144ski" },
            { "yrl", "nhengatu" },
            { "cv", "czuwaski" },
            { "cy", "walijski" },
            { "Yiii", "yi" },
            { "da", "du\u0144ski" },
            { "pt_PT", "europejski portugalski" },
            { "de", "niemiecki" },
            { "bej", "bed\u017ca" },
            { "din", "dinka" },
            { "jut", "jutlandzki" },
            { "Bugi", "bugi\u0144skie" },
            { "bem", "bemba" },
            { "sga", "staroirlandzki" },
            { "dv", "malediwski" },
            { "es_419", "ameryka\u0144ski hiszpa\u0144ski" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "lzh", "chi\u0144ski klasyczny" },
            { "dje", "d\u017cerma" },
            { "sgs", "\u017cmudzki" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "ro_MD", "mo\u0142dawski" },
            { "el", "grecki" },
            { "en", "angielski" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "lazyjski" },
            { "es", "hiszpa\u0144ski" },
            { "et", "esto\u0144ski" },
            { "eu", "baskijski" },
            { "Buhd", "buhid" },
            { "Hang", "hangyl" },
            { "Samr", "samaryta\u0144ski" },
            { "shi", "tashelhiyt" },
            { "hsb", "g\u00f3rno\u0142u\u017cycki" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "perski" },
            { "Hans", "uproszczone" },
            { "Hant", "tradycyjne" },
            { "ff", "fulani" },
            { "shu", "arabski (Czad)" },
            { "hsn", "xiang" },
            { "fi", "fi\u0144ski" },
            { "fj", "fid\u017cijski" },
            { "fon", "fon" },
            { "bgn", "belud\u017ci p\u00f3\u0142nocny" },
            { "yue", "kanto\u0144ski" },
            { "fo", "farerski" },
            { "umb", "umbundu" },
            { "fr", "francuski" },
            { "sid", "sidamo" },
            { "fy", "zachodniofryzyjski" },
            { "ga", "irlandzki" },
            { "gd", "szkocki gaelicki" },
            { "gl", "galicyjski" },
            { "gn", "guarani" },
            { "bho", "bhod\u017apuri" },
            { "und", "nieznany j\u0119zyk" },
            { "gu", "gud\u017aaracki" },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", "hebrajski" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "chorwacki" },
            { "ht", "haita\u0144ski" },
            { "hu", "w\u0119gierski" },
            { "hy", "ormia\u0144ski" },
            { "hz", "herero" },
            { "frc", "cajun" },
            { "%%FONIPA", "fonetyczny mi\u0119dzynarodowy" },
            { "ia", "interlingua" },
            { "id", "indonezyjski" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "syczua\u0144ski" },
            { "frm", "\u015bredniofrancuski" },
            { "ik", "inupiak" },
            { "fro", "starofrancuski" },
            { "frp", "franko-prowansalski" },
            { "io", "ido" },
            { "frs", "fryzyjski wschodni" },
            { "bjn", "banjar" },
            { "frr", "p\u00f3\u0142nocnofryzyjski" },
            { "is", "islandzki" },
            { "it", "w\u0142oski" },
            { "iu", "inuktitut" },
            { "sli", "dolno\u015bl\u0105ski" },
            { "Mlym", metaValue_ml },
            { "ja", "japo\u0144ski" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "bkm", "kom" },
            { "sma", "lapo\u0144ski po\u0142udniowy" },
            { "jv", "jawajski" },
            { "Shaw", "shawa" },
            { "mad", "madurajski" },
            { "smj", "lapo\u0144ski Lule" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "lapo\u0144ski Inari" },
            { "ka", "gruzi\u0144ski" },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu" },
            { "sms", "lapo\u0144ski Skolt" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", "gotyckie" },
            { "ki", "kikuju" },
            { "mas", "masajski" },
            { "kj", "kwanyama" },
            { "kk", "kazachski" },
            { "kl", "grenlandzki" },
            { "km", "khmerski" },
            { "kn", metaValue_kn },
            { "ko", "korea\u0144ski" },
            { "kr", "kanuri" },
            { "ks", "kaszmirski" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", "awestyjskie" },
            { "ku", "kurdyjski" },
            { "kv", "komi" },
            { "kw", "kornijski" },
            { "ky", "kirgiski" },
            { "snk", "soninke" },
            { "la", "\u0142aci\u0144ski" },
            { "lb", "luksemburski" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgijski" },
            { "Tibt", "tybeta\u0144skie" },
            { "ln", "lingala" },
            { "fur", "friulijski" },
            { "lo", "laota\u0144ski" },
            { "lt", "litewski" },
            { "lu", "luba-katanga" },
            { "lv", "\u0142otewski" },
            { "sog", "sogdyjski" },
            { "mg", "malgaski" },
            { "mh", "marshall" },
            { "mi", "maoryjski" },
            { "mk", "macedo\u0144ski" },
            { "ml", metaValue_ml },
            { "mn", "mongolski" },
            { "mr", "marathi" },
            { "ms", "malajski" },
            { "mt", "malta\u0144ski" },
            { "my", "birma\u0144ski" },
            { "Saur", "saurashtra" },
            { "Armn", "ormia\u0144skie" },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "dsb", "dolno\u0142u\u017cycki" },
            { "Armi", "armi" },
            { "na", "nauru" },
            { "nb", "norweski (bokm\u00e5l)" },
            { "nd", "ndebele p\u00f3\u0142nocny" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "niderlandzki" },
            { "nn", "norweski (nynorsk)" },
            { "no", "norweski" },
            { "nr", "ndebele po\u0142udniowy" },
            { "nv", "nawaho" },
            { "kaa", "karaka\u0142packi" },
            { "ny", "njand\u017ca" },
            { "kac", "kaczin" },
            { "kab", "kabylski" },
            { "%%POLYTON", "politoniczny" },
            { "oc", "prowansalski" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "od\u017cibwa" },
            { "mer", "meru" },
            { "om", "oromski" },
            { "kaw", "kawi" },
            { "dtp", "dusun centralny" },
            { "or", metaValue_or },
            { "os", "osetyjski" },
            { "bpy", "bisznuprija-manipuri" },
            { "kbd", "kabardyjski" },
            { "mfe", "kreolski Mauritiusa" },
            { "srn", "sranan tongo" },
            { "pa", "pend\u017cabski" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "dialekt Lipovaz w regionie Resia" },
            { "kbl", "kanembu" },
            { "pi", "palijski" },
            { "bqi", "bachtiarski" },
            { "pl", "polski" },
            { "dum", "\u015bredniowieczny niderlandzki" },
            { "ps", "paszto" },
            { "pt", "portugalski" },
            { "mga", "\u015brednioirlandzki" },
            { "pt_BR", "brazylijski portugalski" },
            { "kcg", "tyap" },
            { "mgh", "makua" },
            { "bra", "brad\u017a" },
            { "Laoo", "laota\u0144skie" },
            { "mgo", "meta" },
            { "ssy", "saho" },
            { "brh", "brahui" },
            { "qu", "keczua" },
            { "zap", "zapotecki" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "stq", "fryzyjski saterlandzki" },
            { "Ethi", "etiopskie" },
            { "rm", "retoroma\u0144ski" },
            { "rn", "rundi" },
            { "ro", "rumu\u0144ski" },
            { "%%SAAHO", "dialekt Saho" },
            { "ru", "rosyjski" },
            { "bss", "akose" },
            { "rw", "kinya-ruanda" },
            { "zbl", "bliss" },
            { "kea", "kreolski Wysp Zielonego Przyl\u0105dka" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "australijski angielski" },
            { "sa", "sanskryt" },
            { "%%UCCOR", "ortografia ujednolicona" },
            { "sc", "sardy\u0144ski" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "lapo\u0144ski p\u00f3\u0142nocny" },
            { "min", "minangkabu" },
            { "sg", "sango" },
            { "sh", "serbsko-chorwacki" },
            { "ken", "kenyang" },
            { "si", "syngaleski" },
            { "sux", "sumeryjski" },
            { "sk", "s\u0142owacki" },
            { "sl", "s\u0142owe\u0144ski" },
            { "sm", "samoa\u0144ski" },
            { "sn", "szona" },
            { "so", "somalijski" },
            { "sq", "alba\u0144ski" },
            { "sr", "serbski" },
            { "ss", "siswati" },
            { "st", "sotho po\u0142udniowy" },
            { "Java", "jawajskie" },
            { "su", "sundajski" },
            { "%%NEDIS", "dialekt Natisone" },
            { "sv", "szwedzki" },
            { "sw", "suahili" },
            { "ibb", "ibibio" },
            { "iba", "ibanag" },
            { "ta", "tamilski" },
            { "142", "Azja" },
            { "bua", "buriacki" },
            { "143", "Azja \u015arodkowa" },
            { "te", metaValue_te },
            { "145", "Azja Zachodnia" },
            { "tg", "tad\u017cycki" },
            { "th", "tajski" },
            { "ti", "tigrinia" },
            { "bug", "bugi\u0144ski" },
            { "kfo", "koro" },
            { "en_CA", "kanadyjski angielski" },
            { "tk", "turkme\u0144ski" },
            { "tl", "tagalski" },
            { "tn", "setswana" },
            { "to", "tonga" },
            { "bum", "bulu" },
            { "dyo", "diola" },
            { "tr", "turecki" },
            { "ts", "tsonga" },
            { "swb", "komoryjski" },
            { "Cakm", "chakma" },
            { "tt", "tatarski" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahita\u0144ski" },
            { "%%BISKE", "dialekt San Giorgio/Bila" },
            { "150", "Europa" },
            { "151", "Europa Wschodnia" },
            { "154", "Europa P\u00f3\u0142nocna" },
            { "dzg", "dazaga" },
            { "155", "Europa Zachodnia" },
            { "ug", "ujgurski" },
            { "Ital", "starow\u0142oskie" },
            { "Kore", "korea\u0144skie" },
            { "kgp", "kaingang" },
            { "Zyyy", "wsp\u00f3lne" },
            { "uk", "ukrai\u0144ski" },
            { "zea", "zelandzki" },
            { "ur", "urdu" },
            { "%%1994", "standardowa ortografia regionu Resia" },
            { "xal", "ka\u0142mucki" },
            { "zen", "zenaga" },
            { "uz", "uzbecki" },
            { "kha", "khasi" },
            { "%%1996", "ortografia niemiecka z 1996 r." },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "vi", "wietnamski" },
            { "kho", "chota\u0144ski" },
            { "khq", "koyra chini" },
            { "%%TARASK", "ortografia taraszkiewicka" },
            { "vo", "volapuk" },
            { "khw", "khowar" },
            { "syc", "syriacki" },
            { "Osma", "osmanya" },
            { "quc", "kicze" },
            { "qug", "chimborazo g\u00f3rski keczua" },
            { "gaa", "ga" },
            { "wa", "walo\u0144ski" },
            { "gag", "gagauski" },
            { "syr", metaValue_syr },
            { "Grek", "greckie" },
            { "gan", "gan" },
            { "kiu", "kirmand\u017cki" },
            { "Lydi", "lidyjskie" },
            { "Xsux", "klinowe sumero-akadyjskie" },
            { "wo", "wolof" },
            { "zgh", "standardowy maroka\u0144ski tamazight" },
            { "ar_001", "wsp\u00f3\u0142czesny arabski" },
            { "Cans", "zunifikowane symbole kanadyjskich autochton\u00f3w" },
            { "gay", "gayo" },
            { "Mong", "mongolskie" },
            { "mnc", "manchu" },
            { "Latf", "\u0142aci\u0144ski - fraktura" },
            { "szl", "\u015bl\u0105ski" },
            { "gba", "gbaya" },
            { "mni", "manipuryjski" },
            { "Latn", "\u0142aci\u0144skie" },
            { "Latg", "\u0142aci\u0144ski - odmiana gaelicka" },
            { "xh", "khosa" },
            { "byn", "blin" },
            { "Lyci", "likijskie" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "zaratusztria\u0144ski dari" },
            { "Moon", "Moon\u2019a" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "siedemnastowieczny francuski" },
            { "Syrc", metaValue_syr },
            { "yi", "jidysz" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "es_MX", "meksyka\u0144ski hiszpa\u0144ski" },
            { "Syrj", "syryjski (odmiana zachodnia)" },
            { "ota", "osma\u0144sko-turecki" },
            { "Syre", "syriacki estrangelo" },
            { "vai", "wai" },
            { "za", "czuang" },
            { "Cari", "karyjskie" },
            { "kln", "kalenjin" },
            { "zh", "chi\u0144ski" },
            { "Bopo", "bopomofo" },
            { "Perm", "staropermskie" },
            { "zu", "zulu" },
            { "%%MONOTON", "monotoniczny" },
            { "Geor", "gruzi\u0144skie" },
            { "kmb", "kimbundu" },
            { "Cham", "czamskie" },
            { "gez", "gyyz" },
            { "mrj", "zachodniomaryjski" },
            { "Syrn", "syryjski (odmiana wschodnia)" },
            { "Tglg", "tagalog" },
            { "Egyd", "egipskie demotyczne" },
            { "Egyh", "egipskie hieratyczne" },
            { "ebu", "embu" },
            { "Egyp", "hieroglify egipskie" },
            { "Geok", "gruzi\u0144skie chucuri" },
            { "zh_Hans", "chi\u0144ski (uproszczony)" },
            { "koi", "komi-permiacki" },
            { "Hung", "starow\u0119gierskie" },
            { "kok", "konkani" },
            { "%%1901", "tradycyjna ortografia niemiecka" },
            { "kos", "kosrae" },
            { "vec", "wenecki" },
            { "zh_Hant", "chi\u0144ski (tradycyjny)" },
            { "Sund", "sundajskie" },
            { "vep", "wepski" },
            { "kpe", "kpelle" },
            { "ilo", "ilokano" },
            { "%%VALENCIA", "walencki" },
            { "Cprt", "cypryjskie" },
            { "%%BAKU1926", "turecki zunifikowany alfabet \u0142aci\u0144ski" },
            { "mua", "mundang" },
            { "mul", "wiele j\u0119zyk\u00f3w" },
            { "cad", "kaddo" },
            { "mus", "creek" },
            { "Glag", "g\u0142agolica" },
            { "gil", "gilberta\u0144ski" },
            { "%%KKCOR", "ortografia wsp\u00f3lna" },
            { "Cher", metaValue_chr },
            { "car", "karibi" },
            { "cay", "kajuga" },
            { "krc", "karaczajsko-ba\u0142karski" },
            { "inh", "inguski" },
            { "krj", "kinaraya" },
            { "kri", "krio" },
            { "krl", "karelski" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "kru", "kurukh" },
            { "ksb", "sambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
