/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.ImagePanel;

public class ImageBlenderPanel
extends ImagePanel {
    private Color background;
    private Image image1;
    private Image image2;
    private float blendAlpha;

    public ImageBlenderPanel(Image image, Image image2) {
        this(image, image2, UIManager.getColor("Panel.background"), 0.0f);
    }

    public ImageBlenderPanel(Image image, Image image2, Color color, float f) {
        super(ImageBlenderPanel.createBlendedImage(image, image2, color, f));
        this.background = color;
        this.blendAlpha = f;
        this.image1 = image;
        this.image2 = image2;
    }

    public void setBlendAlpha(float f) {
        this.setImage(ImageBlenderPanel.createBlendedImage(this.image1, this.image2, this.background, f));
        this.blendAlpha = f;
    }

    private static Image createBlendedImage(Image image, Image image2, Color color, float f) {
        Image image3 = ImageBlenderPanel.loadImage(image);
        Image image4 = ImageBlenderPanel.loadImage(image2);
        int n = Math.max(image3.getWidth(null), image4.getWidth(null));
        int n2 = Math.max(image3.getHeight(null), image4.getHeight(null));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.drawImage(image3, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.drawImage(image4, 0, 0, null);
        return bufferedImage;
    }
}

