/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;

import javax.annotation.Nullable;

@NonNullApi
public class DefaultTaskDestroyablePropertySpec implements TaskDestroyablePropertySpec {
    private final String propertyName;
    private final Object value;

    public DefaultTaskDestroyablePropertySpec(String propertyName, Object value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    @Override
    public String getPropertyName() {
        return propertyName;
    }

    @Nullable
    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return propertyName.compareTo(o.getPropertyName());
    }
}
