/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.BasicURLHandler;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;

public class HttpClientHandler
extends AbstractURLHandler {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private int proxyPort;
    private String proxyHost = null;
    private String proxyUserName = null;
    private String proxyPasswd = null;
    private HttpClientHelper httpClientHelper;
    private static HttpClient httpClient;

    public HttpClientHandler() {
        this.configureProxy();
    }

    private void configureProxy() {
        this.proxyHost = System.getProperty("http.proxyHost");
        if (this.useProxy()) {
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            this.proxyUserName = System.getProperty("http.proxyUser");
            this.proxyPasswd = System.getProperty("http.proxyPassword");
            Message.verbose("proxy configured: host=" + this.proxyHost + " port=" + this.proxyPort + " user=" + this.proxyUserName);
        } else {
            Message.verbose("no proxy configured");
        }
    }

    @Override
    public InputStream openStream(URL uRL) throws IOException {
        GetMethod getMethod = this.doGet(uRL, 0);
        if (!this.checkStatusCode(uRL, (HttpMethodBase)getMethod)) {
            getMethod.releaseConnection();
            throw new IOException("The HTTP response code for " + uRL + " did not indicate a success." + " See log for more detail.");
        }
        Header header = getMethod.getResponseHeader("Content-Encoding");
        return this.getDecodingInputStream(header == null ? null : header.getValue(), getMethod.getResponseBodyAsStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(URL uRL, File file, CopyProgressListener copyProgressListener) throws IOException {
        GetMethod getMethod = this.doGet(uRL, 0);
        try {
            if (!this.checkStatusCode(uRL, (HttpMethodBase)getMethod)) {
                throw new IOException("The HTTP response code for " + uRL + " did not indicate a success." + " See log for more detail.");
            }
            Header header = getMethod.getResponseHeader("Content-Encoding");
            InputStream inputStream = this.getDecodingInputStream(header == null ? null : header.getValue(), getMethod.getResponseBodyAsStream());
            FileUtil.copy(inputStream, file, copyProgressListener);
            file.setLastModified(this.getLastModified((HttpMethodBase)getMethod));
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(File file, URL uRL, CopyProgressListener copyProgressListener) throws IOException {
        HttpClient httpClient = this.getClient();
        PutMethod putMethod = new PutMethod(this.normalizeToString(uRL));
        putMethod.setDoAuthentication(this.useAuthentication(uRL) || this.useProxyAuthentication());
        try {
            putMethod.setRequestEntity((RequestEntity)new FileRequestEntity(file));
            int n = httpClient.executeMethod((HttpMethod)putMethod);
            this.validatePutStatusCode(uRL, n, null);
        }
        finally {
            putMethod.releaseConnection();
        }
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL uRL) {
        return this.getURLInfo(uRL, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLHandler.URLInfo getURLInfo(URL uRL, int n) {
        Object object = null;
        try {
            object = this.getRequestMethod() == 2 ? this.doHead(uRL, n) : this.doGet(uRL, n);
            if (this.checkStatusCode(uRL, (HttpMethodBase)object)) {
                String string = object.getResponseHeader("content-type").getValue();
                String string2 = BasicURLHandler.getCharSetFromContentType(string);
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, this.getResponseContentLength((HttpMethodBase)object), this.getLastModified((HttpMethodBase)object), string2);
                return uRLInfo;
            }
        }
        catch (HttpException httpException) {
            Message.error("HttpClientHandler: " + httpException.getMessage() + ":" + httpException.getReasonCode() + "=" + httpException.getReason() + " url=" + uRL);
        }
        catch (UnknownHostException unknownHostException) {
            Message.warn("Host " + unknownHostException.getMessage() + " not found. url=" + uRL);
            Message.info("You probably access the destination server through a proxy server that is not well configured.");
        }
        catch (IOException iOException) {
            Message.error("HttpClientHandler: " + iOException.getMessage() + " url=" + uRL);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (object != null) {
                object.releaseConnection();
            }
        }
        return UNAVAILABLE;
    }

    private boolean checkStatusCode(URL uRL, HttpMethodBase httpMethodBase) throws IOException {
        int n = httpMethodBase.getStatusCode();
        if (n == 200) {
            return true;
        }
        if ("HEAD".equals(httpMethodBase.getName()) && n == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + n + " url=" + uRL);
        if (n == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(n).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + httpMethodBase.getStatusText() + " url=" + uRL);
        } else if (String.valueOf(n).startsWith("5")) {
            Message.error("SERVER ERROR: " + httpMethodBase.getStatusText() + " url=" + uRL);
        }
        return false;
    }

    private long getLastModified(HttpMethodBase httpMethodBase) {
        Header header = httpMethodBase.getResponseHeader("last-modified");
        if (header != null) {
            String string = header.getValue();
            try {
                return LAST_MODIFIED_FORMAT.parse(string).getTime();
            }
            catch (ParseException parseException) {
                return System.currentTimeMillis();
            }
        }
        return System.currentTimeMillis();
    }

    private long getResponseContentLength(HttpMethodBase httpMethodBase) {
        return this.getHttpClientHelper().getResponseContentLength(httpMethodBase);
    }

    private HttpClientHelper getHttpClientHelper() {
        if (this.httpClientHelper == null) {
            try {
                HttpMethodBase.class.getMethod("getResponseContentLength", new Class[0]);
                this.httpClientHelper = new HttpClientHelper3x();
                Message.verbose("using commons httpclient 3.x helper");
            }
            catch (SecurityException securityException) {
                Message.verbose("unable to get access to getResponseContentLength of commons-httpclient HeadMethod. Please use commons-httpclient 3.0 or use ivy with sufficient security permissions.");
                Message.verbose("exception: " + securityException.getMessage());
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
        }
        return this.httpClientHelper;
    }

    public int getHttpClientMajorVersion() {
        HttpClientHelper httpClientHelper = this.getHttpClientHelper();
        return httpClientHelper.getHttpClientMajorVersion();
    }

    private GetMethod doGet(URL uRL, int n) throws IOException {
        HttpClient httpClient = this.getClient();
        httpClient.setTimeout(n);
        GetMethod getMethod = new GetMethod(this.normalizeToString(uRL));
        getMethod.setDoAuthentication(this.useAuthentication(uRL) || this.useProxyAuthentication());
        getMethod.setRequestHeader("Accept-Encoding", "gzip,deflate");
        httpClient.executeMethod((HttpMethod)getMethod);
        return getMethod;
    }

    private HeadMethod doHead(URL uRL, int n) throws IOException {
        HttpClient httpClient = this.getClient();
        httpClient.setTimeout(n);
        HeadMethod headMethod = new HeadMethod(this.normalizeToString(uRL));
        headMethod.setDoAuthentication(this.useAuthentication(uRL) || this.useProxyAuthentication());
        httpClient.executeMethod((HttpMethod)headMethod);
        return headMethod;
    }

    private HttpClient getClient() {
        if (httpClient == null) {
            final MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
            httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    multiThreadedHttpConnectionManager.shutdown();
                }
            }));
            ArrayList<String> arrayList = new ArrayList<String>(3);
            arrayList.add("Digest");
            arrayList.add("Basic");
            arrayList.add("NTLM");
            httpClient.getParams().setParameter("http.auth.scheme-priority", arrayList);
            if (this.useProxy()) {
                httpClient.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
                if (this.useProxyAuthentication()) {
                    httpClient.getState().setProxyCredentials(new AuthScope(this.proxyHost, this.proxyPort, AuthScope.ANY_REALM), HttpClientHandler.createCredentials(this.proxyUserName, this.proxyPasswd));
                }
            }
            httpClient.getParams().setParameter("http.useragent", (Object)("Apache Ivy/" + Ivy.getIvyVersion()));
            httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)new IvyCredentialsProvider());
        }
        return httpClient;
    }

    private boolean useProxy() {
        return this.proxyHost != null && this.proxyHost.trim().length() > 0;
    }

    private boolean useAuthentication(URL uRL) {
        return CredentialsStore.INSTANCE.hasCredentials(uRL.getHost());
    }

    private boolean useProxyAuthentication() {
        return this.proxyUserName != null && this.proxyUserName.trim().length() > 0;
    }

    private static org.apache.commons.httpclient.Credentials createCredentials(String string, String string2) {
        String string3;
        String string4;
        int n = string.indexOf(92);
        if (n >= 0) {
            string4 = string.substring(n + 1);
            string3 = string.substring(0, n);
        } else {
            string4 = string;
            string3 = System.getProperty("http.auth.ntlm.domain", "");
        }
        return new NTCredentials(string4, string2, HostUtil.getLocalHostName(), string3);
    }

    private static class FileRequestEntity
    implements RequestEntity {
        private File file;

        public FileRequestEntity(File file) {
            this.file = file;
        }

        public long getContentLength() {
            return this.file.length();
        }

        public String getContentType() {
            return null;
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequest(OutputStream outputStream) throws IOException {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            try {
                FileUtil.copy(fileInputStream, outputStream, null, false);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private static class IvyCredentialsProvider
    implements CredentialsProvider {
        private IvyCredentialsProvider() {
        }

        public org.apache.commons.httpclient.Credentials getCredentials(AuthScheme authScheme, String string, int n, boolean bl) throws CredentialsNotAvailableException {
            String string2 = authScheme.getRealm();
            Credentials credentials = CredentialsStore.INSTANCE.getCredentials(string2, string);
            if (credentials != null) {
                return HttpClientHandler.createCredentials(credentials.getUserName(), credentials.getPasswd());
            }
            return null;
        }
    }

    public static interface HttpClientHelper {
        public long getResponseContentLength(HttpMethodBase var1);

        public int getHttpClientMajorVersion();
    }

    private static final class HttpClientHelper2x
    implements HttpClientHelper {
        private static final int VERSION = 2;

        private HttpClientHelper2x() {
        }

        @Override
        public long getResponseContentLength(HttpMethodBase httpMethodBase) {
            Header header = httpMethodBase.getResponseHeader("Content-Length");
            if (header != null) {
                try {
                    return Integer.parseInt(header.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    Message.verbose("Invalid content-length value: " + numberFormatException.getMessage());
                }
            }
            return 0L;
        }

        @Override
        public int getHttpClientMajorVersion() {
            return 2;
        }
    }

    private static final class HttpClientHelper3x
    implements HttpClientHelper {
        private static final int VERSION = 3;

        private HttpClientHelper3x() {
        }

        @Override
        public long getResponseContentLength(HttpMethodBase httpMethodBase) {
            return httpMethodBase.getResponseContentLength();
        }

        @Override
        public int getHttpClientMajorVersion() {
            return 3;
        }
    }
}

