/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceMX;

import com.zeroc.IceInternal.MetricsAdminI;
import com.zeroc.IceInternal.MetricsMap;
import com.zeroc.IceMX.Metrics;
import com.zeroc.IceMX.MetricsHelper;
import com.zeroc.IceMX.Observer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ObserverFactory<T extends Metrics, O extends Observer<T>> {
    private final MetricsAdminI _metrics;
    private final String _name;
    private final Class<T> _class;
    private List<MetricsMap<T>> _maps = new ArrayList<MetricsMap<T>>();
    private volatile boolean _enabled;
    private Runnable _updater;

    public ObserverFactory(MetricsAdminI metrics, String name, Class<T> cl) {
        this._metrics = metrics;
        this._name = name;
        this._class = cl;
        this._metrics.registerMap(name, this._class, () -> this.update());
    }

    public void destroy() {
        if (this._metrics != null) {
            this._metrics.unregisterMap(this._name);
        }
    }

    public O getObserver(MetricsHelper<T> helper, Class<O> cl) {
        return this.getObserver(helper, null, cl);
    }

    public synchronized O getObserver(MetricsHelper<T> helper, Object observer, Class<O> cl) {
        Observer obsv;
        Observer old = null;
        try {
            old = (Observer)observer;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        ArrayList<MetricsMap.Entry> metricsObjects = null;
        for (MetricsMap<T> m : this._maps) {
            MetricsMap.Entry e = m.getMatching(helper, old != null ? old.getEntry(m) : null);
            if (e == null) continue;
            if (metricsObjects == null) {
                metricsObjects = new ArrayList<MetricsMap.Entry>(this._maps.size());
            }
            metricsObjects.add(e);
        }
        if (metricsObjects == null) {
            if (old != null) {
                old.detach();
            }
            return null;
        }
        try {
            obsv = (Observer)cl.newInstance();
        }
        catch (Exception ex) {
            assert (false);
            return null;
        }
        obsv.init(helper, metricsObjects, old);
        return (O)obsv;
    }

    public <S extends Metrics> void registerSubMap(String subMap, Class<S> cl, Field field) {
        this._metrics.registerSubMap(this._name, subMap, cl, field);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Runnable updater;
        ObserverFactory observerFactory = this;
        synchronized (observerFactory) {
            this._maps.clear();
            for (MetricsMap<T> m : this._metrics.getMaps(this._name, this._class)) {
                this._maps.add(m);
            }
            this._enabled = !this._maps.isEmpty();
            updater = this._updater;
        }
        if (updater != null) {
            updater.run();
        }
    }

    public synchronized void setUpdater(Runnable updater) {
        this._updater = updater;
    }
}

