#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: storable-record
version: 0.0.4
id: storable-record-0.0.4-6ipbCeKlvj73kYbaG0fk3X
key: storable-record-0.0.4-6ipbCeKlvj73kYbaG0fk3X
license: BSD3
maintainer: Henning Thielemann <storable@henning-thielemann.de>
stability: Experimental
homepage: http://code.haskell.org/~thielema/storable-record/
synopsis: Elegant definition of Storable instances for records
description:
    With this package
    you can build a Storable instance of a record type
    from Storable instances of its elements in an elegant way.
    It does not do any magic,
    just a bit arithmetic to compute the right offsets,
    that would be otherwise done manually
    or by a preprocessor like C2HS.
    I cannot promise that the generated memory layout
    is compatible with that of a corresponding C struct.
    However, the module generates the smallest layout
    that is possible with respect to the alignment of the record elements.
    If you encounter, that a record does not have a compatible layout,
    we should fix that.
    But also without C compatibility this package is useful
    e.g. in connection with StorableVector.
    .
    We provide Storable instance support for several cases:
    .
    * If you wrap a type in a @newtype@,
    then you can lift its '\''Storable'\'' instance to that @newtype@
    with the module "Foreign.Storable.Newtype".
    This way you do not need the @GeneralizedNewtypeDeriving@ feature of GHC.
    .
    * If you have a type that is an instance of '\''Traversable'\'',
    you can use that feature for implementation of '\''Storable'\'' methods.
    The module "Foreign.Storable.Traversable"
    allows manipulation of the portion of your type,
    that is accessible by '\''Traversable'\'' methods.
    For instance with the type
    @data T a = Cons Int [a]@
    and an according '\''Traversable'\'' implementation,
    you can load and store the elements of the contained list.
    This may be part of a '\''Storable'\'' implementation of the whole type.
    .
    * If you have a record containing elements of various types,
    then you need module "Foreign.Storable.Record".
    .
    Note however that the Storable instances
    defined with this package are quite slow in (up to) GHC-6.12.1.
    I'\''m afraid this is due to incomplete inlining,
    but we have still to investigate the problem.
    .
    For examples see packages @storable-tuple@ and @sample-frame@.
category: Data, Foreign
author: Henning Thielemann <storable@henning-thielemann.de>
exposed: True
indefinite: False
exposed-modules:
    Foreign.Storable.FixedArray Foreign.Storable.Newtype
    Foreign.Storable.Record Foreign.Storable.Traversable
hidden-modules: Foreign.Storable.RecordMinimalSize
                Foreign.Storable.RecordReaderPtr
                Foreign.Storable.TraversableUnequalSizes
abi: 6c65993a5c7e1f7ab227359ee3eefaa5
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/storable-record-0.0.4
library-dirs: /usr/lib/ghc-8.2.2/site-local/storable-record-0.0.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/storable-record-0.0.4
hs-libraries: HSstorable-record-0.0.4-6ipbCeKlvj73kYbaG0fk3X
depends:
    base-4.10.1.0 semigroups-0.18.4-mxkGq2xNPcBC0dj8uuk3q
    transformers-0.5.2.0 utility-ht-0.0.14-1SDJ0BtW7GoAaRrxZT3hIq
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             semigroups-0.18.4-mxkGq2xNPcBC0dj8uuk3q=0f8a4b2bc8ee8ce3a5dab66f0eb14e7c
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             utility-ht-0.0.14-1SDJ0BtW7GoAaRrxZT3hIq=0362a121972f0b40c9fe893b813ad252
haddock-interfaces: /usr/share/doc/haskell-storable-record/html/storable-record.haddock
haddock-html: /usr/share/doc/haskell-storable-record/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

