/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.W32APITypeMapper;
import java.util.List;

public interface Sspi {
    public static final int MAX_TOKEN_SIZE = 12288;
    public static final int SECPKG_CRED_INBOUND = 1;
    public static final int SECPKG_CRED_OUTBOUND = 2;
    public static final int SECURITY_NATIVE_DREP = 16;
    public static final int ISC_REQ_ALLOCATE_MEMORY = 256;
    public static final int ISC_REQ_CONFIDENTIALITY = 16;
    public static final int ISC_REQ_CONNECTION = 2048;
    public static final int ISC_REQ_DELEGATE = 1;
    public static final int ISC_REQ_EXTENDED_ERROR = 16384;
    public static final int ISC_REQ_INTEGRITY = 65536;
    public static final int ISC_REQ_MUTUAL_AUTH = 2;
    public static final int ISC_REQ_REPLAY_DETECT = 4;
    public static final int ISC_REQ_SEQUENCE_DETECT = 8;
    public static final int ISC_REQ_STREAM = 32768;
    public static final int SECBUFFER_VERSION = 0;
    public static final int SECBUFFER_EMPTY = 0;
    public static final int SECBUFFER_DATA = 1;
    public static final int SECBUFFER_TOKEN = 2;
    public static final int SECPKG_ATTR_PACKAGE_INFO = 10;
    public static final int SECPKG_FLAG_INTEGRITY = 1;
    public static final int SECPKG_FLAG_PRIVACY = 2;
    public static final int SECPKG_FLAG_TOKEN_ONLY = 4;
    public static final int SECPKG_FLAG_DATAGRAM = 8;
    public static final int SECPKG_FLAG_CONNECTION = 16;
    public static final int SECPKG_FLAG_MULTI_REQUIRED = 32;
    public static final int SECPKG_FLAG_CLIENT_ONLY = 64;
    public static final int SECPKG_FLAG_EXTENDED_ERROR = 128;
    public static final int SECPKG_FLAG_IMPERSONATION = 256;
    public static final int SECPKG_FLAG_ACCEPT_WIN32_NAME = 512;
    public static final int SECPKG_FLAG_STREAM = 1024;
    public static final int SECPKG_FLAG_NEGOTIABLE = 2048;
    public static final int SECPKG_FLAG_GSS_COMPATIBLE = 4096;
    public static final int SECPKG_FLAG_LOGON = 8192;
    public static final int SECPKG_FLAG_ASCII_BUFFERS = 16384;
    public static final int SECPKG_FLAG_FRAGMENT = 32768;
    public static final int SECPKG_FLAG_MUTUAL_AUTH = 65536;
    public static final int SECPKG_FLAG_DELEGATION = 131072;
    public static final int SECPKG_FLAG_RESTRICTED_TOKENS = 524288;
    public static final int SECPKG_FLAG_NEGO_EXTENDER = 0x100000;
    public static final int SECPKG_FLAG_NEGOTIABLE2 = 0x200000;
    public static final int SECPKG_FLAG_APPCONTAINER_PASSTHROUGH = 0x400000;
    public static final int SECPKG_FLAG_APPCONTAINER_CHECKS = 0x800000;

    public static class SecPkgContext_PackageInfo
    extends Structure {
        public static final List<String> FIELDS = SecPkgContext_PackageInfo.createFieldsOrder("PackageInfo");
        public SecPkgInfo.ByReference PackageInfo;

        public SecPkgContext_PackageInfo() {
            super(W32APITypeMapper.DEFAULT);
        }

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends SecPkgContext_PackageInfo
        implements Structure.ByReference {
        }
    }

    public static class SecPkgInfo
    extends Structure {
        public static final List<String> FIELDS = SecPkgInfo.createFieldsOrder("fCapabilities", "wVersion", "wRPCID", "cbMaxToken", "Name", "Comment");
        public int fCapabilities;
        public short wVersion = 1;
        public short wRPCID;
        public int cbMaxToken;
        public String Name;
        public String Comment;

        public SecPkgInfo() {
            super(W32APITypeMapper.DEFAULT);
        }

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends SecPkgInfo
        implements Structure.ByReference {
        }
    }

    public static class PSecPkgInfo
    extends Structure {
        public static final List<String> FIELDS = PSecPkgInfo.createFieldsOrder("pPkgInfo");
        public SecPkgInfo.ByReference pPkgInfo;

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public SecPkgInfo.ByReference[] toArray(int size) {
            return (SecPkgInfo.ByReference[])this.pPkgInfo.toArray(size);
        }

        public static class ByReference
        extends PSecPkgInfo
        implements Structure.ByReference {
        }
    }

    public static class TimeStamp
    extends SECURITY_INTEGER {
    }

    public static class SECURITY_INTEGER
    extends Structure {
        public static final List<String> FIELDS = SECURITY_INTEGER.createFieldsOrder("dwLower", "dwUpper");
        public int dwLower;
        public int dwUpper;

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }
    }

    public static class SecBufferDesc
    extends Structure {
        public static final List<String> FIELDS = SecBufferDesc.createFieldsOrder("ulVersion", "cBuffers", "pBuffers");
        public int ulVersion = 0;
        public int cBuffers = 1;
        public SecBuffer.ByReference[] pBuffers = new SecBuffer.ByReference[]{new SecBuffer.ByReference()};

        public SecBufferDesc() {
        }

        public SecBufferDesc(int type2, byte[] token) {
            this.pBuffers[0] = new SecBuffer.ByReference(type2, token);
        }

        public SecBufferDesc(int type2, int tokenSize) {
            this.pBuffers[0] = new SecBuffer.ByReference(type2, tokenSize);
        }

        public byte[] getBytes() {
            return this.pBuffers[0].getBytes();
        }

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }
    }

    public static class SecBuffer
    extends Structure {
        public static final List<String> FIELDS = SecBuffer.createFieldsOrder("cbBuffer", "BufferType", "pvBuffer");
        public int cbBuffer;
        public int BufferType = 0;
        public Pointer pvBuffer;

        public SecBuffer() {
        }

        public SecBuffer(int type2, int size) {
            this.cbBuffer = size;
            this.pvBuffer = new Memory(size);
            this.BufferType = type2;
        }

        public SecBuffer(int type2, byte[] token) {
            this.cbBuffer = token.length;
            this.pvBuffer = new Memory(token.length);
            this.pvBuffer.write(0L, token, 0, token.length);
            this.BufferType = type2;
        }

        public byte[] getBytes() {
            return this.pvBuffer == null ? null : this.pvBuffer.getByteArray(0L, this.cbBuffer);
        }

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends SecBuffer
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(int type2, int size) {
                super(type2, size);
            }

            public ByReference(int type2, byte[] token) {
                super(type2, token);
            }
        }
    }

    public static class CtxtHandle
    extends SecHandle {
    }

    public static class CredHandle
    extends SecHandle {
    }

    public static class PSecHandle
    extends Structure {
        public static final List<String> FIELDS = PSecHandle.createFieldsOrder("secHandle");
        public SecHandle.ByReference secHandle;

        public PSecHandle() {
        }

        public PSecHandle(SecHandle h) {
            super(h.getPointer());
            this.read();
        }

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends PSecHandle
        implements Structure.ByReference {
        }
    }

    public static class SecHandle
    extends Structure {
        public static final List<String> FIELDS = SecHandle.createFieldsOrder("dwLower", "dwUpper");
        public Pointer dwLower;
        public Pointer dwUpper;

        public boolean isNull() {
            return this.dwLower == null && this.dwUpper == null;
        }

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends SecHandle
        implements Structure.ByReference {
        }
    }
}

