/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.AbstractDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0014J\"\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u001bH\u0016J \u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020!H\u0016J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010%\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor;", "Lorg/jetbrains/kotlin/js/translate/declaration/AbstractDeclarationVisitor;", "containingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "enumInitializer", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "enumEntries", "", "getEnumEntries", "()Ljava/util/List;", "enumEntryOrdinal", "", "enumInitializerName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getEnumInitializerName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "initializerStatements", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getInitializerStatements", "addFunction", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psi", "Lorg/jetbrains/kotlin/psi/KtElement;", "addInitializerStatement", "statement", "addProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getter", "setter", "generateClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "needCompanionInitializer", "", "getBackingFieldReference", "visitAnonymousInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "visitClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "data", "js.translator"})
public final class DeclarationBodyVisitor
extends AbstractDeclarationVisitor {
    private int enumEntryOrdinal;
    @NotNull
    private final List<JsStatement> initializerStatements;
    @NotNull
    private final List<ClassDescriptor> enumEntries;
    private final ClassDescriptor containingClass;
    private final TranslationContext context;
    private final JsFunction enumInitializer;

    @NotNull
    public final List<JsStatement> getInitializerStatements() {
        return this.initializerStatements;
    }

    @NotNull
    public final List<ClassDescriptor> getEnumEntries() {
        return this.enumEntries;
    }

    @Override
    @Nullable
    public JsName getEnumInitializerName() {
        JsFunction jsFunction = this.enumInitializer;
        return jsFunction != null ? jsFunction.getName() : null;
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super.visitClassOrObject(classOrObject, context);
        if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion() && this.containingClass.getKind() != ClassKind.ENUM_CLASS) {
            DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(context.bindingContext(), classOrObject);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor descriptor2 = (ClassDescriptor)declarationDescriptor;
            JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)context.getNameForObjectInstance(descriptor2).makeRef(), new JsExpression[0]).source(classOrObject)).makeStmt();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsInvocation(context.get\u2026classOrObject).makeStmt()");
            this.addInitializerStatement(jsStatement);
        }
    }

    public final void generateClassOrObject(@NotNull KtPureClassOrObject classOrObject, @NotNull TranslationContext context, boolean needCompanionInitializer) {
        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassTranslator.Companion.translate(classOrObject, context);
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), classOrObject);
        context.export(descriptor2);
        if (needCompanionInitializer) {
            JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)context.getNameForObjectInstance(descriptor2).makeRef(), new JsExpression[0]).source(classOrObject)).makeStmt();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsInvocation(context.get\u2026classOrObject).makeStmt()");
            this.addInitializerStatement(jsStatement);
        }
    }

    public static /* bridge */ /* synthetic */ void generateClassOrObject$default(DeclarationBodyVisitor declarationBodyVisitor, KtPureClassOrObject ktPureClassOrObject, TranslationContext translationContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        declarationBodyVisitor.generateClassOrObject(ktPureClassOrObject, translationContext, bl);
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsFunction jsFunction = this.enumInitializer;
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        JsFunction enumInitializer = jsFunction;
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), enumEntry);
        List<KotlinType> supertypes2 = JsDescriptorUtils.getSupertypesWithoutFakes(descriptor2);
        Collection collection = this.enumEntries;
        collection.add(descriptor2);
        if (enumEntry.getBody() != null || supertypes2.size() > 1) {
            JsName jsName = enumInitializer.getName();
            Intrinsics.checkExpressionValueIsNotNull(jsName, "enumInitializer.name");
            ClassTranslator.Companion.translate(enumEntry, context, jsName, this.enumEntryOrdinal);
            JsBlock jsBlock = enumInitializer.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "enumInitializer.body");
            collection = jsBlock.getStatements();
            JsStatement jsStatement = ((JsExpression)new JsNew(context.getInnerReference(descriptor2)).source(enumEntry)).makeStmt();
            collection.add(jsStatement);
        } else {
            JsFunction enumInstanceFunction;
            boolean bl;
            JsName enumName = context.getInnerNameForDescriptor(descriptor2);
            StringBuilder stringBuilder = new StringBuilder();
            JsName jsName = enumName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "enumName");
            JsName enumInstanceName = JsScope.declareTemporaryName(stringBuilder.append(jsName.getIdent()).append("_instance").toString());
            boolean bl2 = bl = supertypes2.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Simple Enum entry must have one supertype";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            JsExpression jsEnumEntryCreation = ClassInitializerTranslator.generateEnumEntryInstanceCreation(context, enumEntry, this.enumEntryOrdinal);
            context.addDeclarationStatement(JsAstUtils.newVar(enumInstanceName, null));
            JsBlock jsBlock = enumInitializer.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "enumInitializer.body");
            Collection $i$a$1$assert = jsBlock.getStatements();
            Object object = JsAstUtils.assignment(JsAstUtils.pureFqn(enumInstanceName, null), jsEnumEntryCreation).source(enumEntry).makeStmt();
            $i$a$1$assert.add(object);
            JsFunction jsFunction2 = enumInstanceFunction = context.createRootScopedFunction(descriptor2);
            Intrinsics.checkExpressionValueIsNotNull(jsFunction2, "enumInstanceFunction");
            jsFunction2.setSource(enumEntry);
            enumInstanceFunction.setName(context.getNameForObjectInstance(descriptor2));
            context.addDeclarationStatement(enumInstanceFunction.makeStmt());
            JsBlock jsBlock2 = enumInstanceFunction.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock2, "enumInstanceFunction.body");
            object = jsBlock2.getStatements();
            JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)JsAstUtils.pureFqn(enumInitializer.getName(), null), new JsExpression[0]).source(enumEntry)).makeStmt();
            object.add(jsStatement);
            JsBlock jsBlock3 = enumInstanceFunction.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock3, "enumInstanceFunction.body");
            object = jsBlock3.getStatements();
            JsStatement $receiver = jsStatement = new JsReturn(enumInstanceName.makeRef().source(enumEntry));
            ((SourceInfoAwareJsNode)((Object)$receiver)).setSource(enumEntry);
            object.add(jsStatement);
        }
        context.export(descriptor2);
        int n = this.enumEntryOrdinal;
        this.enumEntryOrdinal = n + 1;
    }

    @Override
    public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer expression2, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
    }

    @Override
    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, @NotNull TranslationContext data) {
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(data, "data");
    }

    public final void addInitializerStatement(@NotNull JsStatement statement2) {
        Intrinsics.checkParameterIsNotNull(statement2, "statement");
        this.initializerStatements.add(statement2);
    }

    @Override
    public void addFunction(@NotNull FunctionDescriptor descriptor2, @Nullable JsExpression expression2, @Nullable KtElement psi) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (!DescriptorUtilsKt.hasOrInheritsParametersWithDefaultValue(descriptor2) || !ModalityKt.isOverridableOrOverrides(descriptor2)) {
            if (expression2 != null) {
                this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, this.containingClass, descriptor2, expression2));
            }
        } else {
            JsScope jsScope = this.context.scope();
            StringBuilder stringBuilder = new StringBuilder();
            JsName jsName = this.context.getNameForDescriptor(descriptor2);
            Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescriptor(descriptor)");
            JsName bodyName = jsScope.declareName(stringBuilder.append(jsName.getIdent()).append("$default").toString());
            if (expression2 != null) {
                JsExpression prototypeRef = JsAstUtils.prototypeOf(this.context.getInnerReference(this.containingClass));
                JsNameRef functionRef = new JsNameRef(bodyName, prototypeRef);
                this.context.addDeclarationStatement(JsAstUtils.assignment(functionRef, expression2).makeStmt());
            }
            if (DescriptorUtilsKt.hasOwnParametersWithDefaultValue(descriptor2)) {
                JsStatement jsStatement;
                KotlinType returnType;
                JsExpression jsExpression;
                JsExpression it;
                Collection collection;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                JsInvocation jsInvocation;
                List list2;
                JsExpression callee;
                JsFunction caller = new JsFunction(this.context.getScopeForDescriptor(this.containingClass), new JsBlock(), "");
                KtElement ktElement = psi;
                caller.setSource(ktElement != null ? UtilsKt.getFinalElement(ktElement) : null);
                TranslationContext translationContext = this.context.newDeclaration(descriptor2);
                Intrinsics.checkExpressionValueIsNotNull(translationContext, "context\n                \u2026ewDeclaration(descriptor)");
                List<JsParameter> list3 = caller.getParameters();
                Intrinsics.checkExpressionValueIsNotNull(list3, "caller.parameters");
                TranslationContext callerContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext, descriptor2, list3).innerBlock(caller.getBody());
                JsName callbackName = JsScope.declareTemporaryName("callback$default");
                JsExpression jsExpression2 = callee = new JsNameRef(bodyName, (JsExpression)new JsThisRef()).source(psi);
                List list4 = list2 = CollectionsKt.emptyList();
                JsExpression jsExpression3 = jsExpression2;
                JsInvocation $receiver = jsInvocation = new JsInvocation(jsExpression3, list4);
                $receiver.setSource(psi);
                JsInvocation defaultInvocation = jsInvocation;
                $receiver = new JsInvocation((JsExpression)callbackName.makeRef(), new JsExpression[0]);
                Object $receiver2 = $receiver;
                ((SourceInfoAwareJsNode)$receiver2).setSource(psi);
                JsInvocation callbackInvocation = $receiver;
                JsExpression chosenInvocation = new JsConditional(callbackName.makeRef(), callbackInvocation, defaultInvocation).source(psi);
                $receiver2 = defaultInvocation.getArguments();
                List<JsParameter> list5 = caller.getParameters();
                Intrinsics.checkExpressionValueIsNotNull(list5, "caller.parameters");
                Iterable iterable = $receiver$iv = (Iterable)list5;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    void v7 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v7, "it");
                    jsExpression = v7.getName().makeRef();
                    collection.add(jsExpression);
                }
                $receiver$iv = (List)destination$iv$iv;
                CollectionsKt.addAll($receiver2, $receiver$iv);
                $receiver2 = callbackInvocation.getArguments();
                List<JsExpression> list6 = defaultInvocation.getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list6, "defaultInvocation.arguments");
                $receiver$iv$iv = $receiver$iv = (Iterable)list6;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (JsExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    jsExpression = it.deepCopy();
                    collection.add(jsExpression);
                }
                $receiver$iv = (List)destination$iv$iv;
                CollectionsKt.addAll($receiver2, $receiver$iv);
                caller.getParameters().add(new JsParameter(callbackName));
                JsBlock jsBlock = caller.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsBlock, "caller.body");
                $receiver2 = jsBlock.getStatements();
                List<JsStatement> list7 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, callerContext);
                Intrinsics.checkExpressionValueIsNotNull(list7, "FunctionBodyTranslator.s\u2026escriptor, callerContext)");
                $receiver$iv = list7;
                CollectionsKt.addAll($receiver2, $receiver$iv);
                KotlinType kotlinType = descriptor2.getReturnType();
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                if (KotlinBuiltIns.isUnit(returnType = kotlinType) && !descriptor2.isSuspend()) {
                    JsStatement jsStatement2 = chosenInvocation.makeStmt();
                    jsStatement = jsStatement2;
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "chosenInvocation.makeStmt()");
                } else {
                    jsStatement = new JsReturn(chosenInvocation);
                }
                JsStatement statement2 = jsStatement;
                JsBlock jsBlock2 = caller.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsBlock2, "caller.body");
                iterable = jsBlock2.getStatements();
                iterable.add(statement2);
                this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, this.containingClass, descriptor2, caller));
            }
        }
    }

    @Override
    public void addProperty(@NotNull PropertyDescriptor descriptor2, @NotNull JsExpression getter2, @Nullable JsExpression setter2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(getter2, "getter");
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            JsObjectLiteral literal = new JsObjectLiteral(true);
            Collection collection = literal.getPropertyInitializers();
            JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsStringLiteral("get"), getter2);
            collection.add(jsPropertyInitializer);
            if (setter2 != null) {
                collection = literal.getPropertyInitializers();
                jsPropertyInitializer = new JsPropertyInitializer(new JsStringLiteral("set"), setter2);
                collection.add(jsPropertyInitializer);
            }
            UtilsKt.addAccessorsToPrototype(this.context, this.containingClass, descriptor2, literal);
        }
    }

    @Override
    @NotNull
    public JsExpression getBackingFieldReference(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return new JsNameRef(this.context.getNameForBackingField(descriptor2), (JsExpression)new JsThisRef());
    }

    public DeclarationBodyVisitor(@NotNull ClassDescriptor containingClass, @NotNull TranslationContext context, @Nullable JsFunction enumInitializer) {
        List list2;
        Intrinsics.checkParameterIsNotNull(containingClass, "containingClass");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.containingClass = containingClass;
        this.context = context;
        this.enumInitializer = enumInitializer;
        DeclarationBodyVisitor declarationBodyVisitor = this;
        declarationBodyVisitor.initializerStatements = list2 = (List)new ArrayList();
        declarationBodyVisitor = this;
        declarationBodyVisitor.enumEntries = list2 = (List)new ArrayList();
    }
}

