/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import gnu.inet.imap.IMAPConstants;
import gnu.inet.imap.IMAPResponse;
import gnu.inet.imap.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class IMAPResponseTokenizer
implements IMAPConstants {
    protected InputStream in;
    private byte[] buffer = null;
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_ENCODING = "US-ASCII";
    private static final int STATE_TAG = 0;
    private static final int STATE_COUNT = 1;
    private static final int STATE_ID = 2;
    private static final int STATE_MAYBE_CODE = 3;
    private static final int STATE_CODE = 4;
    private static final int STATE_LITERAL_LENGTH = 5;
    private static final int STATE_LITERAL = 6;
    private static final int STATE_TEXT = 7;
    private static final int STATE_STATUS = 8;

    public IMAPResponseTokenizer(InputStream inputStream) {
        this.in = inputStream;
    }

    byte[] read(boolean bl) throws IOException {
        if (this.buffer != null && !bl && this.buffer.length > 0) {
            return this.buffer;
        }
        int n = this.in.available();
        if (n < 1) {
            n = 4096;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 == 0) {
            n2 = this.in.read(byArray, 0, n);
        }
        if (n2 == -1) {
            return null;
        }
        int n3 = this.buffer == null ? 0 : this.buffer.length;
        byte[] byArray2 = new byte[n3 + n2];
        if (n3 != 0) {
            System.arraycopy(this.buffer, 0, byArray2, 0, n3);
        }
        System.arraycopy(byArray, 0, byArray2, n3, n2);
        this.buffer = byArray2;
        return this.buffer;
    }

    void mark(int n) {
        int n2 = n + 1;
        int n3 = this.buffer.length;
        if (n2 < n3) {
            int n4 = n3 - n2;
            byte[] byArray = new byte[n4];
            System.arraycopy(this.buffer, n2, byArray, 0, n4);
            this.buffer = byArray;
        } else {
            this.buffer = null;
        }
    }

    public IMAPResponse next() throws IOException {
        byte[] byArray = this.read(false);
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        IMAPResponse iMAPResponse = new IMAPResponse();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        int n2 = 0;
        int n3 = -1;
        Stack<Object> stack = new Stack<Object>();
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        block15: for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            switch (n4) {
                case 0: {
                    Object object2;
                    if (i == 0 && by == 42) {
                        iMAPResponse.tag = "*";
                        continue block15;
                    }
                    if (i == 0 && by == 43) {
                        iMAPResponse.tag = "+";
                        continue block15;
                    }
                    if (by == 32) {
                        if (iMAPResponse.tag == null) {
                            object2 = byteArrayOutputStream.toByteArray();
                            iMAPResponse.tag = new String((byte[])object2, DEFAULT_ENCODING);
                        }
                        byteArrayOutputStream.reset();
                        if (iMAPResponse.isContinuation()) {
                            n4 = 7;
                            continue block15;
                        }
                        n4 = 1;
                        continue block15;
                    }
                    byteArrayOutputStream.write(by);
                    continue block15;
                }
                case 1: {
                    Object object3;
                    Object object2;
                    if (by < 48 || by > 57) {
                        n4 = 2;
                    }
                    if (by == 32) {
                        object2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.reset();
                        object3 = new String((byte[])object2, DEFAULT_ENCODING);
                        try {
                            iMAPResponse.count = Integer.parseInt((String)object3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ProtocolException("Expecting number: " + (String)object3);
                        }
                        n4 = 2;
                        continue block15;
                    }
                    byteArrayOutputStream.write(by);
                    continue block15;
                }
                case 2: {
                    Object object2;
                    if (by == 32) {
                        object2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.reset();
                        iMAPResponse.id = new String((byte[])object2, DEFAULT_ENCODING).intern();
                        n4 = 3;
                        continue block15;
                    }
                    if (by == 10) {
                        object2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.reset();
                        iMAPResponse.id = new String((byte[])object2, DEFAULT_ENCODING).intern();
                        n4 = 0;
                        this.mark(i);
                        return iMAPResponse;
                    }
                    if (by == 13) continue block15;
                    byteArrayOutputStream.write(by);
                    continue block15;
                }
                case 3: {
                    Object object2;
                    if (by == 40 || by == 91) {
                        object2 = new ArrayList();
                        iMAPResponse.code = object2;
                        stack.push(object2);
                        n4 = 4;
                        continue block15;
                    }
                    if (iMAPResponse.id == "FETCH") {
                        byteArrayOutputStream.reset();
                        object2 = new byte[]{70, 69, 84, 67, 72, 32};
                        byteArrayOutputStream.write((byte[])object2);
                        byteArrayOutputStream.write(by);
                        n4 = 2;
                        continue block15;
                    }
                    if (iMAPResponse.id == "STATUS") {
                        byteArrayOutputStream.write(by);
                        n4 = 8;
                        continue block15;
                    }
                    byteArrayOutputStream.write(by);
                    n4 = 7;
                    continue block15;
                }
                case 8: {
                    if (by == 32) {
                        iMAPResponse.mailbox = byteArrayOutputStream.toString();
                        byteArrayOutputStream.reset();
                        n4 = 3;
                        continue block15;
                    }
                    byteArrayOutputStream.write(by);
                    continue block15;
                }
                case 4: {
                    Object object;
                    Object object3;
                    Object object2;
                    if (by == 34) {
                        bl = !bl;
                        continue block15;
                    }
                    if (bl) {
                        byteArrayOutputStream.write(by);
                        continue block15;
                    }
                    if (by == 40 || by == 91) {
                        object2 = (List)stack.peek();
                        object3 = new ArrayList();
                        if (byteArrayOutputStream.size() > 0) {
                            object = byteArrayOutputStream.toByteArray();
                            String string = new String((byte[])object, DEFAULT_ENCODING).intern();
                            Pair pair = new Pair(string, (List)object3);
                            object2.add(pair);
                            byteArrayOutputStream.reset();
                        } else {
                            object2.add(object3);
                        }
                        stack.push(object3);
                        continue block15;
                    }
                    if (by == 41 || by == 93) {
                        object2 = (List)stack.pop();
                        if (byteArrayOutputStream.size() <= 0) continue block15;
                        object3 = byteArrayOutputStream.toByteArray();
                        object = new String((byte[])object3, DEFAULT_ENCODING).intern();
                        object2.add(object);
                        byteArrayOutputStream.reset();
                        continue block15;
                    }
                    if (by == 123) {
                        byteArrayOutputStream.reset();
                        n4 = 5;
                        continue block15;
                    }
                    if (by == 32) {
                        if (stack.size() == 0) {
                            n4 = 7;
                            continue block15;
                        }
                        object2 = (List)stack.peek();
                        if (byteArrayOutputStream.size() <= 0) continue block15;
                        object3 = byteArrayOutputStream.toByteArray();
                        object = new String((byte[])object3, DEFAULT_ENCODING).intern();
                        object2.add(object);
                        byteArrayOutputStream.reset();
                        continue block15;
                    }
                    if (by == 10) {
                        n4 = 0;
                        this.mark(i);
                        return iMAPResponse;
                    }
                    if (by == 13) continue block15;
                    byteArrayOutputStream.write(by);
                    continue block15;
                }
                case 5: {
                    Object object3;
                    Object object2;
                    if (by == 125) {
                        object2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.reset();
                        object3 = new String((byte[])object2, DEFAULT_ENCODING);
                        try {
                            n3 = Integer.parseInt((String)object3);
                            continue block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ProtocolException("Expecting number: " + (String)object3);
                        }
                    }
                    if (by == 10) {
                        n4 = 6;
                        byteArrayOutputStream2 = new ByteArrayOutputStream();
                        n2 = 0;
                        continue block15;
                    }
                    if (by == 13) continue block15;
                    byteArrayOutputStream.write(by);
                    continue block15;
                }
                case 6: {
                    Object object3;
                    Object object2;
                    if (n2 >= n3) {
                        object2 = (List)stack.peek();
                        object3 = byteArrayOutputStream2.toByteArray();
                        object2.add(object3);
                        byteArrayOutputStream2 = null;
                        bl2 = false;
                        n4 = 4;
                        continue block15;
                    }
                    byteArrayOutputStream2.write(by);
                    ++n2;
                    continue block15;
                }
                case 7: {
                    Object object2;
                    if (by == 10) {
                        object2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.reset();
                        iMAPResponse.text = new String((byte[])object2, DEFAULT_ENCODING);
                        n4 = 0;
                        this.mark(i);
                        return iMAPResponse;
                    }
                    if (by == 13) continue block15;
                    byteArrayOutputStream.write(by);
                }
            }
        }
        byArray = this.read(true);
        return this.next();
    }
}

