/* libnm-util.vapi generated by vapigen-0.38, do not modify. */

[CCode (cprefix = "NM", gir_namespace = "NetworkManager", gir_version = "1.0", lower_case_cprefix = "nm_")]
namespace NM {
	namespace SettingIP4 {
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_ADDRESSES")]
		public const string CONFIG_ADDRESSES;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_DHCP_CLIENT_ID")]
		public const string CONFIG_DHCP_CLIENT_ID;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_DHCP_HOSTNAME")]
		public const string CONFIG_DHCP_HOSTNAME;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_DHCP_SEND_HOSTNAME")]
		public const string CONFIG_DHCP_SEND_HOSTNAME;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_DHCP_TIMEOUT")]
		public const string CONFIG_DHCP_TIMEOUT;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_DNS")]
		public const string CONFIG_DNS;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_DNS_SEARCH")]
		public const string CONFIG_DNS_SEARCH;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_IGNORE_AUTO_DNS")]
		public const string CONFIG_IGNORE_AUTO_DNS;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_IGNORE_AUTO_ROUTES")]
		public const string CONFIG_IGNORE_AUTO_ROUTES;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_MAY_FAIL")]
		public const string CONFIG_MAY_FAIL;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_METHOD")]
		public const string CONFIG_METHOD;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_AUTO")]
		public const string CONFIG_METHOD_AUTO;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_DISABLED")]
		public const string CONFIG_METHOD_DISABLED;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_LINK_LOCAL")]
		public const string CONFIG_METHOD_LINK_LOCAL;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_MANUAL")]
		public const string CONFIG_METHOD_MANUAL;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_SHARED")]
		public const string CONFIG_METHOD_SHARED;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_NEVER_DEFAULT")]
		public const string CONFIG_NEVER_DEFAULT;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_ROUTES")]
		public const string CONFIG_ROUTES;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_ROUTE_METRIC")]
		public const string CONFIG_ROUTE_METRIC;
		[CCode (cheader_filename = "nm-setting-ip4-config.h", cname = "NM_SETTING_IP4_CONFIG_SETTING_NAME")]
		public const string CONFIG_SETTING_NAME;
	}
	namespace SettingIP6 {
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_ADDRESSES")]
		public const string CONFIG_ADDRESSES;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_DHCP_HOSTNAME")]
		public const string CONFIG_DHCP_HOSTNAME;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_DNS")]
		public const string CONFIG_DNS;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_DNS_SEARCH")]
		public const string CONFIG_DNS_SEARCH;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_IGNORE_AUTO_DNS")]
		public const string CONFIG_IGNORE_AUTO_DNS;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_IGNORE_AUTO_ROUTES")]
		public const string CONFIG_IGNORE_AUTO_ROUTES;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_IP6_PRIVACY")]
		public const string CONFIG_IP6_PRIVACY;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_MAY_FAIL")]
		public const string CONFIG_MAY_FAIL;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_METHOD")]
		public const string CONFIG_METHOD;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_AUTO")]
		public const string CONFIG_METHOD_AUTO;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_DHCP")]
		public const string CONFIG_METHOD_DHCP;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_IGNORE")]
		public const string CONFIG_METHOD_IGNORE;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_LINK_LOCAL")]
		public const string CONFIG_METHOD_LINK_LOCAL;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_MANUAL")]
		public const string CONFIG_METHOD_MANUAL;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_SHARED")]
		public const string CONFIG_METHOD_SHARED;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_NEVER_DEFAULT")]
		public const string CONFIG_NEVER_DEFAULT;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_ROUTES")]
		public const string CONFIG_ROUTES;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_ROUTE_METRIC")]
		public const string CONFIG_ROUTE_METRIC;
		[CCode (cheader_filename = "nm-setting-ip6-config.h", cname = "NM_SETTING_IP6_CONFIG_SETTING_NAME")]
		public const string CONFIG_SETTING_NAME;
	}
	namespace SettingOLPC {
		[CCode (cheader_filename = "nm-setting-olpc-mesh.h", cname = "NM_SETTING_OLPC_MESH_CHANNEL")]
		public const string MESH_CHANNEL;
		[CCode (cheader_filename = "nm-setting-olpc-mesh.h", cname = "NM_SETTING_OLPC_MESH_DHCP_ANYCAST_ADDRESS")]
		public const string MESH_DHCP_ANYCAST_ADDRESS;
		[CCode (cheader_filename = "nm-setting-olpc-mesh.h", cname = "NM_SETTING_OLPC_MESH_SETTING_NAME")]
		public const string MESH_SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-olpc-mesh.h", cname = "NM_SETTING_OLPC_MESH_SSID")]
		public const string MESH_SSID;
	}
	namespace SettingVpn {
		[CCode (cheader_filename = "nm-setting-vpn.h", cname = "NM_SETTING_VPN_DATA")]
		public const string DATA;
		[CCode (cheader_filename = "nm-setting-vpn.h", cname = "NM_SETTING_VPN_PERSISTENT")]
		public const string PERSISTENT;
		[CCode (cheader_filename = "nm-setting-vpn.h", cname = "NM_SETTING_VPN_SECRETS")]
		public const string SECRETS;
		[CCode (cheader_filename = "nm-setting-vpn.h", cname = "NM_SETTING_VPN_SERVICE_TYPE")]
		public const string SERVICE_TYPE;
		[CCode (cheader_filename = "nm-setting-vpn.h", cname = "NM_SETTING_VPN_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-vpn.h", cname = "NM_SETTING_VPN_USER_NAME")]
		public const string USER_NAME;
	}
	namespace Utils {
		[CCode (cheader_filename = "nm-utils.h", cprefix = "NMU_SEC_", type_id = "nm_utils_security_type_get_type ()")]
		[GIR (name = "UtilsSecurityType")]
		public enum SecurityType {
			INVALID,
			NONE,
			STATIC_WEP,
			LEAP,
			DYNAMIC_WEP,
			WPA_PSK,
			WPA_ENTERPRISE,
			WPA2_PSK,
			WPA2_ENTERPRISE
		}
		[CCode (cheader_filename = "nm-utils.h", cname = "NM_UTILS_HWADDR_LEN_MAX")]
		public const int HWADDR_LEN_MAX;
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.8")]
		public static bool ap_mode_security_valid (NM.Utils.SecurityType type, NM.DeviceWifiCapabilities wifi_caps);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.10")]
		public static string bin2hexstr (string bytes, int len, int final_len);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.10")]
		public static bool check_virtual_device_compatibility (GLib.Type virtual_type, GLib.Type other_type);
		[CCode (cheader_filename = "nm-utils.h")]
		public static void deinit ();
		[CCode (cheader_filename = "nm-utils.h")]
		public static unowned string escape_ssid (uint8 ssid, uint32 len);
		[CCode (cheader_filename = "nm-utils.h")]
		public static bool file_is_pkcs12 (string filename);
		[CCode (cheader_filename = "nm-utils.h")]
		public static unowned string file_search_in_paths (string progname, string? try_first, string? paths, GLib.FileTest file_test_flags, NM.UtilsFileSearchInPathsPredicate predicate) throws GLib.Error;
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.HashTable<weak string,weak GLib.Value?> gvalue_hash_dup (GLib.HashTable<void*,void*> hash);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.10")]
		public static int hex2byte (string hex);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.10")]
		public static string hexstr2bin (string hex, size_t len);
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.ByteArray hwaddr_atoba (string asc, int type);
		[CCode (cheader_filename = "nm-utils.h")]
		public static uint8 hwaddr_aton (string asc, int type, void* buffer);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.10")]
		public static uint8 hwaddr_aton_len (string asc, void* buffer, size_t length);
		[CCode (cheader_filename = "nm-utils.h")]
		public static int hwaddr_len (int type);
		[CCode (cheader_filename = "nm-utils.h")]
		public static string hwaddr_ntoa (void* addr, int type);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.10")]
		public static string hwaddr_ntoa_len (void* addr, size_t length);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (deprecated = true)]
		public static int hwaddr_type (int len);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.10")]
		public static bool hwaddr_valid (string asc);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.8")]
		public static bool iface_valid_name (string name);
		[CCode (cheader_filename = "nm-utils.h")]
		public static bool init () throws GLib.Error;
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.SList<NM.IP4Address> ip4_addresses_from_gvalue (GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static void ip4_addresses_to_gvalue (GLib.SList<NM.IP4Address> list, GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static uint32 ip4_get_default_prefix (uint32 ip);
		[CCode (cheader_filename = "nm-utils.h")]
		public static uint32 ip4_netmask_to_prefix (uint32 netmask);
		[CCode (cheader_filename = "nm-utils.h")]
		public static uint32 ip4_prefix_to_netmask (uint32 prefix);
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.SList<NM.IP4Route> ip4_routes_from_gvalue (GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static void ip4_routes_to_gvalue (GLib.SList<NM.IP4Route> list, GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.SList<NM.IP6Address> ip6_addresses_from_gvalue (GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static void ip6_addresses_to_gvalue (GLib.SList<NM.IP6Address> list, GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.SList<NM.IP6Route> ip6_routes_from_gvalue (GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static void ip6_routes_to_gvalue (GLib.SList<NM.IP6Route> list, GLib.Value value);
		[CCode (cheader_filename = "nm-utils.h")]
		public static bool is_empty_ssid (uint8 ssid, int len);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.8")]
		public static bool is_uuid (string str);
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.ByteArray rsa_key_encrypt (GLib.ByteArray data, string? in_password, out string out_password) throws GLib.Error;
		[CCode (cheader_filename = "nm-utils.h")]
		public static GLib.ByteArray rsa_key_encrypt_aes (GLib.ByteArray data, string? in_password, out string out_password) throws GLib.Error;
		[CCode (cheader_filename = "nm-utils.h")]
		public static bool same_ssid (GLib.ByteArray ssid1, GLib.ByteArray ssid2, bool ignore_trailing_null);
		[CCode (cheader_filename = "nm-utils.h")]
		public static bool security_valid (NM.Utils.SecurityType type, NM.DeviceWifiCapabilities wifi_caps, bool have_ap, bool adhoc, NM.80211ApFlags ap_flags, NM.80211ApSecurityFlags ap_wpa, NM.80211ApSecurityFlags ap_rsn);
		[CCode (cheader_filename = "nm-utils.h")]
		public static string ssid_to_utf8 (GLib.ByteArray ssid);
		[CCode (cheader_filename = "nm-utils.h")]
		public static string uuid_generate ();
		[CCode (cheader_filename = "nm-utils.h")]
		public static string uuid_generate_from_string (string s);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.8")]
		public static bool wep_key_valid (string key, NM.WepKeyType wep_type);
		[CCode (cheader_filename = "nm-utils.h")]
		public static uint32 wifi_channel_to_freq (uint32 channel, string band);
		[CCode (cheader_filename = "nm-utils.h")]
		public static uint32 wifi_find_next_channel (uint32 channel, int direction, string band);
		[CCode (cheader_filename = "nm-utils.h")]
		public static uint32 wifi_freq_to_channel (uint32 freq);
		[CCode (cheader_filename = "nm-utils.h")]
		public static bool wifi_is_channel_valid (uint32 channel, string band);
		[CCode (cheader_filename = "nm-utils.h")]
		[Version (since = "0.9.8")]
		public static bool wpa_psk_valid (string psk);
	}
	namespace VPN {
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_DBUS_PLUGIN_INTERFACE")]
		public const string DBUS_PLUGIN_INTERFACE;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_DBUS_PLUGIN_PATH")]
		public const string DBUS_PLUGIN_PATH;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_CAN_PERSIST")]
		public const string PLUGIN_CAN_PERSIST;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_CONFIG_BANNER")]
		public const string PLUGIN_CONFIG_BANNER;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_CONFIG_EXT_GATEWAY")]
		public const string PLUGIN_CONFIG_EXT_GATEWAY;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_CONFIG_HAS_IP4")]
		public const string PLUGIN_CONFIG_HAS_IP4;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_CONFIG_HAS_IP6")]
		public const string PLUGIN_CONFIG_HAS_IP6;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_CONFIG_MTU")]
		public const string PLUGIN_CONFIG_MTU;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_CONFIG_TUNDEV")]
		public const string PLUGIN_CONFIG_TUNDEV;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_ADDRESS")]
		public const string PLUGIN_IP4_CONFIG_ADDRESS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_DNS")]
		public const string PLUGIN_IP4_CONFIG_DNS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_DOMAIN")]
		public const string PLUGIN_IP4_CONFIG_DOMAIN;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_DOMAINS")]
		public const string PLUGIN_IP4_CONFIG_DOMAINS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_INT_GATEWAY")]
		public const string PLUGIN_IP4_CONFIG_INT_GATEWAY;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_MSS")]
		public const string PLUGIN_IP4_CONFIG_MSS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_NBNS")]
		public const string PLUGIN_IP4_CONFIG_NBNS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_NEVER_DEFAULT")]
		public const string PLUGIN_IP4_CONFIG_NEVER_DEFAULT;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_PREFIX")]
		public const string PLUGIN_IP4_CONFIG_PREFIX;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_PTP")]
		public const string PLUGIN_IP4_CONFIG_PTP;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_ROUTES")]
		public const string PLUGIN_IP4_CONFIG_ROUTES;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_ADDRESS")]
		public const string PLUGIN_IP6_CONFIG_ADDRESS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_DNS")]
		public const string PLUGIN_IP6_CONFIG_DNS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_DOMAIN")]
		public const string PLUGIN_IP6_CONFIG_DOMAIN;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_DOMAINS")]
		public const string PLUGIN_IP6_CONFIG_DOMAINS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_INT_GATEWAY")]
		public const string PLUGIN_IP6_CONFIG_INT_GATEWAY;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_MSS")]
		public const string PLUGIN_IP6_CONFIG_MSS;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_NEVER_DEFAULT")]
		public const string PLUGIN_IP6_CONFIG_NEVER_DEFAULT;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_PREFIX")]
		public const string PLUGIN_IP6_CONFIG_PREFIX;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_PTP")]
		public const string PLUGIN_IP6_CONFIG_PTP;
		[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_ROUTES")]
		public const string PLUGIN_IP6_CONFIG_ROUTES;
	}
	[CCode (cheader_filename = "nm-connection.h", type_id = "nm_connection_get_type ()")]
	public class Connection : GLib.Object {
		[CCode (has_construct_function = false)]
		public Connection ();
		public void add_setting (owned NM.Setting setting);
		public void clear_secrets ();
		public void clear_secrets_with_flags (NM.SettingClearSecretsWithFlagsFn func);
		public bool compare (NM.Connection b, NM.SettingCompareFlags flags);
		public static NM.Setting create_setting (string name);
		public bool diff (NM.Connection b, NM.SettingCompareFlags flags, GLib.HashTable<string,GLib.HashTable<void*,void*>> out_settings);
		public void dump ();
		public NM.Connection duplicate ();
		[CCode (cheader_filename = "nm-connection.h")]
		public static GLib.Quark error_quark ();
		public void for_each_setting_value (NM.SettingValueIterFn func);
		[CCode (has_construct_function = false)]
		public Connection.from_hash (GLib.HashTable<string,GLib.HashTable<void*,void*>> hash) throws GLib.Error;
		[Version (since = "0.9.10")]
		public unowned string get_connection_type ();
		public unowned string get_id ();
		[Version (since = "1.0")]
		public unowned string get_interface_name ();
		public unowned string get_path ();
		public unowned NM.Setting get_setting (GLib.Type setting_type);
		public unowned NM.Setting8021x get_setting_802_1x ();
		public unowned NM.SettingAdsl get_setting_adsl ();
		public unowned NM.SettingBluetooth get_setting_bluetooth ();
		public unowned NM.SettingBond get_setting_bond ();
		public unowned NM.SettingBridge get_setting_bridge ();
		public unowned NM.SettingBridgePort get_setting_bridge_port ();
		public unowned NM.Setting get_setting_by_name (string name);
		public unowned NM.SettingCdma get_setting_cdma ();
		public unowned NM.SettingConnection get_setting_connection ();
		[Version (since = "0.9.10")]
		public unowned NM.SettingDcb get_setting_dcb ();
		[Version (since = "0.9.10")]
		public unowned NM.SettingGeneric get_setting_generic ();
		public unowned NM.SettingGsm get_setting_gsm ();
		public unowned NM.SettingInfiniband get_setting_infiniband ();
		public unowned NM.SettingIP4Config get_setting_ip4_config ();
		public unowned NM.SettingIP6Config get_setting_ip6_config ();
		public unowned NM.SettingOlpcMesh get_setting_olpc_mesh ();
		public unowned NM.SettingPPP get_setting_ppp ();
		public unowned NM.SettingPPPOE get_setting_pppoe ();
		public unowned NM.SettingSerial get_setting_serial ();
		[Version (since = "0.9.10")]
		public unowned NM.SettingTeam get_setting_team ();
		[Version (since = "0.9.10")]
		public unowned NM.SettingTeamPort get_setting_team_port ();
		public unowned NM.SettingVlan get_setting_vlan ();
		public unowned NM.SettingVPN get_setting_vpn ();
		public unowned NM.SettingWimax get_setting_wimax ();
		public unowned NM.SettingWired get_setting_wired ();
		public unowned NM.SettingWireless get_setting_wireless ();
		public unowned NM.SettingWirelessSecurity get_setting_wireless_security ();
		public unowned string get_uuid ();
		[Version (since = "0.9.10")]
		public string get_virtual_device_description ();
		public unowned string get_virtual_iface_name ();
		public bool is_type (string type);
		public static GLib.Type lookup_setting_type (string name);
		public static GLib.Type lookup_setting_type_by_quark (GLib.Quark error_quark);
		public unowned string need_secrets (out GLib.GenericArray<weak string> hints);
		[Version (since = "1.0")]
		public bool normalize (GLib.HashTable<string,void*>? parameters, out bool modified) throws GLib.Error;
		public void remove_setting (GLib.Type setting_type);
		public bool replace_settings (GLib.HashTable<string,GLib.HashTable<void*,void*>> new_settings) throws GLib.Error;
		[Version (since = "0.9.10")]
		public bool replace_settings_from_connection (NM.Connection new_connection) throws GLib.Error;
		public void set_path (string path);
		public GLib.HashTable<string,GLib.HashTable<void*,void*>> to_hash (NM.SettingHashFlags flags);
		public bool update_secrets (string setting_name, GLib.HashTable<string,GLib.Value?> secrets) throws GLib.Error;
		public bool verify () throws GLib.Error;
		public string path { get; set construct; }
		[Version (since = "0.9.10")]
		public signal void changed ();
		public signal void secrets_cleared ();
		public virtual signal void secrets_updated (string setting);
	}
	[CCode (cheader_filename = "nm-setting-ip4-config.h", ref_function = "nm_ip4_address_ref", type_id = "nm_ip4_address_get_type ()", unref_function = "nm_ip4_address_unref")]
	[Compact]
	public class IP4Address {
		[CCode (has_construct_function = false)]
		public IP4Address ();
		public bool compare (NM.IP4Address other);
		public NM.IP4Address dup ();
		public uint32 get_address ();
		public uint32 get_gateway ();
		public uint32 get_prefix ();
		public void @ref ();
		public void set_address (uint32 addr);
		public void set_gateway (uint32 gateway);
		public void set_prefix (uint32 prefix);
		public void unref ();
	}
	[CCode (cheader_filename = "nm-setting-ip4-config.h", ref_function = "nm_ip4_route_ref", type_id = "nm_ip4_route_get_type ()", unref_function = "nm_ip4_route_unref")]
	[Compact]
	public class IP4Route {
		[CCode (has_construct_function = false)]
		public IP4Route ();
		public bool compare (NM.IP4Route other);
		public NM.IP4Route dup ();
		public uint32 get_dest ();
		public uint32 get_metric ();
		public uint32 get_next_hop ();
		public uint32 get_prefix ();
		public void @ref ();
		public void set_dest (uint32 dest);
		public void set_metric (uint32 metric);
		public void set_next_hop (uint32 next_hop);
		public void set_prefix (uint32 prefix);
		public void unref ();
	}
	[CCode (cheader_filename = "nm-setting-ip6-config.h", ref_function = "nm_ip6_address_ref", type_id = "nm_ip6_address_get_type ()", unref_function = "nm_ip6_address_unref")]
	[Compact]
	public class IP6Address {
		[CCode (has_construct_function = false)]
		public IP6Address ();
		public bool compare (NM.IP6Address other);
		public NM.IP6Address dup ();
		[CCode (array_length = false)]
		public unowned uint8[] get_address ();
		[CCode (array_length = false)]
		public unowned uint8[] get_gateway ();
		public uint32 get_prefix ();
		public void @ref ();
		public void set_address (void* addr);
		public void set_gateway (void* gateway);
		public void set_prefix (uint32 prefix);
		public void unref ();
	}
	[CCode (cheader_filename = "nm-setting-ip6-config.h", ref_function = "nm_ip6_route_ref", type_id = "nm_ip6_route_get_type ()", unref_function = "nm_ip6_route_unref")]
	[Compact]
	public class IP6Route {
		[CCode (has_construct_function = false)]
		public IP6Route ();
		public bool compare (NM.IP6Route other);
		public NM.IP6Route dup ();
		[CCode (array_length = false)]
		public unowned uint8[] get_dest ();
		public uint32 get_metric ();
		[CCode (array_length = false)]
		public unowned uint8[] get_next_hop ();
		public uint32 get_prefix ();
		public void @ref ();
		public void set_dest (void* dest);
		public void set_metric (uint32 metric);
		public void set_next_hop (void* next_hop);
		public void set_prefix (uint32 prefix);
		public void unref ();
	}
	[CCode (cheader_filename = "nm-setting.h", type_id = "nm_setting_get_type ()")]
	public abstract class Setting : GLib.Object {
		[CCode (cheader_filename = "nm-setting.h", cname = "NM_SETTING_PARAM_FUZZY_IGNORE")]
		public const int FUZZY_IGNORE;
		[CCode (cheader_filename = "nm-setting.h", cname = "NM_SETTING_PARAM_REQUIRED")]
		public const int REQUIRED;
		[CCode (cheader_filename = "nm-setting.h", cname = "NM_SETTING_PARAM_SECRET")]
		public const int SECRET;
		[CCode (cheader_filename = "nm-setting.h", cname = "NM_SETTING_PARAM_SERIALIZE")]
		public const int SERIALIZE;
		[CCode (has_construct_function = false)]
		protected Setting ();
		public void clear_secrets ();
		public void clear_secrets_with_flags (NM.SettingClearSecretsWithFlagsFn func);
		public bool compare (NM.Setting b, NM.SettingCompareFlags flags);
		[NoWrapper]
		public virtual bool compare_property (NM.Setting other, GLib.ParamSpec prop_spec, NM.SettingCompareFlags flags);
		public bool diff (NM.Setting b, NM.SettingCompareFlags flags, bool invert_results, ref GLib.HashTable<string,uint32> results);
		public NM.Setting duplicate ();
		public void enumerate_values (NM.SettingValueIterFn func);
		[CCode (has_construct_function = false)]
		public Setting.from_hash (GLib.Type setting_type, GLib.HashTable<string,GLib.Value?> hash);
		public unowned string get_name ();
		public bool get_secret_flags (string secret_name, NM.SettingSecretFlags out_flags) throws GLib.Error;
		public virtual unowned string get_virtual_iface_name ();
		public virtual GLib.GenericArray<weak string> need_secrets ();
		public bool set_secret_flags (string secret_name, NM.SettingSecretFlags flags) throws GLib.Error;
		public GLib.HashTable<string,GLib.Value?> to_hash (NM.SettingHashFlags flags);
		public string to_string ();
		[NoWrapper]
		public virtual int update_one_secret (string key, GLib.Value value) throws GLib.Error;
		public bool update_secrets (GLib.HashTable<string,GLib.Value?> secrets) throws GLib.Error;
		public bool verify (GLib.SList<NM.Setting> all_settings) throws GLib.Error;
		[NoAccessorMethod]
		public string name { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-8021x.h", lower_case_csuffix = "setting_802_1x", type_id = "nm_setting_802_1x_get_type ()")]
	public class Setting8021x : NM.Setting {
		[CCode (cname = "NM_SETTING_802_1X_ALTSUBJECT_MATCHES")]
		public const string ALTSUBJECT_MATCHES;
		[CCode (cname = "NM_SETTING_802_1X_ANONYMOUS_IDENTITY")]
		public const string ANONYMOUS_IDENTITY;
		[CCode (cname = "NM_SETTING_802_1X_CA_CERT")]
		public const string CA_CERT;
		[CCode (cname = "NM_SETTING_802_1X_CA_PATH")]
		public const string CA_PATH;
		[CCode (cname = "NM_SETTING_802_1X_CLIENT_CERT")]
		public const string CLIENT_CERT;
		[CCode (cname = "NM_SETTING_802_1X_EAP")]
		public const string EAP;
		[CCode (cname = "NM_SETTING_802_1X_IDENTITY")]
		public const string IDENTITY;
		[CCode (cname = "NM_SETTING_802_1X_PAC_FILE")]
		public const string PAC_FILE;
		[CCode (cname = "NM_SETTING_802_1X_PASSWORD")]
		public const string PASSWORD;
		[CCode (cname = "NM_SETTING_802_1X_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cname = "NM_SETTING_802_1X_PASSWORD_RAW")]
		public const string PASSWORD_RAW;
		[CCode (cname = "NM_SETTING_802_1X_PASSWORD_RAW_FLAGS")]
		public const string PASSWORD_RAW_FLAGS;
		[CCode (cname = "NM_SETTING_802_1X_PHASE1_FAST_PROVISIONING")]
		public const string PHASE1_FAST_PROVISIONING;
		[CCode (cname = "NM_SETTING_802_1X_PHASE1_PEAPLABEL")]
		public const string PHASE1_PEAPLABEL;
		[CCode (cname = "NM_SETTING_802_1X_PHASE1_PEAPVER")]
		public const string PHASE1_PEAPVER;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_ALTSUBJECT_MATCHES")]
		public const string PHASE2_ALTSUBJECT_MATCHES;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_AUTH")]
		public const string PHASE2_AUTH;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_AUTHEAP")]
		public const string PHASE2_AUTHEAP;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_CA_CERT")]
		public const string PHASE2_CA_CERT;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_CA_PATH")]
		public const string PHASE2_CA_PATH;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_CLIENT_CERT")]
		public const string PHASE2_CLIENT_CERT;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_PRIVATE_KEY")]
		public const string PHASE2_PRIVATE_KEY;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_PRIVATE_KEY_PASSWORD")]
		public const string PHASE2_PRIVATE_KEY_PASSWORD;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_PRIVATE_KEY_PASSWORD_FLAGS")]
		public const string PHASE2_PRIVATE_KEY_PASSWORD_FLAGS;
		[CCode (cname = "NM_SETTING_802_1X_PHASE2_SUBJECT_MATCH")]
		public const string PHASE2_SUBJECT_MATCH;
		[CCode (cname = "NM_SETTING_802_1X_PIN")]
		public const string PIN;
		[CCode (cname = "NM_SETTING_802_1X_PIN_FLAGS")]
		public const string PIN_FLAGS;
		[CCode (cname = "NM_SETTING_802_1X_PRIVATE_KEY")]
		public const string PRIVATE_KEY;
		[CCode (cname = "NM_SETTING_802_1X_PRIVATE_KEY_PASSWORD")]
		public const string PRIVATE_KEY_PASSWORD;
		[CCode (cname = "NM_SETTING_802_1X_PRIVATE_KEY_PASSWORD_FLAGS")]
		public const string PRIVATE_KEY_PASSWORD_FLAGS;
		[CCode (cname = "NM_SETTING_802_1X_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cname = "NM_SETTING_802_1X_SUBJECT_MATCH")]
		public const string SUBJECT_MATCH;
		[CCode (cname = "NM_SETTING_802_1X_SYSTEM_CA_CERTS")]
		public const string SYSTEM_CA_CERTS;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public Setting8021x ();
		public bool add_altsubject_match (string altsubject_match);
		public bool add_eap_method (string eap);
		public bool add_phase2_altsubject_match (string phase2_altsubject_match);
		public void clear_altsubject_matches ();
		public void clear_eap_methods ();
		public void clear_phase2_altsubject_matches ();
		public unowned string get_altsubject_match (uint32 i);
		public unowned string get_anonymous_identity ();
		public unowned GLib.ByteArray get_ca_cert_blob ();
		public unowned string get_ca_cert_path ();
		public NM.Setting8021xCKScheme get_ca_cert_scheme ();
		public unowned string get_ca_path ();
		public unowned GLib.ByteArray get_client_cert_blob ();
		public unowned string get_client_cert_path ();
		public NM.Setting8021xCKScheme get_client_cert_scheme ();
		public unowned string get_eap_method (uint32 i);
		public unowned string get_identity ();
		public uint32 get_num_altsubject_matches ();
		public uint32 get_num_eap_methods ();
		public uint32 get_num_phase2_altsubject_matches ();
		public unowned string get_pac_file ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned GLib.ByteArray get_password_raw ();
		public NM.SettingSecretFlags get_password_raw_flags ();
		public unowned string get_phase1_fast_provisioning ();
		public unowned string get_phase1_peaplabel ();
		public unowned string get_phase1_peapver ();
		public unowned string get_phase2_altsubject_match (uint32 i);
		public unowned string get_phase2_auth ();
		public unowned string get_phase2_autheap ();
		public unowned GLib.ByteArray get_phase2_ca_cert_blob ();
		public unowned string get_phase2_ca_cert_path ();
		public NM.Setting8021xCKScheme get_phase2_ca_cert_scheme ();
		public unowned string get_phase2_ca_path ();
		public unowned GLib.ByteArray get_phase2_client_cert_blob ();
		public unowned string get_phase2_client_cert_path ();
		public NM.Setting8021xCKScheme get_phase2_client_cert_scheme ();
		public unowned GLib.ByteArray get_phase2_private_key_blob ();
		public NM.Setting8021xCKFormat get_phase2_private_key_format ();
		public unowned string get_phase2_private_key_password ();
		public NM.SettingSecretFlags get_phase2_private_key_password_flags ();
		public unowned string get_phase2_private_key_path ();
		public NM.Setting8021xCKScheme get_phase2_private_key_scheme ();
		public unowned string get_phase2_subject_match ();
		public unowned string get_pin ();
		public NM.SettingSecretFlags get_pin_flags ();
		public unowned GLib.ByteArray get_private_key_blob ();
		public NM.Setting8021xCKFormat get_private_key_format ();
		public unowned string get_private_key_password ();
		public NM.SettingSecretFlags get_private_key_password_flags ();
		public unowned string get_private_key_path ();
		public NM.Setting8021xCKScheme get_private_key_scheme ();
		public unowned string get_subject_match ();
		public bool get_system_ca_certs ();
		public void remove_altsubject_match (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_altsubject_match_by_value (string altsubject_match);
		public void remove_eap_method (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_eap_method_by_value (string eap);
		public void remove_phase2_altsubject_match (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_phase2_altsubject_match_by_value (string phase2_altsubject_match);
		public bool set_ca_cert (string cert_path, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_client_cert (string cert_path, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_phase2_ca_cert (string cert_path, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_phase2_client_cert (string cert_path, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_phase2_private_key (string key_path, string password, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_private_key (string key_path, string password, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		[NoAccessorMethod]
		public string anonymous_identity { owned get; set; }
		[NoAccessorMethod]
		public string ca_path { owned get; set; }
		[NoAccessorMethod]
		public string identity { owned get; set; }
		[NoAccessorMethod]
		public string pac_file { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint password_flags { get; set; }
		[NoAccessorMethod]
		public uint password_raw_flags { get; set; }
		[NoAccessorMethod]
		public string phase1_fast_provisioning { owned get; set; }
		[NoAccessorMethod]
		public string phase1_peaplabel { owned get; set; }
		[NoAccessorMethod]
		public string phase1_peapver { owned get; set; }
		[NoAccessorMethod]
		public string phase2_auth { owned get; set; }
		[NoAccessorMethod]
		public string phase2_autheap { owned get; set; }
		[NoAccessorMethod]
		public string phase2_ca_path { owned get; set; }
		[NoAccessorMethod]
		public string phase2_private_key_password { owned get; set; }
		[NoAccessorMethod]
		public uint phase2_private_key_password_flags { get; set; }
		[NoAccessorMethod]
		public string phase2_subject_match { owned get; set; }
		[NoAccessorMethod]
		public string pin { owned get; set; }
		[NoAccessorMethod]
		public uint pin_flags { get; set; }
		[NoAccessorMethod]
		public string private_key_password { owned get; set; }
		[NoAccessorMethod]
		public uint private_key_password_flags { get; set; }
		[NoAccessorMethod]
		public string subject_match { owned get; set; }
		[NoAccessorMethod]
		public bool system_ca_certs { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-adsl.h", type_id = "nm_setting_adsl_get_type ()")]
	public class SettingAdsl : NM.Setting {
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_ENCAPSULATION")]
		public const string ENCAPSULATION;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_ENCAPSULATION_LLC")]
		public const string ENCAPSULATION_LLC;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_ENCAPSULATION_VCMUX")]
		public const string ENCAPSULATION_VCMUX;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_PROTOCOL")]
		public const string PROTOCOL;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_PROTOCOL_IPOATM")]
		public const string PROTOCOL_IPOATM;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_PROTOCOL_PPPOA")]
		public const string PROTOCOL_PPPOA;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_PROTOCOL_PPPOE")]
		public const string PROTOCOL_PPPOE;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_USERNAME")]
		public const string USERNAME;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_VCI")]
		public const string VCI;
		[CCode (cheader_filename = "nm-setting-adsl.h", cname = "NM_SETTING_ADSL_VPI")]
		public const string VPI;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingAdsl ();
		public unowned string get_encapsulation ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_protocol ();
		public unowned string get_username ();
		public uint32 get_vci ();
		public uint32 get_vpi ();
		[NoAccessorMethod]
		public string encapsulation { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint password_flags { get; set; }
		[NoAccessorMethod]
		public string protocol { owned get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
		[NoAccessorMethod]
		public uint vci { get; set; }
		[NoAccessorMethod]
		public uint vpi { get; set; }
	}
	[CCode (cheader_filename = "nm-setting-bluetooth.h", type_id = "nm_setting_bluetooth_get_type ()")]
	public class SettingBluetooth : NM.Setting {
		[CCode (cheader_filename = "nm-setting-bluetooth.h", cname = "NM_SETTING_BLUETOOTH_BDADDR")]
		public const string BDADDR;
		[CCode (cheader_filename = "nm-setting-bluetooth.h", cname = "NM_SETTING_BLUETOOTH_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-bluetooth.h", cname = "NM_SETTING_BLUETOOTH_TYPE")]
		public const string TYPE;
		[CCode (cheader_filename = "nm-setting-bluetooth.h", cname = "NM_SETTING_BLUETOOTH_TYPE_DUN")]
		public const string TYPE_DUN;
		[CCode (cheader_filename = "nm-setting-bluetooth.h", cname = "NM_SETTING_BLUETOOTH_TYPE_PANU")]
		public const string TYPE_PANU;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingBluetooth ();
		public unowned GLib.ByteArray get_bdaddr ();
		public unowned string get_connection_type ();
		[NoAccessorMethod]
		public string type { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-bond.h", type_id = "nm_setting_bond_get_type ()")]
	public class SettingBond : NM.Setting {
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_INTERFACE_NAME")]
		public const string INTERFACE_NAME;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTIONS")]
		public const string OPTIONS;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_AD_SELECT")]
		public const string OPTION_AD_SELECT;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_ARP_INTERVAL")]
		public const string OPTION_ARP_INTERVAL;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_ARP_IP_TARGET")]
		public const string OPTION_ARP_IP_TARGET;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_ARP_VALIDATE")]
		public const string OPTION_ARP_VALIDATE;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_DOWNDELAY")]
		public const string OPTION_DOWNDELAY;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_FAIL_OVER_MAC")]
		public const string OPTION_FAIL_OVER_MAC;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_LACP_RATE")]
		public const string OPTION_LACP_RATE;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_MIIMON")]
		public const string OPTION_MIIMON;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_MODE")]
		public const string OPTION_MODE;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_PRIMARY")]
		public const string OPTION_PRIMARY;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_PRIMARY_RESELECT")]
		public const string OPTION_PRIMARY_RESELECT;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_RESEND_IGMP")]
		public const string OPTION_RESEND_IGMP;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_UPDELAY")]
		public const string OPTION_UPDELAY;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_USE_CARRIER")]
		public const string OPTION_USE_CARRIER;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_OPTION_XMIT_HASH_POLICY")]
		public const string OPTION_XMIT_HASH_POLICY;
		[CCode (cheader_filename = "nm-setting-bond.h", cname = "NM_SETTING_BOND_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingBond ();
		public bool add_option (string name, string value);
		public unowned string get_interface_name ();
		public uint32 get_num_options ();
		public bool get_option (uint32 idx, out string out_name, out string out_value);
		public unowned string get_option_by_name (string name);
		public unowned string get_option_default (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_valid_options ();
		public bool remove_option (string name);
		[Version (since = "0.9.10")]
		public static bool validate_option (string name, string value);
		[NoAccessorMethod]
		public string interface_name { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-bridge.h", type_id = "nm_setting_bridge_get_type ()")]
	public class SettingBridge : NM.Setting {
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_AGEING_TIME")]
		public const string AGEING_TIME;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_FORWARD_DELAY")]
		public const string FORWARD_DELAY;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_HELLO_TIME")]
		public const string HELLO_TIME;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_INTERFACE_NAME")]
		public const string INTERFACE_NAME;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_MAX_AGE")]
		public const string MAX_AGE;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_PORT_HAIRPIN_MODE")]
		public const string PORT_HAIRPIN_MODE;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_PORT_PATH_COST")]
		public const string PORT_PATH_COST;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_PORT_PRIORITY")]
		public const string PORT_PRIORITY;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_PORT_SETTING_NAME")]
		public const string PORT_SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_PRIORITY")]
		public const string PRIORITY;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-bridge.h", cname = "NM_SETTING_BRIDGE_STP")]
		public const string STP;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "0.9.8")]
		public SettingBridge ();
		[Version (since = "0.9.8")]
		public uint32 get_ageing_time ();
		[Version (since = "0.9.8")]
		public uint16 get_forward_delay ();
		[Version (since = "0.9.8")]
		public uint16 get_hello_time ();
		[Version (since = "0.9.8")]
		public unowned string get_interface_name ();
		[Version (since = "0.9.10")]
		public unowned GLib.ByteArray get_mac_address ();
		[Version (since = "0.9.8")]
		public uint16 get_max_age ();
		[Version (since = "0.9.8")]
		public uint16 get_priority ();
		[Version (since = "0.9.8")]
		public bool get_stp ();
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public uint ageing_time { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public uint forward_delay { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public uint hello_time { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public string interface_name { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public uint max_age { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public uint priority { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public bool stp { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", type_id = "nm_setting_bridge_port_get_type ()")]
	public class SettingBridgePort : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "0.9.8")]
		public SettingBridgePort ();
		[Version (since = "0.9.8")]
		public bool get_hairpin_mode ();
		[Version (since = "0.9.8")]
		public uint16 get_path_cost ();
		[Version (since = "0.9.8")]
		public uint16 get_priority ();
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public bool hairpin_mode { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public uint path_cost { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public uint priority { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-cdma.h", type_id = "nm_setting_cdma_get_type ()")]
	public class SettingCdma : NM.Setting {
		[CCode (cheader_filename = "nm-setting-cdma.h", cname = "NM_SETTING_CDMA_NUMBER")]
		public const string NUMBER;
		[CCode (cheader_filename = "nm-setting-cdma.h", cname = "NM_SETTING_CDMA_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "nm-setting-cdma.h", cname = "NM_SETTING_CDMA_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "nm-setting-cdma.h", cname = "NM_SETTING_CDMA_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-cdma.h", cname = "NM_SETTING_CDMA_USERNAME")]
		public const string USERNAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingCdma ();
		public unowned string get_number ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_username ();
		[NoAccessorMethod]
		public string number { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint password_flags { get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-connection.h", type_id = "nm_setting_connection_get_type ()")]
	public class SettingConnection : NM.Setting {
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT")]
		public const string AUTOCONNECT;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_GATEWAY_PING_TIMEOUT")]
		public const string GATEWAY_PING_TIMEOUT;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_ID")]
		public const string ID;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_INTERFACE_NAME")]
		public const string INTERFACE_NAME;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_MASTER")]
		public const string MASTER;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_PERMISSIONS")]
		public const string PERMISSIONS;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_READ_ONLY")]
		public const string READ_ONLY;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_SECONDARIES")]
		public const string SECONDARIES;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_SLAVE_TYPE")]
		public const string SLAVE_TYPE;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_TIMESTAMP")]
		public const string TIMESTAMP;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_TYPE")]
		public const string TYPE;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_UUID")]
		public const string UUID;
		[CCode (cheader_filename = "nm-setting-connection.h", cname = "NM_SETTING_CONNECTION_ZONE")]
		public const string ZONE;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingConnection ();
		public bool add_permission (string ptype, string pitem, string? detail);
		[Version (since = "0.9.8")]
		public bool add_secondary (string sec_uuid);
		public bool get_autoconnect ();
		public unowned string get_connection_type ();
		[Version (since = "0.9.10")]
		public uint32 get_gateway_ping_timeout ();
		public unowned string get_id ();
		[Version (since = "0.9.10")]
		public unowned string get_interface_name ();
		public unowned string get_master ();
		public uint32 get_num_permissions ();
		[Version (since = "0.9.8")]
		public uint32 get_num_secondaries ();
		public bool get_permission (uint32 idx, string out_ptype, string out_pitem, string out_detail);
		public bool get_read_only ();
		[Version (since = "0.9.8")]
		public unowned string get_secondary (uint32 idx);
		public unowned string get_slave_type ();
		public uint64 get_timestamp ();
		public unowned string get_uuid ();
		public unowned string get_zone ();
		public bool is_slave_type (string type);
		public bool permissions_user_allowed (string uname);
		public void remove_permission (uint32 idx);
		[Version (since = "0.9.10")]
		public bool remove_permission_by_value (string ptype, string pitem, string? detail);
		[Version (since = "0.9.8")]
		public void remove_secondary (uint32 idx);
		[Version (since = "0.9.10")]
		public bool remove_secondary_by_value (string sec_uuid);
		[NoAccessorMethod]
		public bool autoconnect { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public uint gateway_ping_timeout { get; set construct; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public string interface_name { owned get; set; }
		[NoAccessorMethod]
		public string master { owned get; set; }
		[NoAccessorMethod]
		public bool read_only { get; set construct; }
		[NoAccessorMethod]
		public string slave_type { owned get; set; }
		[NoAccessorMethod]
		public uint64 timestamp { get; set construct; }
		[NoAccessorMethod]
		public string type { owned get; set; }
		[NoAccessorMethod]
		public string uuid { owned get; set; }
		[NoAccessorMethod]
		public string zone { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", type_id = "nm_setting_dcb_get_type ()")]
	public class SettingDcb : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "0.9.10")]
		public SettingDcb ();
		[Version (since = "0.9.10")]
		public NM.SettingDcbFlags get_app_fcoe_flags ();
		[Version (since = "0.9.10")]
		public unowned string get_app_fcoe_mode ();
		[Version (since = "0.9.10")]
		public int get_app_fcoe_priority ();
		[Version (since = "0.9.10")]
		public NM.SettingDcbFlags get_app_fip_flags ();
		[Version (since = "0.9.10")]
		public int get_app_fip_priority ();
		[Version (since = "0.9.10")]
		public NM.SettingDcbFlags get_app_iscsi_flags ();
		[Version (since = "0.9.10")]
		public int get_app_iscsi_priority ();
		[Version (since = "0.9.10")]
		public uint get_priority_bandwidth (uint user_priority);
		[Version (since = "0.9.10")]
		public bool get_priority_flow_control (uint user_priority);
		[Version (since = "0.9.10")]
		public NM.SettingDcbFlags get_priority_flow_control_flags ();
		[Version (since = "0.9.10")]
		public uint get_priority_group_bandwidth (uint group_id);
		[Version (since = "0.9.10")]
		public NM.SettingDcbFlags get_priority_group_flags ();
		[Version (since = "0.9.10")]
		public uint get_priority_group_id (uint user_priority);
		[Version (since = "0.9.10")]
		public bool get_priority_strict_bandwidth (uint user_priority);
		[Version (since = "0.9.10")]
		public uint get_priority_traffic_class (uint user_priority);
		[Version (since = "0.9.10")]
		public void set_priority_bandwidth (uint user_priority, uint bandwidth_percent);
		[Version (since = "0.9.10")]
		public void set_priority_flow_control (uint user_priority, bool enabled);
		[Version (since = "0.9.10")]
		public void set_priority_group_bandwidth (uint group_id, uint bandwidth_percent);
		[Version (since = "0.9.10")]
		public void set_priority_group_id (uint user_priority, uint group_id);
		[Version (since = "0.9.10")]
		public void set_priority_strict_bandwidth (uint user_priority, bool strict);
		public void set_priority_traffic_class (uint user_priority, uint traffic_class);
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public uint app_fcoe_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public string app_fcoe_mode { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public int app_fcoe_priority { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public uint app_fip_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public int app_fip_priority { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public uint app_iscsi_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public int app_iscsi_priority { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public uint priority_flow_control_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public uint priority_group_flags { get; set; }
	}
	[CCode (cheader_filename = "nm-setting-generic.h", type_id = "nm_setting_generic_get_type ()")]
	public class SettingGeneric : NM.Setting {
		[CCode (cheader_filename = "nm-setting-generic.h", cname = "NM_SETTING_GENERIC_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "0.9.10")]
		public SettingGeneric ();
	}
	[CCode (cheader_filename = "nm-setting-gsm.h", type_id = "nm_setting_gsm_get_type ()")]
	public class SettingGsm : NM.Setting {
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_ALLOWED_BANDS")]
		public const string ALLOWED_BANDS;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_APN")]
		public const string APN;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_BANDS_MAX")]
		[Version (deprecated = true, deprecated_since = "0.9.10")]
		public const int BANDS_MAX;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_HOME_ONLY")]
		public const string HOME_ONLY;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_NETWORK_ID")]
		public const string NETWORK_ID;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_NETWORK_TYPE")]
		public const string NETWORK_TYPE;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_NUMBER")]
		public const string NUMBER;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_PIN")]
		public const string PIN;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_PIN_FLAGS")]
		public const string PIN_FLAGS;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-gsm.h", cname = "NM_SETTING_GSM_USERNAME")]
		public const string USERNAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingGsm ();
		[Version (deprecated = true, deprecated_since = "0.9.10")]
		public uint32 get_allowed_bands ();
		public unowned string get_apn ();
		public bool get_home_only ();
		public unowned string get_network_id ();
		[Version (deprecated = true, deprecated_since = "0.9.10")]
		public int get_network_type ();
		public unowned string get_number ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_pin ();
		public NM.SettingSecretFlags get_pin_flags ();
		public unowned string get_username ();
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "0.9.10")]
		public uint allowed_bands { get; set construct; }
		[NoAccessorMethod]
		public string apn { owned get; set; }
		[NoAccessorMethod]
		public bool home_only { get; set; }
		[NoAccessorMethod]
		public string network_id { owned get; set; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "0.9.10")]
		public int network_type { get; set construct; }
		[NoAccessorMethod]
		public string number { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint password_flags { get; set; }
		[NoAccessorMethod]
		public string pin { owned get; set; }
		[NoAccessorMethod]
		public uint pin_flags { get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-ip4-config.h", type_id = "nm_setting_ip4_config_get_type ()")]
	public class SettingIP4Config : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingIP4Config ();
		public bool add_address (NM.IP4Address address);
		public bool add_dns (uint32 dns);
		public bool add_dns_search (string dns_search);
		public bool add_route (NM.IP4Route route);
		public void clear_addresses ();
		public void clear_dns ();
		public void clear_dns_searches ();
		public void clear_routes ();
		public NM.IP4Address get_address (uint32 i);
		public unowned string get_dhcp_client_id ();
		public unowned string get_dhcp_hostname ();
		public bool get_dhcp_send_hostname ();
		public int get_dhcp_timeout ();
		public uint32 get_dns (uint32 i);
		public unowned string get_dns_search (uint32 i);
		public bool get_ignore_auto_dns ();
		public bool get_ignore_auto_routes ();
		public bool get_may_fail ();
		public unowned string get_method ();
		public bool get_never_default ();
		public uint32 get_num_addresses ();
		public uint32 get_num_dns ();
		public uint32 get_num_dns_searches ();
		public uint32 get_num_routes ();
		public NM.IP4Route get_route (uint32 i);
		[Version (since = "1.0")]
		public int64 get_route_metric ();
		public void remove_address (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_address_by_value (NM.IP4Address address);
		public void remove_dns (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_dns_by_value (uint32 dns);
		public void remove_dns_search (uint32 i);
		public bool remove_dns_search_by_value (string dns_search);
		public void remove_route (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_route_by_value (NM.IP4Route route);
		[NoAccessorMethod]
		public string dhcp_client_id { owned get; set; }
		[NoAccessorMethod]
		public string dhcp_hostname { owned get; set; }
		[NoAccessorMethod]
		public bool dhcp_send_hostname { get; set construct; }
		[NoAccessorMethod]
		public uint dhcp_timeout { get; set; }
		[NoAccessorMethod]
		public bool ignore_auto_dns { get; set construct; }
		[NoAccessorMethod]
		public bool ignore_auto_routes { get; set construct; }
		[NoAccessorMethod]
		public bool may_fail { get; set construct; }
		[NoAccessorMethod]
		public string method { owned get; set; }
		[NoAccessorMethod]
		public bool never_default { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.0")]
		public int64 route_metric { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-ip6-config.h", type_id = "nm_setting_ip6_config_get_type ()")]
	public class SettingIP6Config : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingIP6Config ();
		public bool add_address (NM.IP6Address address);
		public bool add_dns (void* dns);
		public bool add_dns_search (string dns_search);
		public bool add_route (NM.IP6Route route);
		public void clear_addresses ();
		public void clear_dns ();
		public void clear_dns_searches ();
		public void clear_routes ();
		public NM.IP6Address get_address (uint32 i);
		[Version (since = "0.9.8")]
		public unowned string get_dhcp_hostname ();
		public void* get_dns (uint32 i);
		public unowned string get_dns_search (uint32 i);
		public bool get_ignore_auto_dns ();
		public bool get_ignore_auto_routes ();
		public NM.SettingIP6ConfigPrivacy get_ip6_privacy ();
		public bool get_may_fail ();
		public unowned string get_method ();
		public bool get_never_default ();
		public uint32 get_num_addresses ();
		public uint32 get_num_dns ();
		public uint32 get_num_dns_searches ();
		public uint32 get_num_routes ();
		public NM.IP6Route get_route (uint32 i);
		[Version (since = "1.0")]
		public int64 get_route_metric ();
		public void remove_address (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_address_by_value (NM.IP6Address address);
		public void remove_dns (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_dns_by_value (void* dns);
		public void remove_dns_search (uint32 i);
		public bool remove_dns_search_by_value (string dns_search);
		public void remove_route (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_route_by_value (NM.IP6Route route);
		[NoAccessorMethod]
		[Version (since = "0.9.8")]
		public string dhcp_hostname { owned get; set; }
		[NoAccessorMethod]
		public bool ignore_auto_dns { get; set construct; }
		[NoAccessorMethod]
		public bool ignore_auto_routes { get; set construct; }
		[NoAccessorMethod]
		public int ip6_privacy { get; set construct; }
		[NoAccessorMethod]
		public bool may_fail { get; set construct; }
		[NoAccessorMethod]
		public string method { owned get; set; }
		[NoAccessorMethod]
		public bool never_default { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.0")]
		public int64 route_metric { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-infiniband.h", type_id = "nm_setting_infiniband_get_type ()")]
	public class SettingInfiniband : NM.Setting {
		[CCode (cheader_filename = "nm-setting-infiniband.h", cname = "NM_SETTING_INFINIBAND_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "nm-setting-infiniband.h", cname = "NM_SETTING_INFINIBAND_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "nm-setting-infiniband.h", cname = "NM_SETTING_INFINIBAND_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "nm-setting-infiniband.h", cname = "NM_SETTING_INFINIBAND_P_KEY")]
		public const string P_KEY;
		[CCode (cheader_filename = "nm-setting-infiniband.h", cname = "NM_SETTING_INFINIBAND_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-infiniband.h", cname = "NM_SETTING_INFINIBAND_TRANSPORT_MODE")]
		public const string TRANSPORT_MODE;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingInfiniband ();
		public unowned GLib.ByteArray get_mac_address ();
		public uint32 get_mtu ();
		public int get_p_key ();
		public unowned string get_parent ();
		public unowned string get_transport_mode ();
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public int p_key { get; set construct; }
		[NoAccessorMethod]
		public string parent { owned get; set construct; }
		[NoAccessorMethod]
		public string transport_mode { owned get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-olpc-mesh.h", type_id = "nm_setting_olpc_mesh_get_type ()")]
	public class SettingOlpcMesh : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingOlpcMesh ();
		public uint32 get_channel ();
		public unowned GLib.ByteArray get_dhcp_anycast_address ();
		public unowned GLib.ByteArray get_ssid ();
		[NoAccessorMethod]
		public uint channel { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-ppp.h", type_id = "nm_setting_ppp_get_type ()")]
	public class SettingPPP : NM.Setting {
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_BAUD")]
		public const string BAUD;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_CRTSCTS")]
		public const string CRTSCTS;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_LCP_ECHO_FAILURE")]
		public const string LCP_ECHO_FAILURE;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_LCP_ECHO_INTERVAL")]
		public const string LCP_ECHO_INTERVAL;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_MPPE_STATEFUL")]
		public const string MPPE_STATEFUL;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_MRU")]
		public const string MRU;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_NOAUTH")]
		public const string NOAUTH;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_NOBSDCOMP")]
		public const string NOBSDCOMP;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_NODEFLATE")]
		public const string NODEFLATE;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_NO_VJ_COMP")]
		public const string NO_VJ_COMP;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_REFUSE_CHAP")]
		public const string REFUSE_CHAP;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_REFUSE_EAP")]
		public const string REFUSE_EAP;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_REFUSE_MSCHAP")]
		public const string REFUSE_MSCHAP;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_REFUSE_MSCHAPV2")]
		public const string REFUSE_MSCHAPV2;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_REFUSE_PAP")]
		public const string REFUSE_PAP;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_REQUIRE_MPPE")]
		public const string REQUIRE_MPPE;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_REQUIRE_MPPE_128")]
		public const string REQUIRE_MPPE_128;
		[CCode (cheader_filename = "nm-setting-ppp.h", cname = "NM_SETTING_PPP_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingPPP ();
		public uint32 get_baud ();
		public bool get_crtscts ();
		public uint32 get_lcp_echo_failure ();
		public uint32 get_lcp_echo_interval ();
		public bool get_mppe_stateful ();
		public uint32 get_mru ();
		public uint32 get_mtu ();
		public bool get_no_vj_comp ();
		public bool get_noauth ();
		public bool get_nobsdcomp ();
		public bool get_nodeflate ();
		public bool get_refuse_chap ();
		public bool get_refuse_eap ();
		public bool get_refuse_mschap ();
		public bool get_refuse_mschapv2 ();
		public bool get_refuse_pap ();
		public bool get_require_mppe ();
		public bool get_require_mppe_128 ();
		[NoAccessorMethod]
		public uint baud { get; set construct; }
		[NoAccessorMethod]
		public bool crtscts { get; set construct; }
		[NoAccessorMethod]
		public uint lcp_echo_failure { get; set construct; }
		[NoAccessorMethod]
		public uint lcp_echo_interval { get; set construct; }
		[NoAccessorMethod]
		public bool mppe_stateful { get; set construct; }
		[NoAccessorMethod]
		public uint mru { get; set construct; }
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public bool no_vj_comp { get; set construct; }
		[NoAccessorMethod]
		public bool noauth { get; set construct; }
		[NoAccessorMethod]
		public bool nobsdcomp { get; set construct; }
		[NoAccessorMethod]
		public bool nodeflate { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_chap { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_eap { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_mschap { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_mschapv2 { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_pap { get; set construct; }
		[NoAccessorMethod]
		public bool require_mppe { get; set construct; }
		[NoAccessorMethod]
		public bool require_mppe_128 { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-pppoe.h", type_id = "nm_setting_pppoe_get_type ()")]
	public class SettingPPPOE : NM.Setting {
		[CCode (cheader_filename = "nm-setting-pppoe.h", cname = "NM_SETTING_PPPOE_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "nm-setting-pppoe.h", cname = "NM_SETTING_PPPOE_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "nm-setting-pppoe.h", cname = "NM_SETTING_PPPOE_SERVICE")]
		public const string SERVICE;
		[CCode (cheader_filename = "nm-setting-pppoe.h", cname = "NM_SETTING_PPPOE_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-pppoe.h", cname = "NM_SETTING_PPPOE_USERNAME")]
		public const string USERNAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingPPPOE ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_service ();
		public unowned string get_username ();
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint password_flags { get; set; }
		[NoAccessorMethod]
		public string service { owned get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-serial.h", type_id = "nm_setting_serial_get_type ()")]
	public class SettingSerial : NM.Setting {
		[CCode (cheader_filename = "nm-setting-serial.h", cname = "NM_SETTING_SERIAL_BAUD")]
		public const string BAUD;
		[CCode (cheader_filename = "nm-setting-serial.h", cname = "NM_SETTING_SERIAL_BITS")]
		public const string BITS;
		[CCode (cheader_filename = "nm-setting-serial.h", cname = "NM_SETTING_SERIAL_PARITY")]
		public const string PARITY;
		[CCode (cheader_filename = "nm-setting-serial.h", cname = "NM_SETTING_SERIAL_SEND_DELAY")]
		public const string SEND_DELAY;
		[CCode (cheader_filename = "nm-setting-serial.h", cname = "NM_SETTING_SERIAL_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-serial.h", cname = "NM_SETTING_SERIAL_STOPBITS")]
		public const string STOPBITS;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingSerial ();
		public uint get_baud ();
		public uint get_bits ();
		public char get_parity ();
		public uint64 get_send_delay ();
		public uint get_stopbits ();
		[NoAccessorMethod]
		public uint baud { get; set construct; }
		[NoAccessorMethod]
		public uint bits { get; set construct; }
		[NoAccessorMethod]
		public char parity { get; set construct; }
		[NoAccessorMethod]
		public uint64 send_delay { get; set construct; }
		[NoAccessorMethod]
		public uint stopbits { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-team.h", type_id = "nm_setting_team_get_type ()")]
	public class SettingTeam : NM.Setting {
		[CCode (cheader_filename = "nm-setting-team.h", cname = "NM_SETTING_TEAM_CONFIG")]
		public const string CONFIG;
		[CCode (cheader_filename = "nm-setting-team.h", cname = "NM_SETTING_TEAM_INTERFACE_NAME")]
		public const string INTERFACE_NAME;
		[CCode (cheader_filename = "nm-setting-team.h", cname = "NM_SETTING_TEAM_PORT_CONFIG")]
		public const string PORT_CONFIG;
		[CCode (cheader_filename = "nm-setting-team.h", cname = "NM_SETTING_TEAM_PORT_SETTING_NAME")]
		public const string PORT_SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-team.h", cname = "NM_SETTING_TEAM_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "0.9.10")]
		public SettingTeam ();
		[Version (since = "0.9.10")]
		public unowned string get_config ();
		[Version (since = "0.9.10")]
		public unowned string get_interface_name ();
		[NoAccessorMethod]
		public string config { owned get; set; }
		[NoAccessorMethod]
		public string interface_name { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", type_id = "nm_setting_team_port_get_type ()")]
	public class SettingTeamPort : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "0.9.10")]
		public SettingTeamPort ();
		[Version (since = "0.9.10")]
		public unowned string get_config ();
		[NoAccessorMethod]
		public string config { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-vpn.h", type_id = "nm_setting_vpn_get_type ()")]
	public class SettingVPN : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingVPN ();
		public void add_data_item (string key, string item);
		public void add_secret (string key, string secret);
		public void foreach_data_item (NM.VPNIterFunc func);
		public void foreach_secret (NM.VPNIterFunc func);
		public unowned string get_data_item (string key);
		public uint32 get_num_data_items ();
		public uint32 get_num_secrets ();
		public bool get_persistent ();
		public unowned string get_secret (string key);
		public unowned string get_service_type ();
		public unowned string get_user_name ();
		public bool remove_data_item (string key);
		public bool remove_secret (string key);
		[NoAccessorMethod]
		public bool persistent { get; set; }
		[NoAccessorMethod]
		public string service_type { owned get; set; }
		[NoAccessorMethod]
		public string user_name { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-vlan.h", type_id = "nm_setting_vlan_get_type ()")]
	public class SettingVlan : NM.Setting {
		[CCode (cheader_filename = "nm-setting-vlan.h", cname = "NM_SETTING_VLAN_EGRESS_PRIORITY_MAP")]
		public const string EGRESS_PRIORITY_MAP;
		[CCode (cheader_filename = "nm-setting-vlan.h", cname = "NM_SETTING_VLAN_FLAGS")]
		public const string FLAGS;
		[CCode (cheader_filename = "nm-setting-vlan.h", cname = "NM_SETTING_VLAN_ID")]
		public const string ID;
		[CCode (cheader_filename = "nm-setting-vlan.h", cname = "NM_SETTING_VLAN_INGRESS_PRIORITY_MAP")]
		public const string INGRESS_PRIORITY_MAP;
		[CCode (cheader_filename = "nm-setting-vlan.h", cname = "NM_SETTING_VLAN_INTERFACE_NAME")]
		public const string INTERFACE_NAME;
		[CCode (cheader_filename = "nm-setting-vlan.h", cname = "NM_SETTING_VLAN_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "nm-setting-vlan.h", cname = "NM_SETTING_VLAN_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingVlan ();
		public bool add_priority (NM.VlanPriorityMap map, uint32 from, uint32 to);
		public bool add_priority_str (NM.VlanPriorityMap map, string str);
		public void clear_priorities (NM.VlanPriorityMap map);
		public uint32 get_flags ();
		public uint32 get_id ();
		public unowned string get_interface_name ();
		public int32 get_num_priorities (NM.VlanPriorityMap map);
		public unowned string get_parent ();
		public bool get_priority (NM.VlanPriorityMap map, uint32 idx, out uint32 out_from, out uint32 out_to);
		public void remove_priority (NM.VlanPriorityMap map, uint32 idx);
		[Version (since = "0.9.10")]
		public bool remove_priority_by_value (NM.VlanPriorityMap map, uint32 from, uint32 to);
		[Version (since = "0.9.10")]
		public bool remove_priority_str_by_value (NM.VlanPriorityMap map, string str);
		[NoAccessorMethod]
		public uint flags { get; set construct; }
		[NoAccessorMethod]
		public uint id { get; set construct; }
		[NoAccessorMethod]
		public string interface_name { owned get; set construct; }
		[NoAccessorMethod]
		public string parent { owned get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-wimax.h", type_id = "nm_setting_wimax_get_type ()")]
	public class SettingWimax : NM.Setting {
		[CCode (cheader_filename = "nm-setting-wimax.h", cname = "NM_SETTING_WIMAX_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "nm-setting-wimax.h", cname = "NM_SETTING_WIMAX_NETWORK_NAME")]
		public const string NETWORK_NAME;
		[CCode (cheader_filename = "nm-setting-wimax.h", cname = "NM_SETTING_WIMAX_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public SettingWimax ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned GLib.ByteArray get_mac_address ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned string get_network_name ();
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string network_name { owned get; set; }
	}
	[CCode (cheader_filename = "nm-setting-wired.h", type_id = "nm_setting_wired_get_type ()")]
	public class SettingWired : NM.Setting {
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_AUTO_NEGOTIATE")]
		public const string AUTO_NEGOTIATE;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_CLONED_MAC_ADDRESS")]
		public const string CLONED_MAC_ADDRESS;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_DUPLEX")]
		public const string DUPLEX;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_MAC_ADDRESS_BLACKLIST")]
		public const string MAC_ADDRESS_BLACKLIST;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_PORT")]
		public const string PORT;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_S390_NETTYPE")]
		public const string S390_NETTYPE;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_S390_OPTIONS")]
		public const string S390_OPTIONS;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_S390_SUBCHANNELS")]
		public const string S390_SUBCHANNELS;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-wired.h", cname = "NM_SETTING_WIRED_SPEED")]
		public const string SPEED;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWired ();
		[Version (since = "0.9.10")]
		public bool add_mac_blacklist_item (string mac);
		public bool add_s390_option (string key, string value);
		[Version (since = "0.9.10")]
		public void clear_mac_blacklist_items ();
		public bool get_auto_negotiate ();
		public unowned GLib.ByteArray get_cloned_mac_address ();
		public unowned string get_duplex ();
		public unowned GLib.ByteArray get_mac_address ();
		public unowned GLib.SList<GLib.ByteArray> get_mac_address_blacklist ();
		[Version (since = "0.9.10")]
		public unowned string get_mac_blacklist_item (uint32 idx);
		public uint32 get_mtu ();
		[Version (since = "0.9.10")]
		public uint32 get_num_mac_blacklist_items ();
		public uint32 get_num_s390_options ();
		public unowned string get_port ();
		public unowned string get_s390_nettype ();
		public bool get_s390_option (uint32 idx, out string out_key, out string out_value);
		public unowned string get_s390_option_by_key (string key);
		public unowned GLib.GenericArray<string> get_s390_subchannels ();
		public uint32 get_speed ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.9.10")]
		public unowned string[] get_valid_s390_options ();
		[Version (since = "0.9.10")]
		public void remove_mac_blacklist_item (uint32 idx);
		[Version (since = "0.9.10")]
		public bool remove_mac_blacklist_item_by_value (string mac);
		public bool remove_s390_option (string key);
		[NoAccessorMethod]
		public bool auto_negotiate { get; set construct; }
		[NoAccessorMethod]
		public string duplex { owned get; set; }
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public string port { owned get; set; }
		[NoAccessorMethod]
		public string s390_nettype { owned get; set; }
		[NoAccessorMethod]
		public uint speed { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-wireless.h", type_id = "nm_setting_wireless_get_type ()")]
	public class SettingWireless : NM.Setting {
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_BAND")]
		public const string BAND;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_BSSID")]
		public const string BSSID;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_CHANNEL")]
		public const string CHANNEL;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_CLONED_MAC_ADDRESS")]
		public const string CLONED_MAC_ADDRESS;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_HIDDEN")]
		public const string HIDDEN;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_MAC_ADDRESS_BLACKLIST")]
		public const string MAC_ADDRESS_BLACKLIST;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_MODE_ADHOC")]
		public const string MODE_ADHOC;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_MODE_AP")]
		[Version (since = "0.9.8")]
		public const string MODE_AP;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_MODE_INFRA")]
		public const string MODE_INFRA;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_POWERSAVE")]
		public const string POWERSAVE;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_RATE")]
		public const string RATE;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_SEC")]
		public const string SEC;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_SEEN_BSSIDS")]
		public const string SEEN_BSSIDS;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_SSID")]
		public const string SSID;
		[CCode (cheader_filename = "nm-setting-wireless.h", cname = "NM_SETTING_WIRELESS_TX_POWER")]
		public const string TX_POWER;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWireless ();
		[Version (since = "0.9.10")]
		public bool add_mac_blacklist_item (string mac);
		public bool add_seen_bssid (string bssid);
		public bool ap_security_compatible (NM.SettingWirelessSecurity s_wireless_sec, NM.80211ApFlags ap_flags, NM.80211ApSecurityFlags ap_wpa, NM.80211ApSecurityFlags ap_rsn, NM.80211Mode ap_mode);
		[Version (since = "0.9.10")]
		public void clear_mac_blacklist_items ();
		public unowned string get_band ();
		public unowned GLib.ByteArray get_bssid ();
		public uint32 get_channel ();
		public unowned GLib.ByteArray get_cloned_mac_address ();
		public bool get_hidden ();
		public unowned GLib.ByteArray get_mac_address ();
		public unowned GLib.SList<GLib.ByteArray> get_mac_address_blacklist ();
		[Version (since = "0.9.10")]
		public unowned string get_mac_blacklist_item (uint32 idx);
		public unowned string get_mode ();
		public uint32 get_mtu ();
		[Version (since = "0.9.10")]
		public uint32 get_num_mac_blacklist_items ();
		public uint32 get_num_seen_bssids ();
		[Version (since = "1.2")]
		public uint32 get_powersave ();
		public uint32 get_rate ();
		[Version (deprecated = true, deprecated_since = "0.9.10")]
		public unowned string get_security ();
		public unowned string get_seen_bssid (uint32 i);
		public unowned GLib.ByteArray get_ssid ();
		public uint32 get_tx_power ();
		[Version (since = "0.9.10")]
		public void remove_mac_blacklist_item (uint32 idx);
		[Version (since = "0.9.10")]
		public bool remove_mac_blacklist_item_by_value (string mac);
		[NoAccessorMethod]
		public string band { owned get; set; }
		[NoAccessorMethod]
		public uint channel { get; set construct; }
		[NoAccessorMethod]
		public bool hidden { get; set; }
		[NoAccessorMethod]
		public string mode { owned get; set; }
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint powersave { get; set; }
		[NoAccessorMethod]
		public uint rate { get; set construct; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "0.9.10")]
		public string security { owned get; set; }
		[NoAccessorMethod]
		public uint tx_power { get; set construct; }
	}
	[CCode (cheader_filename = "nm-setting-wireless-security.h", type_id = "nm_setting_wireless_security_get_type ()")]
	public class SettingWirelessSecurity : NM.Setting {
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_AUTH_ALG")]
		public const string AUTH_ALG;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_GROUP")]
		public const string GROUP;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_KEY_MGMT")]
		public const string KEY_MGMT;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_LEAP_PASSWORD")]
		public const string LEAP_PASSWORD;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_LEAP_PASSWORD_FLAGS")]
		public const string LEAP_PASSWORD_FLAGS;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_LEAP_USERNAME")]
		public const string LEAP_USERNAME;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_PAIRWISE")]
		public const string PAIRWISE;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_PROTO")]
		public const string PROTO;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_PSK")]
		public const string PSK;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_PSK_FLAGS")]
		public const string PSK_FLAGS;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY0")]
		public const string WEP_KEY0;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY1")]
		public const string WEP_KEY1;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY2")]
		public const string WEP_KEY2;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY3")]
		public const string WEP_KEY3;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY_FLAGS")]
		public const string WEP_KEY_FLAGS;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY_TYPE")]
		public const string WEP_KEY_TYPE;
		[CCode (cheader_filename = "nm-setting-wireless-security.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_TX_KEYIDX")]
		public const string WEP_TX_KEYIDX;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWirelessSecurity ();
		public bool add_group (string group);
		public bool add_pairwise (string pairwise);
		public bool add_proto (string proto);
		public void clear_groups ();
		public void clear_pairwise ();
		public void clear_protos ();
		public unowned string get_auth_alg ();
		public unowned string get_group (uint32 i);
		public unowned string get_key_mgmt ();
		public unowned string get_leap_password ();
		public NM.SettingSecretFlags get_leap_password_flags ();
		public unowned string get_leap_username ();
		public uint32 get_num_groups ();
		public uint32 get_num_pairwise ();
		public uint32 get_num_protos ();
		public unowned string get_pairwise (uint32 i);
		public unowned string get_proto (uint32 i);
		public unowned string get_psk ();
		public NM.SettingSecretFlags get_psk_flags ();
		public unowned string get_wep_key (uint32 idx);
		public NM.SettingSecretFlags get_wep_key_flags ();
		public NM.WepKeyType get_wep_key_type ();
		public uint32 get_wep_tx_keyidx ();
		public void remove_group (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_group_by_value (string group);
		public void remove_pairwise (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_pairwise_by_value (string pairwise);
		public void remove_proto (uint32 i);
		[Version (since = "0.9.10")]
		public bool remove_proto_by_value (string proto);
		public void set_wep_key (uint32 idx, string key);
		[NoAccessorMethod]
		public string auth_alg { owned get; set; }
		[NoAccessorMethod]
		public string key_mgmt { owned get; set; }
		[NoAccessorMethod]
		public string leap_password { owned get; set; }
		[NoAccessorMethod]
		public uint leap_password_flags { get; set; }
		[NoAccessorMethod]
		public string leap_username { owned get; set; }
		[NoAccessorMethod]
		public string psk { owned get; set; }
		[NoAccessorMethod]
		public uint psk_flags { get; set; }
		[NoAccessorMethod]
		public string wep_key0 { owned get; set; }
		[NoAccessorMethod]
		public string wep_key1 { owned get; set; }
		[NoAccessorMethod]
		public string wep_key2 { owned get; set; }
		[NoAccessorMethod]
		public string wep_key3 { owned get; set; }
		[NoAccessorMethod]
		public uint wep_key_flags { get; set; }
		[NoAccessorMethod]
		public uint wep_key_type { get; set construct; }
		[NoAccessorMethod]
		public uint wep_tx_keyidx { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_802_11_AP_FLAGS_", has_type_id = false)]
	[Flags]
	public enum @80211ApFlags {
		NONE,
		PRIVACY
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_802_11_AP_SEC_", has_type_id = false)]
	[Flags]
	public enum @80211ApSecurityFlags {
		NONE,
		PAIR_WEP40,
		PAIR_WEP104,
		PAIR_TKIP,
		PAIR_CCMP,
		GROUP_WEP40,
		GROUP_WEP104,
		GROUP_TKIP,
		GROUP_CCMP,
		KEY_MGMT_PSK,
		KEY_MGMT_802_1X
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_802_11_MODE_", has_type_id = false)]
	public enum @80211Mode {
		UNKNOWN,
		ADHOC,
		INFRA,
		AP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_ACTIVE_CONNECTION_STATE_", has_type_id = false)]
	public enum ActiveConnectionState {
		UNKNOWN,
		ACTIVATING,
		ACTIVATED,
		DEACTIVATING,
		DEACTIVATED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_BT_CAPABILITY_", has_type_id = false)]
	[Flags]
	public enum BluetoothCapabilities {
		NONE,
		DUN,
		NAP
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", cprefix = "NM_CONNECTIVITY_", has_type_id = false)]
	[Version (since = "0.9.8.6")]
	public enum ConnectivityState {
		UNKNOWN,
		NONE,
		PORTAL,
		LIMITED,
		FULL
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_CAP_", has_type_id = false)]
	[Flags]
	public enum DeviceCapabilities {
		NONE,
		NM_SUPPORTED,
		CARRIER_DETECT,
		IS_SOFTWARE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_MODEM_CAPABILITY_", has_type_id = false)]
	[Flags]
	public enum DeviceModemCapabilities {
		NONE,
		POTS,
		CDMA_EVDO,
		GSM_UMTS,
		LTE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_STATE_", has_type_id = false)]
	public enum DeviceState {
		UNKNOWN,
		UNMANAGED,
		UNAVAILABLE,
		DISCONNECTED,
		PREPARE,
		CONFIG,
		NEED_AUTH,
		IP_CONFIG,
		IP_CHECK,
		SECONDARIES,
		ACTIVATED,
		DEACTIVATING,
		FAILED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_STATE_REASON_", has_type_id = false)]
	public enum DeviceStateReason {
		NONE,
		UNKNOWN,
		NOW_MANAGED,
		NOW_UNMANAGED,
		CONFIG_FAILED,
		IP_CONFIG_UNAVAILABLE,
		IP_CONFIG_EXPIRED,
		NO_SECRETS,
		SUPPLICANT_DISCONNECT,
		SUPPLICANT_CONFIG_FAILED,
		SUPPLICANT_FAILED,
		SUPPLICANT_TIMEOUT,
		PPP_START_FAILED,
		PPP_DISCONNECT,
		PPP_FAILED,
		DHCP_START_FAILED,
		DHCP_ERROR,
		DHCP_FAILED,
		SHARED_START_FAILED,
		SHARED_FAILED,
		AUTOIP_START_FAILED,
		AUTOIP_ERROR,
		AUTOIP_FAILED,
		MODEM_BUSY,
		MODEM_NO_DIAL_TONE,
		MODEM_NO_CARRIER,
		MODEM_DIAL_TIMEOUT,
		MODEM_DIAL_FAILED,
		MODEM_INIT_FAILED,
		GSM_APN_FAILED,
		GSM_REGISTRATION_NOT_SEARCHING,
		GSM_REGISTRATION_DENIED,
		GSM_REGISTRATION_TIMEOUT,
		GSM_REGISTRATION_FAILED,
		GSM_PIN_CHECK_FAILED,
		FIRMWARE_MISSING,
		REMOVED,
		SLEEPING,
		CONNECTION_REMOVED,
		USER_REQUESTED,
		CARRIER,
		CONNECTION_ASSUMED,
		SUPPLICANT_AVAILABLE,
		MODEM_NOT_FOUND,
		BT_FAILED,
		GSM_SIM_NOT_INSERTED,
		GSM_SIM_PIN_REQUIRED,
		GSM_SIM_PUK_REQUIRED,
		GSM_SIM_WRONG,
		INFINIBAND_MODE,
		DEPENDENCY_FAILED,
		BR2684_FAILED,
		MODEM_MANAGER_UNAVAILABLE,
		SSID_NOT_FOUND,
		SECONDARY_CONNECTION_FAILED,
		DCB_FCOE_FAILED,
		TEAMD_CONTROL_FAILED,
		MODEM_FAILED,
		MODEM_AVAILABLE,
		SIM_PIN_INCORRECT,
		NEW_ACTIVATION,
		PARENT_CHANGED,
		PARENT_MANAGED_CHANGED,
		LAST
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_TYPE_", has_type_id = false)]
	public enum DeviceType {
		UNKNOWN,
		ETHERNET,
		WIFI,
		UNUSED1,
		UNUSED2,
		BT,
		OLPC_MESH,
		WIMAX,
		MODEM,
		INFINIBAND,
		BOND,
		VLAN,
		ADSL,
		BRIDGE,
		GENERIC,
		TEAM,
		TUN,
		IP_TUNNEL,
		MACVLAN,
		VXLAN,
		VETH
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_WIFI_DEVICE_CAP_", has_type_id = false)]
	[Flags]
	public enum DeviceWifiCapabilities {
		NONE,
		CIPHER_WEP40,
		CIPHER_WEP104,
		CIPHER_TKIP,
		CIPHER_CCMP,
		WPA,
		RSN,
		AP,
		ADHOC,
		FREQ_VALID,
		FREQ_2GHZ,
		FREQ_5GHZ
	}
	[CCode (cheader_filename = "nm-setting-8021x.h", cprefix = "NM_SETTING_802_1X_CK_FORMAT_", type_id = "nm_setting_802_1x_ck_format_get_type ()")]
	public enum Setting8021xCKFormat {
		UNKNOWN,
		X509,
		RAW_KEY,
		PKCS12
	}
	[CCode (cheader_filename = "nm-setting-8021x.h", cprefix = "NM_SETTING_802_1X_CK_SCHEME_", type_id = "nm_setting_802_1x_ck_scheme_get_type ()")]
	public enum Setting8021xCKScheme {
		UNKNOWN,
		BLOB,
		PATH
	}
	[CCode (cheader_filename = "nm-setting.h", cprefix = "NM_SETTING_COMPARE_FLAG_", type_id = "nm_setting_compare_flags_get_type ()")]
	public enum SettingCompareFlags {
		EXACT,
		FUZZY,
		IGNORE_ID,
		IGNORE_SECRETS,
		IGNORE_AGENT_OWNED_SECRETS,
		IGNORE_NOT_SAVED_SECRETS,
		DIFF_RESULT_WITH_DEFAULT,
		DIFF_RESULT_NO_DEFAULT
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", cprefix = "NM_SETTING_DCB_FLAG_", type_id = "nm_setting_dcb_flags_get_type ()")]
	[Version (since = "0.9.10")]
	public enum SettingDcbFlags {
		NONE,
		ENABLE,
		ADVERTISE,
		WILLING
	}
	[CCode (cheader_filename = "nm-setting.h", cprefix = "NM_SETTING_DIFF_RESULT_", type_id = "nm_setting_diff_result_get_type ()")]
	public enum SettingDiffResult {
		UNKNOWN,
		IN_A,
		IN_B,
		IN_A_DEFAULT,
		IN_B_DEFAULT
	}
	[CCode (cheader_filename = "nm-setting-gsm.h", cprefix = "NM_SETTING_GSM_BAND_", type_id = "nm_setting_gsm_network_band_get_type ()")]
	[Version (deprecated = true, deprecated_since = "0.9.10")]
	public enum SettingGsmNetworkBand {
		UNKNOWN,
		ANY,
		EGSM,
		DCS,
		PCS,
		G850,
		U2100,
		U1800,
		U17IV,
		U800,
		U850,
		U900,
		U17IX,
		U1900,
		U2600
	}
	[CCode (cheader_filename = "nm-setting-gsm.h", cprefix = "NM_SETTING_GSM_NETWORK_TYPE_", type_id = "nm_setting_gsm_network_type_get_type ()")]
	[Version (deprecated = true, deprecated_since = "0.9.10")]
	public enum SettingGsmNetworkType {
		ANY,
		UMTS_HSPA,
		GPRS_EDGE,
		PREFER_UMTS_HSPA,
		PREFER_GPRS_EDGE,
		PREFER_4G,
		@4G
	}
	[CCode (cheader_filename = "nm-setting.h", cprefix = "NM_SETTING_HASH_FLAG_", type_id = "nm_setting_hash_flags_get_type ()")]
	public enum SettingHashFlags {
		ALL,
		NO_SECRETS,
		ONLY_SECRETS
	}
	[CCode (cheader_filename = "nm-setting-ip6-config.h", cprefix = "NM_SETTING_IP6_CONFIG_PRIVACY_", type_id = "nm_setting_ip6_config_privacy_get_type ()")]
	public enum SettingIP6ConfigPrivacy {
		UNKNOWN,
		DISABLED,
		PREFER_PUBLIC_ADDR,
		PREFER_TEMP_ADDR
	}
	[CCode (cheader_filename = "nm-setting.h", cprefix = "NM_SETTING_SECRET_FLAG_", type_id = "nm_setting_secret_flags_get_type ()")]
	public enum SettingSecretFlags {
		NONE,
		AGENT_OWNED,
		NOT_SAVED,
		NOT_REQUIRED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_STATE_", has_type_id = false)]
	public enum State {
		UNKNOWN,
		ASLEEP,
		DISCONNECTED,
		DISCONNECTING,
		CONNECTING,
		CONNECTED_LOCAL,
		CONNECTED_SITE,
		CONNECTED_GLOBAL
	}
	[CCode (cheader_filename = "NetworkManagerVPN.h", cprefix = "NM_VPN_CONNECTION_STATE_", has_type_id = false)]
	public enum VPNConnectionState {
		UNKNOWN,
		PREPARE,
		NEED_AUTH,
		CONNECT,
		IP_CONFIG_GET,
		ACTIVATED,
		FAILED,
		DISCONNECTED
	}
	[CCode (cheader_filename = "NetworkManagerVPN.h", cprefix = "NM_VPN_CONNECTION_STATE_REASON_", has_type_id = false)]
	public enum VPNConnectionStateReason {
		UNKNOWN,
		NONE,
		USER_DISCONNECTED,
		DEVICE_DISCONNECTED,
		SERVICE_STOPPED,
		IP_CONFIG_INVALID,
		CONNECT_TIMEOUT,
		SERVICE_START_TIMEOUT,
		SERVICE_START_FAILED,
		NO_SECRETS,
		LOGIN_FAILED,
		CONNECTION_REMOVED
	}
	[CCode (cheader_filename = "NetworkManagerVPN.h", cprefix = "NM_VPN_PLUGIN_FAILURE_", has_type_id = false)]
	public enum VPNPluginFailure {
		LOGIN_FAILED,
		CONNECT_FAILED,
		BAD_IP_CONFIG
	}
	[CCode (cheader_filename = "NetworkManagerVPN.h", cprefix = "NM_VPN_SERVICE_STATE_", has_type_id = false)]
	public enum VPNServiceState {
		UNKNOWN,
		INIT,
		SHUTDOWN,
		STARTING,
		STARTED,
		STOPPING,
		STOPPED
	}
	[CCode (cheader_filename = "nm-setting-vlan.h", cprefix = "NM_VLAN_FLAG_", type_id = "nm_vlan_flags_get_type ()")]
	public enum VlanFlags {
		REORDER_HEADERS,
		GVRP,
		LOOSE_BINDING,
		MVRP
	}
	[CCode (cheader_filename = "nm-setting-vlan.h", cprefix = "NM_VLAN_", type_id = "nm_vlan_priority_map_get_type ()")]
	public enum VlanPriorityMap {
		INGRESS_MAP,
		EGRESS_MAP
	}
	[CCode (cheader_filename = "nm-setting-wireless-security.h", cprefix = "NM_WEP_KEY_TYPE_", type_id = "nm_wep_key_type_get_type ()")]
	public enum WepKeyType {
		UNKNOWN,
		KEY,
		PASSPHRASE,
		LAST
	}
	[CCode (cheader_filename = "nm-connection.h", cprefix = "NM_CONNECTION_ERROR_")]
	public errordomain ConnectionError {
		[CCode (cname = "NM_CONNECTION_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_CONNECTION_ERROR_CONNECTION_SETTING_NOT_FOUND")]
		CONNECTIONSETTINGNOTFOUND,
		[CCode (cname = "NM_CONNECTION_ERROR_CONNECTION_TYPE_INVALID")]
		CONNECTIONTYPEINVALID,
		[CCode (cname = "NM_CONNECTION_ERROR_SETTING_NOT_FOUND")]
		SETTINGNOTFOUND,
		[CCode (cname = "NM_CONNECTION_ERROR_INVALID_SETTING")]
		INVALIDSETTING
	}
	[CCode (cheader_filename = "nm-setting-8021x.h", cprefix = "NM_SETTING_802_1X_ERROR_")]
	public errordomain Setting8021xError {
		[CCode (cname = "NM_SETTING_802_1X_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_802_1X_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_802_1X_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-8021x.h", cname = "nm_setting_802_1x_error_quark")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-adsl.h", cprefix = "NM_SETTING_ADSL_ERROR_")]
	public errordomain SettingAdslError {
		[CCode (cname = "NM_SETTING_ADSL_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_ADSL_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_ADSL_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-adsl.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-bluetooth.h", cprefix = "NM_SETTING_BLUETOOTH_ERROR_")]
	public errordomain SettingBluetoothError {
		[CCode (cname = "NM_SETTING_BLUETOOTH_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_BLUETOOTH_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_BLUETOOTH_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_BLUETOOTH_ERROR_TYPE_SETTING_NOT_FOUND")]
		TYPESETTINGNOTFOUND;
		[CCode (cheader_filename = "nm-setting-bluetooth.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-bond.h", cprefix = "NM_SETTING_BOND_ERROR_")]
	public errordomain SettingBondError {
		[CCode (cname = "NM_SETTING_BOND_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_BOND_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_BOND_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_BOND_ERROR_INVALID_OPTION")]
		INVALIDOPTION,
		[CCode (cname = "NM_SETTING_BOND_ERROR_MISSING_OPTION")]
		MISSINGOPTION;
		[CCode (cheader_filename = "nm-setting-bond.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-bridge.h", cprefix = "NM_SETTING_BRIDGE_ERROR_")]
	[Version (since = "0.9.8")]
	public errordomain SettingBridgeError {
		[CCode (cname = "NM_SETTING_BRIDGE_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_BRIDGE_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_BRIDGE_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-bridge.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", cprefix = "NM_SETTING_BRIDGE_PORT_ERROR_")]
	[Version (since = "0.9.8")]
	public errordomain SettingBridgePortError {
		[CCode (cname = "NM_SETTING_BRIDGE_PORT_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_BRIDGE_PORT_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_BRIDGE_PORT_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-cdma.h", cprefix = "NM_SETTING_CDMA_ERROR_")]
	public errordomain SettingCdmaError {
		[CCode (cname = "NM_SETTING_CDMA_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_CDMA_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_CDMA_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_CDMA_ERROR_MISSING_SERIAL_SETTING")]
		MISSINGSERIALSETTING;
		[CCode (cheader_filename = "nm-setting-cdma.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-connection.h", cprefix = "NM_SETTING_CONNECTION_ERROR_")]
	public errordomain SettingConnectionError {
		[CCode (cname = "NM_SETTING_CONNECTION_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_CONNECTION_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_CONNECTION_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_CONNECTION_ERROR_TYPE_SETTING_NOT_FOUND")]
		TYPESETTINGNOTFOUND,
		[CCode (cname = "NM_SETTING_CONNECTION_ERROR_IP_CONFIG_NOT_ALLOWED")]
		IPCONFIGNOTALLOWED;
		[CCode (cheader_filename = "nm-setting-connection.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", cprefix = "NM_SETTING_DCB_ERROR_")]
	public errordomain SettingDcbError {
		[CCode (cname = "NM_SETTING_DCB_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_DCB_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_DCB_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[Version (since = "0.9.10")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting.h", cprefix = "NM_SETTING_ERROR_")]
	public errordomain SettingError {
		[CCode (cname = "NM_SETTING_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_ERROR_PROPERTY_NOT_FOUND")]
		PROPERTYNOTFOUND,
		[CCode (cname = "NM_SETTING_ERROR_PROPERTY_NOT_SECRET")]
		PROPERTYNOTSECRET,
		[CCode (cname = "NM_SETTING_ERROR_PROPERTY_TYPE_MISMATCH")]
		PROPERTYTYPEMISMATCH;
		[CCode (cheader_filename = "nm-setting.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-generic.h", cprefix = "NM_SETTING_GENERIC_ERROR_")]
	[Version (since = "0.9.10")]
	public errordomain SettingGenericError {
		[CCode (cname = "NM_SETTING_GENERIC_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_GENERIC_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_GENERIC_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-generic.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-gsm.h", cprefix = "NM_SETTING_GSM_ERROR_")]
	public errordomain SettingGsmError {
		[CCode (cname = "NM_SETTING_GSM_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_GSM_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_GSM_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_GSM_ERROR_MISSING_SERIAL_SETTING")]
		MISSINGSERIALSETTING;
		[CCode (cheader_filename = "nm-setting-gsm.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-ip4-config.h", cprefix = "NM_SETTING_IP4_CONFIG_ERROR_")]
	public errordomain SettingIP4ConfigError {
		[CCode (cname = "NM_SETTING_IP4_CONFIG_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_IP4_CONFIG_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_IP4_CONFIG_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_IP4_CONFIG_ERROR_NOT_ALLOWED_FOR_METHOD")]
		NOTALLOWEDFORMETHOD;
		[CCode (cheader_filename = "nm-setting-ip4-config.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-ip6-config.h", cprefix = "NM_SETTING_IP6_CONFIG_ERROR_")]
	public errordomain SettingIP6ConfigError {
		[CCode (cname = "NM_SETTING_IP6_CONFIG_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_IP6_CONFIG_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_IP6_CONFIG_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_IP6_CONFIG_ERROR_NOT_ALLOWED_FOR_METHOD")]
		NOTALLOWEDFORMETHOD;
		[CCode (cheader_filename = "nm-setting-ip6-config.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-infiniband.h", cprefix = "NM_SETTING_INFINIBAND_ERROR_")]
	public errordomain SettingInfinibandError {
		[CCode (cname = "NM_SETTING_INFINIBAND_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_INFINIBAND_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_INFINIBAND_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-infiniband.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-olpc-mesh.h", cprefix = "NM_SETTING_OLPC_MESH_ERROR_")]
	public errordomain SettingOlpcMeshError {
		[CCode (cname = "NM_SETTING_OLPC_MESH_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_OLPC_MESH_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_OLPC_MESH_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-olpc-mesh.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-ppp.h", cprefix = "NM_SETTING_PPP_ERROR_")]
	public errordomain SettingPPPError {
		[CCode (cname = "NM_SETTING_PPP_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_PPP_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_PPP_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_PPP_ERROR_REQUIRE_MPPE_NOT_ALLOWED")]
		REQUIREMPPENOTALLOWED;
		[CCode (cheader_filename = "nm-setting-ppp.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-pppoe.h", cprefix = "NM_SETTING_PPPOE_ERROR_")]
	public errordomain SettingPPPOEError {
		[CCode (cname = "NM_SETTING_PPPOE_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_PPPOE_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_PPPOE_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_PPPOE_ERROR_MISSING_PPP_SETTING")]
		MISSINGPPPSETTING;
		[CCode (cheader_filename = "nm-setting-pppoe.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-serial.h", cprefix = "NM_SETTING_SERIAL_ERROR_")]
	public errordomain SettingSerialError {
		[CCode (cname = "NM_SETTING_SERIAL_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_SERIAL_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_SERIAL_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_SERIAL_ERROR_MISSING_PPP_SETTING")]
		MISSINGPPPSETTING;
		[CCode (cheader_filename = "nm-setting-serial.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-team.h", cprefix = "NM_SETTING_TEAM_ERROR_")]
	public errordomain SettingTeamError {
		[CCode (cname = "NM_SETTING_TEAM_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_TEAM_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_TEAM_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-team.h")]
		[Version (since = "0.9.10")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager-1.0.h", cprefix = "NM_SETTING_TEAM_PORT_ERROR_")]
	public errordomain SettingTeamPortError {
		[CCode (cname = "NM_SETTING_TEAM_PORT_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_TEAM_PORT_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_TEAM_PORT_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[Version (since = "0.9.10")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-vlan.h", cprefix = "NM_SETTING_VLAN_ERROR_")]
	public errordomain SettingVlanError {
		UNKNOWN,
		[CCode (cname = "NM_SETTING_VLAN_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_VLAN_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_VLAN_ERROR_INVALID_PARENT")]
		INVALIDPARENT;
		[CCode (cheader_filename = "nm-setting-vlan.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-vpn.h", cprefix = "NM_SETTING_VPN_ERROR_")]
	public errordomain SettingVpnError {
		[CCode (cname = "NM_SETTING_VPN_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_VPN_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_VPN_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-vpn.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-wimax.h", cprefix = "NM_SETTING_WIMAX_ERROR_")]
	public errordomain SettingWimaxError {
		[CCode (cname = "NM_SETTING_WIMAX_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_WIMAX_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_WIMAX_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-wimax.h")]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-wired.h", cprefix = "NM_SETTING_WIRED_ERROR_")]
	public errordomain SettingWiredError {
		[CCode (cname = "NM_SETTING_WIRED_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_WIRED_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_WIRED_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY;
		[CCode (cheader_filename = "nm-setting-wired.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-wireless.h", cprefix = "NM_SETTING_WIRELESS_ERROR_")]
	public errordomain SettingWirelessError {
		[CCode (cname = "NM_SETTING_WIRELESS_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_WIRELESS_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_WIRELESS_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_WIRELESS_ERROR_MISSING_SECURITY_SETTING")]
		MISSINGSECURITYSETTING,
		[CCode (cname = "NM_SETTING_WIRELESS_ERROR_CHANNEL_REQUIRES_BAND")]
		CHANNELREQUIRESBAND;
		[CCode (cheader_filename = "nm-setting-wireless.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting-wireless-security.h", cprefix = "NM_SETTING_WIRELESS_SECURITY_ERROR_")]
	public errordomain SettingWirelessSecurityError {
		[CCode (cname = "NM_SETTING_WIRELESS_SECURITY_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_SETTING_WIRELESS_SECURITY_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY,
		[CCode (cname = "NM_SETTING_WIRELESS_SECURITY_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_SETTING_WIRELESS_SECURITY_ERROR_MISSING_802_1X_SETTING")]
		MISSING8021XSETTING,
		[CCode (cname = "NM_SETTING_WIRELESS_SECURITY_ERROR_LEAP_REQUIRES_802_1X")]
		LEAPREQUIRES8021X,
		[CCode (cname = "NM_SETTING_WIRELESS_SECURITY_ERROR_LEAP_REQUIRES_USERNAME")]
		LEAPREQUIRESUSERNAME,
		[CCode (cname = "NM_SETTING_WIRELESS_SECURITY_ERROR_SHARED_KEY_REQUIRES_WEP")]
		SHAREDKEYREQUIRESWEP;
		[CCode (cheader_filename = "nm-setting-wireless-security.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-setting.h", instance_pos = 3.9)]
	public delegate bool SettingClearSecretsWithFlagsFn (NM.Setting setting, string secret, NM.SettingSecretFlags flags);
	[CCode (cheader_filename = "nm-setting.h", instance_pos = 4.9)]
	public delegate void SettingValueIterFn (NM.Setting setting, string key, GLib.Value value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "NetworkManager-1.0.h", instance_pos = 1.9)]
	public delegate bool UtilsFileSearchInPathsPredicate (string filename);
	[CCode (cheader_filename = "nm-setting-vpn.h", instance_pos = 2.9)]
	public delegate void VPNIterFunc (string key, string value);
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_CONNECTION_CHANGED")]
	public const string CONNECTION_CHANGED;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_CONNECTION_NORMALIZE_PARAM_IP6_CONFIG_METHOD")]
	public const string CONNECTION_NORMALIZE_PARAM_IP6_CONFIG_METHOD;
	[CCode (cheader_filename = "nm-connection.h", cname = "NM_CONNECTION_PATH")]
	public const string CONNECTION_PATH;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_CONNECTION_SECRETS_CLEARED")]
	public const string CONNECTION_SECRETS_CLEARED;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_CONNECTION_SECRETS_UPDATED")]
	public const string CONNECTION_SECRETS_UPDATED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_IFACE_SETTINGS")]
	public const string DBUS_IFACE_SETTINGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_IFACE_SETTINGS_CONNECTION")]
	public const string DBUS_IFACE_SETTINGS_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_IFACE_SETTINGS_CONNECTION_SECRETS")]
	public const string DBUS_IFACE_SETTINGS_CONNECTION_SECRETS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE")]
	public const string DBUS_INTERFACE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_VPN")]
	public const string DBUS_INTERFACE_VPN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_VPN_CONNECTION")]
	public const string DBUS_INTERFACE_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INVALID_VPN_CONNECTION")]
	public const string DBUS_INVALID_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_NO_ACTIVE_VPN_CONNECTION")]
	public const string DBUS_NO_ACTIVE_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_NO_VPN_CONNECTIONS")]
	public const string DBUS_NO_VPN_CONNECTIONS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH")]
	public const string DBUS_PATH;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_AGENT_MANAGER")]
	public const string DBUS_PATH_AGENT_MANAGER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_SECRET_AGENT")]
	public const string DBUS_PATH_SECRET_AGENT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_SETTINGS")]
	public const string DBUS_PATH_SETTINGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_SETTINGS_CONNECTION")]
	public const string DBUS_PATH_SETTINGS_CONNECTION;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_PATH_VPN")]
	public const string DBUS_PATH_VPN;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_PATH_VPN_CONNECTION")]
	public const string DBUS_PATH_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_SERVICE")]
	public const string DBUS_SERVICE;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_ALREADY_STARTED")]
	public const string DBUS_VPN_ALREADY_STARTED;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_ALREADY_STOPPED")]
	public const string DBUS_VPN_ALREADY_STOPPED;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_BAD_ARGUMENTS")]
	public const string DBUS_VPN_BAD_ARGUMENTS;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_ERROR_PREFIX")]
	public const string DBUS_VPN_ERROR_PREFIX;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_INTERACTIVE_NOT_SUPPORTED")]
	public const string DBUS_VPN_INTERACTIVE_NOT_SUPPORTED;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_CONNECT_FAILED")]
	public const string DBUS_VPN_SIGNAL_CONNECT_FAILED;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_IP4_CONFIG")]
	public const string DBUS_VPN_SIGNAL_IP4_CONFIG;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_IP_CONFIG_BAD")]
	public const string DBUS_VPN_SIGNAL_IP_CONFIG_BAD;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_LAUNCH_FAILED")]
	public const string DBUS_VPN_SIGNAL_LAUNCH_FAILED;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_LOGIN_BANNER")]
	public const string DBUS_VPN_SIGNAL_LOGIN_BANNER;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_LOGIN_FAILED")]
	public const string DBUS_VPN_SIGNAL_LOGIN_FAILED;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_STATE_CHANGE")]
	public const string DBUS_VPN_SIGNAL_STATE_CHANGE;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_SIGNAL_VPN_CONFIG_BAD")]
	public const string DBUS_VPN_SIGNAL_VPN_CONFIG_BAD;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_STARTING_IN_PROGRESS")]
	public const string DBUS_VPN_STARTING_IN_PROGRESS;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_STOPPING_IN_PROGRESS")]
	public const string DBUS_VPN_STOPPING_IN_PROGRESS;
	[CCode (cheader_filename = "NetworkManagerVPN.h", cname = "NM_DBUS_VPN_WRONG_STATE")]
	public const string DBUS_VPN_WRONG_STATE;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_APP_FCOE_FLAGS")]
	public const string SETTING_DCB_APP_FCOE_FLAGS;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_APP_FCOE_MODE")]
	public const string SETTING_DCB_APP_FCOE_MODE;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_APP_FCOE_PRIORITY")]
	public const string SETTING_DCB_APP_FCOE_PRIORITY;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_APP_FIP_FLAGS")]
	public const string SETTING_DCB_APP_FIP_FLAGS;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_APP_FIP_PRIORITY")]
	public const string SETTING_DCB_APP_FIP_PRIORITY;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_APP_ISCSI_FLAGS")]
	public const string SETTING_DCB_APP_ISCSI_FLAGS;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_APP_ISCSI_PRIORITY")]
	public const string SETTING_DCB_APP_ISCSI_PRIORITY;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_FCOE_MODE_FABRIC")]
	[Version (since = "0.9.10")]
	public const string SETTING_DCB_FCOE_MODE_FABRIC;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_FCOE_MODE_VN2VN")]
	[Version (since = "0.9.10")]
	public const string SETTING_DCB_FCOE_MODE_VN2VN;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_BANDWIDTH")]
	public const string SETTING_DCB_PRIORITY_BANDWIDTH;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_FLOW_CONTROL")]
	public const string SETTING_DCB_PRIORITY_FLOW_CONTROL;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_FLOW_CONTROL_FLAGS")]
	public const string SETTING_DCB_PRIORITY_FLOW_CONTROL_FLAGS;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_GROUP_BANDWIDTH")]
	public const string SETTING_DCB_PRIORITY_GROUP_BANDWIDTH;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_GROUP_FLAGS")]
	public const string SETTING_DCB_PRIORITY_GROUP_FLAGS;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_GROUP_ID")]
	public const string SETTING_DCB_PRIORITY_GROUP_ID;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_STRICT_BANDWIDTH")]
	public const string SETTING_DCB_PRIORITY_STRICT_BANDWIDTH;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_PRIORITY_TRAFFIC_CLASS")]
	public const string SETTING_DCB_PRIORITY_TRAFFIC_CLASS;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_SETTING_DCB_SETTING_NAME")]
	public const string SETTING_DCB_SETTING_NAME;
	[CCode (cheader_filename = "nm-setting.h", cname = "NM_SETTING_NAME")]
	public const string SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager-1.0.h", cname = "NM_VLAN_FLAGS_ALL")]
	public const int VLAN_FLAGS_ALL;
}
