/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.CommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;

public class ExtendedCommonTermsQuery
extends CommonTermsQuery {
    private final MappedFieldType fieldType;
    private String lowFreqMinNumShouldMatchSpec;
    private String highFreqMinNumShouldMatchSpec;

    public ExtendedCommonTermsQuery(BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, MappedFieldType fieldType) {
        super(highFreqOccur, lowFreqOccur, maxTermFrequency);
        this.fieldType = fieldType;
    }

    protected int calcLowFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.lowFreqMinNumShouldMatchSpec, numOptional);
    }

    protected int calcMinimumNumberShouldMatch(String spec, int numOptional) {
        if (spec == null) {
            return 0;
        }
        return Queries.calculateMinShouldMatch(numOptional, spec);
    }

    protected int calcHighFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.highFreqMinNumShouldMatchSpec, numOptional);
    }

    public void setHighFreqMinimumNumberShouldMatch(String spec) {
        this.highFreqMinNumShouldMatchSpec = spec;
    }

    public String getHighFreqMinimumNumberShouldMatchSpec() {
        return this.highFreqMinNumShouldMatchSpec;
    }

    public void setLowFreqMinimumNumberShouldMatch(String spec) {
        this.lowFreqMinNumShouldMatchSpec = spec;
    }

    public String getLowFreqMinimumNumberShouldMatchSpec() {
        return this.lowFreqMinNumShouldMatchSpec;
    }

    public float getMaxTermFrequency() {
        return this.maxTermFrequency;
    }

    protected Query newTermQuery(Term term, TermContext context) {
        if (this.fieldType == null) {
            return super.newTermQuery(term, context);
        }
        Query query = this.fieldType.queryStringTermQuery(term);
        if (query == null) {
            return super.newTermQuery(term, context);
        }
        return query;
    }
}

