/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.spi.Whitelist;

public final class Definition {
    private static final Map<String, Method> methodCache = new HashMap<String, Method>();
    private static final Map<String, Field> fieldCache = new HashMap<String, Field>();
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][._a-zA-Z0-9]*$");
    public final Type voidType;
    public final Type booleanType;
    public final Type BooleanType;
    public final Type byteType;
    public final Type ByteType;
    public final Type shortType;
    public final Type ShortType;
    public final Type intType;
    public final Type IntegerType;
    public final Type longType;
    public final Type LongType;
    public final Type floatType;
    public final Type FloatType;
    public final Type doubleType;
    public final Type DoubleType;
    public final Type charType;
    public final Type CharacterType;
    public final Type ObjectType;
    public final Type DefType;
    public final Type NumberType;
    public final Type StringType;
    public final Type ExceptionType;
    public final Type PatternType;
    public final Type MatcherType;
    public final Type IteratorType;
    public final Type ArrayListType;
    public final Type HashMapType;
    private final Map<Class<?>, RuntimeClass> runtimeMap;
    private final Map<String, Struct> structsMap = new HashMap<String, Struct>();
    private final Map<String, Type> simpleTypesMap = new HashMap<String, Type>();
    public AnalyzerCaster caster;

    public boolean isSimpleType(String name) {
        return this.structsMap.containsKey(name);
    }

    public Type getType(String name) {
        return this.getTypeInternal(name);
    }

    public Type getType(Struct struct, int dimensions) {
        return this.getTypeInternal(struct, dimensions);
    }

    public Type getBoxedType(Type unboxed) {
        if (unboxed.clazz == Boolean.TYPE) {
            return this.BooleanType;
        }
        if (unboxed.clazz == Byte.TYPE) {
            return this.ByteType;
        }
        if (unboxed.clazz == Short.TYPE) {
            return this.ShortType;
        }
        if (unboxed.clazz == Character.TYPE) {
            return this.CharacterType;
        }
        if (unboxed.clazz == Integer.TYPE) {
            return this.IntegerType;
        }
        if (unboxed.clazz == Long.TYPE) {
            return this.LongType;
        }
        if (unboxed.clazz == Float.TYPE) {
            return this.FloatType;
        }
        if (unboxed.clazz == Double.TYPE) {
            return this.DoubleType;
        }
        return unboxed;
    }

    public Type getUnboxedType(Type boxed) {
        if (boxed.clazz == Boolean.class) {
            return this.booleanType;
        }
        if (boxed.clazz == Byte.class) {
            return this.byteType;
        }
        if (boxed.clazz == Short.class) {
            return this.shortType;
        }
        if (boxed.clazz == Character.class) {
            return this.charType;
        }
        if (boxed.clazz == Integer.class) {
            return this.intType;
        }
        if (boxed.clazz == Long.class) {
            return this.longType;
        }
        if (boxed.clazz == Float.class) {
            return this.floatType;
        }
        if (boxed.clazz == Double.class) {
            return this.doubleType;
        }
        return boxed;
    }

    public static boolean isConstantType(Type constant) {
        return constant.clazz == Boolean.TYPE || constant.clazz == Byte.TYPE || constant.clazz == Short.TYPE || constant.clazz == Character.TYPE || constant.clazz == Integer.TYPE || constant.clazz == Long.TYPE || constant.clazz == Float.TYPE || constant.clazz == Double.TYPE || constant.clazz == String.class;
    }

    public RuntimeClass getRuntimeClass(Class<?> clazz) {
        return this.runtimeMap.get(clazz);
    }

    public Class<?> getClassFromBinaryName(String name) {
        Struct struct = this.structsMap.get(name.replace('$', '.'));
        return struct == null ? null : struct.clazz;
    }

    Collection<Type> allSimpleTypes() {
        return this.simpleTypesMap.values();
    }

    private static String buildMethodCacheKey(String structName, String methodName, List<Type> arguments) {
        StringBuilder key = new StringBuilder();
        key.append(structName);
        key.append(methodName);
        for (Type argument : arguments) {
            key.append(argument.name);
        }
        return key.toString();
    }

    private static String buildFieldCacheKey(String structName, String fieldName, String typeName) {
        return structName + fieldName + typeName;
    }

    public Definition(List<Whitelist> whitelists) {
        Struct painlessStruct;
        this.runtimeMap = new HashMap();
        HashMap javaClassesToPainlessStructs = new HashMap();
        String origin = null;
        this.structsMap.put("def", new Struct("def", Object.class, org.objectweb.asm.Type.getType(Object.class)));
        try {
            String painlessTypeName;
            for (Whitelist whitelist : whitelists) {
                for (Whitelist.Struct whitelistStruct : whitelist.whitelistStructs) {
                    painlessTypeName = whitelistStruct.javaClassName.replace('$', '.');
                    Object painlessStruct2 = this.structsMap.get(painlessTypeName);
                    if (painlessStruct2 != null && !((Struct)painlessStruct2).clazz.getName().equals(whitelistStruct.javaClassName)) {
                        throw new IllegalArgumentException("struct [" + ((Struct)painlessStruct2).name + "] cannot represent multiple classes [" + ((Struct)painlessStruct2).clazz.getName() + "] and [" + whitelistStruct.javaClassName + "]");
                    }
                    origin = whitelistStruct.origin;
                    this.addStruct(whitelist.javaClassLoader, whitelistStruct);
                    painlessStruct2 = this.structsMap.get(painlessTypeName);
                    javaClassesToPainlessStructs.put(((Struct)painlessStruct2).clazz, painlessStruct2);
                }
            }
            for (Whitelist whitelist : whitelists) {
                for (Whitelist.Struct whitelistStruct : whitelist.whitelistStructs) {
                    painlessTypeName = whitelistStruct.javaClassName.replace('$', '.');
                    for (Whitelist.Constructor whitelistConstructor : whitelistStruct.whitelistConstructors) {
                        origin = whitelistConstructor.origin;
                        this.addConstructor(painlessTypeName, whitelistConstructor);
                    }
                    for (Whitelist.Method whitelistMethod : whitelistStruct.whitelistMethods) {
                        origin = whitelistMethod.origin;
                        this.addMethod(whitelist.javaClassLoader, painlessTypeName, whitelistMethod);
                    }
                    for (Whitelist.Field whitelistField : whitelistStruct.whitelistFields) {
                        origin = whitelistField.origin;
                        this.addField(painlessTypeName, whitelistField);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("error loading whitelist(s) " + origin, exception);
        }
        for (Map.Entry entry : this.structsMap.entrySet()) {
            Struct painlessObjectStruct;
            Class<?> javaSuperClass;
            String painlessStructName = (String)entry.getKey();
            Struct painlessStruct3 = (Struct)entry.getValue();
            if (!painlessStruct3.name.equals(painlessStructName)) continue;
            ArrayList<String> painlessSuperStructs = new ArrayList<String>();
            Stack javaInteraceLookups = new Stack();
            javaInteraceLookups.push(painlessStruct3.clazz);
            if (javaSuperClass != null && !javaSuperClass.isInterface()) {
                for (javaSuperClass = painlessStruct3.clazz.getSuperclass(); javaSuperClass != null; javaSuperClass = javaSuperClass.getSuperclass()) {
                    Struct painlessSuperStruct = (Struct)javaClassesToPainlessStructs.get(javaSuperClass);
                    if (painlessSuperStruct != null) {
                        painlessSuperStructs.add(painlessSuperStruct.name);
                    }
                    javaInteraceLookups.push(javaSuperClass);
                }
            }
            while (!javaInteraceLookups.isEmpty()) {
                Class javaInterfaceLookup = (Class)javaInteraceLookups.pop();
                for (Class<?> javaSuperInterface : javaInterfaceLookup.getInterfaces()) {
                    Struct painlessInterfaceStruct = (Struct)javaClassesToPainlessStructs.get(javaSuperInterface);
                    if (painlessInterfaceStruct == null) continue;
                    String painlessInterfaceStructName = painlessInterfaceStruct.name;
                    if (!painlessSuperStructs.contains(painlessInterfaceStructName)) {
                        painlessSuperStructs.add(painlessInterfaceStructName);
                    }
                    for (Class<?> javaPushInterface : javaInterfaceLookup.getInterfaces()) {
                        javaInteraceLookups.push(javaPushInterface);
                    }
                }
            }
            this.copyStruct(painlessStruct3.name, painlessSuperStructs);
            if (!painlessStruct3.clazz.isInterface() && !"def".equals(painlessStruct3.name) || (painlessObjectStruct = (Struct)javaClassesToPainlessStructs.get(Object.class)) == null) continue;
            this.copyStruct(painlessStruct3.name, Collections.singletonList(painlessObjectStruct.name));
        }
        for (String string : this.structsMap.keySet()) {
            painlessStruct = this.structsMap.get(string);
            if (!painlessStruct.name.equals(string)) continue;
            painlessStruct.functionalMethod.set((Object)this.computeFunctionalInterfaceMethod(painlessStruct));
        }
        for (String string : this.structsMap.keySet()) {
            painlessStruct = this.structsMap.get(string);
            if (!painlessStruct.name.equals(string)) continue;
            this.addRuntimeClass(painlessStruct);
        }
        for (Map.Entry entry : this.structsMap.entrySet()) {
            if (!((String)entry.getKey()).equals(((Struct)entry.getValue()).name)) continue;
            entry.setValue(((Struct)entry.getValue()).freeze());
        }
        this.voidType = this.getType("void");
        this.booleanType = this.getType("boolean");
        this.BooleanType = this.getType("Boolean");
        this.byteType = this.getType("byte");
        this.ByteType = this.getType("Byte");
        this.shortType = this.getType("short");
        this.ShortType = this.getType("Short");
        this.intType = this.getType("int");
        this.IntegerType = this.getType("Integer");
        this.longType = this.getType("long");
        this.LongType = this.getType("Long");
        this.floatType = this.getType("float");
        this.FloatType = this.getType("Float");
        this.doubleType = this.getType("double");
        this.DoubleType = this.getType("Double");
        this.charType = this.getType("char");
        this.CharacterType = this.getType("Character");
        this.ObjectType = this.getType("Object");
        this.DefType = this.getType("def");
        this.NumberType = this.getType("Number");
        this.StringType = this.getType("String");
        this.ExceptionType = this.getType("Exception");
        this.PatternType = this.getType("Pattern");
        this.MatcherType = this.getType("Matcher");
        this.IteratorType = this.getType("Iterator");
        this.ArrayListType = this.getType("ArrayList");
        this.HashMapType = this.getType("HashMap");
        this.caster = new AnalyzerCaster(this);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addStruct(ClassLoader whitelistClassLoader, Whitelist.Struct whitelistStruct) {
        void var6_16;
        String painlessTypeName;
        String importedPainlessTypeName = painlessTypeName = whitelistStruct.javaClassName.replace('$', '.');
        if (!TYPE_NAME_PATTERN.matcher(painlessTypeName).matches()) {
            throw new IllegalArgumentException("invalid struct type name [" + painlessTypeName + "]");
        }
        int index = whitelistStruct.javaClassName.lastIndexOf(46);
        if (index != -1) {
            importedPainlessTypeName = whitelistStruct.javaClassName.substring(index + 1).replace('$', '.');
        }
        if ("void".equals(whitelistStruct.javaClassName)) {
            Class<Void> clazz = Void.TYPE;
        } else if ("boolean".equals(whitelistStruct.javaClassName)) {
            Class<Boolean> clazz = Boolean.TYPE;
        } else if ("byte".equals(whitelistStruct.javaClassName)) {
            Class<Byte> clazz = Byte.TYPE;
        } else if ("short".equals(whitelistStruct.javaClassName)) {
            Class<Short> clazz = Short.TYPE;
        } else if ("char".equals(whitelistStruct.javaClassName)) {
            Class<Character> clazz = Character.TYPE;
        } else if ("int".equals(whitelistStruct.javaClassName)) {
            Class<Integer> clazz = Integer.TYPE;
        } else if ("long".equals(whitelistStruct.javaClassName)) {
            Class<Long> clazz = Long.TYPE;
        } else if ("float".equals(whitelistStruct.javaClassName)) {
            Class<Float> clazz = Float.TYPE;
        } else if ("double".equals(whitelistStruct.javaClassName)) {
            Class<Double> clazz = Double.TYPE;
        } else {
            try {
                Class<?> clazz = Class.forName(whitelistStruct.javaClassName, true, whitelistClassLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("invalid java class name [" + whitelistStruct.javaClassName + "] for struct [" + painlessTypeName + "]");
            }
        }
        Struct existingStruct = this.structsMap.get(painlessTypeName);
        if (existingStruct == null) {
            Struct struct = new Struct(painlessTypeName, (Class)var6_16, org.objectweb.asm.Type.getType((Class)var6_16));
            this.structsMap.put(painlessTypeName, struct);
            if (whitelistStruct.onlyFQNJavaClassName) {
                this.simpleTypesMap.put(painlessTypeName, this.getType(painlessTypeName));
                return;
            } else {
                if (this.simpleTypesMap.containsKey(importedPainlessTypeName)) throw new IllegalArgumentException("duplicate short name [" + importedPainlessTypeName + "] found for struct [" + painlessTypeName + "]");
                this.simpleTypesMap.put(importedPainlessTypeName, this.getType(painlessTypeName));
                this.structsMap.put(importedPainlessTypeName, struct);
            }
            return;
        } else {
            if (!existingStruct.clazz.equals(var6_16)) {
                throw new IllegalArgumentException("struct [" + painlessTypeName + "] is used to illegally represent multiple java classes [" + whitelistStruct.javaClassName + "] and [" + existingStruct.clazz.getName() + "]");
            }
            if ((!whitelistStruct.onlyFQNJavaClassName || !this.simpleTypesMap.containsKey(importedPainlessTypeName) || this.simpleTypesMap.get((Object)importedPainlessTypeName).clazz != var6_16) && (whitelistStruct.onlyFQNJavaClassName || this.simpleTypesMap.containsKey(importedPainlessTypeName) && this.simpleTypesMap.get((Object)importedPainlessTypeName).clazz == var6_16)) return;
            throw new IllegalArgumentException("inconsistent only_fqn parameters found for type [" + painlessTypeName + "]");
        }
    }

    private void addConstructor(String ownerStructName, Whitelist.Constructor whitelistConstructor) {
        Constructor<?> javaConstructor;
        Struct ownerStruct = this.structsMap.get(ownerStructName);
        if (ownerStruct == null) {
            throw new IllegalArgumentException("owner struct [" + ownerStructName + "] not defined for constructor with parameters " + whitelistConstructor.painlessParameterTypeNames);
        }
        ArrayList<Type> painlessParametersTypes = new ArrayList<Type>(whitelistConstructor.painlessParameterTypeNames.size());
        Class[] javaClassParameters = new Class[whitelistConstructor.painlessParameterTypeNames.size()];
        for (int parameterCount = 0; parameterCount < whitelistConstructor.painlessParameterTypeNames.size(); ++parameterCount) {
            String painlessParameterTypeName = (String)whitelistConstructor.painlessParameterTypeNames.get(parameterCount);
            try {
                Type painlessParameterType = this.getTypeInternal(painlessParameterTypeName);
                painlessParametersTypes.add(painlessParameterType);
                javaClassParameters[parameterCount] = painlessParameterType.clazz;
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("struct not defined for constructor parameter [" + painlessParameterTypeName + "] with owner struct [" + ownerStructName + "] and constructor parameters " + whitelistConstructor.painlessParameterTypeNames, iae);
            }
        }
        try {
            javaConstructor = ownerStruct.clazz.getConstructor(javaClassParameters);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("constructor not defined for owner struct [" + ownerStructName + "]  with constructor parameters " + whitelistConstructor.painlessParameterTypeNames, exception);
        }
        MethodKey painlessMethodKey = new MethodKey("<init>", whitelistConstructor.painlessParameterTypeNames.size());
        Method painlessConstructor = ownerStruct.constructors.get(painlessMethodKey);
        if (painlessConstructor == null) {
            MethodHandle javaHandle;
            org.objectweb.asm.commons.Method asmConstructor = org.objectweb.asm.commons.Method.getMethod(javaConstructor);
            try {
                javaHandle = MethodHandles.publicLookup().in(ownerStruct.clazz).unreflectConstructor(javaConstructor);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("constructor not defined for owner struct [" + ownerStructName + "]  with constructor parameters " + whitelistConstructor.painlessParameterTypeNames);
            }
            painlessConstructor = methodCache.computeIfAbsent(Definition.buildMethodCacheKey(ownerStruct.name, "<init>", painlessParametersTypes), key -> new Method("<init>", ownerStruct, null, this.getTypeInternal("void"), painlessParametersTypes, asmConstructor, javaConstructor.getModifiers(), javaHandle));
            ownerStruct.constructors.put(painlessMethodKey, painlessConstructor);
        } else if (!painlessConstructor.arguments.equals(painlessParametersTypes)) {
            throw new IllegalArgumentException("illegal duplicate constructors [" + painlessMethodKey + "] found within the struct [" + ownerStruct.name + "] with parameters " + painlessParametersTypes + " and " + painlessConstructor.arguments);
        }
    }

    private void addMethod(ClassLoader whitelistClassLoader, String ownerStructName, Whitelist.Method whitelistMethod) {
        Type painlessReturnType;
        java.lang.reflect.Method javaMethod;
        Class<?> javaAugmentedClass;
        Struct ownerStruct = this.structsMap.get(ownerStructName);
        if (ownerStruct == null) {
            throw new IllegalArgumentException("owner struct [" + ownerStructName + "] not defined for method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames);
        }
        if (!TYPE_NAME_PATTERN.matcher(whitelistMethod.javaMethodName).matches()) {
            throw new IllegalArgumentException("invalid method name [" + whitelistMethod.javaMethodName + "] for owner struct [" + ownerStructName + "].");
        }
        if (whitelistMethod.javaAugmentedClassName != null) {
            try {
                javaAugmentedClass = Class.forName(whitelistMethod.javaAugmentedClassName, true, whitelistClassLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("augmented class [" + whitelistMethod.javaAugmentedClassName + "] not found for method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames, cnfe);
            }
        } else {
            javaAugmentedClass = null;
        }
        int augmentedOffset = javaAugmentedClass == null ? 0 : 1;
        ArrayList<Type> painlessParametersTypes = new ArrayList<Type>(whitelistMethod.painlessParameterTypeNames.size());
        Class[] javaClassParameters = new Class[whitelistMethod.painlessParameterTypeNames.size() + augmentedOffset];
        if (javaAugmentedClass != null) {
            javaClassParameters[0] = ownerStruct.clazz;
        }
        for (int parameterCount = 0; parameterCount < whitelistMethod.painlessParameterTypeNames.size(); ++parameterCount) {
            String painlessParameterTypeName = (String)whitelistMethod.painlessParameterTypeNames.get(parameterCount);
            try {
                Type painlessParameterType = this.getTypeInternal(painlessParameterTypeName);
                painlessParametersTypes.add(painlessParameterType);
                javaClassParameters[parameterCount + augmentedOffset] = painlessParameterType.clazz;
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("struct not defined for method parameter [" + painlessParameterTypeName + "] with owner struct [" + ownerStructName + "] and method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames, iae);
            }
        }
        Class<?> javaImplClass = javaAugmentedClass == null ? ownerStruct.clazz : javaAugmentedClass;
        try {
            javaMethod = javaImplClass.getMethod(whitelistMethod.javaMethodName, javaClassParameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames + " not found for class [" + javaImplClass.getName() + "]", nsme);
        }
        try {
            painlessReturnType = this.getTypeInternal(whitelistMethod.painlessReturnTypeName);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("struct not defined for return type [" + whitelistMethod.painlessReturnTypeName + "] with owner struct [" + ownerStructName + "] and method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames, iae);
        }
        if (!javaMethod.getReturnType().equals(painlessReturnType.clazz)) {
            throw new IllegalArgumentException("specified return type class [" + painlessReturnType.clazz + "] does not match the return type class [" + javaMethod.getReturnType() + "] for the method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames);
        }
        MethodKey painlessMethodKey = new MethodKey(whitelistMethod.javaMethodName, whitelistMethod.painlessParameterTypeNames.size());
        if (javaAugmentedClass == null && Modifier.isStatic(javaMethod.getModifiers())) {
            Method painlessMethod = ownerStruct.staticMethods.get(painlessMethodKey);
            if (painlessMethod == null) {
                MethodHandle javaMethodHandle;
                org.objectweb.asm.commons.Method asmMethod = org.objectweb.asm.commons.Method.getMethod((java.lang.reflect.Method)javaMethod);
                try {
                    javaMethodHandle = MethodHandles.publicLookup().in(javaImplClass).unreflect(javaMethod);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalArgumentException("method handle not found for method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames);
                }
                painlessMethod = methodCache.computeIfAbsent(Definition.buildMethodCacheKey(ownerStruct.name, whitelistMethod.javaMethodName, painlessParametersTypes), key -> new Method(whitelistMethod.javaMethodName, ownerStruct, null, painlessReturnType, painlessParametersTypes, asmMethod, javaMethod.getModifiers(), javaMethodHandle));
                ownerStruct.staticMethods.put(painlessMethodKey, painlessMethod);
            } else if (!(painlessMethod.name.equals(whitelistMethod.javaMethodName) && painlessMethod.rtn.equals(painlessReturnType) && painlessMethod.arguments.equals(painlessParametersTypes))) {
                throw new IllegalArgumentException("illegal duplicate static methods [" + painlessMethodKey + "] found within the struct [" + ownerStruct.name + "] with name [" + whitelistMethod.javaMethodName + "], return types [" + painlessReturnType + "] and [" + painlessMethod.rtn.name + "], and parameters " + painlessParametersTypes + " and " + painlessMethod.arguments);
            }
        } else {
            Method painlessMethod = ownerStruct.methods.get(painlessMethodKey);
            if (painlessMethod == null) {
                MethodHandle javaMethodHandle;
                org.objectweb.asm.commons.Method asmMethod = org.objectweb.asm.commons.Method.getMethod((java.lang.reflect.Method)javaMethod);
                try {
                    javaMethodHandle = MethodHandles.publicLookup().in(javaImplClass).unreflect(javaMethod);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalArgumentException("method handle not found for method with name [" + whitelistMethod.javaMethodName + "] and parameters " + whitelistMethod.painlessParameterTypeNames);
                }
                painlessMethod = methodCache.computeIfAbsent(Definition.buildMethodCacheKey(ownerStruct.name, whitelistMethod.javaMethodName, painlessParametersTypes), key -> new Method(whitelistMethod.javaMethodName, ownerStruct, javaAugmentedClass, painlessReturnType, painlessParametersTypes, asmMethod, javaMethod.getModifiers(), javaMethodHandle));
                ownerStruct.methods.put(painlessMethodKey, painlessMethod);
            } else if (!(painlessMethod.name.equals(whitelistMethod.javaMethodName) && painlessMethod.rtn.equals(painlessReturnType) && painlessMethod.arguments.equals(painlessParametersTypes))) {
                throw new IllegalArgumentException("illegal duplicate member methods [" + painlessMethodKey + "] found within the struct [" + ownerStruct.name + "] with name [" + whitelistMethod.javaMethodName + "], return types [" + painlessReturnType + "] and [" + painlessMethod.rtn.name + "], and parameters " + painlessParametersTypes + " and " + painlessMethod.arguments);
            }
        }
    }

    private void addField(String ownerStructName, Whitelist.Field whitelistField) {
        Type painlessFieldType;
        java.lang.reflect.Field javaField;
        Struct ownerStruct = this.structsMap.get(ownerStructName);
        if (ownerStruct == null) {
            throw new IllegalArgumentException("owner struct [" + ownerStructName + "] not defined for method with name [" + whitelistField.javaFieldName + "] and type " + whitelistField.painlessFieldTypeName);
        }
        if (!TYPE_NAME_PATTERN.matcher(whitelistField.javaFieldName).matches()) {
            throw new IllegalArgumentException("invalid field name [" + whitelistField.painlessFieldTypeName + "] for owner struct [" + ownerStructName + "].");
        }
        try {
            javaField = ownerStruct.clazz.getField(whitelistField.javaFieldName);
        }
        catch (NoSuchFieldException exception) {
            throw new IllegalArgumentException("field [" + whitelistField.javaFieldName + "] not found for class [" + ownerStruct.clazz.getName() + "].");
        }
        try {
            painlessFieldType = this.getTypeInternal(whitelistField.painlessFieldTypeName);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("struct not defined for return type [" + whitelistField.painlessFieldTypeName + "] with owner struct [" + ownerStructName + "] and field with name [" + whitelistField.javaFieldName + "]", iae);
        }
        if (Modifier.isStatic(javaField.getModifiers())) {
            if (!Modifier.isFinal(javaField.getModifiers())) {
                throw new IllegalArgumentException("static [" + whitelistField.javaFieldName + "] with owner struct [" + ownerStruct.name + "] is not final");
            }
            Field painlessField = ownerStruct.staticMembers.get(whitelistField.javaFieldName);
            if (painlessField == null) {
                painlessField = fieldCache.computeIfAbsent(Definition.buildFieldCacheKey(ownerStruct.name, whitelistField.javaFieldName, painlessFieldType.name), key -> new Field(whitelistField.javaFieldName, javaField.getName(), ownerStruct, painlessFieldType, javaField.getModifiers(), null, null));
                ownerStruct.staticMembers.put(whitelistField.javaFieldName, painlessField);
            } else if (!painlessField.type.equals(painlessFieldType)) {
                throw new IllegalArgumentException("illegal duplicate static fields [" + whitelistField.javaFieldName + "] found within the struct [" + ownerStruct.name + "] with type [" + whitelistField.painlessFieldTypeName + "]");
            }
        } else {
            MethodHandle javaMethodHandleSetter;
            MethodHandle javaMethodHandleGetter;
            try {
                if (!Modifier.isStatic(javaField.getModifiers())) {
                    javaMethodHandleGetter = MethodHandles.publicLookup().unreflectGetter(javaField);
                    javaMethodHandleSetter = MethodHandles.publicLookup().unreflectSetter(javaField);
                } else {
                    javaMethodHandleGetter = null;
                    javaMethodHandleSetter = null;
                }
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("getter/setter [" + whitelistField.javaFieldName + "] not found for class [" + ownerStruct.clazz.getName() + "].");
            }
            Field painlessField = ownerStruct.members.get(whitelistField.javaFieldName);
            if (painlessField == null) {
                painlessField = fieldCache.computeIfAbsent(Definition.buildFieldCacheKey(ownerStruct.name, whitelistField.javaFieldName, painlessFieldType.name), key -> new Field(whitelistField.javaFieldName, javaField.getName(), ownerStruct, painlessFieldType, javaField.getModifiers(), javaMethodHandleGetter, javaMethodHandleSetter));
                ownerStruct.members.put(whitelistField.javaFieldName, painlessField);
            } else if (!painlessField.type.equals(painlessFieldType)) {
                throw new IllegalArgumentException("illegal duplicate member fields [" + whitelistField.javaFieldName + "] found within the struct [" + ownerStruct.name + "] with type [" + whitelistField.painlessFieldTypeName + "]");
            }
        }
    }

    private void copyStruct(String struct, List<String> children) {
        Struct owner = this.structsMap.get(struct);
        if (owner == null) {
            throw new IllegalArgumentException("Owner struct [" + struct + "] not defined for copy.");
        }
        for (int count = 0; count < children.size(); ++count) {
            Struct child = this.structsMap.get(children.get(count));
            if (child == null) {
                throw new IllegalArgumentException("Child struct [" + children.get(count) + "] not defined for copy to owner struct [" + owner.name + "].");
            }
            if (!child.clazz.isAssignableFrom(owner.clazz)) {
                throw new ClassCastException("Child struct [" + child.name + "] is not a super type of owner struct [" + owner.name + "] in copy.");
            }
            for (Map.Entry<MethodKey, Method> kvPair : child.methods.entrySet()) {
                MethodKey methodKey = kvPair.getKey();
                Method method = kvPair.getValue();
                if (owner.methods.get(methodKey) != null) continue;
                owner.methods.put(methodKey, method);
            }
            for (Field field : child.members.values()) {
                if (owner.members.get(field.name) != null) continue;
                owner.members.put(field.name, new Field(field.name, field.javaName, owner, field.type, field.modifiers, field.getter, field.setter));
            }
        }
    }

    private void addRuntimeClass(Struct struct) {
        Map<MethodKey, Method> methods = struct.methods;
        HashMap<String, MethodHandle> getters = new HashMap<String, MethodHandle>();
        HashMap<String, MethodHandle> setters = new HashMap<String, MethodHandle>();
        for (Map.Entry<String, Field> entry : struct.members.entrySet()) {
            getters.put(entry.getKey(), entry.getValue().getter);
            setters.put(entry.getKey(), entry.getValue().setter);
        }
        for (Map.Entry<Object, Object> entry : methods.entrySet()) {
            StringBuilder newName;
            String name = ((MethodKey)entry.getKey()).name;
            Method m = (Method)entry.getValue();
            if (m.arguments.size() == 0 && name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                newName = new StringBuilder();
                newName.append(Character.toLowerCase(name.charAt(3)));
                newName.append(name.substring(4));
                getters.putIfAbsent(newName.toString(), m.handle);
            } else if (m.arguments.size() == 0 && name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
                newName = new StringBuilder();
                newName.append(Character.toLowerCase(name.charAt(2)));
                newName.append(name.substring(3));
                getters.putIfAbsent(newName.toString(), m.handle);
            }
            if (m.arguments.size() != 1 || !name.startsWith("set") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3))) continue;
            newName = new StringBuilder();
            newName.append(Character.toLowerCase(name.charAt(3)));
            newName.append(name.substring(4));
            setters.putIfAbsent(newName.toString(), m.handle);
        }
        this.runtimeMap.put(struct.clazz, new RuntimeClass(struct, methods, getters, setters));
    }

    private Method computeFunctionalInterfaceMethod(Struct clazz) {
        if (!clazz.clazz.isInterface()) {
            return null;
        }
        boolean hasAnnotation = clazz.clazz.isAnnotationPresent(FunctionalInterface.class);
        ArrayList<java.lang.reflect.Method> methods = new ArrayList<java.lang.reflect.Method>();
        for (java.lang.reflect.Method m : clazz.clazz.getMethods()) {
            if (m.isDefault() || Modifier.isStatic(m.getModifiers())) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                methods.add(m);
            }
        }
        if (methods.size() != 1) {
            if (hasAnnotation) {
                throw new IllegalArgumentException("Class: " + clazz.name + " is marked with FunctionalInterface but doesn't fit the bill: " + methods);
            }
            return null;
        }
        java.lang.reflect.Method oneMethod = (java.lang.reflect.Method)methods.get(0);
        Method painless = clazz.methods.get(new MethodKey(oneMethod.getName(), oneMethod.getParameterCount()));
        if (painless == null || !painless.method.equals((Object)org.objectweb.asm.commons.Method.getMethod((java.lang.reflect.Method)oneMethod))) {
            throw new IllegalArgumentException("Class: " + clazz.name + " is functional but the functional method is not whitelisted!");
        }
        return painless;
    }

    private Type getTypeInternal(String name) {
        Type simple = this.simpleTypesMap.get(name);
        if (simple != null) {
            return simple;
        }
        int dimensions = this.getDimensions(name);
        String structstr = dimensions == 0 ? name : name.substring(0, name.indexOf(91));
        Struct struct = this.structsMap.get(structstr);
        if (struct == null) {
            throw new IllegalArgumentException("The struct with name [" + name + "] has not been defined.");
        }
        return this.getTypeInternal(struct, dimensions);
    }

    private Type getTypeInternal(Struct struct, int dimensions) {
        String name = struct.name;
        org.objectweb.asm.Type type = struct.type;
        Class<?> clazz = struct.clazz;
        if (dimensions > 0) {
            StringBuilder builder = new StringBuilder(name);
            char[] brackets = new char[dimensions];
            for (int count = 0; count < dimensions; ++count) {
                builder.append("[]");
                brackets[count] = 91;
            }
            String descriptor = new String(brackets) + struct.type.getDescriptor();
            name = builder.toString();
            type = org.objectweb.asm.Type.getType((String)descriptor);
            try {
                clazz = Class.forName(type.getInternalName().replace('/', '.'));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException("The class [" + type.getInternalName() + "] could not be found to create type [" + name + "].");
            }
        }
        return new Type(name, dimensions, "def".equals(name), struct, clazz, type);
    }

    private int getDimensions(String name) {
        int dimensions = 0;
        int index = name.indexOf(91);
        if (index != -1) {
            int length = name.length();
            while (index < length) {
                if (name.charAt(index) == '[' && ++index < length && name.charAt(index++) == ']') {
                    ++dimensions;
                    continue;
                }
                throw new IllegalArgumentException("Invalid array braces in canonical name [" + name + "].");
            }
        }
        return dimensions;
    }

    public static final class RuntimeClass {
        private final Struct struct;
        public final Map<MethodKey, Method> methods;
        public final Map<String, MethodHandle> getters;
        public final Map<String, MethodHandle> setters;

        private RuntimeClass(Struct struct, Map<MethodKey, Method> methods, Map<String, MethodHandle> getters, Map<String, MethodHandle> setters) {
            this.struct = struct;
            this.methods = Collections.unmodifiableMap(methods);
            this.getters = Collections.unmodifiableMap(getters);
            this.setters = Collections.unmodifiableMap(setters);
        }

        public Struct getStruct() {
            return this.struct;
        }
    }

    public static class Cast {
        public final Type from;
        public final Type to;
        public final boolean explicit;
        public final Type unboxFrom;
        public final Type unboxTo;
        public final Type boxFrom;
        public final Type boxTo;

        public static Cast standard(Type from, Type to, boolean explicit) {
            return new Cast(from, to, explicit, null, null, null, null);
        }

        public static Cast unboxFrom(Type from, Type to, boolean explicit, Type unboxFrom) {
            return new Cast(from, to, explicit, unboxFrom, null, null, null);
        }

        public static Cast unboxTo(Type from, Type to, boolean explicit, Type unboxTo) {
            return new Cast(from, to, explicit, null, unboxTo, null, null);
        }

        public static Cast boxFrom(Type from, Type to, boolean explicit, Type boxFrom) {
            return new Cast(from, to, explicit, null, null, boxFrom, null);
        }

        public static Cast boxTo(Type from, Type to, boolean explicit, Type boxTo) {
            return new Cast(from, to, explicit, null, null, null, boxTo);
        }

        private Cast(Type from, Type to, boolean explicit, Type unboxFrom, Type unboxTo, Type boxFrom, Type boxTo) {
            this.from = from;
            this.to = to;
            this.explicit = explicit;
            this.unboxFrom = unboxFrom;
            this.unboxTo = unboxTo;
            this.boxFrom = boxFrom;
            this.boxTo = boxTo;
        }
    }

    public static final class Struct {
        public final String name;
        public final Class<?> clazz;
        public final org.objectweb.asm.Type type;
        public final Map<MethodKey, Method> constructors;
        public final Map<MethodKey, Method> staticMethods;
        public final Map<MethodKey, Method> methods;
        public final Map<String, Field> staticMembers;
        public final Map<String, Field> members;
        private final SetOnce<Method> functionalMethod;

        private Struct(String name, Class<?> clazz, org.objectweb.asm.Type type) {
            this.name = name;
            this.clazz = clazz;
            this.type = type;
            this.constructors = new HashMap<MethodKey, Method>();
            this.staticMethods = new HashMap<MethodKey, Method>();
            this.methods = new HashMap<MethodKey, Method>();
            this.staticMembers = new HashMap<String, Field>();
            this.members = new HashMap<String, Field>();
            this.functionalMethod = new SetOnce();
        }

        private Struct(Struct struct) {
            this.name = struct.name;
            this.clazz = struct.clazz;
            this.type = struct.type;
            this.constructors = Collections.unmodifiableMap(struct.constructors);
            this.staticMethods = Collections.unmodifiableMap(struct.staticMethods);
            this.methods = Collections.unmodifiableMap(struct.methods);
            this.staticMembers = Collections.unmodifiableMap(struct.staticMembers);
            this.members = Collections.unmodifiableMap(struct.members);
            this.functionalMethod = struct.functionalMethod;
        }

        private Struct freeze() {
            return new Struct(this);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Struct struct = (Struct)object;
            return this.name.equals(struct.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public Method getFunctionalMethod() {
            return (Method)this.functionalMethod.get();
        }
    }

    public static final class MethodKey {
        public final String name;
        public final int arity;

        public MethodKey(String name, int arity) {
            this.name = Objects.requireNonNull(name);
            this.arity = arity;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.arity;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.arity != other.arity) {
                return false;
            }
            return this.name.equals(other.name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append('/');
            sb.append(this.arity);
            return sb.toString();
        }
    }

    public static final class Field {
        public final String name;
        public final Struct owner;
        public final Type type;
        public final String javaName;
        public final int modifiers;
        private final MethodHandle getter;
        private final MethodHandle setter;

        private Field(String name, String javaName, Struct owner, Type type, int modifiers, MethodHandle getter, MethodHandle setter) {
            this.name = name;
            this.javaName = javaName;
            this.owner = owner;
            this.type = type;
            this.modifiers = modifiers;
            this.getter = getter;
            this.setter = setter;
        }
    }

    public static class Method {
        public final String name;
        public final Struct owner;
        public final Class<?> augmentation;
        public final Type rtn;
        public final List<Type> arguments;
        public final org.objectweb.asm.commons.Method method;
        public final int modifiers;
        public final MethodHandle handle;

        public Method(String name, Struct owner, Class<?> augmentation, Type rtn, List<Type> arguments, org.objectweb.asm.commons.Method method, int modifiers, MethodHandle handle) {
            this.name = name;
            this.augmentation = augmentation;
            this.owner = owner;
            this.rtn = rtn;
            this.arguments = Collections.unmodifiableList(arguments);
            this.method = method;
            this.modifiers = modifiers;
            this.handle = handle;
        }

        public MethodType getMethodType() {
            Class<?> returnValue;
            Class[] params;
            if (this.handle != null) {
                return this.handle.type();
            }
            if (this.augmentation != null) {
                params = new Class[1 + this.arguments.size()];
                params[0] = this.augmentation;
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i + 1] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.rtn.clazz;
            } else if (Modifier.isStatic(this.modifiers)) {
                params = new Class[this.arguments.size()];
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.rtn.clazz;
            } else if ("<init>".equals(this.name)) {
                params = new Class[this.arguments.size()];
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.owner.clazz;
            } else {
                params = new Class[1 + this.arguments.size()];
                params[0] = this.owner.clazz;
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i + 1] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.rtn.clazz;
            }
            return MethodType.methodType(returnValue, params);
        }

        public void write(MethodWriter writer) {
            org.objectweb.asm.Type type;
            if (this.augmentation != null) {
                assert (Modifier.isStatic(this.modifiers));
                type = org.objectweb.asm.Type.getType(this.augmentation);
            } else {
                type = this.owner.type;
            }
            if (Modifier.isStatic(this.modifiers)) {
                writer.invokeStatic(type, this.method);
            } else if (Modifier.isInterface(this.owner.clazz.getModifiers())) {
                writer.invokeInterface(type, this.method);
            } else {
                writer.invokeVirtual(type, this.method);
            }
        }
    }

    public static final class Type {
        public final String name;
        public final int dimensions;
        public final boolean dynamic;
        public final Struct struct;
        public final Class<?> clazz;
        public final org.objectweb.asm.Type type;

        private Type(String name, int dimensions, boolean dynamic, Struct struct, Class<?> clazz, org.objectweb.asm.Type type) {
            this.name = name;
            this.dimensions = dimensions;
            this.dynamic = dynamic;
            this.struct = struct;
            this.clazz = clazz;
            this.type = type;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Type type = (Type)object;
            return this.type.equals((Object)type.type) && this.struct.equals(type.struct);
        }

        public int hashCode() {
            int result = this.struct.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return this.name;
        }
    }
}

