/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SDeclBlock;
import org.objectweb.asm.Label;

public final class SFor
extends AStatement {
    private ANode initializer;
    private AExpression condition;
    private AExpression afterthought;
    private final SBlock block;
    private boolean continuous = false;

    public SFor(Location location, ANode initializer, AExpression condition, AExpression afterthought, SBlock block) {
        super(location);
        this.initializer = initializer;
        this.condition = condition;
        this.afterthought = afterthought;
        this.block = block;
    }

    @Override
    void extractVariables(Set<String> variables) {
        if (this.initializer != null) {
            this.initializer.extractVariables(variables);
        }
        if (this.condition != null) {
            this.condition.extractVariables(variables);
        }
        if (this.afterthought != null) {
            this.afterthought.extractVariables(variables);
        }
        if (this.block != null) {
            this.block.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        locals = Locals.newLocalScope(locals);
        if (this.initializer != null) {
            if (this.initializer instanceof SDeclBlock) {
                this.initializer.analyze(locals);
            } else if (this.initializer instanceof AExpression) {
                AExpression initializer = (AExpression)this.initializer;
                initializer.read = false;
                initializer.analyze(locals);
                if (!initializer.statement) {
                    throw this.createError(new IllegalArgumentException("Not a statement."));
                }
                initializer.expected = initializer.actual;
                this.initializer = initializer.cast(locals);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        if (this.condition != null) {
            this.condition.expected = locals.getDefinition().booleanType;
            this.condition.analyze(locals);
            this.condition = this.condition.cast(locals);
            if (this.condition.constant != null) {
                this.continuous = (Boolean)this.condition.constant;
                if (!this.continuous) {
                    throw this.createError(new IllegalArgumentException("Extraneous for loop."));
                }
                if (this.block == null) {
                    throw this.createError(new IllegalArgumentException("For loop has no escape."));
                }
            }
        } else {
            this.continuous = true;
        }
        if (this.afterthought != null) {
            this.afterthought.read = false;
            this.afterthought.analyze(locals);
            if (!this.afterthought.statement) {
                throw this.createError(new IllegalArgumentException("Not a statement."));
            }
            this.afterthought.expected = this.afterthought.actual;
            this.afterthought = this.afterthought.cast(locals);
        }
        if (this.block != null) {
            this.block.beginLoop = true;
            this.block.inLoop = true;
            this.block.analyze(locals);
            if (this.block.loopEscape && !this.block.anyContinue) {
                throw this.createError(new IllegalArgumentException("Extraneous for loop."));
            }
            if (this.continuous && !this.block.anyBreak) {
                this.methodEscape = true;
                this.allEscape = true;
            }
            this.block.statementCount = Math.max(1, this.block.statementCount);
        }
        this.statementCount = 1;
        if (locals.hasVariable("#loop")) {
            this.loopCounter = locals.getVariable(this.location, "#loop");
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        Label start = new Label();
        Label begin = this.afterthought == null ? start : new Label();
        Label end = new Label();
        if (this.initializer instanceof SDeclBlock) {
            this.initializer.write(writer, globals);
        } else if (this.initializer instanceof AExpression) {
            AExpression initializer = (AExpression)this.initializer;
            initializer.write(writer, globals);
            writer.writePop(initializer.expected.type.getSize());
        }
        writer.mark(start);
        if (this.condition != null && !this.continuous) {
            this.condition.write(writer, globals);
            writer.ifZCmp(153, end);
        }
        boolean allEscape = false;
        if (this.block != null) {
            allEscape = this.block.allEscape;
            int statementCount = Math.max(1, this.block.statementCount);
            if (this.afterthought != null) {
                ++statementCount;
            }
            if (this.loopCounter != null) {
                writer.writeLoopCounter(this.loopCounter.getSlot(), statementCount, this.location);
            }
            this.block.continu = begin;
            this.block.brake = end;
            this.block.write(writer, globals);
        } else if (this.loopCounter != null) {
            writer.writeLoopCounter(this.loopCounter.getSlot(), 1, this.location);
        }
        if (this.afterthought != null) {
            writer.mark(begin);
            this.afterthought.write(writer, globals);
            writer.writePop(this.afterthought.expected.type.getSize());
        }
        if (this.afterthought != null || !allEscape) {
            writer.goTo(start);
        }
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.multilineToString(Collections.emptyList(), Arrays.asList(this.initializer, this.condition, this.afterthought, this.block));
    }
}

