/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.MetaPluginInfo;
import org.elasticsearch.plugins.PluginInfo;

class ListPluginsCommand
extends EnvironmentAwareCommand {
    ListPluginsCommand() {
        super("Lists installed elasticsearch plugins");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!Files.exists(env.pluginsFile(), new LinkOption[0])) {
            throw new IOException("Plugins directory missing: " + env.pluginsFile());
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "Plugins directory: " + env.pluginsFile());
        ArrayList<Path> plugins = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(env.pluginsFile());){
            for (Path plugin : paths) {
                plugins.add(plugin);
            }
        }
        Collections.sort(plugins);
        for (Path plugin : plugins) {
            if (MetaPluginInfo.isMetaPlugin((Path)plugin)) {
                MetaPluginInfo metaInfo = MetaPluginInfo.readFromProperties((Path)plugin);
                ArrayList<Path> subPluginPaths = new ArrayList<Path>();
                try (DirectoryStream<Path> subPaths = Files.newDirectoryStream(plugin);){
                    for (Path subPlugin : subPaths) {
                        if (MetaPluginInfo.isPropertiesFile((Path)subPlugin)) continue;
                        subPluginPaths.add(subPlugin);
                    }
                }
                Collections.sort(subPluginPaths);
                terminal.println(Terminal.Verbosity.SILENT, metaInfo.getName());
                for (Path subPlugin : subPluginPaths) {
                    this.printPlugin(env, terminal, subPlugin, "\t");
                }
                continue;
            }
            this.printPlugin(env, terminal, plugin, "");
        }
    }

    private void printPlugin(Environment env, Terminal terminal, Path plugin, String prefix) throws IOException {
        terminal.println(Terminal.Verbosity.SILENT, prefix + plugin.getFileName().toString());
        try {
            PluginInfo info = PluginInfo.readFromProperties((Path)env.pluginsFile().resolve(plugin.toAbsolutePath()));
            terminal.println(Terminal.Verbosity.VERBOSE, info.toString(prefix));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("incompatible with version")) {
                terminal.println("WARNING: " + e.getMessage());
            }
            throw e;
        }
    }
}

