/*
 * Decompiled with CFR 0.152.
 */
package IceGrid;

import Ice.Current;
import Ice.InputStream;
import Ice.Object;
import Ice.OutputStream;
import Ice.ValueFactory;
import IceGrid.AdapterDescriptor;
import IceGrid.CommunicatorDescriptor;
import IceGrid.DbEnvDescriptor;
import IceGrid.DistributionDescriptor;
import IceGrid.PropertySetDescriptor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ServerDescriptor
extends CommunicatorDescriptor {
    private static ValueFactory _factory = new _F();
    private static final String[] _ids = new String[]{"::Ice::Object", "::IceGrid::CommunicatorDescriptor", "::IceGrid::ServerDescriptor"};
    public String id;
    public String exe;
    public String iceVersion;
    public String pwd;
    public List<String> options;
    public List<String> envs;
    public String activation;
    public String activationTimeout;
    public String deactivationTimeout;
    public boolean applicationDistrib;
    public DistributionDescriptor distrib;
    public boolean allocatable;
    public String user;
    public static final long serialVersionUID = 1025667871710056919L;

    public ServerDescriptor() {
        this.id = "";
        this.exe = "";
        this.iceVersion = "";
        this.pwd = "";
        this.activation = "";
        this.activationTimeout = "";
        this.deactivationTimeout = "";
        this.distrib = new DistributionDescriptor();
        this.user = "";
    }

    public ServerDescriptor(List<AdapterDescriptor> adapters, PropertySetDescriptor propertySet, List<DbEnvDescriptor> dbEnvs, String[] logs, String description, String id, String exe, String iceVersion, String pwd, List<String> options, List<String> envs, String activation, String activationTimeout, String deactivationTimeout, boolean applicationDistrib, DistributionDescriptor distrib, boolean allocatable, String user) {
        super(adapters, propertySet, dbEnvs, logs, description);
        this.id = id;
        this.exe = exe;
        this.iceVersion = iceVersion;
        this.pwd = pwd;
        this.options = options;
        this.envs = envs;
        this.activation = activation;
        this.activationTimeout = activationTimeout;
        this.deactivationTimeout = deactivationTimeout;
        this.applicationDistrib = applicationDistrib;
        this.distrib = distrib;
        this.allocatable = allocatable;
        this.user = user;
    }

    public static ValueFactory ice_factory() {
        return _factory;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(_ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current current) {
        return Arrays.binarySearch(_ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return _ids;
    }

    @Override
    public String[] ice_ids(Current current) {
        return _ids;
    }

    @Override
    public String ice_id() {
        return _ids[2];
    }

    @Override
    public String ice_id(Current current) {
        return _ids[2];
    }

    public static String ice_staticId() {
        return _ids[2];
    }

    @Override
    protected void _iceWriteImpl(OutputStream ostr_) {
        ostr_.startSlice(ServerDescriptor.ice_staticId(), -1, false);
        ostr_.writeString(this.id);
        ostr_.writeString(this.exe);
        ostr_.writeString(this.iceVersion);
        ostr_.writeString(this.pwd);
        if (this.options == null) {
            ostr_.writeSize(0);
        } else {
            ostr_.writeSize(this.options.size());
            for (String elem : this.options) {
                ostr_.writeString(elem);
            }
        }
        if (this.envs == null) {
            ostr_.writeSize(0);
        } else {
            ostr_.writeSize(this.envs.size());
            for (String elem : this.envs) {
                ostr_.writeString(elem);
            }
        }
        ostr_.writeString(this.activation);
        ostr_.writeString(this.activationTimeout);
        ostr_.writeString(this.deactivationTimeout);
        ostr_.writeBool(this.applicationDistrib);
        DistributionDescriptor.ice_write(ostr_, this.distrib);
        ostr_.writeBool(this.allocatable);
        ostr_.writeString(this.user);
        ostr_.endSlice();
        super._iceWriteImpl(ostr_);
    }

    @Override
    protected void _iceReadImpl(InputStream istr_) {
        istr_.startSlice();
        this.id = istr_.readString();
        this.exe = istr_.readString();
        this.iceVersion = istr_.readString();
        this.pwd = istr_.readString();
        this.options = new LinkedList<String>();
        int len0 = istr_.readAndCheckSeqSize(1);
        for (int i0 = 0; i0 < len0; ++i0) {
            String elem = istr_.readString();
            this.options.add(elem);
        }
        this.envs = new LinkedList<String>();
        int len1 = istr_.readAndCheckSeqSize(1);
        for (int i1 = 0; i1 < len1; ++i1) {
            String elem = istr_.readString();
            this.envs.add(elem);
        }
        this.activation = istr_.readString();
        this.activationTimeout = istr_.readString();
        this.deactivationTimeout = istr_.readString();
        this.applicationDistrib = istr_.readBool();
        this.distrib = DistributionDescriptor.ice_read(istr_);
        this.allocatable = istr_.readBool();
        this.user = istr_.readString();
        istr_.endSlice();
        super._iceReadImpl(istr_);
    }

    @Override
    public ServerDescriptor clone() {
        return (ServerDescriptor)super.clone();
    }

    private static class _F
    implements ValueFactory {
        private _F() {
        }

        @Override
        public Object create(String type) {
            assert (type.equals(ServerDescriptor.ice_staticId()));
            return new ServerDescriptor();
        }
    }
}

