/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Utils;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class SimpleMapField
extends JTable {
    private DefaultTableModel _model;
    private Vector<String> _columnNames;
    private boolean _editable = false;
    private boolean _substituteKey;
    private Editor _editor;

    public SimpleMapField(Editor editor, boolean substituteKey, String headKey, String headValue) {
        this._editor = editor;
        this._substituteKey = substituteKey;
        this._columnNames = new Vector(2);
        this._columnNames.add(headKey);
        this._columnNames.add(headValue);
        int fontSize = this.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this.rowHeight < minRowHeight) {
            this.setRowHeight(minRowHeight);
        }
        AbstractAction deleteRow = new AbstractAction("Delete selected row(s)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleMapField.this._editable) {
                    int selectedRow;
                    if (SimpleMapField.this.isEditing()) {
                        SimpleMapField.this.getCellEditor().stopCellEditing();
                    }
                    while ((selectedRow = SimpleMapField.this.getSelectedRow()) != -1) {
                        SimpleMapField.this._model.removeRow(selectedRow);
                    }
                }
            }
        };
        this.getActionMap().put("delete", deleteRow);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    public void set(Map<String, String> map, Utils.Resolver resolver, boolean editable) {
        this._editable = editable;
        Vector vector = new Vector(map.size());
        for (Map.Entry<String, String> p : map.entrySet()) {
            Vector<String> row = new Vector<String>(2);
            if (this._substituteKey) {
                row.add(Utils.substitute(p.getKey(), resolver));
            } else {
                row.add(p.getKey());
            }
            row.add(Utils.substitute(p.getValue(), resolver));
            vector.add(row);
        }
        if (this._editable) {
            Vector<String> newRow = new Vector<String>(2);
            newRow.add("");
            newRow.add("");
            vector.add(newRow);
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return SimpleMapField.this._editable;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (SimpleMapField.this._editable) {
                    Object lastKey = SimpleMapField.this._model.getValueAt(SimpleMapField.this._model.getRowCount() - 1, 0);
                    if (lastKey != null && !lastKey.equals("")) {
                        Object[] emptyRow = new Object[]{"", ""};
                        SimpleMapField.this._model.addRow(emptyRow);
                    }
                    SimpleMapField.this._editor.updated();
                }
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(this._editable);
        this.setOpaque(this._editable);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(this._editable);
    }

    public TreeMap<String, String> get() {
        assert (this._editable);
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Vector row : vector) {
            String key = (String)row.elementAt(0);
            if (key == null || (key = key.trim()).equals("")) continue;
            String val = (String)row.elementAt(1);
            if (val == null) {
                val = "";
            }
            result.put(key, val);
        }
        return result;
    }
}

