/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.datatransfer.LayerTransferable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class LayerListTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        LayerListDialog.LayerListModel tableModel;
        if (c instanceof JTable && !(tableModel = (LayerListDialog.LayerListModel)((JTable)c).getModel()).getSelectedLayers().isEmpty()) {
            int actions = 2;
            if (LayerListTransferHandler.onlyDataLayersSelected(tableModel)) {
                actions |= 1;
            }
            return actions;
        }
        return 0;
    }

    private static boolean onlyDataLayersSelected(LayerListDialog.LayerListModel tableModel) {
        for (Layer l : tableModel.getSelectedLayers()) {
            if (l instanceof OsmDataLayer) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTable) {
            LayerListDialog.LayerListModel tableModel = (LayerListDialog.LayerListModel)((JTable)c).getModel();
            return new LayerTransferable(tableModel.getLayerManager(), tableModel.getSelectedLayers());
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDrop()) {
            support.setShowDropLocation(true);
        }
        if (!support.isDataFlavorSupported(LayerTransferable.LAYER_DATA)) {
            return false;
        }
        return support.getDropAction() != 0x40000000;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            boolean isSameLayerManager;
            TransferHandler.DropLocation dl;
            LayerListDialog.LayerListModel tableModel = (LayerListDialog.LayerListModel)((JTable)support.getComponent()).getModel();
            LayerTransferable.Data layers = (LayerTransferable.Data)support.getTransferable().getTransferData(LayerTransferable.LAYER_DATA);
            int dropLocation = support.isDrop() ? ((dl = support.getDropLocation()) instanceof JTable.DropLocation ? ((JTable.DropLocation)dl).getRow() : 0) : layers.getLayers().get(0).getDefaultLayerPosition().getPosition(layers.getManager());
            boolean bl = isSameLayerManager = tableModel.getLayerManager() == layers.getManager();
            if (isSameLayerManager && support.getDropAction() == 2) {
                for (Layer layer : layers.getLayers()) {
                    boolean wasBeforeInsert;
                    boolean bl2 = wasBeforeInsert = layers.getManager().getLayers().indexOf(layer) <= dropLocation;
                    if (wasBeforeInsert) {
                        --dropLocation;
                    }
                    layers.getManager().moveLayer(layer, dropLocation);
                    ++dropLocation;
                }
            } else {
                List<Layer> layersToUse = layers.getLayers();
                if (support.getDropAction() == 1) {
                    layersToUse = LayerListTransferHandler.createCopy(layersToUse, layers.getManager().getLayers());
                }
                for (Layer layer : layersToUse) {
                    layers.getManager().addLayer(layer);
                    layers.getManager().moveLayer(layer, dropLocation);
                    ++dropLocation;
                }
            }
            return true;
        }
        catch (UnsupportedFlavorException e) {
            Logging.warn("Flavor not supported", e);
            return false;
        }
        catch (IOException e) {
            Logging.warn("Error while pasting layer", e);
            return false;
        }
    }

    private static List<Layer> createCopy(List<Layer> layersToUse, List<Layer> namesToAvoid) {
        List<String> layerNames = LayerListTransferHandler.getNames(namesToAvoid);
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer layer : layersToUse) {
            if (!(layer instanceof OsmDataLayer)) continue;
            String newName = LayerListTransferHandler.suggestNewLayerName(layer.getName(), layerNames);
            OsmDataLayer newLayer = new OsmDataLayer(new DataSet(((OsmDataLayer)layer).data), newName, null);
            layers.add(newLayer);
            layerNames.add(newName);
        }
        return layers;
    }

    public static String suggestNewLayerName(String name, List<Layer> namesToAvoid) {
        List<String> layerNames = LayerListTransferHandler.getNames(namesToAvoid);
        return LayerListTransferHandler.suggestNewLayerName(name, layerNames);
    }

    private static List<String> getNames(List<Layer> namesToAvoid) {
        ArrayList<String> layerNames = new ArrayList<String>();
        for (Layer l : namesToAvoid) {
            layerNames.add(l.getName());
        }
        return layerNames;
    }

    private static String suggestNewLayerName(String name, Collection<String> layerNames) {
        String newName = I18n.tr("Copy of {0}", name);
        int i = 2;
        while (layerNames.contains(newName)) {
            newName = I18n.tr("Copy {1} of {0}", name, i);
            ++i;
        }
        return newName;
    }
}

