/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openstreetmap.josm.gui.io.SaveLayersModel;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;

class UploadAndSaveProgressRenderer
extends JPanel
implements ProgressRenderer,
PropertyChangeListener {
    private final JLabel lblTaskTitle = new JLabel("");
    private final JLabel lblCustomText = new JLabel("");
    private final JProgressBar progressBar = new JProgressBar(0);

    UploadAndSaveProgressRenderer() {
        this.build();
        this.setVisible(false);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.lblTaskTitle, gc);
        this.lblTaskTitle.setLabelFor(this.lblCustomText);
        gc.gridy = 1;
        this.add((Component)this.lblCustomText, gc);
        this.lblCustomText.setLabelFor(this.progressBar);
        gc.gridy = 2;
        this.add((Component)this.progressBar, gc);
    }

    @Override
    public void setCustomText(String message) {
        this.lblCustomText.setText(message);
        this.repaint();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.repaint();
    }

    @Override
    public void setMaximum(int maximum) {
        this.progressBar.setMaximum(maximum);
        this.repaint();
    }

    @Override
    public void setTaskTitle(String taskTitle) {
        this.lblTaskTitle.setText(taskTitle);
        this.repaint();
    }

    @Override
    public void setValue(int value) {
        this.progressBar.setValue(value);
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
            this.setVisible(SaveLayersModel.Mode.UPLOADING_AND_SAVING.equals(evt.getNewValue()));
        }
        this.getParent().validate();
    }
}

