/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.CompositeVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentStateWithDependents;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.internal.component.model.ComponentResolveMetadata;

class LatestModuleConflictResolver
implements ModuleConflictResolver {
    private final Comparator<Version> versionComparator;

    LatestModuleConflictResolver(VersionComparator versionComparator) {
        this.versionComparator = versionComparator.asVersionComparator();
    }

    @Override
    public <T extends ComponentResolutionState> void select(ConflictResolverDetails<T> details) {
        Version baseVersion = null;
        LinkedHashMap<Version, ComponentResolutionState> matches = new LinkedHashMap<Version, ComponentResolutionState>();
        Collection<T> candidates = details.getCandidates();
        for (ComponentResolutionState candidate : candidates) {
            Version version = VersionParser.INSTANCE.transform(candidate.getVersion());
            if (baseVersion == null || this.versionComparator.compare(version.getBaseVersion(), baseVersion) > 0) {
                boolean accept = true;
                for (ComponentResolutionState t : candidates) {
                    VersionSelector rejectedVersionSelector;
                    ResolvedVersionConstraint candidateConstraints = t.getVersionConstraint();
                    if (t == candidate || candidateConstraints == null || (rejectedVersionSelector = candidateConstraints.getRejectedSelector()) == null || !rejectedVersionSelector.accept(version)) continue;
                    accept = false;
                    break;
                }
                baseVersion = version.getBaseVersion();
                if (accept) {
                    matches.put(version, candidate);
                    continue;
                }
                matches.clear();
                continue;
            }
            if (!version.getBaseVersion().equals(baseVersion)) continue;
            matches.put(version, candidate);
        }
        if (matches.isEmpty()) {
            boolean hasRejectAll = false;
            for (ComponentResolutionState candidate : candidates) {
                hasRejectAll |= LatestModuleConflictResolver.isRejectAll(candidate.getVersionConstraint());
            }
            StringBuilder sb = new StringBuilder();
            if (hasRejectAll) {
                sb.append("Module ");
            } else {
                sb.append("Cannot find a version of ");
            }
            boolean first = true;
            for (ComponentResolutionState candidate : candidates) {
                if (first) {
                    sb.append("'").append(candidate.getId().getModule()).append("'");
                    if (hasRejectAll) {
                        sb.append(" has been rejected:\n");
                    } else {
                        sb.append(" that satisfies the version constraints: \n");
                    }
                }
                if (candidate instanceof ComponentStateWithDependents) {
                    ComponentStateWithDependents component = (ComponentStateWithDependents)candidate;
                    List<String> paths = this.pathTo(component);
                    for (String path : paths) {
                        sb.append("   ").append(path).append("\n");
                    }
                } else {
                    sb.append(LatestModuleConflictResolver.renderVersionConstraint(candidate.getVersionConstraint()));
                }
                first = false;
            }
            details.fail((Throwable)new GradleException(sb.toString()));
            return;
        }
        if (matches.size() == 1) {
            details.select((ComponentResolutionState)matches.values().iterator().next());
            return;
        }
        ArrayList sorted = new ArrayList(matches.keySet());
        Collections.sort(sorted, Collections.reverseOrder(this.versionComparator));
        for (Version version : sorted) {
            ComponentResolutionState component = (ComponentResolutionState)matches.get(version);
            if (!version.isQualified()) {
                details.select(component);
                return;
            }
            ComponentResolveMetadata metaData = component.getMetaData();
            if (metaData == null || !"release".equals(metaData.getStatus())) continue;
            details.select(component);
            return;
        }
        details.select((ComponentResolutionState)matches.get(sorted.get(0)));
    }

    private List<String> pathTo(ComponentStateWithDependents component) {
        ArrayList acc = Lists.newArrayListWithExpectedSize((int)1);
        this.pathTo(component, Lists.newArrayList(), acc, Sets.newHashSet());
        ArrayList result = Lists.newArrayListWithCapacity((int)acc.size());
        for (List path : acc) {
            ComponentStateWithDependents target = (ComponentStateWithDependents)Iterators.getLast(path.iterator());
            StringBuilder sb = new StringBuilder();
            if (target.isFromPendingNode()) {
                sb.append("Constraint path ");
            } else {
                sb.append("Dependency path ");
            }
            Iterator iterator = path.iterator();
            while (iterator.hasNext()) {
                ComponentStateWithDependents e = (ComponentStateWithDependents)iterator.next();
                ModuleVersionIdentifier id = e.getId();
                if (iterator.hasNext()) {
                    sb.append('\'').append(id).append('\'');
                    sb.append(" --> ");
                    continue;
                }
                sb.append('\'').append(id.getGroup()).append(':').append(id.getName()).append('\'');
                sb.append(" ").append(LatestModuleConflictResolver.renderVersionConstraint(e.getVersionConstraint()));
                this.renderReason(sb, e);
            }
            result.add(sb.toString());
        }
        return result;
    }

    private void renderReason(StringBuilder sb, ComponentStateWithDependents e) {
        ComponentSelectionReasonInternal selectionReason = e.getSelectionReason();
        if (selectionReason.hasCustomDescriptions()) {
            sb.append(" because of the following reason");
            ArrayList reasons = Lists.newArrayListWithExpectedSize((int)1);
            for (ComponentSelectionDescriptor componentSelectionDescriptor : selectionReason.getDescriptions()) {
                ComponentSelectionDescriptorInternal next = (ComponentSelectionDescriptorInternal)componentSelectionDescriptor;
                if (!next.hasCustomDescription()) continue;
                reasons.add(next.getDescription());
            }
            if (reasons.size() == 1) {
                sb.append(": ").append((String)reasons.get(0));
            } else {
                sb.append("s: ");
                Joiner.on((String)", ").appendTo(sb, (Iterable)reasons);
            }
        }
    }

    private void pathTo(ComponentStateWithDependents component, List<ComponentStateWithDependents> currentPath, List<List<ComponentStateWithDependents>> accumulator, Set<ComponentStateWithDependents> alreadySeen) {
        if (alreadySeen.add(component)) {
            currentPath.add(0, component);
            List dependents = component.getDependents();
            List unattachedDependencies = component.getUnattachedDependencies();
            LinkedHashSet allDependents = Sets.newLinkedHashSet();
            allDependents.addAll(dependents);
            allDependents.addAll(unattachedDependencies);
            for (ComponentStateWithDependents dependent : allDependents) {
                ArrayList otherPath = Lists.newArrayList(currentPath);
                this.pathTo(dependent, otherPath, accumulator, alreadySeen);
            }
            if (allDependents.isEmpty()) {
                accumulator.add(currentPath);
            }
        }
    }

    private static String renderVersionConstraint(ResolvedVersionConstraint constraint) {
        if (LatestModuleConflictResolver.isRejectAll(constraint)) {
            return "rejects all versions";
        }
        VersionSelector preferredSelector = constraint.getPreferredSelector();
        VersionSelector rejectedSelector = constraint.getRejectedSelector();
        StringBuilder sb = new StringBuilder("prefers ");
        sb.append('\'');
        sb.append(preferredSelector.getSelector());
        sb.append('\'');
        if (rejectedSelector != null) {
            sb.append(", rejects ");
            if (rejectedSelector instanceof CompositeVersionSelector) {
                sb.append("any of \"");
                int i = 0;
                for (VersionSelector selector : ((CompositeVersionSelector)rejectedSelector).getSelectors()) {
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append('\'');
                    sb.append(selector.getSelector());
                    sb.append('\'');
                }
                sb.append("\"");
            } else {
                sb.append('\'');
                sb.append(rejectedSelector.getSelector());
                sb.append('\'');
            }
        }
        return sb.toString();
    }

    private static boolean isRejectAll(ResolvedVersionConstraint constraint) {
        return "".equals(constraint.getPreferredVersion()) && LatestModuleConflictResolver.hasMatchAllSelector(constraint.getRejectedVersions());
    }

    private static boolean hasMatchAllSelector(List<String> rejectedVersions) {
        for (String version : rejectedVersions) {
            if (!"+".equals(version)) continue;
            return true;
        }
        return false;
    }
}

