/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequests;

public class BuildDefinition {
    private final File buildRootDir;
    private final StartParameter startParameter;
    private final PluginRequests injectedSettingsPlugins;

    public BuildDefinition(File buildRootDir, StartParameter startParameter, PluginRequests injectedSettingsPlugins) {
        this.buildRootDir = buildRootDir;
        this.startParameter = startParameter;
        this.injectedSettingsPlugins = injectedSettingsPlugins;
    }

    @Nullable
    public File getBuildRootDir() {
        return this.buildRootDir;
    }

    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public PluginRequests getInjectedPluginRequests() {
        return this.injectedSettingsPlugins;
    }

    public static BuildDefinition fromStartParameterForBuild(StartParameter startParameter, File buildRootDir, PluginRequests pluginRequests) {
        StartParameter includedBuildStartParam = startParameter.newBuild();
        includedBuildStartParam.setCurrentDir(buildRootDir);
        includedBuildStartParam.setSearchUpwards(false);
        includedBuildStartParam.setConfigureOnDemand(false);
        includedBuildStartParam.setInitScripts(startParameter.getInitScripts());
        return new BuildDefinition(buildRootDir, includedBuildStartParam, pluginRequests);
    }

    public static BuildDefinition fromStartParameter(StartParameter startParameter) {
        return new BuildDefinition(null, startParameter, DefaultPluginRequests.EMPTY);
    }

    public BuildDefinition newInstance() {
        return new BuildDefinition(this.buildRootDir, this.startParameter.newInstance(), this.injectedSettingsPlugins);
    }
}

