/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppApplication;
import org.gradle.language.cpp.internal.DefaultCppExecutable;
import org.gradle.language.cpp.internal.NativeVariant;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;

@Incubating
public class CppApplicationPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public CppApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        ObjectFactory objectFactory = project.getObjects();
        final DefaultCppApplication application = this.componentFactory.newInstance(CppApplication.class, DefaultCppApplication.class, "main");
        project.getExtensions().add(CppApplication.class, "application", (Object)application);
        project.getComponents().add((Object)application);
        application.getBaseName().set((Object)project.getName());
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ToolChainSelector.Result<CppPlatform> result = CppApplicationPlugin.this.toolChainSelector.select(CppPlatform.class);
                DefaultCppExecutable debugExecutable = application.addExecutable("debug", true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                application.addExecutable("release", true, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                application.getDevelopmentBinary().set((Object)debugExecutable);
                ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
            }
        });
        final Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
        ((DefaultBinaryCollection)application.getBinaries()).whenElementKnown(DefaultCppExecutable.class, new Action<DefaultCppExecutable>(){

            public void execute(DefaultCppExecutable executable) {
                Configuration runtimeElements = (Configuration)executable.getRuntimeElements().get();
                NativeVariant variant = new NativeVariant(executable.getNames(), runtimeUsage, (Set<? extends PublishArtifact>)runtimeElements.getAllArtifacts(), runtimeElements);
                application.getMainPublication().addVariant((SoftwareComponent)variant);
            }
        });
    }
}

