/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.ConnectionInfo;
import Ice.Current;
import Ice.DispatchInterceptorAsyncCallback;
import Ice.Exception;
import Ice.FacetNotExistException;
import Ice.FormatType;
import Ice.IPConnectionInfo;
import Ice.Identity;
import Ice.Instrumentation.DispatchObserver;
import Ice.LocalException;
import Ice.LocalObjectHolder;
import Ice.MarshalException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import Ice.RequestFailedException;
import Ice.ServantLocator;
import Ice.SystemException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import Ice.UserException;
import Ice.Util;
import IceInternal.Instance;
import IceInternal.Protocol;
import IceInternal.ResponseHandler;
import IceInternal.ServantError;
import IceUtilInternal.OutputBase;
import IceUtilInternal.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;

class IncomingBase {
    protected Instance _instance;
    protected Current _current;
    protected Object _servant;
    protected ServantLocator _locator;
    protected LocalObjectHolder _cookie;
    protected DispatchObserver _observer;
    protected boolean _response;
    protected byte _compress;
    protected FormatType _format;
    protected OutputStream _os;
    protected ResponseHandler _responseHandler;
    protected LinkedList<DispatchInterceptorAsyncCallback> _interceptorCBs;

    protected IncomingBase(Instance instance, ResponseHandler handler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._instance = instance;
        this._responseHandler = handler;
        this._response = response;
        this._compress = compress;
        this._format = FormatType.DefaultFormat;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = connection;
        this._current.requestId = requestId;
    }

    protected IncomingBase(IncomingBase other) {
        this._current = other._current;
        this._instance = other._instance;
        this._servant = other._servant;
        this._locator = other._locator;
        this._response = other._response;
        this._compress = other._compress;
        this._format = other._format;
        this._responseHandler = other._responseHandler;
        this._observer = other._observer;
        other._observer = null;
        this._cookie = other._cookie;
        other._cookie = null;
        if (other._interceptorCBs != null) {
            this._interceptorCBs = new LinkedList<DispatchInterceptorAsyncCallback>(other._interceptorCBs);
        }
    }

    public OutputStream startWriteParams() {
        if (!this._response) {
            throw new MarshalException("can't marshal out parameters for oneway dispatch");
        }
        this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
        this._os.writeBlob(Protocol.replyHdr);
        this._os.writeInt(this._current.requestId);
        this._os.writeByte((byte)0);
        this._os.startEncapsulation(this._current.encoding, this._format);
        return this._os;
    }

    public void endWriteParams() {
        if (this._response) {
            this._os.endEncapsulation();
        }
    }

    public void writeEmptyParams() {
        if (this._response) {
            this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
            this._os.writeBlob(Protocol.replyHdr);
            this._os.writeInt(this._current.requestId);
            this._os.writeByte((byte)0);
            this._os.writeEmptyEncapsulation(this._current.encoding);
        }
    }

    public void writeParamEncaps(byte[] v, boolean ok) {
        if (!ok && this._observer != null) {
            this._observer.userException();
        }
        if (this._response) {
            this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
            this._os.writeBlob(Protocol.replyHdr);
            this._os.writeInt(this._current.requestId);
            this._os.writeByte(ok ? (byte)0 : 1);
            if (v == null || v.length == 0) {
                this._os.writeEmptyEncapsulation(this._current.encoding);
            } else {
                this._os.writeEncapsulation(v);
            }
        }
    }

    public void reset(Instance instance, ResponseHandler handler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._instance = instance;
        this._responseHandler = handler;
        this._response = response;
        this._compress = compress;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = connection;
        this._current.requestId = requestId;
        this._interceptorCBs = null;
    }

    public void reclaim() {
        this._current = null;
        this._servant = null;
        this._locator = null;
        if (this._cookie != null) {
            this._cookie.value = null;
        }
        assert (this._observer == null);
        this._os = null;
        this._responseHandler = null;
        this._interceptorCBs = null;
    }

    protected final void response(boolean amd) {
        try {
            if (this._locator != null && !this.servantLocatorFinished(amd)) {
                return;
            }
            assert (this._responseHandler != null);
            if (this._response) {
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (LocalException ex) {
            this._responseHandler.invokeException(this._current.requestId, ex, 1, amd);
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
    }

    protected final void exception(Throwable exc, boolean amd) {
        try {
            if (this._locator != null && !this.servantLocatorFinished(amd)) {
                return;
            }
            this.handleException(exc, amd);
        }
        catch (LocalException ex) {
            this._responseHandler.invokeException(this._current.requestId, ex, 1, amd);
        }
    }

    protected final void warning(Throwable ex) {
        assert (this._instance != null);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        OutputBase out = new OutputBase(pw);
        out.setUseTab(false);
        out.print("dispatch exception:");
        out.print("\nidentity: " + Util.identityToString(this._current.id, this._instance.toStringMode()));
        out.print("\nfacet: " + StringUtil.escapeString(this._current.facet, "", this._instance.toStringMode()));
        out.print("\noperation: " + this._current.operation);
        if (this._current.con != null) {
            try {
                ConnectionInfo connInfo = this._current.con.getInfo();
                while (connInfo != null) {
                    if (connInfo instanceof IPConnectionInfo) {
                        IPConnectionInfo ipConnInfo = (IPConnectionInfo)connInfo;
                        out.print("\nremote host: " + ipConnInfo.remoteAddress + " remote port: " + ipConnInfo.remotePort);
                    }
                    connInfo = connInfo.underlying;
                }
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
        out.print("\n");
        ex.printStackTrace(pw);
        pw.flush();
        this._instance.initializationData().logger.warning(sw.toString());
    }

    protected final boolean servantLocatorFinished(boolean amd) {
        assert (this._locator != null && this._servant != null);
        try {
            assert (this._cookie != null);
            this._locator.finished(this._current, this._servant, this._cookie.value);
            return true;
        }
        catch (Throwable ex) {
            this.handleException(ex, amd);
            return false;
        }
    }

    protected final void handleException(Throwable exc, boolean amd) {
        block58: {
            assert (this._responseHandler != null);
            if (exc instanceof SystemException && this._responseHandler.systemException(this._current.requestId, (SystemException)exc, amd)) {
                return;
            }
            try {
                throw exc;
            }
            catch (RequestFailedException ex) {
                if (ex.id == null || ex.id.name == null || ex.id.name.isEmpty()) {
                    ex.id = this._current.id;
                }
                if (ex.facet == null || ex.facet.isEmpty()) {
                    ex.facet = this._current.facet;
                }
                if (ex.operation == null || ex.operation.length() == 0) {
                    ex.operation = this._current.operation;
                }
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    if (ex instanceof ObjectNotExistException) {
                        this._os.writeByte((byte)2);
                    } else if (ex instanceof FacetNotExistException) {
                        this._os.writeByte((byte)3);
                    } else if (ex instanceof OperationNotExistException) {
                        this._os.writeByte((byte)4);
                    } else assert (false);
                    ex.id.ice_writeMembers(this._os);
                    if (ex.facet == null || ex.facet.length() == 0) {
                        this._os.writeStringSeq(null);
                    } else {
                        String[] facetPath2 = new String[]{ex.facet};
                        this._os.writeStringSeq(facetPath2);
                    }
                    this._os.writeString(ex.operation);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UnknownLocalException ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)5);
                    this._os.writeString(ex.unknown);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UnknownUserException ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)6);
                    this._os.writeString(ex.unknown);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UnknownException ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)7);
                    this._os.writeString(ex.unknown);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (Exception ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)5);
                    StringWriter sw = new StringWriter();
                    sw.write(ex.ice_id() + "\n");
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._os.writeString(sw.toString());
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UserException ex) {
                if (this._observer != null) {
                    this._observer.userException();
                }
                if (this._response) {
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)1);
                    this._os.startEncapsulation(this._current.encoding, this._format);
                    this._os.writeException(ex);
                    this._os.endEncapsulation();
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (Throwable ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.getClass().getName());
                }
                if (this._response) {
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)7);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._os.writeString(sw.toString());
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
                if (this._observer != null) {
                    this._observer.detach();
                    this._observer = null;
                }
                this._responseHandler = null;
                if (amd || !(ex instanceof Error)) break block58;
                throw new ServantError((Error)ex);
            }
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
    }
}

