/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.commons.AnnotationRemapper;
import org.jruby.org.objectweb.asm.commons.Remapper;

public class MethodRemapper
extends MethodVisitor {
    protected final Remapper remapper;

    public MethodRemapper(MethodVisitor mv, Remapper remapper) {
        this(393216, mv, remapper);
    }

    protected MethodRemapper(int api, MethodVisitor mv, Remapper remapper) {
        super(api, mv);
        this.remapper = remapper;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor av = super.visitAnnotationDefault();
        return av == null ? av : new AnnotationRemapper(av, this.remapper);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(this.remapper.mapDesc(desc), visible);
        return av == null ? av : new AnnotationRemapper(av, this.remapper);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitor av = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(desc), visible);
        return av == null ? av : new AnnotationRemapper(av, this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor av = super.visitParameterAnnotation(parameter, this.remapper.mapDesc(desc), visible);
        return av == null ? av : new AnnotationRemapper(av, this.remapper);
    }

    public void visitFrame(int type2, int nLocal, Object[] local2, int nStack, Object[] stack) {
        super.visitFrame(type2, nLocal, this.remapEntries(nLocal, local2), nStack, this.remapEntries(nStack, stack));
    }

    private Object[] remapEntries(int n, Object[] entries2) {
        if (entries2 != null) {
            for (int i2 = 0; i2 < n; ++i2) {
                if (!(entries2[i2] instanceof String)) continue;
                Object[] newEntries = new Object[n];
                if (i2 > 0) {
                    System.arraycopy(entries2, 0, newEntries, 0, i2);
                }
                do {
                    Object t = entries2[i2];
                    Object object = newEntries[i2++] = t instanceof String ? this.remapper.mapType((String)t) : t;
                } while (i2 < n);
                return newEntries;
            }
        }
        return entries2;
    }

    public void visitFieldInsn(int opcode, String owner2, String name2, String desc) {
        super.visitFieldInsn(opcode, this.remapper.mapType(owner2), this.remapper.mapFieldName(owner2, name2, desc), this.remapper.mapDesc(desc));
    }

    @Deprecated
    public void visitMethodInsn(int opcode, String owner2, String name2, String desc) {
        if (this.api >= 327680) {
            super.visitMethodInsn(opcode, owner2, name2, desc);
            return;
        }
        this.doVisitMethodInsn(opcode, owner2, name2, desc, opcode == 185);
    }

    public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
        if (this.api < 327680) {
            super.visitMethodInsn(opcode, owner2, name2, desc, itf);
            return;
        }
        this.doVisitMethodInsn(opcode, owner2, name2, desc, itf);
    }

    private void doVisitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, this.remapper.mapType(owner2), this.remapper.mapMethodName(owner2, name2, desc), this.remapper.mapMethodDesc(desc), itf);
        }
    }

    public void visitInvokeDynamicInsn(String name2, String desc, Handle bsm, Object ... bsmArgs) {
        for (int i2 = 0; i2 < bsmArgs.length; ++i2) {
            bsmArgs[i2] = this.remapper.mapValue(bsmArgs[i2]);
        }
        super.visitInvokeDynamicInsn(this.remapper.mapInvokeDynamicMethodName(name2, desc), this.remapper.mapMethodDesc(desc), (Handle)this.remapper.mapValue(bsm), bsmArgs);
    }

    public void visitTypeInsn(int opcode, String type2) {
        super.visitTypeInsn(opcode, this.remapper.mapType(type2));
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(this.remapper.mapValue(cst));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(desc), dims);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitor av = super.visitInsnAnnotation(typeRef, typePath, this.remapper.mapDesc(desc), visible);
        return av == null ? av : new AnnotationRemapper(av, this.remapper);
    }

    public void visitTryCatchBlock(Label start2, Label end2, Label handler, String type2) {
        super.visitTryCatchBlock(start2, end2, handler, type2 == null ? null : this.remapper.mapType(type2));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitor av = super.visitTryCatchAnnotation(typeRef, typePath, this.remapper.mapDesc(desc), visible);
        return av == null ? av : new AnnotationRemapper(av, this.remapper);
    }

    public void visitLocalVariable(String name2, String desc, String signature, Label start2, Label end2, int index2) {
        super.visitLocalVariable(name2, this.remapper.mapDesc(desc), this.remapper.mapSignature(signature, true), start2, end2, index2);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start2, Label[] end2, int[] index2, String desc, boolean visible) {
        AnnotationVisitor av = super.visitLocalVariableAnnotation(typeRef, typePath, start2, end2, index2, this.remapper.mapDesc(desc), visible);
        return av == null ? av : new AnnotationRemapper(av, this.remapper);
    }
}

