/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private final AreaInstance myArea;
    private final String myName;
    private final String myClassName;
    private final ExtensionPoint.Kind myKind;
    private volatile T[] myExtensionsCache;
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    private Set<ExtensionComponentAdapter> myExtensionAdapters;
    private final List<ExtensionPointListener<T>> myEPListeners;
    private List<ExtensionComponentAdapter> myLoadedAdapters;
    private Class<T> myExtensionClass;
    private static final StringInterner INTERNER = new StringInterner();
    private boolean processingAdaptersNow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtensionPointImpl(@NotNull String name, @NotNull String className2, @NotNull ExtensionPoint.Kind kind, @NotNull ExtensionsAreaImpl owner, AreaInstance area, @NotNull PluginDescriptor descriptor2) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        this.myEPListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = INTERNER.intern(name);
        }
        this.myClassName = className2;
        this.myKind = kind;
        this.myOwner = owner;
        this.myArea = area;
        this.myDescriptor = descriptor2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public ExtensionPoint.Kind getKind() {
        ExtensionPoint.Kind kind = this.myKind;
        if (kind == null) {
            ExtensionPointImpl.$$$reportNull$$$0(7);
        }
        return kind;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(8);
        }
        this.registerExtension(extension, LoadingOrder.ANY);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        return pluginDescriptor;
    }

    public synchronized void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order);
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index2;
            for (index2 = this.getLoadedAdaptersSize(); index2 > 0 && (lastAdapter = this.myLoadedAdapters.get(index2 - 1)).getOrder() == LoadingOrder.LAST; --index2) {
            }
            this.registerExtension(extension, adapter, index2, true);
        } else {
            this.registerExtensionAdapter(adapter);
            this.processAdapters();
        }
    }

    private int getLoadedAdaptersSize() {
        List<ExtensionComponentAdapter> loadedAdapters = this.myLoadedAdapters;
        return loadedAdapters == null ? 0 : loadedAdapters.size();
    }

    private void registerExtension(@NotNull T extension, @NotNull ExtensionComponentAdapter adapter, int index2, boolean runNotifications) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        if (this.getExtensionIndex(extension) != -1) {
            this.myOwner.error("Extension was already added: " + extension);
            return;
        }
        Class<T> extensionClass = this.getExtensionClass();
        if (!extensionClass.isInstance(extension)) {
            this.myOwner.error("Extension " + extension.getClass() + " does not implement " + extensionClass);
            return;
        }
        if (this.myLoadedAdapters == null) {
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myLoadedAdapters.add(index2, adapter);
        if (runNotifications) {
            this.clearCache();
            if (!adapter.isNotificationSent()) {
                if (extension instanceof Extension) {
                    try {
                        ((Extension)extension).extensionAdded(this);
                    }
                    catch (Throwable e) {
                        this.myOwner.error(e);
                    }
                }
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor());
                adapter.setNotificationSent(true);
            }
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(14);
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] result2 = this.myExtensionsCache;
        if (result2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result2 = this.myExtensionsCache;
                if (result2 == null) {
                    result2 = this.processAdapters();
                    if (result2 == null) {
                        result2 = (Object[])Array.newInstance(this.getExtensionClass(), 0);
                    }
                    this.myExtensionsCache = result2;
                }
            }
        }
        Object[] objectArray = result2.length == 0 ? result2 : (Object[])result2.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        T[] cache2 = this.myExtensionsCache;
        if (cache2 != null) {
            return cache2.length > 0;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.getExtensionAdaptersSize() + this.getLoadedAdaptersSize() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means empty")
    private T[] processAdapters() {
        if (this.processingAdaptersNow) {
            throw new IllegalStateException("Recursive processAdapters() detected. You must have called 'getExtensions()' from within your extension constructor - don't. Either pass extension via constructor parameter or call getExtensions() later.");
        }
        int totalSize = this.getExtensionAdaptersSize() + this.getLoadedAdaptersSize();
        if (totalSize == 0) {
            return null;
        }
        this.processingAdaptersNow = true;
        try {
            Class<T> extensionClass = this.getExtensionClass();
            Object[] result2 = (Object[])Array.newInstance(extensionClass, totalSize);
            ArrayList adapters = ContainerUtil.newArrayListWithCapacity(totalSize);
            if (this.myExtensionAdapters != null) {
                adapters.addAll(this.myExtensionAdapters);
            }
            if (this.myLoadedAdapters != null) {
                adapters.addAll(this.myLoadedAdapters);
            }
            LoadingOrder.sort(adapters);
            this.myExtensionAdapters = new LinkedHashSet(adapters);
            Set<ExtensionComponentAdapter> loaded = ContainerUtil.newHashOrEmptySet(this.myLoadedAdapters);
            this.myLoadedAdapters = null;
            boolean errorHappened = false;
            for (int i = 0; i < adapters.size(); ++i) {
                ExtensionComponentAdapter adapter;
                block15: {
                    adapter = (ExtensionComponentAdapter)adapters.get(i);
                    try {
                        Object extension = adapter.getExtension();
                        if (extension == null) {
                            errorHappened = true;
                            LOG.error("null extension in: " + adapter + ";\ngetExtensionClass(): " + this.getExtensionClass() + ";\n");
                        }
                        if (i > 0 && extension == result2[i - 1]) {
                            errorHappened = true;
                            LOG.error("Duplicate extension found: " + extension + ";  Adapter:      " + adapter + ";\n Prev adapter: " + adapters.get(i - 1) + ";\n getExtensionClass(): " + this.getExtensionClass() + ";\n result:" + Arrays.asList(result2));
                        }
                        if (!extensionClass.isInstance(extension)) {
                            errorHappened = true;
                            this.myOwner.error("Extension " + (extension == null ? null : extension.getClass()) + " does not implement " + extensionClass + ". It came from " + adapter);
                            continue;
                        }
                        result2[i] = extension;
                        this.registerExtension(extension, adapter, this.getLoadedAdaptersSize(), !loaded.contains(adapter));
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        errorHappened = true;
                        if ("org.jetbrains.uast.kotlin.KotlinUastLanguagePlugin".equals(adapter.getAssignableToClassName()) || "org.jetbrains.uast.java.JavaUastLanguagePlugin".equals(adapter.getAssignableToClassName())) break block15;
                        LOG.error(e);
                    }
                }
                this.myExtensionAdapters.remove(adapter);
            }
            this.myExtensionAdapters = null;
            if (errorHappened) {
                result2 = ContainerUtil.findAllAsArray(result2, Condition.NOT_NULL);
            }
            Object[] objectArray = result2;
            return objectArray;
        }
        finally {
            this.processingAdaptersNow = false;
        }
    }

    private int getExtensionAdaptersSize() {
        return this.myExtensionAdapters == null ? 0 : this.myExtensionAdapters.size();
    }

    @Override
    public synchronized boolean hasExtension(@NotNull T extension) {
        T[] extensions;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        return (extensions = this.processAdapters()) != null && ArrayUtil.contains(extension, extensions);
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        int index2;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        if ((index2 = this.getExtensionIndex(extension)) == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index2);
        Object key = adapter.getComponentKey();
        this.myOwner.getPicoContainer().unregisterComponent(key);
        this.processAdapters();
        this.unregisterExtension(extension, null);
    }

    private int getExtensionIndex(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        if (this.myLoadedAdapters == null) {
            return -1;
        }
        for (int i = 0; i < this.myLoadedAdapters.size(); ++i) {
            ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(i);
            if (!Comparing.equal(adapter.getExtension(), extension)) continue;
            return i;
        }
        return -1;
    }

    private void unregisterExtension(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        int index2;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        if ((index2 = this.getExtensionIndex(extension)) == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        this.myLoadedAdapters.remove(index2);
        this.clearCache();
        this.notifyListenersOnRemove(extension, pluginDescriptor);
        if (extension instanceof Extension) {
            try {
                ((Extension)extension).extensionRemoved(this);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, PluginDescriptor pluginDescriptor) {
        if (extensionObject == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        this.processAdapters();
        if (this.myEPListeners.add(listener)) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters == null ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionAdded(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myOwner.error(e);
                }
            }
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(26);
        }
        this.removeExtensionPointListener(listener, true);
    }

    private synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        if (this.myEPListeners.remove(listener) && invokeForLoadedExtensions) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters == null ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionRemoved(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myOwner.error(e);
                }
            }
        }
    }

    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(28);
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(29);
        }
        if (this.myExtensionAdapters == null) {
            this.myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
        }
        this.myExtensionAdapters.add(adapter);
        this.clearCache();
    }

    private void clearCache() {
        this.myExtensionsCache = null;
    }

    final synchronized void notifyAreaReplaced(ExtensionsArea area) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(area);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 13: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 28: {
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnAdd";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasExtension";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIndex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnRemove";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionAdapter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionAdapter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private final Object myExtension;
        private final LoadingOrder myLoadingOrder;

        private ObjectComponentAdapter(@NotNull Object extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            super(extension.getClass().getName(), null, null, null, false);
            this.myExtension = extension;
            this.myLoadingOrder = loadingOrder;
        }

        @Override
        public Object getExtension() {
            return this.myExtension;
        }

        @Override
        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        @Override
        @Nullable
        public String getOrderId() {
            return null;
        }

        @Override
        @NonNls
        public Element getDescribingElement() {
            return new Element("RuntimeExtension: " + this.myExtension);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loadingOrder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

