/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class DescriptorUtils {
    public static final Name ENUM_VALUES = Name.identifier("values");
    public static final Name ENUM_VALUE_OF = Name.identifier("valueOf");
    public static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");
    private static final FqName VOLATILE = new FqName("kotlin.jvm.Volatile");
    private static final FqName SYNCHRONIZED = new FqName("kotlin.jvm.Synchronized");
    public static final FqName COROUTINES_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.experimental");
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME = COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("intrinsics"));
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME = COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("Continuation"));

    private DescriptorUtils() {
    }

    @Nullable
    public static ReceiverParameterDescriptor getDispatchReceiverParameterIfNeeded(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            return classDescriptor.getThisAsReceiverParameter();
        }
        return null;
    }

    public static boolean isLocal(@NotNull DeclarationDescriptor descriptor2) {
        for (DeclarationDescriptor current = descriptor2; current != null; current = current.getContainingDeclaration()) {
            if (!DescriptorUtils.isAnonymousObject(current) && !DescriptorUtils.isDescriptorWithLocalVisibility(current)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescriptorWithLocalVisibility(DeclarationDescriptor current) {
        return current instanceof DeclarationDescriptorWithVisibility && ((DeclarationDescriptorWithVisibility)current).getVisibility() == Visibilities.LOCAL;
    }

    @NotNull
    public static FqNameUnsafe getFqName(@NotNull DeclarationDescriptor descriptor2) {
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor2);
        return safe != null ? safe.toUnsafe() : DescriptorUtils.getFqNameUnsafe(descriptor2);
    }

    @NotNull
    public static FqName getFqNameSafe(@NotNull DeclarationDescriptor descriptor2) {
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor2);
        return safe != null ? safe : DescriptorUtils.getFqNameUnsafe(descriptor2).toSafe();
    }

    @Nullable
    private static FqName getFqNameSafeIfPossible(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ModuleDescriptor || ErrorUtils.isError(descriptor2)) {
            return FqName.ROOT;
        }
        if (descriptor2 instanceof PackageViewDescriptor) {
            return ((PackageViewDescriptor)descriptor2).getFqName();
        }
        if (descriptor2 instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)descriptor2).getFqName();
        }
        return null;
    }

    @NotNull
    private static FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration != null) : "Not package/module descriptor doesn't have containing declaration: " + descriptor2;
        return DescriptorUtils.getFqName(containingDeclaration).child(descriptor2.getName());
    }

    @NotNull
    public static FqName getFqNameFromTopLevelClass(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        Name name = descriptor2.getName();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return FqName.topLevel(name);
        }
        return DescriptorUtils.getFqNameFromTopLevelClass(containingDeclaration).child(name);
    }

    public static boolean isTopLevelDeclaration(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 != null && descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static boolean isExtension(@NotNull CallableDescriptor descriptor2) {
        return descriptor2.getExtensionReceiverParameter() != null;
    }

    public static boolean isOverride(@NotNull CallableMemberDescriptor descriptor2) {
        return !descriptor2.getOverriddenDescriptors().isEmpty();
    }

    public static boolean isStaticDeclaration(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 instanceof ConstructorDescriptor) {
            return false;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        return container2 instanceof PackageFragmentDescriptor || container2 instanceof ClassDescriptor && descriptor2.getDispatchReceiverParameter() == null;
    }

    public static boolean areInSameModule(@NotNull DeclarationDescriptor first2, @NotNull DeclarationDescriptor second) {
        return DescriptorUtils.getContainingModule(first2).equals(DescriptorUtils.getContainingModule(second));
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor2, @NotNull Class<D> aClass2) {
        return DescriptorUtils.getParentOfType(descriptor2, aClass2, true);
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor2, @NotNull Class<D> aClass2, boolean strict) {
        if (descriptor2 == null) {
            return null;
        }
        if (strict) {
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        while (descriptor2 != null) {
            if (aClass2.isInstance(descriptor2)) {
                return (D)descriptor2;
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return null;
    }

    @NotNull
    public static ModuleDescriptor getContainingModule(@NotNull DeclarationDescriptor descriptor2) {
        ModuleDescriptor module2 = DescriptorUtils.getContainingModuleOrNull(descriptor2);
        assert (module2 != null) : "Descriptor without a containing module: " + descriptor2;
        return module2;
    }

    @Nullable
    public static ModuleDescriptor getContainingModuleOrNull(@NotNull DeclarationDescriptor descriptor2) {
        while (descriptor2 != null) {
            if (descriptor2 instanceof ModuleDescriptor) {
                return (ModuleDescriptor)descriptor2;
            }
            if (descriptor2 instanceof PackageViewDescriptor) {
                return ((PackageViewDescriptor)descriptor2).getModule();
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull DeclarationDescriptor descriptor2) {
        for (DeclarationDescriptor containing = descriptor2.getContainingDeclaration(); containing != null; containing = containing.getContainingDeclaration()) {
            if (!(containing instanceof ClassDescriptor) || DescriptorUtils.isCompanionObject(containing)) continue;
            return (ClassDescriptor)containing;
        }
        return null;
    }

    public static boolean isAncestor(@Nullable DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor, boolean strict) {
        DeclarationDescriptor descriptor2;
        if (ancestor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor2 = strict ? declarationDescriptor.getContainingDeclaration() : declarationDescriptor;
        while (descriptor2 != null) {
            if (ancestor == descriptor2) {
                return true;
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return false;
    }

    public static boolean isDirectSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        for (KotlinType superType : subClass.getTypeConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSameClass(superType, superClass.getOriginal())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        return DescriptorUtils.isSubtypeOfClass(subClass.getDefaultType(), superClass.getOriginal());
    }

    private static boolean isSameClass(@NotNull KotlinType type2, @NotNull DeclarationDescriptor other) {
        DeclarationDescriptor originalDescriptor;
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && (originalDescriptor = descriptor2.getOriginal()) instanceof ClassifierDescriptor && other instanceof ClassifierDescriptor && ((ClassifierDescriptor)other).getTypeConstructor().equals(((ClassifierDescriptor)originalDescriptor).getTypeConstructor());
    }

    public static boolean isSubtypeOfClass(@NotNull KotlinType type2, @NotNull DeclarationDescriptor superClass) {
        if (DescriptorUtils.isSameClass(type2, superClass)) {
            return true;
        }
        for (KotlinType superType : type2.getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(superType, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompanionObject(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.OBJECT) && ((ClassDescriptor)descriptor2).isCompanionObject();
    }

    public static boolean isSealedClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.CLASS) && ((ClassDescriptor)descriptor2).getModality() == Modality.SEALED;
    }

    public static boolean isAnonymousObject(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isClass(descriptor2) && descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isAnonymousFunction(@NotNull DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getName().equals(SpecialNames.ANONYMOUS_FUNCTION);
    }

    public static boolean isNonCompanionObject(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.OBJECT) && !((ClassDescriptor)descriptor2).isCompanionObject();
    }

    public static boolean isObject(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.OBJECT);
    }

    public static boolean isEnumEntry(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ENUM_ENTRY);
    }

    public static boolean isEnumClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isInterface(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.INTERFACE);
    }

    public static boolean isClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.CLASS);
    }

    public static boolean isClassOrEnumClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isClass(descriptor2) || DescriptorUtils.isEnumClass(descriptor2);
    }

    private static boolean isKindOf(@Nullable DeclarationDescriptor descriptor2, @NotNull ClassKind classKind) {
        return descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == classKind;
    }

    @NotNull
    public static List<ClassDescriptor> getSuperclassDescriptors(@NotNull ClassDescriptor classDescriptor) {
        Collection<KotlinType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        ArrayList<ClassDescriptor> superClassDescriptors = new ArrayList<ClassDescriptor>();
        for (KotlinType type2 : superclassTypes) {
            ClassDescriptor result2 = DescriptorUtils.getClassDescriptorForType(type2);
            if (KotlinBuiltIns.isAny(result2)) continue;
            superClassDescriptors.add(result2);
        }
        return superClassDescriptors;
    }

    @NotNull
    public static KotlinType getSuperClassType(@NotNull ClassDescriptor classDescriptor) {
        Collection<KotlinType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        for (KotlinType type2 : superclassTypes) {
            ClassDescriptor superClassDescriptor = DescriptorUtils.getClassDescriptorForType(type2);
            if (superClassDescriptor.getKind() == ClassKind.INTERFACE) continue;
            return type2;
        }
        return DescriptorUtilsKt.getBuiltIns(classDescriptor).getAnyType();
    }

    @Nullable
    public static ClassDescriptor getSuperClassDescriptor(@NotNull ClassDescriptor classDescriptor) {
        Collection<KotlinType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        for (KotlinType type2 : superclassTypes) {
            ClassDescriptor superClassDescriptor = DescriptorUtils.getClassDescriptorForType(type2);
            if (superClassDescriptor.getKind() == ClassKind.INTERFACE) continue;
            return superClassDescriptor;
        }
        return null;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForType(@NotNull KotlinType type2) {
        return DescriptorUtils.getClassDescriptorForTypeConstructor(type2.getConstructor());
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        ClassifierDescriptor descriptor2 = typeConstructor2.getDeclarationDescriptor();
        assert (descriptor2 instanceof ClassDescriptor) : "Classifier descriptor of a type should be of type ClassDescriptor: " + typeConstructor2;
        return (ClassDescriptor)descriptor2;
    }

    @NotNull
    public static Visibility getDefaultConstructorVisibility(@NotNull ClassDescriptor classDescriptor) {
        ClassKind classKind = classDescriptor.getKind();
        if (classKind == ClassKind.ENUM_CLASS || classKind.isSingleton() || DescriptorUtils.isSealedClass(classDescriptor)) {
            return Visibilities.PRIVATE;
        }
        if (DescriptorUtils.isAnonymousObject(classDescriptor)) {
            return Visibilities.DEFAULT_VISIBILITY;
        }
        assert (classKind == ClassKind.CLASS || classKind == ClassKind.INTERFACE || classKind == ClassKind.ANNOTATION_CLASS);
        return Visibilities.PUBLIC;
    }

    @Nullable
    public static ClassDescriptor getInnerClassByName(@NotNull ClassDescriptor classDescriptor, @NotNull String innerClassName, @NotNull LookupLocation location2) {
        ClassifierDescriptor classifier2 = classDescriptor.getDefaultType().getMemberScope().getContributedClassifier(Name.identifier(innerClassName), location2);
        assert (classifier2 instanceof ClassDescriptor) : "Inner class " + innerClassName + " in " + classDescriptor + " should be instance of ClassDescriptor, but was: " + (classifier2 == null ? "null" : classifier2.getClass());
        return (ClassDescriptor)classifier2;
    }

    @Nullable
    public static KotlinType getReceiverParameterType(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
        return receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
    }

    public static boolean isStaticNestedClass(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        return descriptor2 instanceof ClassDescriptor && containing instanceof ClassDescriptor && !((ClassDescriptor)descriptor2).isInner();
    }

    public static boolean isTopLevelOrInnerClass(@NotNull ClassDescriptor descriptor2) {
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        return DescriptorUtils.isTopLevelDeclaration(descriptor2) || containing instanceof ClassDescriptor && DescriptorUtils.isTopLevelOrInnerClass((ClassDescriptor)containing);
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> D unwrapFakeOverride(@NotNull D descriptor2) {
        while (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Collection<? extends CallableMemberDescriptor> overridden = descriptor2.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor2);
            }
            descriptor2 = overridden.iterator().next();
        }
        return descriptor2;
    }

    @NotNull
    public static <D extends DeclarationDescriptorWithVisibility> D unwrapFakeOverrideToAnyDeclaration(@NotNull D descriptor2) {
        if (descriptor2 instanceof CallableMemberDescriptor) {
            return (D)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
        }
        return descriptor2;
    }

    public static boolean shouldRecordInitializerForProperty(@NotNull VariableDescriptor variable2, @NotNull KotlinType type2) {
        if (variable2.isVar() || KotlinTypeKt.isError(type2)) {
            return false;
        }
        if (TypeUtils.acceptsNullable(type2)) {
            return true;
        }
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(variable2);
        return KotlinBuiltIns.isPrimitiveType(type2) || KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getStringType(), type2) || KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getNumber().getDefaultType(), type2) || KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getAnyType(), type2);
    }

    public static boolean classCanHaveAbstractFakeOverride(@NotNull ClassDescriptor classDescriptor) {
        return DescriptorUtils.classCanHaveAbstractDeclaration(classDescriptor) || classDescriptor.isExpect();
    }

    public static boolean classCanHaveAbstractDeclaration(@NotNull ClassDescriptor classDescriptor) {
        return classDescriptor.getModality() == Modality.ABSTRACT || DescriptorUtils.isSealedClass(classDescriptor) || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
    }

    public static boolean classCanHaveOpenMembers(@NotNull ClassDescriptor classDescriptor) {
        return classDescriptor.getModality() != Modality.FINAL || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
    }

    @NotNull
    public static <D extends CallableDescriptor> Set<D> getAllOverriddenDescriptors(@NotNull D f) {
        LinkedHashSet result2 = new LinkedHashSet();
        DescriptorUtils.collectAllOverriddenDescriptors(f.getOriginal(), result2);
        return result2;
    }

    private static <D extends CallableDescriptor> void collectAllOverriddenDescriptors(@NotNull D current, @NotNull Set<D> result2) {
        if (result2.contains(current)) {
            return;
        }
        for (CallableDescriptor callableDescriptor : current.getOriginal().getOverriddenDescriptors()) {
            CallableDescriptor descriptor2 = callableDescriptor.getOriginal();
            DescriptorUtils.collectAllOverriddenDescriptors(descriptor2, result2);
            result2.add(descriptor2);
        }
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Set<D> getAllOverriddenDeclarations(@NotNull D memberDescriptor) {
        HashSet<CallableMemberDescriptor> result2 = new HashSet<CallableMemberDescriptor>();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result2.add(callableMemberDescriptor);
            } else if (kind != CallableMemberDescriptor.Kind.DELEGATION && kind != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
            result2.addAll(DescriptorUtils.getAllOverriddenDeclarations(callableMemberDescriptor));
        }
        return result2;
    }

    public static boolean isSingletonOrAnonymousObject(@NotNull ClassDescriptor classDescriptor) {
        return classDescriptor.getKind().isSingleton() || DescriptorUtils.isAnonymousObject(classDescriptor);
    }

    public static boolean canHaveDeclaredConstructors(@NotNull ClassDescriptor classDescriptor) {
        return !DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor) && !DescriptorUtils.isInterface(classDescriptor);
    }

    @Nullable
    public static String getJvmName(@NotNull Annotated annotated) {
        return DescriptorUtils.getJvmName(DescriptorUtils.getJvmNameAnnotation(annotated));
    }

    @Nullable
    private static String getJvmName(@Nullable AnnotationDescriptor jvmNameAnnotation) {
        if (jvmNameAnnotation == null) {
            return null;
        }
        Map<Name, ConstantValue<?>> arguments2 = jvmNameAnnotation.getAllValueArguments();
        if (arguments2.isEmpty()) {
            return null;
        }
        ConstantValue<?> name = arguments2.values().iterator().next();
        if (!(name instanceof StringValue)) {
            return null;
        }
        return (String)((StringValue)name).getValue();
    }

    @Nullable
    public static AnnotationDescriptor getAnnotationByFqName(@NotNull Annotations annotations2, @NotNull FqName name) {
        AnnotationWithTarget annotationWithTarget = Annotations.Companion.findAnyAnnotation(annotations2, name);
        return annotationWithTarget == null ? null : annotationWithTarget.getAnnotation();
    }

    @Nullable
    public static AnnotationDescriptor getJvmNameAnnotation(@NotNull Annotated annotated) {
        return DescriptorUtils.getAnnotationByFqName(annotated.getAnnotations(), JVM_NAME);
    }

    @Nullable
    public static AnnotationDescriptor getVolatileAnnotation(@NotNull Annotated annotated) {
        return DescriptorUtils.getAnnotationByFqName(annotated.getAnnotations(), VOLATILE);
    }

    @Nullable
    public static AnnotationDescriptor getSynchronizedAnnotation(@NotNull Annotated annotated) {
        return DescriptorUtils.getAnnotationByFqName(annotated.getAnnotations(), SYNCHRONIZED);
    }

    @NotNull
    public static SourceFile getContainingSourceFile(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof PropertySetterDescriptor) {
            descriptor2 = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
        }
        if (descriptor2 instanceof DeclarationDescriptorWithSource) {
            return ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile();
        }
        return SourceFile.NO_SOURCE_FILE;
    }

    @NotNull
    public static Collection<DeclarationDescriptor> getAllDescriptors(@NotNull MemberScope scope) {
        return scope.getContributedDescriptors(DescriptorKindFilter.ALL, MemberScope.Companion.getALL_NAME_FILTER());
    }

    @NotNull
    public static FunctionDescriptor getFunctionByName(@NotNull MemberScope scope, @NotNull Name name) {
        FunctionDescriptor result2 = DescriptorUtils.getFunctionByNameOrNull(scope, name);
        if (result2 == null) {
            throw new IllegalStateException("Function not found");
        }
        return result2;
    }

    @Nullable
    public static FunctionDescriptor getFunctionByNameOrNull(@NotNull MemberScope scope, @NotNull Name name) {
        Collection<SimpleFunctionDescriptor> functions2 = scope.getContributedFunctions(name, NoLookupLocation.FROM_BACKEND);
        for (SimpleFunctionDescriptor d : functions2) {
            if (!name.equals(d.getOriginal().getName())) continue;
            return d;
        }
        return null;
    }

    @NotNull
    public static PropertyDescriptor getPropertyByName(@NotNull MemberScope scope, @NotNull Name name) {
        Collection<PropertyDescriptor> properties2 = scope.getContributedVariables(name, NoLookupLocation.FROM_BACKEND);
        for (PropertyDescriptor d : properties2) {
            if (!name.equals(d.getOriginal().getName())) continue;
            return d;
        }
        throw new IllegalStateException("Property not found");
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor2) {
        return descriptor2 instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty() : descriptor2;
    }
}

