/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.network;

import com.sun.webpane.platform.Invoker;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.webkit.network.ByteBufferAllocator;
import com.sun.webpane.webkit.network.ByteBufferPool;
import com.sun.webpane.webkit.network.DirectoryURLConnection;
import com.sun.webpane.webkit.network.FormDataElement;
import com.sun.webpane.webkit.network.URLs;
import com.sun.webpane.webkit.network.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;
import sun.net.www.ParseUtil;

public class URLLoader
implements Runnable {
    private static final Logger logger = Logger.getLogger(URLLoader.class.getName());
    private static final int MAX_REDIRECTS = 10;
    private static final int MAX_BUF_COUNT = 3;
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final String DELETE = "DELETE";
    private final WebPage webPage;
    private final ByteBufferPool byteBufferPool;
    private final boolean asynchronous;
    private String url;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final long data;
    private volatile boolean canceled = false;

    URLLoader(WebPage webPage, ByteBufferPool byteBufferPool, boolean bl, String string, String string2, String string3, FormDataElement[] formDataElementArray, long l) {
        this.webPage = webPage;
        this.byteBufferPool = byteBufferPool;
        this.asynchronous = bl;
        this.url = string;
        this.method = string2;
        this.headers = string3;
        this.formDataElements = formDataElementArray;
        this.data = l;
    }

    private void fwkCancel() {
        logger.log(Level.FINEST, "Canceling: [{0}]", this.url);
        this.canceled = true;
    }

    @Override
    public void run() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                URLLoader.this.doRun();
                return null;
            }
        }, this.webPage.getAccessControlContext());
    }

    private void doRun() {
        Throwable throwable = null;
        int n = 0;
        try {
            int n2 = 0;
            boolean bl = true;
            while (true) {
                int n3;
                String string = this.url;
                if (this.url.startsWith("file:") && (n3 = this.url.indexOf(63)) != -1) {
                    string = this.url.substring(0, n3);
                }
                URL uRL = URLs.newURL(string);
                URLLoader.workaround7177996(uRL);
                URLConnection uRLConnection = uRL.openConnection();
                this.prepareConnection(uRLConnection);
                Redirect redirect = null;
                try {
                    this.sendRequest(uRLConnection, bl);
                    redirect = this.receiveResponse(uRLConnection);
                }
                catch (HttpRetryException httpRetryException) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    throw httpRetryException;
                }
                finally {
                    URLLoader.close(uRLConnection);
                    continue;
                }
                if (redirect != null) {
                    if (n2++ >= 10) {
                        throw new TooManyRedirectsException();
                    }
                    boolean bl2 = !redirect.preserveRequest && !this.method.equals(GET) && !this.method.equals(HEAD);
                    String string2 = bl2 ? GET : this.method;
                    this.willSendRequest(redirect.url, string2, uRLConnection);
                    if (!this.canceled) {
                        this.url = redirect.url;
                        this.method = string2;
                        this.formDataElements = bl2 ? null : this.formDataElements;
                        continue;
                    }
                }
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throwable = malformedURLException;
            n = 2;
        }
        catch (AccessControlException accessControlException) {
            throwable = accessControlException;
            n = 8;
        }
        catch (UnknownHostException unknownHostException) {
            throwable = unknownHostException;
            n = 1;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            throwable = noRouteToHostException;
            n = 6;
        }
        catch (ConnectException connectException) {
            throwable = connectException;
            n = 4;
        }
        catch (SocketException socketException) {
            throwable = socketException;
            n = 5;
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            throwable = sSLHandshakeException;
            n = 3;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throwable = socketTimeoutException;
            n = 7;
        }
        catch (InvalidResponseException invalidResponseException) {
            throwable = invalidResponseException;
            n = 9;
        }
        catch (TooManyRedirectsException tooManyRedirectsException) {
            throwable = tooManyRedirectsException;
            n = 10;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throwable = fileNotFoundException;
            n = 11;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n = 99;
        }
        if (throwable != null) {
            if (n == 99) {
                logger.log(Level.WARNING, "Unexpected error", throwable);
            } else {
                logger.log(Level.FINEST, "Load error", throwable);
            }
            this.didFail(n, throwable.getMessage());
        }
    }

    private static void workaround7177996(URL uRL) throws FileNotFoundException {
        if (!uRL.getProtocol().equals("file")) {
            return;
        }
        String string = uRL.getHost();
        if (string == null || string.equals("") || string.equals("~") || string.equalsIgnoreCase("localhost")) {
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            String string2 = ParseUtil.decode(uRL.getPath());
            string2 = string2.replace('/', '\\');
            string2 = string2.replace('|', ':');
            File file = new File("\\\\" + string + string2);
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + uRL);
            }
        } else {
            throw new FileNotFoundException("File not found: " + uRL);
        }
    }

    private void prepareConnection(URLConnection uRLConnection) throws IOException {
        uRLConnection.setConnectTimeout(30000);
        uRLConnection.setReadTimeout(3600000);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Accept-Language", "en-us,en;q=0.5");
        uRLConnection.setRequestProperty("Accept-Encoding", "gzip");
        uRLConnection.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        if (this.headers != null && this.headers.length() > 0) {
            for (String string : this.headers.split("\n")) {
                int n = string.indexOf(58);
                if (n <= 0) continue;
                uRLConnection.addRequestProperty(string.substring(0, n), string.substring(n + 2));
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            String[] stringArray = (String[])uRLConnection;
            stringArray.setRequestMethod(this.method);
            stringArray.setInstanceFollowRedirects(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(URLConnection uRLConnection, boolean bl) throws IOException {
        OutputStream outputStream = null;
        try {
            int n;
            long l = 0L;
            int n2 = n = this.formDataElements != null && uRLConnection instanceof HttpURLConnection && !this.method.equals(DELETE) ? 1 : 0;
            if (n != 0) {
                uRLConnection.setDoOutput(true);
                for (FormDataElement formDataElement : this.formDataElements) {
                    formDataElement.open();
                    l += formDataElement.getSize();
                }
                if (bl) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    if (l <= Integer.MAX_VALUE) {
                        httpURLConnection.setFixedLengthStreamingMode((int)l);
                    } else {
                        httpURLConnection.setChunkedStreamingMode(0);
                    }
                }
            }
            int n3 = this.method.equals(GET) || this.method.equals(HEAD) ? 3 : 1;
            uRLConnection.setConnectTimeout(uRLConnection.getConnectTimeout() / n3);
            int n4 = 0;
            while (!this.canceled) {
                try {
                    uRLConnection.connect();
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (++n4 < n3) continue;
                    throw socketTimeoutException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new MalformedURLException(this.url);
                }
            }
            if (n != 0) {
                outputStream = uRLConnection.getOutputStream();
                byte[] byArray = new byte[4096];
                long l2 = 0L;
                for (FormDataElement formDataElement : this.formDataElements) {
                    int n5;
                    InputStream inputStream = formDataElement.getInputStream();
                    while ((n5 = inputStream.read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n5);
                        this.didSendData(l2 += (long)n5, l);
                    }
                    formDataElement.close();
                }
                outputStream.flush();
                outputStream.close();
                outputStream = null;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.formDataElements != null && uRLConnection instanceof HttpURLConnection) {
                for (FormDataElement formDataElement : this.formDataElements) {
                    try {
                        formDataElement.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Redirect receiveResponse(URLConnection uRLConnection) throws IOException, InterruptedException {
        Object object;
        Object object2;
        int n;
        Object object3;
        if (this.canceled) {
            return null;
        }
        InputStream inputStream = null;
        if (uRLConnection instanceof HttpURLConnection) {
            object3 = (HttpURLConnection)uRLConnection;
            n = ((HttpURLConnection)object3).getResponseCode();
            if (n == -1) {
                throw new InvalidResponseException();
            }
            if (this.canceled) {
                return null;
            }
            switch (n) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    URL uRL;
                    object2 = ((URLConnection)object3).getHeaderField("Location");
                    if (object2 == null) break;
                    try {
                        uRL = URLs.newURL((String)object2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = URLs.newURL(uRLConnection.getURL(), (String)object2);
                    }
                    return new Redirect(uRL.toExternalForm(), n == 307);
                }
                case 304: {
                    this.didReceiveResponse(uRLConnection);
                    this.didFinishLoading();
                    return null;
                }
            }
            if (n >= 400 && !this.method.equals(HEAD)) {
                inputStream = ((HttpURLConnection)object3).getErrorStream();
            }
        }
        if (this.url.startsWith("ftp:") || this.url.startsWith("ftps:")) {
            boolean bl = false;
            n = 0;
            object2 = uRLConnection.getURL().getPath();
            if (object2 == null || ((String)object2).isEmpty() || ((String)object2).endsWith("/") || ((String)object2).contains(";type=d")) {
                bl = true;
            } else {
                object = uRLConnection.getContentType();
                if ("text/plain".equalsIgnoreCase((String)object) || "text/html".equalsIgnoreCase((String)object)) {
                    bl = true;
                    n = 1;
                }
            }
            if (bl) {
                uRLConnection = new DirectoryURLConnection(uRLConnection, n != 0);
            }
        }
        if (this.url.startsWith("file:") && "text/plain".equals(uRLConnection.getContentType()) && uRLConnection.getHeaderField("content-length") == null) {
            uRLConnection = new DirectoryURLConnection(uRLConnection);
        }
        this.didReceiveResponse(uRLConnection);
        if (this.method.equals(HEAD)) {
            this.didFinishLoading();
            return null;
        }
        object3 = inputStream == null ? uRLConnection.getInputStream() : inputStream;
        String string = uRLConnection.getContentEncoding();
        if ("gzip".equalsIgnoreCase(string)) {
            object3 = new GZIPInputStream((InputStream)object3);
        } else if ("deflate".equalsIgnoreCase(string)) {
            object3 = new InflaterInputStream((InputStream)object3);
        }
        object2 = this.byteBufferPool.newAllocator(3);
        object = null;
        try {
            byte[] byArray = new byte[8192];
            while (!this.canceled) {
                int n2;
                int n3;
                try {
                    n3 = ((InputStream)object3).read(byArray);
                }
                catch (EOFException eOFException) {
                    n3 = -1;
                }
                if (n3 == -1) break;
                if (object == null) {
                    object = object2.allocate();
                }
                if (n3 < (n2 = ((Buffer)object).remaining())) {
                    ((ByteBuffer)object).put(byArray, 0, n3);
                    continue;
                }
                ((ByteBuffer)object).put(byArray, 0, n2);
                ((ByteBuffer)object).flip();
                this.didReceiveData((ByteBuffer)object, (ByteBufferAllocator)object2);
                object = null;
                int n4 = n3 - n2;
                if (n4 <= 0) continue;
                object = object2.allocate();
                ((ByteBuffer)object).put(byArray, n2, n4);
            }
            if (!this.canceled) {
                if (object != null && ((Buffer)object).position() > 0) {
                    ((ByteBuffer)object).flip();
                    this.didReceiveData((ByteBuffer)object, (ByteBufferAllocator)object2);
                    object = null;
                }
                this.didFinishLoading();
            }
        }
        finally {
            if (object != null) {
                ((ByteBuffer)object).clear();
                object2.release((ByteBuffer)object);
            }
        }
        return null;
    }

    private static void close(URLConnection uRLConnection) {
        InputStream inputStream;
        if (uRLConnection instanceof HttpURLConnection && (inputStream = ((HttpURLConnection)uRLConnection).getErrorStream()) != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            uRLConnection.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void didSendData(final long l, final long l2) {
        this.callBack(new Runnable(){

            @Override
            public void run() {
                if (!URLLoader.this.canceled) {
                    URLLoader.twkDidSendData(l, l2, URLLoader.this.data);
                }
            }
        });
    }

    private void willSendRequest(String string, final String string2, URLConnection uRLConnection) throws InterruptedException {
        final String string3 = URLLoader.adjustUrlForWebKit(string);
        final int n = URLLoader.extractStatus(uRLConnection);
        final String string4 = uRLConnection.getContentType();
        final String string5 = URLLoader.extractContentEncoding(uRLConnection);
        final long l = URLLoader.extractContentLength(uRLConnection);
        final String string6 = URLLoader.extractHeaders(uRLConnection);
        final String string7 = URLLoader.adjustUrlForWebKit(this.url);
        final CountDownLatch countDownLatch = this.asynchronous ? new CountDownLatch(1) : null;
        this.callBack(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean bl;
                    if (!URLLoader.this.canceled && !(bl = URLLoader.twkWillSendRequest(string3, string2, n, string4, string5, l, string6, string7, URLLoader.this.data))) {
                        URLLoader.this.fwkCancel();
                    }
                }
                finally {
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }
            }
        });
        if (countDownLatch != null) {
            countDownLatch.await();
        }
    }

    private void didReceiveResponse(URLConnection uRLConnection) {
        final int n = URLLoader.extractStatus(uRLConnection);
        final String string = uRLConnection.getContentType();
        final String string2 = URLLoader.extractContentEncoding(uRLConnection);
        final long l = URLLoader.extractContentLength(uRLConnection);
        final String string3 = URLLoader.extractHeaders(uRLConnection);
        final String string4 = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(new Runnable(){

            @Override
            public void run() {
                if (!URLLoader.this.canceled) {
                    URLLoader.twkDidReceiveResponse(n, string, string2, l, string3, string4, URLLoader.this.data);
                }
            }
        });
    }

    private void didReceiveData(final ByteBuffer byteBuffer, final ByteBufferAllocator byteBufferAllocator) {
        this.callBack(new Runnable(){

            @Override
            public void run() {
                if (!URLLoader.this.canceled) {
                    URLLoader.twkDidReceiveData(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), URLLoader.this.data);
                }
                byteBuffer.clear();
                byteBufferAllocator.release(byteBuffer);
            }
        });
    }

    private void didFinishLoading() {
        this.callBack(new Runnable(){

            @Override
            public void run() {
                if (!URLLoader.this.canceled) {
                    URLLoader.twkDidFinishLoading(URLLoader.this.data);
                }
            }
        });
    }

    private void didFail(final int n, final String string) {
        final String string2 = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(new Runnable(){

            @Override
            public void run() {
                if (!URLLoader.this.canceled) {
                    URLLoader.twkDidFail(n, string2, string, URLLoader.this.data);
                }
            }
        });
    }

    private void callBack(Runnable runnable) {
        if (this.asynchronous) {
            Invoker.getInvoker().invokeOnEventThread(runnable);
        } else {
            runnable.run();
        }
    }

    private static native void twkDidSendData(long var0, long var2, long var4);

    private static native boolean twkWillSendRequest(String var0, String var1, int var2, String var3, String var4, long var5, String var7, String var8, long var9);

    private static native void twkDidReceiveResponse(int var0, String var1, String var2, long var3, String var5, String var6, long var7);

    private static native void twkDidReceiveData(ByteBuffer var0, int var1, int var2, long var3);

    private static native void twkDidFinishLoading(long var0);

    private static native void twkDidFail(int var0, String var1, String var2, long var3);

    private static int extractStatus(URLConnection uRLConnection) {
        int n = 0;
        if (uRLConnection instanceof HttpURLConnection) {
            try {
                n = ((HttpURLConnection)uRLConnection).getResponseCode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    private static String extractContentEncoding(URLConnection uRLConnection) {
        int n;
        String string;
        String string2 = uRLConnection.getContentEncoding();
        if (("gzip".equalsIgnoreCase(string2) || "deflate".equalsIgnoreCase(string2)) && (string = uRLConnection.getContentType()) != null && (n = string.indexOf("charset=")) >= 0 && (n = (string2 = string.substring(n + 8)).indexOf(";")) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static long extractContentLength(URLConnection uRLConnection) {
        try {
            return Long.parseLong(uRLConnection.getHeaderField("content-length"));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static String extractHeaders(URLConnection uRLConnection) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<String>> map = uRLConnection.getHeaderFields();
        Set<String> set = map.keySet();
        for (String string : set) {
            List<String> list = map.get(string);
            for (String string2 : list) {
                stringBuilder.append(string != null ? string : "");
                stringBuilder.append(':').append(string2).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private static String adjustUrlForWebKit(String string) {
        try {
            string = Util.adjustUrlForWebKit(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static class InvalidResponseException
    extends IOException {
        private InvalidResponseException() {
            super("Invalid server response");
        }
    }

    private static class Redirect {
        private final String url;
        private final boolean preserveRequest;

        private Redirect(String string, boolean bl) {
            this.url = string;
            this.preserveRequest = bl;
        }
    }

    private static class TooManyRedirectsException
    extends IOException {
        private TooManyRedirectsException() {
            super("Too many redirects");
        }
    }
}

