/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.InitializationException;
import Ice.Logger;
import Ice.SocketException;
import IceInternal.Network;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public final class SysLoggerI
implements Logger {
    private String _prefix;
    private int _facility;
    private DatagramSocket _socket;
    private InetAddress _host;
    private static int _port = 514;
    private static final int LOG_KERN = 0;
    private static final int LOG_USER = 1;
    private static final int LOG_MAIL = 2;
    private static final int LOG_DAEMON = 3;
    private static final int LOG_AUTH = 4;
    private static final int LOG_SYSLOG = 5;
    private static final int LOG_LPR = 6;
    private static final int LOG_NEWS = 7;
    private static final int LOG_UUCP = 8;
    private static final int LOG_CRON = 9;
    private static final int LOG_AUTHPRIV = 10;
    private static final int LOG_FTP = 11;
    private static final int LOG_LOCAL0 = 16;
    private static final int LOG_LOCAL1 = 17;
    private static final int LOG_LOCAL2 = 18;
    private static final int LOG_LOCAL3 = 19;
    private static final int LOG_LOCAL4 = 20;
    private static final int LOG_LOCAL5 = 21;
    private static final int LOG_LOCAL6 = 22;
    private static final int LOG_LOCAL7 = 23;
    private static final int LOG_ERR = 3;
    private static final int LOG_WARNING = 4;
    private static final int LOG_INFO = 6;

    public SysLoggerI(String prefix, String facilityString) {
        int facility;
        if (facilityString.equals("LOG_KERN")) {
            facility = 0;
        } else if (facilityString.equals("LOG_USER")) {
            facility = 1;
        } else if (facilityString.equals("LOG_MAIL")) {
            facility = 2;
        } else if (facilityString.equals("LOG_DAEMON")) {
            facility = 3;
        } else if (facilityString.equals("LOG_AUTH")) {
            facility = 4;
        } else if (facilityString.equals("LOG_SYSLOG")) {
            facility = 5;
        } else if (facilityString.equals("LOG_LPR")) {
            facility = 6;
        } else if (facilityString.equals("LOG_NEWS")) {
            facility = 7;
        } else if (facilityString.equals("LOG_UUCP")) {
            facility = 8;
        } else if (facilityString.equals("LOG_CRON")) {
            facility = 9;
        } else if (facilityString.equals("LOG_AUTHPRIV")) {
            facility = 10;
        } else if (facilityString.equals("LOG_FTP")) {
            facility = 11;
        } else if (facilityString.equals("LOG_LOCAL0")) {
            facility = 16;
        } else if (facilityString.equals("LOG_LOCAL1")) {
            facility = 17;
        } else if (facilityString.equals("LOG_LOCAL2")) {
            facility = 18;
        } else if (facilityString.equals("LOG_LOCAL3")) {
            facility = 19;
        } else if (facilityString.equals("LOG_LOCAL4")) {
            facility = 20;
        } else if (facilityString.equals("LOG_LOCAL5")) {
            facility = 21;
        } else if (facilityString.equals("LOG_LOCAL6")) {
            facility = 22;
        } else if (facilityString.equals("LOG_LOCAL7")) {
            facility = 23;
        } else {
            throw new InitializationException("Invalid value for Ice.SyslogFacility: " + facilityString);
        }
        this.initialize(prefix, facility);
    }

    private SysLoggerI(String prefix, int facility) {
        this.initialize(prefix, facility);
    }

    private void initialize(String prefix, int facility) {
        this._prefix = prefix;
        this._facility = facility;
        try {
            this._host = Network.getLocalAddress(2);
            this._socket = new DatagramSocket();
            this._socket.connect(this._host, _port);
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    @Override
    public void print(String message) {
        this.log(6, message);
    }

    @Override
    public void trace(String category, String message) {
        this.log(6, category + ": " + message);
    }

    @Override
    public void warning(String message) {
        this.log(4, message);
    }

    @Override
    public void error(String message) {
        this.log(3, message);
    }

    @Override
    public String getPrefix() {
        return this._prefix;
    }

    @Override
    public Logger cloneWithPrefix(String prefix) {
        return new SysLoggerI(prefix, this._facility);
    }

    private void log(int severity, String message) {
        try {
            int priority = this._facility << 3 | severity;
            String msg = '<' + Integer.toString(priority) + '>' + this._prefix + ": " + message;
            byte[] buf = msg.getBytes();
            DatagramPacket p = new DatagramPacket(buf, buf.length, this._host, _port);
            this._socket.send(p);
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }
}

