/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.EndpointSelectionType;
import Ice.Holder;
import Ice.IPEndpointInfo;
import Ice.LocalException;
import Ice.OutputStream;
import IceInternal.Acceptor;
import IceInternal.Connector;
import IceInternal.EndpointI_connectors;
import IceInternal.Transceiver;
import IceSSL.AcceptorI;
import IceSSL.ConnectorI;
import IceSSL.EndpointInfo;
import IceSSL.Instance;
import java.util.ArrayList;
import java.util.List;

final class EndpointI
extends IceInternal.EndpointI {
    private Instance _instance;
    private IceInternal.EndpointI _delegate;

    public EndpointI(Instance instance, IceInternal.EndpointI delegate) {
        this._instance = instance;
        this._delegate = delegate;
    }

    @Override
    public void streamWriteImpl(OutputStream s) {
        this._delegate.streamWriteImpl(s);
    }

    @Override
    public Ice.EndpointInfo getInfo() {
        EndpointInfo info = new EndpointInfo(this._delegate.getInfo(), this.timeout(), this.compress()){

            @Override
            public short type() {
                return EndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return EndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return EndpointI.this.secure();
            }
        };
        info.compress = info.underlying.compress;
        info.timeout = info.underlying.timeout;
        return info;
    }

    @Override
    public short type() {
        return this._delegate.type();
    }

    @Override
    public String protocol() {
        return this._delegate.protocol();
    }

    @Override
    public int timeout() {
        return this._delegate.timeout();
    }

    @Override
    public IceInternal.EndpointI timeout(int timeout) {
        if (timeout == this._delegate.timeout()) {
            return this;
        }
        return new EndpointI(this._instance, this._delegate.timeout(timeout));
    }

    @Override
    public String connectionId() {
        return this._delegate.connectionId();
    }

    @Override
    public IceInternal.EndpointI connectionId(String connectionId) {
        if (connectionId == this._delegate.connectionId()) {
            return this;
        }
        return new EndpointI(this._instance, this._delegate.connectionId(connectionId));
    }

    @Override
    public boolean compress() {
        return this._delegate.compress();
    }

    @Override
    public IceInternal.EndpointI compress(boolean compress) {
        if (compress == this._delegate.compress()) {
            return this;
        }
        return new EndpointI(this._instance, this._delegate.compress(compress));
    }

    @Override
    public boolean datagram() {
        return this._delegate.datagram();
    }

    @Override
    public boolean secure() {
        return this._delegate.secure();
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public void connectors_async(EndpointSelectionType selType, final EndpointI_connectors callback) {
        IPEndpointInfo ipInfo = null;
        Ice.EndpointInfo p = this._delegate.getInfo();
        while (p != null) {
            if (p instanceof IPEndpointInfo) {
                ipInfo = (IPEndpointInfo)p;
            }
            p = p.underlying;
        }
        final String host = ipInfo != null ? ipInfo.host : "";
        EndpointI_connectors cb = new EndpointI_connectors(){

            @Override
            public void connectors(List<Connector> connectors) {
                ArrayList<Connector> l = new ArrayList<Connector>();
                for (Connector c : connectors) {
                    l.add(new ConnectorI(EndpointI.this._instance, c, host));
                }
                callback.connectors(l);
            }

            @Override
            public void exception(LocalException ex) {
                callback.exception(ex);
            }
        };
        this._delegate.connectors_async(selType, cb);
    }

    @Override
    public Acceptor acceptor(String adapterName) {
        return new AcceptorI(this, this._instance, this._delegate.acceptor(adapterName), adapterName);
    }

    public EndpointI endpoint(IceInternal.EndpointI delEndpt) {
        if (delEndpt == this._delegate) {
            return this;
        }
        return new EndpointI(this._instance, delEndpt);
    }

    @Override
    public List<IceInternal.EndpointI> expandIfWildcard() {
        ArrayList<IceInternal.EndpointI> l = new ArrayList<IceInternal.EndpointI>();
        for (IceInternal.EndpointI e : this._delegate.expandIfWildcard()) {
            l.add(e == this._delegate ? this : new EndpointI(this._instance, e));
        }
        return l;
    }

    @Override
    public List<IceInternal.EndpointI> expandHost(Holder<IceInternal.EndpointI> publish) {
        ArrayList<IceInternal.EndpointI> l = new ArrayList<IceInternal.EndpointI>();
        for (IceInternal.EndpointI e : this._delegate.expandHost(publish)) {
            l.add(e == this._delegate ? this : new EndpointI(this._instance, e));
        }
        if (publish.value != null) {
            publish.value = publish.value == this._delegate ? this : new EndpointI(this._instance, (IceInternal.EndpointI)publish.value);
        }
        return l;
    }

    @Override
    public boolean equivalent(IceInternal.EndpointI endpoint) {
        if (!(endpoint instanceof EndpointI)) {
            return false;
        }
        EndpointI endpointI = (EndpointI)endpoint;
        return this._delegate.equivalent(endpointI._delegate);
    }

    public synchronized int hashCode() {
        return this._delegate.hashCode();
    }

    @Override
    public String options() {
        return this._delegate.options();
    }

    @Override
    public int compareTo(IceInternal.EndpointI obj) {
        if (!(obj instanceof EndpointI)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        EndpointI p = (EndpointI)obj;
        if (this == p) {
            return 0;
        }
        return this._delegate.compareTo(p._delegate);
    }

    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        return false;
    }
}

