/*
 * Decompiled with CFR 0.152.
 */
package IceUtilInternal;

import Ice.ToStringMode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class StringUtil {
    public static int findFirstOf(String str, String match) {
        return StringUtil.findFirstOf(str, match, 0);
    }

    public static int findFirstOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) == -1) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstNotOf(String str, String match) {
        return StringUtil.findFirstNotOf(str, match, 0);
    }

    public static int findFirstNotOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) != -1) continue;
            return i;
        }
        return -1;
    }

    private static void encodeChar(char c, StringBuilder sb, String special, ToStringMode toStringMode) {
        switch (c) {
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\'': {
                sb.append("\\'");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\u0007': {
                if (toStringMode == ToStringMode.Compat) {
                    sb.append("\\007");
                    break;
                }
                sb.append("\\a");
                break;
            }
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\u000b': {
                if (toStringMode == ToStringMode.Compat) {
                    sb.append("\\013");
                    break;
                }
                sb.append("\\v");
                break;
            }
            default: {
                if (special != null && special.indexOf(c) != -1) {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                if (c < ' ' || c > '~') {
                    if (toStringMode == ToStringMode.Compat) {
                        assert (c < '\u0100');
                        sb.append('\\');
                        String octal = Integer.toOctalString(c);
                        for (int j = octal.length(); j < 3; ++j) {
                            sb.append('0');
                        }
                        sb.append(octal);
                        break;
                    }
                    if (c < ' ' || c == '\u007f' || toStringMode == ToStringMode.ASCII) {
                        sb.append("\\u");
                        String hex = Integer.toHexString(c);
                        for (int j = hex.length(); j < 4; ++j) {
                            sb.append('0');
                        }
                        sb.append(hex);
                        break;
                    }
                    sb.append(c);
                    break;
                }
                sb.append(c);
            }
        }
    }

    public static String escapeString(String s, String special, ToStringMode toStringMode) {
        if (special != null) {
            for (int i = 0; i < special.length(); ++i) {
                if (special.charAt(i) >= ' ' && special.charAt(i) <= '~') continue;
                throw new IllegalArgumentException("special characters must be in ASCII range 32-126");
            }
        }
        if (toStringMode == ToStringMode.Compat) {
            byte[] bytes = null;
            try {
                bytes = s.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                assert (false);
                return null;
            }
            StringBuilder result = new StringBuilder(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                StringUtil.encodeChar((char)(bytes[i] & 0xFF), result, special, toStringMode);
            }
            return result.toString();
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (toStringMode == ToStringMode.Unicode || !Character.isSurrogate(c)) {
                StringUtil.encodeChar(c, result, special, toStringMode);
                continue;
            }
            assert (toStringMode == ToStringMode.ASCII && Character.isSurrogate(c));
            if (i + 1 == s.length()) {
                throw new IllegalArgumentException("High surrogate without low surrogate");
            }
            int codePoint = Character.toCodePoint(c, s.charAt(++i));
            result.append("\\U");
            String hex = Integer.toHexString(codePoint);
            for (int j = hex.length(); j < 8; ++j) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    private static char checkChar(String s, int pos) {
        char c = s.charAt(pos);
        if (c < ' ' || c == '\u007f') {
            String msg = pos > 0 ? "character after `" + s.substring(0, pos) + "'" : "first character";
            msg = msg + " has invalid ordinal value " + c;
            throw new IllegalArgumentException(msg);
        }
        return c;
    }

    private static int decodeChar(String s, int start, int end, String special, StringBuilder result) {
        assert (start >= 0);
        assert (start < end);
        assert (end <= s.length());
        if (s.charAt(start) != '\\') {
            result.append(StringUtil.checkChar(s, start++));
        } else if (start + 1 == end) {
            ++start;
            result.append('\\');
        } else {
            char c = s.charAt(++start);
            switch (c) {
                case '\"': 
                case '\'': 
                case '?': 
                case '\\': {
                    ++start;
                    result.append(c);
                    break;
                }
                case 'a': {
                    ++start;
                    result.append('\u0007');
                    break;
                }
                case 'b': {
                    ++start;
                    result.append('\b');
                    break;
                }
                case 'f': {
                    ++start;
                    result.append('\f');
                    break;
                }
                case 'n': {
                    ++start;
                    result.append('\n');
                    break;
                }
                case 'r': {
                    ++start;
                    result.append('\r');
                    break;
                }
                case 't': {
                    ++start;
                    result.append('\t');
                    break;
                }
                case 'v': {
                    ++start;
                    result.append('\u000b');
                }
                case 'U': 
                case 'u': {
                    int size;
                    int codePoint = 0;
                    boolean inBMP = c == 'u';
                    ++start;
                    for (size = inBMP ? 4 : 8; size > 0 && start < end; --size) {
                        c = s.charAt(start++);
                        int charVal = 0;
                        if (c >= '0' && c <= '9') {
                            charVal = c - 48;
                        } else if (c >= 'a' && c <= 'f') {
                            charVal = 10 + (c - 97);
                        } else {
                            if (c < 'A' || c > 'F') break;
                            charVal = 10 + (c - 65);
                        }
                        codePoint = codePoint * 16 + charVal;
                    }
                    if (size > 0) {
                        throw new IllegalArgumentException("Invalid universal character name: too few hex digits");
                    }
                    if (codePoint >= 55296 && codePoint <= 57343) {
                        throw new IllegalArgumentException("A universal character name cannot designate a surrogate");
                    }
                    if (inBMP || Character.isBmpCodePoint(codePoint)) {
                        result.append((char)codePoint);
                        break;
                    }
                    result.append(Character.toChars(codePoint));
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case 'x': {
                    byte[] arr = new byte[end - start];
                    int i = 0;
                    boolean more = true;
                    while (more) {
                        int charVal;
                        int val = 0;
                        if (c == 'x') {
                            int size;
                            ++start;
                            for (size = 2; size > 0 && start < end; --size) {
                                c = s.charAt(start++);
                                charVal = 0;
                                if (c >= '0' && c <= '9') {
                                    charVal = c - 48;
                                } else if (c >= 'a' && c <= 'f') {
                                    charVal = 10 + (c - 97);
                                } else if (c >= 'A' && c <= 'F') {
                                    charVal = 10 + (c - 65);
                                } else {
                                    --start;
                                    break;
                                }
                                val = val * 16 + charVal;
                            }
                            if (size == 2) {
                                throw new IllegalArgumentException("Invalid \\x escape sequence: no hex digit");
                            }
                        } else {
                            for (int j = 0; j < 3 && start < end; ++j) {
                                if ((charVal = s.charAt(start++) - 48) < 0 || charVal > 7) {
                                    --start;
                                    assert (j != 0);
                                    break;
                                }
                                val = val * 8 + charVal;
                            }
                            if (val > 255) {
                                String msg = "octal value \\" + Integer.toOctalString(val) + " (" + val + ") is out of range";
                                throw new IllegalArgumentException(msg);
                            }
                        }
                        arr[i++] = (byte)val;
                        more = false;
                        if (start + 1 >= end || s.charAt(start) != '\\' || (c = s.charAt(start + 1)) != 'x' && (c < '0' || c > '9')) continue;
                        ++start;
                        more = true;
                    }
                    try {
                        result.append(new String(arr, 0, i, "UTF8"));
                        break;
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IllegalArgumentException("unsupported encoding", ex);
                    }
                }
                default: {
                    if (special == null || special.isEmpty() || special.indexOf(c) == -1) {
                        result.append('\\');
                    }
                    result.append(StringUtil.checkChar(s, start++));
                }
            }
        }
        return start;
    }

    public static String unescapeString(String s, int start, int end, String special) {
        int p;
        assert (start >= 0 && start <= end && end <= s.length());
        if (special != null) {
            for (int i = 0; i < special.length(); ++i) {
                if (special.charAt(i) >= ' ' && special.charAt(i) <= '~') continue;
                throw new IllegalArgumentException("special characters must be in ASCII range 32-126");
            }
        }
        if ((p = s.indexOf(92, start)) == -1 || p >= end) {
            p = start;
            while (p < end) {
                StringUtil.checkChar(s, p++);
            }
            return s.substring(start, end);
        }
        StringBuilder sb = new StringBuilder(end - start);
        while (start < end) {
            start = StringUtil.decodeChar(s, start, end, special, sb);
        }
        return sb.toString();
    }

    public static String joinString(List<String> values, String delimiter) {
        StringBuffer s = new StringBuffer();
        boolean first = true;
        for (String v : values) {
            if (!first) {
                s.append(delimiter);
            }
            s.append(v);
            first = false;
        }
        return s.toString();
    }

    public static String[] splitString(String str, String delim) {
        ArrayList<String> l = new ArrayList<String>();
        char[] arr = new char[str.length()];
        int pos = 0;
        int n = 0;
        char quoteChar = '\u0000';
        while (pos < str.length()) {
            if (quoteChar == '\u0000' && (str.charAt(pos) == '\"' || str.charAt(pos) == '\'')) {
                quoteChar = str.charAt(pos++);
                continue;
            }
            if (quoteChar == '\u0000' && str.charAt(pos) == '\\' && pos + 1 < str.length() && (str.charAt(pos + 1) == '\"' || str.charAt(pos + 1) == '\'')) {
                ++pos;
            } else if (quoteChar != '\u0000' && str.charAt(pos) == '\\' && pos + 1 < str.length() && str.charAt(pos + 1) == quoteChar) {
                ++pos;
            } else {
                if (quoteChar != '\u0000' && str.charAt(pos) == quoteChar) {
                    ++pos;
                    quoteChar = '\u0000';
                    continue;
                }
                if (delim.indexOf(str.charAt(pos)) != -1 && quoteChar == '\u0000') {
                    ++pos;
                    if (n <= 0) continue;
                    l.add(new String(arr, 0, n));
                    n = 0;
                    continue;
                }
            }
            if (pos >= str.length()) continue;
            arr[n++] = str.charAt(pos++);
        }
        if (n > 0) {
            l.add(new String(arr, 0, n));
        }
        if (quoteChar != '\u0000') {
            return null;
        }
        return l.toArray(new String[0]);
    }

    public static int checkQuote(String s) {
        return StringUtil.checkQuote(s, 0);
    }

    public static int checkQuote(String s, int start) {
        char quoteChar = s.charAt(start);
        if (quoteChar == '\"' || quoteChar == '\'') {
            int pos;
            ++start;
            int len = s.length();
            while (start < len && (pos = s.indexOf(quoteChar, start)) != -1) {
                if (s.charAt(pos - 1) != '\\') {
                    return pos;
                }
                start = pos + 1;
            }
            return -1;
        }
        return 0;
    }

    public static boolean match(String s, String pat, boolean emptyMatch) {
        assert (s.length() > 0);
        assert (pat.length() > 0);
        int beginIndex = pat.indexOf(42);
        if (beginIndex < 0) {
            return s.equals(pat);
        }
        if (beginIndex > s.length() || !s.substring(0, beginIndex).equals(pat.substring(0, beginIndex))) {
            return false;
        }
        int endLength = pat.length() - beginIndex - 1;
        if (endLength == 0) {
            return true;
        }
        if (endLength > s.length()) {
            return false;
        }
        int endIndex = s.length() - endLength;
        if (endIndex < beginIndex || !emptyMatch && endIndex == beginIndex) {
            return false;
        }
        return s.substring(endIndex, s.length() - endIndex).equals(pat.substring(beginIndex + 1, pat.length() - beginIndex - 1));
    }
}

