// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are created either via the
 * {@link Registry} object or via the registry client <tt>SessionManager</tt>
 * object.
 *
 * @see Registry
 *
 **/
public interface _SessionOperations extends Glacier2._SessionOperations
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     *
     * @param current The Current object for the invocation.
     **/
    void keepAlive(Ice.Current current);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     *
     * @param current The Current object for the invocation.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the object can't be
     * allocated.
     *
     **/
    void allocateObjectById_async(AMD_Session_allocateObjectById cb, Ice.Identity id, Ice.Current current)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param cb The callback object for the operation.
     * @param type The type of the object.
     *
     * @param current The Current object for the invocation.
     * @throws AllocationException Raised if the object could not be allocated.
     *
     **/
    void allocateObjectByType_async(AMD_Session_allocateObjectByType cb, String type, Ice.Current current)
        throws AllocationException;

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     *
     * @param current The Current object for the invocation.
     **/
    void releaseObject(Ice.Identity id, Ice.Current current)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param current The Current object for the invocation.
     **/
    void setAllocationTimeout(int timeout, Ice.Current current);
}
