/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class MoldenReader
extends MopacSlaterReader {
    protected boolean loadGeometries;
    protected boolean loadVibrations;
    protected boolean vibOnly;
    protected boolean optOnly;
    protected boolean doSort = true;
    protected String orbitalType = "";
    protected int modelAtomCount;
    private BS bsAtomOK = new BS();
    private BS bsBadIndex = new BS();
    private int[] nSPDF;
    private boolean haveEnergy = true;

    protected void initializeReader() {
        this.vibOnly = this.checkFilterKey("VIBONLY");
        this.optOnly = this.checkFilterKey("OPTONLY");
        this.doSort = !this.checkFilterKey("NOSORT");
        this.loadGeometries = !this.vibOnly && this.desiredVibrationNumber < 0 && !this.checkFilterKey("NOOPT");
        boolean bl = this.loadVibrations = !this.optOnly && this.desiredModelNumber < 0 && !this.checkFilterKey("NOVIB");
        this.filter = this.checkFilterKey("ALPHA") ? "alpha" : (this.checkFilterKey("BETA") ? "beta" : this.getFilter("SYM="));
    }

    protected boolean checkLine() throws Exception {
        if (!this.line.contains("[")) {
            return true;
        }
        this.line = this.line.toUpperCase().trim();
        if (!this.line.startsWith("[")) {
            return true;
        }
        Logger.info((String)this.line);
        if (this.line.indexOf("[ATOMS]") == 0) {
            this.readAtoms();
            this.modelAtomCount = this.asc.atomSetAtomCounts[0];
            if (this.asc.atomSetCount == 1 && this.moData != null) {
                this.finalizeMOData(this.moData);
            }
            return false;
        }
        if (this.line.indexOf("[GTO]") == 0) {
            return this.readGaussianBasis();
        }
        if (this.line.indexOf("[STO]") == 0) {
            return this.readSlaterBasis();
        }
        if (this.line.indexOf("[MO]") == 0) {
            return !this.doReadMolecularOrbitals || this.readMolecularOrbitals();
        }
        if (this.line.indexOf("[FREQ]") == 0) {
            return !this.loadVibrations || this.readFreqsAndModes();
        }
        if (this.line.indexOf("[GEOCONV]") == 0) {
            return !this.loadGeometries || this.readGeometryOptimization();
        }
        if (this.checkOrbitalType(this.line)) {
            return true;
        }
        return !this.checkSymmetry();
    }

    private boolean checkSymmetry() throws Exception {
        if (this.line.startsWith("[SPACEGROUP]")) {
            this.setSpaceGroupName(this.rd());
            this.rd();
            return true;
        }
        if (this.line.startsWith("[OPERATORS]")) {
            while (this.rd() != null && this.line.indexOf("[") < 0) {
                if (this.line.length() <= 0) continue;
                Logger.info((String)("adding operator " + this.line));
                this.setSymmetryOperator(this.line);
            }
            return true;
        }
        if (this.line.startsWith("[CELL]")) {
            this.rd();
            Logger.info((String)("setting cell dimensions " + this.line));
            this.next[0] = 0;
            for (int i = 0; i < 6; ++i) {
                this.setUnitCellItem(i, this.parseFloat());
            }
            this.rd();
            return true;
        }
        if (this.line.startsWith("[CELLAXES]")) {
            float[] f = new float[9];
            this.fillFloatArray(null, 0, f);
            this.addExplicitLatticeVector(0, f, 0);
            this.addExplicitLatticeVector(1, f, 3);
            this.addExplicitLatticeVector(2, f, 6);
            return true;
        }
        return false;
    }

    public void finalizeSubclassReader() throws Exception {
        if (!this.bsBadIndex.isEmpty()) {
            try {
                short ilast = 0;
                Atom[] atoms = this.asc.atoms;
                int nAtoms = this.asc.ac;
                this.bsAtomOK.set(nAtoms);
                int n = this.shells.size();
                block2: for (int i = 0; i < n; ++i) {
                    int iatom = ((int[])this.shells.get(i))[0];
                    if (iatom != Integer.MAX_VALUE) {
                        ilast = atoms[iatom - 1].elementNumber;
                        continue;
                    }
                    int j = this.bsAtomOK.nextClearBit(0);
                    while (j >= 0) {
                        if (atoms[j].elementNumber == ilast) {
                            ((int[])this.shells.get((int)i))[0] = j + 1;
                            Logger.info((String)("MoldenReader assigning shells starting with " + i + " for ** to atom " + (j + 1) + " z " + ilast));
                            while (++i < n && !this.bsBadIndex.get(i) && ((int[])this.shells.get(i))[0] == Integer.MAX_VALUE) {
                                ((int[])this.shells.get((int)i))[0] = j + 1;
                            }
                            --i;
                            this.bsAtomOK.set(j);
                            continue block2;
                        }
                        j = this.bsAtomOK.nextClearBit(j + 1);
                    }
                }
            }
            catch (Exception e) {
                Logger.error((String)"Molden reader could not assign shells -- abandoning MOs");
                this.asc.setCurrentModelInfo("moData", null);
            }
        }
        this.finalizeReaderASCR();
    }

    private void readAtoms() throws Exception {
        float f;
        boolean isAU;
        String coordUnit = PT.getTokens((String)this.line.replace(']', ' '))[1];
        boolean isFractional = coordUnit.indexOf("FRACTIONAL") >= 0;
        boolean bl = isAU = !isFractional && coordUnit.indexOf("ANGS") < 0;
        if (isAU && coordUnit.indexOf("AU") < 0) {
            Logger.error((String)("Molden atom line does not indicate units ANGS, AU, or FRACTIONAL -- AU assumed: " + this.line));
        }
        this.setFractionalCoordinates(isFractional);
        float f2 = f = isAU ? 0.5291772f : 1.0f;
        while (this.rd() != null && this.line.indexOf(91) < 0) {
            String[] tokens = this.getTokens();
            if (tokens.length < 6) continue;
            Atom atom = this.setAtomCoordScaled(null, tokens, 3, f);
            atom.atomName = tokens[0];
            atom.elementNumber = (short)this.parseIntStr(tokens[2]);
        }
    }

    boolean readSlaterBasis() throws Exception {
        this.nCoef = 0;
        while (this.rd() != null && this.line.indexOf("[") < 0) {
            String[] tokens = this.getTokens();
            if (tokens.length < 7) continue;
            this.addSlater(this.parseIntStr(tokens[0]), this.parseIntStr(tokens[1]), this.parseIntStr(tokens[2]), this.parseIntStr(tokens[3]), this.parseIntStr(tokens[4]), this.parseFloatStr(tokens[5]), this.parseFloatStr(tokens[6]));
            ++this.nCoef;
        }
        this.setSlaters(false, false);
        return false;
    }

    private boolean readGaussianBasis() throws Exception {
        this.shells = new Lst();
        Lst gdata = new Lst();
        int atomIndex = 0;
        int gaussianPtr = 0;
        this.nCoef = 0;
        this.nSPDF = new int[12];
        this.discardLinesUntilNonBlank();
        while (this.line != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            String[] tokens = this.getTokens();
            atomIndex = this.parseIntStr(tokens[0]) - 1;
            if (atomIndex == Integer.MAX_VALUE) {
                this.bsBadIndex.set(this.shells.size());
            } else {
                this.bsAtomOK.set(atomIndex);
            }
            while (this.rd() != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '[') {
                tokens = this.getTokens();
                String shellLabel = tokens[0].toUpperCase();
                int type = BasisFunctionReader.getQuantumShellTagID(shellLabel);
                int nPrimitives = this.parseIntStr(tokens[1]);
                int[] slater = new int[4];
                int n = type;
                this.nSPDF[n] = this.nSPDF[n] + 1;
                slater[0] = atomIndex + 1;
                slater[1] = type;
                slater[2] = gaussianPtr + 1;
                slater[3] = nPrimitives;
                int n2 = this.getDfCoefMaps()[type].length;
                this.nCoef += n2;
                int ip = nPrimitives;
                while (--ip >= 0) {
                    String[] primTokens = PT.getTokens((String)this.rd());
                    int nTokens = primTokens.length;
                    float[] orbData = new float[nTokens];
                    for (int d = 0; d < nTokens; ++d) {
                        orbData[d] = this.parseFloatStr(primTokens[d]);
                    }
                    gdata.addLast((Object)orbData);
                    ++gaussianPtr;
                }
                this.shells.addLast((Object)slater);
            }
            if (this.line.length() > 0 && this.line.charAt(0) == '[') break;
            this.rd();
        }
        float[][] garray = AU.newFloat2((int)gaussianPtr);
        for (int i = 0; i < gaussianPtr; ++i) {
            garray[i] = (float[])gdata.get(i);
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", garray);
        Logger.info((String)(this.shells.size() + " slater shells read"));
        Logger.info((String)(garray.length + " gaussian primitives read"));
        Logger.info((String)(this.nCoef + " MO coefficients expected for orbital type " + this.orbitalType));
        this.asc.setCurrentModelInfo("moData", (Object)this.moData);
        return false;
    }

    private boolean readMolecularOrbitals() throws Exception {
        while (this.checkOrbitalType(this.rd())) {
        }
        this.fixOrbitalType();
        String[] tokens = this.getMoTokens(this.line);
        while (tokens != null && tokens.length > 0 && tokens[0].indexOf(91) < 0) {
            String key;
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            Lst data = new Lst();
            float energy = Float.NaN;
            float occupancy = Float.NaN;
            String symmetry = null;
            while (this.parseIntStr(key = tokens[0]) == Integer.MIN_VALUE) {
                if (key.startsWith("Ene")) {
                    energy = this.parseFloatStr(tokens[1]);
                } else if (key.startsWith("Occup")) {
                    occupancy = this.parseFloatStr(tokens[1]);
                } else if (key.startsWith("Sym")) {
                    symmetry = tokens[1];
                } else if (key.startsWith("Spin")) {
                    this.alphaBeta = tokens[1].toLowerCase();
                }
                tokens = this.getMoTokens(null);
            }
            int pt = 0;
            while (tokens != null && tokens.length > 0 && this.parseIntStr(tokens[0]) != Integer.MIN_VALUE) {
                if (tokens.length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                int i = this.parseIntStr(tokens[0]);
                while (i > ++pt) {
                    data.addLast((Object)"0");
                }
                data.addLast((Object)tokens[1]);
                tokens = this.getMoTokens(null);
            }
            if (this.orbitalType.equals("") && data.size() < this.nCoef) {
                Logger.info((String)"too few orbital coefficients for 6D");
                this.checkOrbitalType("[5D]");
            }
            while (++pt <= this.nCoef) {
                data.addLast((Object)"0");
            }
            float[] coefs = new float[this.nCoef];
            int i = data.size();
            while (--i >= 0) {
                coefs[i] = this.parseFloatStr((String)data.get(i));
            }
            String l = this.line;
            this.line = "" + symmetry;
            if (this.filterMO()) {
                mo.put("coefficients", coefs);
                if (Float.isNaN(energy)) {
                    this.haveEnergy = false;
                } else {
                    mo.put("energy", Float.valueOf(energy));
                }
                if (!Float.isNaN(occupancy)) {
                    mo.put("occupancy", Float.valueOf(occupancy));
                }
                if (symmetry != null) {
                    mo.put("symmetry", symmetry);
                }
                if (this.alphaBeta.length() > 0) {
                    mo.put("type", this.alphaBeta);
                }
                this.setMO(mo);
                if (this.debugging) {
                    Logger.debug((String)(coefs.length + " coefficients in MO " + this.orbitals.size()));
                }
            }
            this.line = l;
        }
        if (this.debugging) {
            Logger.debug((String)("read " + this.orbitals.size() + " MOs"));
        }
        this.setMOs("eV");
        if (this.haveEnergy && this.doSort) {
            this.sortMOs();
        }
        return false;
    }

    private void sortMOs() {
        Object[] list = this.orbitals.toArray(new Object[this.orbitals.size()]);
        Arrays.sort(list, new BasisFunctionReader.MOEnergySorter());
        this.orbitals.clear();
        for (int i = 0; i < list.length; ++i) {
            this.orbitals.addLast((Object)((Map)list[i]));
        }
    }

    private String[] getMoTokens(String line) throws Exception {
        return line == null && (line = this.rd()) == null ? null : PT.getTokens((String)line.replace('=', ' '));
    }

    private boolean checkOrbitalType(String line) {
        if (line.length() > 3 && "5D 6D 7F 10 9G 15 11 21".indexOf(line.substring(1, 3)) >= 0) {
            if (this.orbitalType.indexOf(line) >= 0) {
                return true;
            }
            if (line.indexOf("G") >= 0 || line.indexOf("H") >= 0 || line.indexOf("I") >= 0) {
                this.appendLoadNote("Unsupported orbital type ignored: " + line);
            }
            this.orbitalType = this.orbitalType + line;
            Logger.info((String)("Orbital type set to " + this.orbitalType));
            this.fixOrbitalType();
            return true;
        }
        return false;
    }

    private void fixOrbitalType() {
        if (this.orbitalType.contains("5D")) {
            this.fixSlaterTypes(4, 3);
            this.fixSlaterTypes(6, 5);
            this.fixSlaterTypes(8, 7);
            this.fixSlaterTypes(10, 9);
        }
        if (this.orbitalType.contains("10F")) {
            this.fixSlaterTypes(5, 6);
            this.fixSlaterTypes(7, 8);
            this.fixSlaterTypes(9, 10);
        }
        if (this.orbitalType.contains("15G")) {
            this.fixSlaterTypes(7, 8);
            this.fixSlaterTypes(9, 10);
        }
    }

    private boolean readFreqsAndModes() throws Exception {
        Lst frequencies = new Lst();
        while (this.rd() != null && this.line.indexOf(91) < 0) {
            String f = this.getTokens()[0];
            frequencies.addLast((Object)f);
        }
        int nFreqs = frequencies.size();
        this.skipTo("[FR-COORD]");
        if (!this.vibOnly) {
            this.readAtomSet("frequency base geometry", true, true);
        }
        this.skipTo("[FR-NORM-COORD]");
        boolean haveVib = false;
        for (int nFreq = 0; nFreq < nFreqs; ++nFreq) {
            this.skipTo("vibration");
            this.doGetVibration(++this.vibrationNumber);
            if (haveVib) {
                this.asc.cloneLastAtomSet();
            }
            haveVib = true;
            this.asc.setAtomSetFrequency(null, null, "" + PT.dVal((String)((String)frequencies.get(nFreq))), null);
            int i0 = this.asc.getLastAtomSetAtomIndex();
            for (int i = 0; i < this.modelAtomCount; ++i) {
                String[] tokens = PT.getTokens((String)this.rd());
                this.asc.addVibrationVector(i + i0, this.parseFloatStr(tokens[0]) * 0.5291772f, this.parseFloatStr(tokens[1]) * 0.5291772f, this.parseFloatStr(tokens[2]) * 0.5291772f);
            }
        }
        return true;
    }

    private boolean readGeometryOptimization() throws Exception {
        int firstModel;
        Lst energies = new Lst();
        this.rd();
        while (this.rd() != null && this.line.indexOf("force") < 0) {
            energies.addLast((Object)("" + PT.dVal((String)this.line.trim())));
        }
        this.skipTo("[GEOMETRIES] XYZ");
        int nGeom = energies.size();
        this.modelNumber = firstModel = this.optOnly || this.desiredModelNumber >= 0 ? 0 : 1;
        boolean haveModel = false;
        if (this.desiredModelNumber == 0 || this.desiredModelNumber == nGeom) {
            this.desiredModelNumber = nGeom;
        } else if (this.asc.atomSetCount > 0) {
            this.finalizeMOData(this.moData);
        }
        for (int i = 0; i < nGeom; ++i) {
            this.readLines(2);
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomSet("Step " + (this.modelNumber - firstModel) + "/" + nGeom + ": " + (String)energies.get(i), false, !this.optOnly || haveModel);
                haveModel = true;
                continue;
            }
            this.readLines(this.modelAtomCount);
        }
        return true;
    }

    private void skipTo(String key) throws Exception {
        key = key.toUpperCase();
        if (this.line == null || !this.line.toUpperCase().contains(key)) {
            while (this.rd() != null && this.line.toUpperCase().indexOf(key) < 0) {
            }
        }
    }

    private void readAtomSet(String atomSetName, boolean isBohr, boolean asClone) throws Exception {
        if (asClone && this.desiredModelNumber < 0) {
            this.asc.cloneFirstAtomSet(0);
        }
        float f = isBohr ? 0.5291772f : 1.0f;
        this.asc.setAtomSetName(atomSetName);
        if (this.asc.ac == 0) {
            while (this.rd() != null && this.line.indexOf(91) < 0) {
                String[] tokens = this.getTokens();
                if (tokens.length != 4) continue;
                this.setAtomCoordScaled(null, (String[])tokens, (int)1, (float)f).atomName = tokens[0];
            }
            this.modelAtomCount = this.asc.getLastAtomSetAtomCount();
            return;
        }
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        for (int i = 0; i < this.modelAtomCount; ++i) {
            this.setAtomCoordScaled(atoms[i + i0], PT.getTokens((String)this.rd()), 1, f);
        }
    }
}

