// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * An Ice object adapter descriptor.
 *
 **/
public class AdapterDescriptor implements java.lang.Cloneable,
                                          java.io.Serializable
{
    /**
     * The object adapter name.
     *
     **/
    public String name;

    /**
     * The description of this object adapter.
     *
     **/
    public String description;

    /**
     * The object adapter id.
     *
     **/
    public String id;

    /**
     * The replica id of this adapter.
     *
     **/
    public String replicaGroupId;

    /**
     * The adapter priority. This is eventually used when the adapter
     * is member of a replica group to sort the adapter endpoints by
     * priority.
     *
     **/
    public String priority;

    /**
     * Flag to specify if the object adapter will register a process object.
     *
     **/
    public boolean registerProcess;

    /**
     * If true the lifetime of this object adapter is the same of the
     * server lifetime. This information is used by the IceGrid node
     * to figure out the server state: the server is active only if
     * all its "server lifetime" adapters are active.
     *
     **/
    public boolean serverLifetime;

    /**
     * The well-known object descriptors associated with this object adapter.
     *
     **/
    public java.util.List<ObjectDescriptor> objects;

    /**
     * The allocatable object descriptors associated with this object adapter.
     *
     **/
    public java.util.List<ObjectDescriptor> allocatables;

    public AdapterDescriptor()
    {
        this.name = "";
        this.description = "";
        this.id = "";
        this.replicaGroupId = "";
        this.priority = "";
    }

    public AdapterDescriptor(String name, String description, String id, String replicaGroupId, String priority, boolean registerProcess, boolean serverLifetime, java.util.List<ObjectDescriptor> objects, java.util.List<ObjectDescriptor> allocatables)
    {
        this.name = name;
        this.description = description;
        this.id = id;
        this.replicaGroupId = replicaGroupId;
        this.priority = priority;
        this.registerProcess = registerProcess;
        this.serverLifetime = serverLifetime;
        this.objects = objects;
        this.allocatables = allocatables;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        AdapterDescriptor r = null;
        if(rhs instanceof AdapterDescriptor)
        {
            r = (AdapterDescriptor)rhs;
        }

        if(r != null)
        {
            if(this.name != r.name)
            {
                if(this.name == null || r.name == null || !this.name.equals(r.name))
                {
                    return false;
                }
            }
            if(this.description != r.description)
            {
                if(this.description == null || r.description == null || !this.description.equals(r.description))
                {
                    return false;
                }
            }
            if(this.id != r.id)
            {
                if(this.id == null || r.id == null || !this.id.equals(r.id))
                {
                    return false;
                }
            }
            if(this.replicaGroupId != r.replicaGroupId)
            {
                if(this.replicaGroupId == null || r.replicaGroupId == null || !this.replicaGroupId.equals(r.replicaGroupId))
                {
                    return false;
                }
            }
            if(this.priority != r.priority)
            {
                if(this.priority == null || r.priority == null || !this.priority.equals(r.priority))
                {
                    return false;
                }
            }
            if(this.registerProcess != r.registerProcess)
            {
                return false;
            }
            if(this.serverLifetime != r.serverLifetime)
            {
                return false;
            }
            if(this.objects != r.objects)
            {
                if(this.objects == null || r.objects == null || !this.objects.equals(r.objects))
                {
                    return false;
                }
            }
            if(this.allocatables != r.allocatables)
            {
                if(this.allocatables == null || r.allocatables == null || !this.allocatables.equals(r.allocatables))
                {
                    return false;
                }
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int h_ = 5381;
        h_ = IceInternal.HashUtil.hashAdd(h_, "::IceGrid::AdapterDescriptor");
        h_ = IceInternal.HashUtil.hashAdd(h_, name);
        h_ = IceInternal.HashUtil.hashAdd(h_, description);
        h_ = IceInternal.HashUtil.hashAdd(h_, id);
        h_ = IceInternal.HashUtil.hashAdd(h_, replicaGroupId);
        h_ = IceInternal.HashUtil.hashAdd(h_, priority);
        h_ = IceInternal.HashUtil.hashAdd(h_, registerProcess);
        h_ = IceInternal.HashUtil.hashAdd(h_, serverLifetime);
        h_ = IceInternal.HashUtil.hashAdd(h_, objects);
        h_ = IceInternal.HashUtil.hashAdd(h_, allocatables);
        return h_;
    }

    public AdapterDescriptor
    clone()
    {
        AdapterDescriptor c = null;
        try
        {
            c = (AdapterDescriptor)super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return c;
    }

    public void
    ice_writeMembers(Ice.OutputStream ostr)
    {
        ostr.writeString(this.name);
        ostr.writeString(this.description);
        ostr.writeString(this.id);
        ostr.writeString(this.replicaGroupId);
        ostr.writeString(this.priority);
        ostr.writeBool(this.registerProcess);
        ostr.writeBool(this.serverLifetime);
        ObjectDescriptorSeqHelper.write(ostr, this.objects);
        ObjectDescriptorSeqHelper.write(ostr, this.allocatables);
    }

    public void
    ice_readMembers(Ice.InputStream istr)
    {
        this.name = istr.readString();
        this.description = istr.readString();
        this.id = istr.readString();
        this.replicaGroupId = istr.readString();
        this.priority = istr.readString();
        this.registerProcess = istr.readBool();
        this.serverLifetime = istr.readBool();
        this.objects = ObjectDescriptorSeqHelper.read(istr);
        this.allocatables = ObjectDescriptorSeqHelper.read(istr);
    }

    static public void
    ice_write(Ice.OutputStream ostr, AdapterDescriptor v)
    {
        if(v == null)
        {
            _nullMarshalValue.ice_writeMembers(ostr);
        }
        else
        {
            v.ice_writeMembers(ostr);
        }
    }

    static public AdapterDescriptor
    ice_read(Ice.InputStream istr)
    {
        AdapterDescriptor v = new AdapterDescriptor();
        v.ice_readMembers(istr);
        return v;
    }

    private static final AdapterDescriptor _nullMarshalValue = new AdapterDescriptor();

    public static final long serialVersionUID = -256374784L;
}
