/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class ContentType {
    private String primaryType;
    private String subType;
    private ParameterList list;

    public ContentType() {
    }

    public ContentType(String primaryType, String subType, ParameterList list) {
        this.primaryType = primaryType;
        this.subType = subType;
        this.list = list;
    }

    public ContentType(String s) throws ParseException {
        HeaderTokenizer ht = new HeaderTokenizer(s, "()<>@,;:\\\"\t []/?=");
        HeaderTokenizer.Token token = ht.next();
        if (token.getType() != -1) {
            throw new ParseException("expected primary type: " + s);
        }
        this.primaryType = token.getValue();
        token = ht.next();
        if (token.getType() != 47) {
            throw new ParseException("expected '/': " + s);
        }
        token = ht.next();
        if (token.getType() != -1) {
            throw new ParseException("expected subtype: " + s);
        }
        this.subType = token.getValue();
        s = ht.getRemainder();
        if (s != null) {
            this.list = new ParameterList(s);
        }
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getBaseType() {
        if (this.primaryType == null || this.subType == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.primaryType);
        buffer.append('/');
        buffer.append(this.subType);
        return buffer.toString();
    }

    public String getParameter(String name) {
        return this.list == null ? null : this.list.get(name);
    }

    public ParameterList getParameterList() {
        return this.list;
    }

    public void setPrimaryType(String primaryType) {
        this.primaryType = primaryType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public void setParameter(String name, String value) {
        if (this.list == null) {
            this.list = new ParameterList();
        }
        this.list.set(name, value);
    }

    public void setParameterList(ParameterList list) {
        this.list = list;
    }

    public String toString() {
        if (this.primaryType == null || this.subType == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.primaryType);
        buffer.append('/');
        buffer.append(this.subType);
        if (this.list != null) {
            int used = buffer.length() + 14;
            buffer.append(this.list.toString(used));
        }
        return buffer.toString();
    }

    public boolean match(ContentType cType) {
        if (!this.primaryType.equalsIgnoreCase(cType.getPrimaryType())) {
            return false;
        }
        String cTypeSubType = cType.getSubType();
        if (this.subType.charAt(0) == '*' || cTypeSubType.charAt(0) == '*') {
            return true;
        }
        return this.subType.equalsIgnoreCase(cTypeSubType);
    }

    public boolean match(String s) {
        try {
            return this.match(new ContentType(s));
        }
        catch (ParseException e) {
            return false;
        }
    }
}

