/* dee-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Dee", gir_namespace = "Dee", gir_version = "1.0", lower_case_cprefix = "dee_")]
namespace Dee {
	[CCode (cheader_filename = "dee.h", type_id = "dee_analyzer_get_type ()")]
	public class Analyzer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Analyzer ();
		public virtual void add_term_filter (owned Dee.TermFilterFunc filter_func);
		public virtual void analyze (string data, Dee.TermList? terms_out, Dee.TermList? colkeys_out);
		public virtual int collate_cmp (string key1, string key2);
		public static int collate_cmp_func (string key1, string key2, void* analyzer);
		public virtual string collate_key (string data);
		public virtual void tokenize (string data, Dee.TermList terms_out);
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_client_get_type ()")]
	public class Client : Dee.Peer {
		[CCode (has_construct_function = false)]
		public Client (string swarm_name);
		[CCode (has_construct_function = false)]
		public Client.for_address (string swarm_name, string bus_address);
		[NoAccessorMethod]
		public string bus_address { owned get; construct; }
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_file_resource_manager_get_type ()")]
	public class FileResourceManager : GLib.Object, Dee.ResourceManager {
		[CCode (has_construct_function = false, type = "DeeResourceManager*")]
		public FileResourceManager (string primary_path);
		public void add_search_path (string path);
		public unowned string get_primary_path ();
		public string primary_path { get; construct; }
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_filter_model_get_type ()")]
	public class FilterModel : Dee.ProxyModel, Dee.Model, Dee.Serializable {
		[CCode (has_construct_function = false, type = "DeeModel*")]
		public FilterModel (Dee.Model orig_model, Dee.Filter filter);
		public unowned Dee.ModelIter append_iter (Dee.ModelIter iter);
		public bool contains (Dee.ModelIter iter);
		public unowned Dee.ModelIter insert_iter (Dee.ModelIter iter, uint pos);
		public unowned Dee.ModelIter insert_iter_before (Dee.ModelIter iter, Dee.ModelIter pos);
		public unowned Dee.ModelIter insert_iter_with_original_order (Dee.ModelIter iter);
		public unowned Dee.ModelIter prepend_iter (Dee.ModelIter iter);
		[NoAccessorMethod]
		public Dee.Filter filter { get; construct; }
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_hash_index_get_type ()")]
	public class HashIndex : Dee.Index {
		[CCode (has_construct_function = false)]
		public HashIndex (Dee.Model model, Dee.Analyzer analyzer, Dee.ModelReader reader);
	}
	[CCode (cheader_filename = "dee-icu.h", free_function = "dee_icu_term_filter_destroy", has_type_id = false)]
	[Compact]
	public class ICUTermFilter {
		public ICUTermFilter (string system_id, string? rules) throws Dee.ICUError;
		public string apply (string text);
		public ICUTermFilter.ascii_folder ();
		public void destroy ();
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_index_get_type ()")]
	public abstract class Index : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Index ();
		public virtual void @foreach (string start_term, Dee.IndexIterFunc func);
		public unowned Dee.Analyzer get_analyzer ();
		public unowned Dee.Model get_model ();
		public virtual uint get_n_rows ();
		public virtual uint get_n_rows_for_term (string term);
		public virtual uint get_n_terms ();
		public unowned Dee.ModelReader? get_reader ();
		public virtual uint get_supported_term_match_flags ();
		public virtual Dee.ResultSet lookup (string term, Dee.TermMatchFlag flags);
		public unowned Dee.ModelIter lookup_one (string term);
		public Dee.Analyzer analyzer { get; construct; }
		public Dee.Model model { get; construct; }
		public Dee.ModelReader reader { construct; }
	}
	[CCode (cheader_filename = "dee.h", ref_function = "", type_id = "dee_model_iter_get_type ()", unref_function = "")]
	[Compact]
	public class ModelIter {
	}
	[CCode (cheader_filename = "dee.h", has_type_id = false, ref_function = "", unref_function = "")]
	[Compact]
	public class ModelTag<G> {
		[CCode (cname = "dee_model_register_tag", simple_generics = true)]
		public ModelTag (Dee.Model model);
		[CCode (cname = "dee_model_clear_tag", instance_pos = 2.1)]
		public void clear (Dee.Model model, Dee.ModelIter iter);
		[CCode (cname = "dee_model_get_tag", instance_pos = 2.1)]
		public unowned G @get (Dee.Model model, Dee.ModelIter iter);
		[CCode (cname = "dee_model_set_tag", instance_pos = 2.1)]
		public void @set (Dee.Model model, Dee.ModelIter iter, owned G value);
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_peer_get_type ()")]
	public class Peer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Peer (string swarm_name);
		public virtual GLib.SList<weak GLib.DBusConnection> get_connections ();
		public virtual unowned string get_swarm_leader ();
		public unowned string get_swarm_name ();
		public virtual bool is_swarm_leader ();
		public bool is_swarm_owner ();
		[CCode (array_length = false, array_null_terminated = true)]
		public virtual string[] list_peers ();
		public string swarm_leader { get; }
		[NoAccessorMethod]
		public string swarm_name { owned get; set construct; }
		[NoAccessorMethod]
		public bool swarm_owner { get; construct; }
		public virtual signal void connection_acquired (GLib.DBusConnection connection);
		public virtual signal void connection_closed (GLib.DBusConnection connection);
		public virtual signal void peer_found (string name);
		public virtual signal void peer_lost (string name);
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_proxy_model_get_type ()")]
	public class ProxyModel : Dee.SerializableModel, Dee.Model, Dee.Serializable {
		[CCode (has_construct_function = false)]
		protected ProxyModel ();
		[NoAccessorMethod]
		public Dee.Model back_end { owned get; construct; }
		[NoAccessorMethod]
		public bool inherit_seqnums { get; construct; }
		[NoAccessorMethod]
		public bool proxy_signals { get; construct; }
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_sequence_model_get_type ()")]
	public class SequenceModel : Dee.SerializableModel, Dee.Model, Dee.Serializable {
		[CCode (has_construct_function = false, type = "DeeModel*")]
		public SequenceModel ();
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_serializable_model_get_type ()")]
	public abstract class SerializableModel : GLib.Object, Dee.Model, Dee.Serializable {
		[CCode (has_construct_function = false)]
		protected SerializableModel ();
		public virtual uint64 get_seqnum ();
		public virtual uint64 inc_seqnum ();
		public virtual void set_seqnum (uint64 seqnum);
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_server_get_type ()")]
	public class Server : Dee.Peer {
		[CCode (has_construct_function = false)]
		public Server (string swarm_name);
		public static string bus_address_for_name (string name, bool include_username);
		[CCode (has_construct_function = false)]
		public Server.for_address (string swarm_name, string bus_address);
		public unowned string get_client_address ();
		[NoAccessorMethod]
		public string bus_address { owned get; construct; }
		[NoAccessorMethod]
		public bool same_user_only { get; construct; }
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_shared_model_get_type ()")]
	public class SharedModel : Dee.ProxyModel, Dee.Model, Dee.Serializable {
		[CCode (has_construct_function = false, type = "DeeModel*")]
		public SharedModel (string name);
		public uint flush_revision_queue ();
		public uint flush_revision_queue_sync ();
		[CCode (has_construct_function = false, type = "DeeModel*")]
		public SharedModel.for_peer (owned Dee.Peer peer);
		public Dee.SharedModelFlushMode get_flush_mode ();
		public unowned Dee.Peer get_peer ();
		public unowned string get_swarm_name ();
		public bool is_leader ();
		public bool is_synchronized ();
		public void set_flush_mode (Dee.SharedModelFlushMode mode);
		[CCode (has_construct_function = false, type = "DeeModel*")]
		public SharedModel.with_back_end (string name, owned Dee.Model back_end);
		[NoAccessorMethod]
		public Dee.SharedModelAccessMode access_mode { get; construct; }
		public Dee.SharedModelFlushMode flush_mode { get; set; }
		public Dee.Peer peer { get; construct; }
		[NoAccessorMethod]
		public bool synchronized { get; }
		public signal void begin_transaction (uint64 begin_seqnum, uint64 end_seqnum);
		public signal void end_transaction (uint64 begin_seqnum, uint64 end_seqnum);
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_term_list_get_type ()")]
	public class TermList : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TermList ();
		public virtual unowned Dee.TermList add_term (string term);
		public virtual unowned Dee.TermList clear ();
		public virtual Dee.TermList clone ();
		[CCode (cname = "dee_term_list_get_term")]
		public unowned string @get (uint index);
		public virtual unowned string get_term (uint n);
		public virtual uint num_terms ();
		public uint size {[CCode (cname = "dee_term_list_num_terms")]  get; }
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_text_analyzer_get_type ()")]
	public class TextAnalyzer : Dee.Analyzer {
		[CCode (has_construct_function = false)]
		public TextAnalyzer ();
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_transaction_get_type ()")]
	public class Transaction : Dee.SerializableModel, Dee.Model, Dee.Serializable {
		[CCode (has_construct_function = false, type = "DeeModel*")]
		public Transaction (Dee.Model target);
		public bool commit () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned Dee.Model get_target ();
		public bool is_committed ();
		public Dee.Model target { get; construct; }
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_tree_index_get_type ()")]
	public class TreeIndex : Dee.Index {
		[CCode (has_construct_function = false)]
		public TreeIndex (Dee.Model model, Dee.Analyzer analyzer, Dee.ModelReader reader);
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_model_get_type ()")]
	public interface Model : GLib.Object {
		public unowned Dee.ModelIter append (...);
		public abstract unowned Dee.ModelIter append_row ([CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_members);
		public abstract void begin_changeset ();
		[CCode (array_length_pos = 1.33333, array_length_type = "guint", cname = "dee_model_build_named_row_sunk")]
		public GLib.Variant[] build_named_row ([CCode (array_length = false)] GLib.Variant[]? out_row_members, string first_column_name, ...);
		[CCode (array_length_pos = 1.33333, array_length_type = "guint", cname = "dee_model_build_named_row_sunk")]
		public unowned GLib.Variant[] build_named_row_static ([CCode (array_length = false)] GLib.Variant[] out_row_members, string first_column_name, ...);
		public abstract void clear ();
		public abstract void end_changeset ();
		public abstract unowned Dee.ModelIter find_row_sorted ([CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_spec, [CCode (delegate_target_pos = 2.5)] Dee.CompareRowFunc cmp_func, out bool out_was_found);
		public unowned Dee.ModelIter find_row_sorted_with_sizes ([CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_spec, [CCode (delegate_target_pos = 2.5)] Dee.CompareRowSizedFunc cmp_func, out bool out_was_found);
		public unowned Dee.ModelIter find_sorted ([CCode (delegate_target_pos = 1.5)] Dee.CompareRowFunc cmp_func, out bool out_was_found, ...);
		public void @get (Dee.ModelIter iter, ...);
		public abstract bool get_bool (Dee.ModelIter iter, uint column);
		public abstract int get_column_index (string column_name);
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public abstract unowned string[] get_column_names ();
		public abstract unowned string get_column_schema (uint column);
		public abstract double get_double (Dee.ModelIter iter, uint column);
		public abstract unowned string get_field_schema (string field_name, out uint out_column);
		public abstract unowned Dee.ModelIter get_first_iter ();
		public abstract int32 get_int32 (Dee.ModelIter iter, uint column);
		public abstract int64 get_int64 (Dee.ModelIter iter, uint column);
		public abstract unowned Dee.ModelIter get_iter_at_row (uint row);
		public abstract unowned Dee.ModelIter get_last_iter ();
		public abstract uint get_n_columns ();
		public abstract uint get_n_rows ();
		public abstract uint get_position (Dee.ModelIter iter);
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract GLib.Variant[] get_row (Dee.ModelIter iter, [CCode (array_length = false)] GLib.Variant[]? out_row_members = null);
		[CCode (array_length = false, array_null_terminated = true, cname = "dee_model_get_row")]
		public unowned GLib.Variant[] get_row_static (Dee.ModelIter iter, [CCode (array_length = false)] GLib.Variant[] out_row_members);
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public abstract unowned string[] get_schema ();
		public abstract unowned string get_string (Dee.ModelIter iter, uint column);
		public abstract uint8 get_uchar (Dee.ModelIter iter, uint column);
		public abstract uint32 get_uint32 (Dee.ModelIter iter, uint column);
		public abstract uint64 get_uint64 (Dee.ModelIter iter, uint column);
		public abstract GLib.Variant get_value (Dee.ModelIter iter, uint column);
		public abstract GLib.Variant get_value_by_name (Dee.ModelIter iter, string column_name);
		public abstract GLib.HashTable<weak string,weak string> get_vardict_schema (uint num_column);
		public unowned Dee.ModelIter insert (uint pos, ...);
		public unowned Dee.ModelIter insert_before (Dee.ModelIter iter, ...);
		public abstract unowned Dee.ModelIter insert_row (uint pos, [CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_members);
		public abstract unowned Dee.ModelIter insert_row_before (Dee.ModelIter iter, [CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_members);
		public abstract unowned Dee.ModelIter insert_row_sorted ([CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_members, Dee.CompareRowFunc cmp_func);
		public unowned Dee.ModelIter insert_row_sorted_with_sizes ([CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_members, Dee.CompareRowSizedFunc cmp_func);
		public unowned Dee.ModelIter insert_sorted ([CCode (delegate_target_pos = 1.5)] Dee.CompareRowFunc cmp_func, ...);
		public abstract bool is_first (Dee.ModelIter iter);
		public abstract bool is_last (Dee.ModelIter iter);
		public abstract unowned Dee.ModelIter next (Dee.ModelIter iter);
		public unowned Dee.ModelIter prepend (...);
		public abstract unowned Dee.ModelIter prepend_row ([CCode (array_length = false, array_null_terminated = true)] GLib.Variant[] row_members);
		public abstract unowned Dee.ModelIter prev (Dee.ModelIter iter);
		public abstract void register_vardict_schema (uint num_column, GLib.HashTable<string,string> schemas);
		public abstract void remove (Dee.ModelIter iter);
		public void @set (Dee.ModelIter iter, ...);
		public void set_column_names (string first_column_name, ...);
		public abstract void set_column_names_full ([CCode (array_length = true, array_length_cname = "num_columns", array_length_pos = 1.1, array_length_type = "guint", array_null_terminated = true)] string[] column_names);
		public abstract void set_row (Dee.ModelIter iter, [CCode (array_length = false)] GLib.Variant[] row_members);
		public void set_schema (...);
		public abstract void set_schema_full ([CCode (array_length = true, array_length_cname = "num_columns", array_length_pos = 1.1, array_length_type = "guint", array_null_terminated = true)] string[] column_schemas);
		public abstract void set_value (Dee.ModelIter iter, uint column, GLib.Variant value);
		public virtual signal void changeset_finished ();
		public virtual signal void changeset_started ();
		public virtual signal void row_added (Dee.ModelIter iter);
		public virtual signal void row_changed (Dee.ModelIter iter);
		public virtual signal void row_removed (Dee.ModelIter iter);
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_resource_manager_get_type ()")]
	public interface ResourceManager : GLib.Object {
		public static unowned Dee.ResourceManager get_default ();
		public abstract GLib.Object load (string resource_name) throws GLib.Error;
		public abstract bool store (Dee.Serializable resource, string resource_name) throws GLib.Error;
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_result_set_get_type ()")]
	public interface ResultSet : GLib.Object {
		public abstract unowned Dee.Model get_model ();
		public abstract uint get_n_rows ();
		public abstract bool has_next ();
		[CCode (cname = "_vala_dee_result_set_iterator")]
		public Dee.ResultSet iterator ();
		public abstract unowned Dee.ModelIter next ();
		[CCode (cname = "_vala_dee_result_set_next_value")]
		public unowned Dee.ModelIter? next_value ();
		public abstract unowned Dee.ModelIter peek ();
		public abstract void seek (uint pos);
		public abstract uint tell ();
	}
	[CCode (cheader_filename = "dee.h", type_id = "dee_serializable_get_type ()")]
	public interface Serializable : GLib.Object {
		[CCode (returns_floating_reference = true)]
		public GLib.Variant externalize ();
		public static GLib.Object parse (GLib.Variant data, GLib.Type type);
		public static GLib.Object parse_external (GLib.Variant data);
		public static void register_parser (GLib.Type type, GLib.VariantType vtype, Dee.SerializableParseFunc parse_func);
		public abstract GLib.Variant serialize ();
	}
	[CCode (cheader_filename = "dee.h", has_type_id = false)]
	public struct Filter {
		[CCode (cname = "destroy")]
		public GLib.DestroyNotify destroy_notify;
		public weak Dee.FilterMapFunc map_func;
		public weak Dee.FilterMapNotify map_notify;
		public void* userdata;
		public void destroy ();
		public void map (Dee.Model orig_model, Dee.FilterModel filter_model);
		public static Dee.Filter @new (Dee.StaticFilterMapFunc map_func, owned Dee.FilterMapNotify map_notify);
		public static Dee.Filter new_collator (uint column);
		public static Dee.Filter new_collator_desc (uint column);
		public static Dee.Filter new_for_any_column (uint column, GLib.Variant value);
		public static Dee.Filter new_for_key_column (uint column, string key);
		public static Dee.Filter new_regex (uint column, GLib.Regex regex);
		public static Dee.Filter new_sort (owned Dee.CompareRowFunc cmp_row);
		public bool notify (Dee.ModelIter orig_iter, Dee.Model orig_model, Dee.FilterModel filter_model);
	}
	[CCode (cheader_filename = "dee.h", has_type_id = false)]
	public struct ModelReader {
		public weak Dee.ModelReaderFunc reader_func;
		public void* userdata;
		public void destroy ();
		public static Dee.ModelReader @new (owned Dee.ModelReaderFunc reader_func);
		public static Dee.ModelReader new_for_int32_column (uint column);
		public static Dee.ModelReader new_for_string_column (uint column);
		public static Dee.ModelReader new_for_uint32_column (uint column);
		public string read (Dee.Model model, Dee.ModelIter iter);
	}
	[CCode (cheader_filename = "dee.h", cprefix = "DEE_SHARED_MODEL_ACCESS_MODE_", type_id = "dee_shared_model_access_mode_get_type ()")]
	public enum SharedModelAccessMode {
		WORLD_WRITABLE,
		LEADER_WRITABLE
	}
	[CCode (cheader_filename = "dee.h", cprefix = "DEE_SHARED_MODEL_FLUSH_MODE_", type_id = "dee_shared_model_flush_mode_get_type ()")]
	public enum SharedModelFlushMode {
		AUTOMATIC,
		MANUAL
	}
	[CCode (cheader_filename = "dee.h", cprefix = "DEE_TERM_MATCH_", has_type_id = false)]
	[Flags]
	public enum TermMatchFlag {
		EXACT,
		PREFIX
	}
	[CCode (cheader_filename = "dee.h", cprefix = "DEE_TRANSACTION_ERROR_", has_type_id = false)]
	public enum TransactionError {
		CONCURRENT_MODIFICATION,
		COMMITTED
	}
	[CCode (cheader_filename = "dee-icu.h", cprefix = "DEE_ICU_ERROR_")]
	public errordomain ICUError {
		BAD_RULE,
		BAD_ID,
		UNKNOWN;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "dee.h", cprefix = "DEE_SHARED_MODEL_ERROR_LEADER_")]
	public errordomain SharedModelError {
		[CCode (cname = "DEE_SHARED_MODEL_ERROR_LEADER_INVALIDATED")]
		LEADER_INVALIDATED
	}
	[CCode (cheader_filename = "dee.h", instance_pos = 1.9)]
	public delegate string CollatorFunc (string input);
	[CCode (cheader_filename = "dee.h", instance_pos = 2.9)]
	public delegate int CompareRowFunc ([CCode (array_length = false)] GLib.Variant[] row1, [CCode (array_length = false)] GLib.Variant[] row2);
	[CCode (cheader_filename = "dee.h", instance_pos = 2.9)]
	public delegate int CompareRowSizedFunc ([CCode (array_length_cname = "row1_length", array_length_pos = 1.5, array_length_type = "guint")] GLib.Variant[] row1, [CCode (array_length_cname = "row2_length", array_length_pos = 2.1, array_length_type = "guint")] GLib.Variant[] row2);
	[CCode (cheader_filename = "dee.h", instance_pos = 2.9)]
	public delegate void FilterMapFunc (Dee.Model orig_model, Dee.FilterModel filter_model);
	[CCode (cheader_filename = "dee.h", instance_pos = 3.9)]
	public delegate bool FilterMapNotify (Dee.Model orig_model, Dee.ModelIter orig_iter, Dee.FilterModel filter_model);
	[CCode (cheader_filename = "dee.h", instance_pos = 2.9)]
	public delegate bool IndexIterFunc (string key, Dee.ResultSet rows);
	[CCode (cheader_filename = "dee.h", instance_pos = 2.9)]
	public delegate string ModelReaderFunc (Dee.Model model, Dee.ModelIter iter);
	[CCode (cheader_filename = "dee.h", has_target = false)]
	public delegate GLib.Object SerializableParseFunc (GLib.Variant data);
	[CCode (cheader_filename = "dee.h", cname = "DeeFilterMapFunc", has_target = false)]
	public delegate void StaticFilterMapFunc (Dee.Model orig_model, Dee.FilterModel filter_model, void* data);
	[CCode (cheader_filename = "dee.h", instance_pos = 2.9)]
	public delegate void TermFilterFunc (Dee.TermList terms_in, Dee.TermList terms_out);
	[CCode (cheader_filename = "dee.h", cname = "DEE_PEER_DBUS_IFACE")]
	public const string PEER_DBUS_IFACE;
	[CCode (cheader_filename = "dee.h", cname = "DEE_SEQUENCE_MODEL_DBUS_IFACE")]
	public const string SEQUENCE_MODEL_DBUS_IFACE;
	[CCode (cheader_filename = "dee.h", cname = "DEE_SHARED_MODEL_DBUS_IFACE")]
	public const string SHARED_MODEL_DBUS_IFACE;
}
